/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-12-13 21:13:18 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3272 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=45491 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=9772 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_cky_banners` (
  `banner_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(190) NOT NULL DEFAULT '',
  `slug` varchar(190) NOT NULL DEFAULT '',
  `status` int(11) NOT NULL DEFAULT 0,
  `settings` longtext NOT NULL DEFAULT '',
  `banner_default` int(11) NOT NULL DEFAULT 0,
  `contents` longtext NOT NULL DEFAULT '',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`banner_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_cky_cookie_categories` (
  `category_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL DEFAULT '',
  `slug` varchar(190) NOT NULL DEFAULT '',
  `description` longtext NOT NULL DEFAULT '',
  `prior_consent` int(11) NOT NULL DEFAULT 0,
  `visibility` int(11) NOT NULL DEFAULT 1,
  `priority` int(11) NOT NULL DEFAULT 0,
  `sell_personal_data` int(11) NOT NULL DEFAULT 0,
  `meta` longtext DEFAULT '',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_cky_cookies` (
  `cookie_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(190) NOT NULL DEFAULT '',
  `slug` varchar(190) NOT NULL DEFAULT '',
  `description` longtext NOT NULL DEFAULT '',
  `duration` text NOT NULL DEFAULT '',
  `domain` varchar(190) NOT NULL DEFAULT '',
  `category` bigint(20) NOT NULL,
  `type` text NOT NULL DEFAULT '',
  `discovered` int(11) NOT NULL DEFAULT 0,
  `url_pattern` varchar(190) DEFAULT '',
  `meta` longtext DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`cookie_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=131 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_litespeed_url` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url` varchar(500) NOT NULL,
  `cache_tags` varchar(1000) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `url` (`url`(191)),
  KEY `cache_tags` (`cache_tags`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_litespeed_url_file` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url_id` bigint(20) NOT NULL,
  `vary` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of final vary',
  `filename` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of file content',
  `type` tinyint(4) NOT NULL COMMENT 'css=1,js=2,ccss=3,ucss=4',
  `mobile` tinyint(4) NOT NULL COMMENT 'mobile=1',
  `webp` tinyint(4) NOT NULL COMMENT 'webp=1',
  `expired` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `filename` (`filename`),
  KEY `type` (`type`),
  KEY `url_id_2` (`url_id`,`vary`,`type`),
  KEY `filename_2` (`filename`,`expired`),
  KEY `url_id` (`url_id`,`expired`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=124928 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=5185 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1582 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_smush_dir_images` (
  `id` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `path_hash` char(32) DEFAULT NULL,
  `resize` varchar(55) DEFAULT NULL,
  `lossy` varchar(55) DEFAULT NULL,
  `error` varchar(55) DEFAULT NULL,
  `image_size` int(10) unsigned DEFAULT NULL,
  `orig_size` int(10) unsigned DEFAULT NULL,
  `file_time` int(10) unsigned DEFAULT NULL,
  `last_scan` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `path_hash` (`path_hash`),
  KEY `image_size` (`image_size`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_entries` (
  `entry_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `post_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `status` varchar(30) NOT NULL,
  `type` varchar(30) NOT NULL,
  `viewed` tinyint(1) DEFAULT 0,
  `starred` tinyint(1) DEFAULT 0,
  `fields` longtext NOT NULL,
  `meta` longtext NOT NULL,
  `date` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `ip_address` varchar(128) NOT NULL,
  `user_agent` varchar(256) NOT NULL,
  `user_uuid` varchar(36) NOT NULL,
  PRIMARY KEY (`entry_id`),
  KEY `form_id` (`form_id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_entry_fields` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `entry_id` bigint(20) NOT NULL,
  `form_id` bigint(20) NOT NULL,
  `field_id` int(11) NOT NULL,
  `value` longtext NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `entry_id` (`entry_id`),
  KEY `form_id` (`form_id`),
  KEY `field_id` (`field_id`)
) ENGINE=InnoDB AUTO_INCREMENT=152 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_entry_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `entry_id` bigint(20) NOT NULL,
  `form_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `status` varchar(30) NOT NULL,
  `type` varchar(255) NOT NULL,
  `data` longtext NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `entry_id` (`entry_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_logs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `message` longtext NOT NULL,
  `types` varchar(255) NOT NULL,
  `create_at` datetime NOT NULL,
  `form_id` bigint(20) DEFAULT NULL,
  `entry_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_payment_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `payment_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payment_id` (`payment_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_payments` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `status` varchar(10) NOT NULL DEFAULT '',
  `subtotal_amount` decimal(26,8) NOT NULL DEFAULT 0.00000000,
  `discount_amount` decimal(26,8) NOT NULL DEFAULT 0.00000000,
  `total_amount` decimal(26,8) NOT NULL DEFAULT 0.00000000,
  `currency` varchar(3) NOT NULL DEFAULT '',
  `entry_id` bigint(20) NOT NULL DEFAULT 0,
  `gateway` varchar(20) NOT NULL DEFAULT '',
  `type` varchar(12) NOT NULL DEFAULT '',
  `mode` varchar(4) NOT NULL DEFAULT '',
  `transaction_id` varchar(40) NOT NULL DEFAULT '',
  `customer_id` varchar(40) NOT NULL DEFAULT '',
  `subscription_id` varchar(40) NOT NULL DEFAULT '',
  `subscription_status` varchar(10) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `date_created_gmt` datetime NOT NULL,
  `date_updated_gmt` datetime NOT NULL,
  `is_published` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `status` (`status`(8)),
  KEY `total_amount` (`total_amount`),
  KEY `type` (`type`(8)),
  KEY `transaction_id` (`transaction_id`(32)),
  KEY `customer_id` (`customer_id`(32)),
  KEY `subscription_id` (`subscription_id`(32)),
  KEY `subscription_status` (`subscription_status`(8)),
  KEY `title` (`title`(64))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_tasks_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `action` varchar(255) NOT NULL,
  `data` longtext NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1036 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpmailsmtp_debug_events` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content` text DEFAULT NULL,
  `initiator` text DEFAULT NULL,
  `event_type` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpmailsmtp_tasks_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `action` varchar(255) NOT NULL,
  `data` longtext NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("39", "wpforms_admin_addons_cache_update", "failed", "2023-02-20 17:03:05", "2023-02-20 17:03:05", "{\"tasks_meta_id\":8}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1676912585;s:18:\"\0*\0first_timestamp\";i:1676290503;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1676912585;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2023-02-20 18:43:55", "2023-02-20 18:43:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("40", "wpforms_admin_builder_templates_cache_update", "failed", "2023-02-20 17:03:05", "2023-02-20 17:03:05", "{\"tasks_meta_id\":10}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1676912585;s:18:\"\0*\0first_timestamp\";i:1676290522;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1676912585;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2023-02-20 18:43:55", "2023-02-20 18:43:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("98", "action_scheduler/migration_hook", "failed", "2023-02-22 20:42:48", "2023-02-22 20:42:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1677098568;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1677098568;}", "1", "1", "2023-02-22 20:43:05", "2023-02-22 20:43:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3052", "wpforms_admin_addons_cache_update", "complete", "2025-11-13 00:34:47", "2025-11-13 00:34:47", "{\"tasks_meta_id\":36}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762994087;s:18:\"\0*\0first_timestamp\";i:1677753100;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762994087;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-11-13 01:54:34", "2025-11-13 01:54:34", "43237", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3053", "wpforms_admin_builder_templates_cache_update", "complete", "2025-11-13 00:34:47", "2025-11-13 00:34:47", "{\"tasks_meta_id\":38}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762994087;s:18:\"\0*\0first_timestamp\";i:1677753108;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762994087;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-11-13 01:54:34", "2025-11-13 01:54:34", "43237", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3054", "wpforms_builder_help_cache_update", "complete", "2025-11-13 00:34:47", "2025-11-13 00:34:47", "{\"tasks_meta_id\":39}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762994087;s:18:\"\0*\0first_timestamp\";i:1677753109;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762994087;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-11-13 01:54:34", "2025-11-13 01:54:34", "43237", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3055", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-11-13 00:34:47", "2025-11-13 00:34:47", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762994087;s:18:\"\0*\0first_timestamp\";i:1677095594;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762994087;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-11-13 01:54:34", "2025-11-13 01:54:34", "43237", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3081", "wp_mail_smtp_summary_report_email", "complete", "2025-11-17 19:03:58", "2025-11-17 19:03:58", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763406238;s:18:\"\0*\0first_timestamp\";i:1756130400;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763406238;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "5", "1", "2025-11-17 19:16:50", "2025-11-17 19:16:50", "43624", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3087", "wpforms_process_purge_spam", "complete", "2025-11-13 12:02:22", "2025-11-13 12:02:22", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763035342;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763035342;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-13 12:38:12", "2025-11-13 12:38:12", "43285", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3089", "wpforms_process_forms_locator_scan", "complete", "2025-11-13 12:02:22", "2025-11-13 12:02:22", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763035342;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763035342;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-13 12:38:12", "2025-11-13 12:38:12", "43285", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3090", "wp_mail_smtp_admin_notifications_update", "complete", "2025-11-13 12:02:22", "2025-11-13 12:02:22", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763035342;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763035342;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-13 12:38:12", "2025-11-13 12:38:12", "43285", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3091", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-13 12:02:22", "2025-11-13 12:02:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763035342;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763035342;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-11-13 12:38:12", "2025-11-13 12:38:12", "43285", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3092", "wpforms_admin_addons_cache_update", "complete", "2025-11-20 01:54:34", "2025-11-20 01:54:34", "{\"tasks_meta_id\":36}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763603674;s:18:\"\0*\0first_timestamp\";i:1677753100;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763603674;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-11-20 02:16:21", "2025-11-20 02:16:21", "43775", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3093", "wpforms_admin_builder_templates_cache_update", "complete", "2025-11-20 01:54:34", "2025-11-20 01:54:34", "{\"tasks_meta_id\":38}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763603674;s:18:\"\0*\0first_timestamp\";i:1677753108;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763603674;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-11-20 02:16:21", "2025-11-20 02:16:21", "43775", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3094", "wpforms_builder_help_cache_update", "complete", "2025-11-20 01:54:34", "2025-11-20 01:54:34", "{\"tasks_meta_id\":39}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763603674;s:18:\"\0*\0first_timestamp\";i:1677753109;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763603674;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-11-20 02:16:21", "2025-11-20 02:16:21", "43775", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3095", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-11-20 01:54:34", "2025-11-20 01:54:34", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763603674;s:18:\"\0*\0first_timestamp\";i:1677095594;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763603674;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-11-20 02:16:21", "2025-11-20 02:16:21", "43775", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3096", "wpforms_process_purge_spam", "complete", "2025-11-14 12:38:12", "2025-11-14 12:38:12", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763123892;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763123892;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-14 12:38:28", "2025-11-14 12:38:28", "43365", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3097", "wpforms_process_forms_locator_save", "complete", "2025-11-13 12:38:12", "2025-11-13 12:38:12", "{\"tasks_meta_id\":1004}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-11-13 12:38:12", "2025-11-13 12:38:12", "43286", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3098", "wpforms_process_forms_locator_scan", "complete", "2025-11-14 12:38:12", "2025-11-14 12:38:12", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763123892;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763123892;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-14 12:38:28", "2025-11-14 12:38:28", "43365", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3099", "wp_mail_smtp_admin_notifications_update", "complete", "2025-11-14 12:38:12", "2025-11-14 12:38:12", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763123892;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763123892;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-14 12:38:28", "2025-11-14 12:38:28", "43365", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3100", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-14 12:38:12", "2025-11-14 12:38:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763123892;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763123892;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-11-14 12:38:28", "2025-11-14 12:38:28", "43365", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3101", "wpforms_process_purge_spam", "complete", "2025-11-15 12:38:28", "2025-11-15 12:38:28", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763210308;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763210308;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-15 12:39:20", "2025-11-15 12:39:20", "43473", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3102", "wpforms_process_forms_locator_save", "complete", "2025-11-14 12:38:28", "2025-11-14 12:38:28", "{\"tasks_meta_id\":1005}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-11-14 12:38:28", "2025-11-14 12:38:28", "43366", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3103", "wpforms_process_forms_locator_scan", "complete", "2025-11-15 12:38:28", "2025-11-15 12:38:28", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763210308;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763210308;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-15 12:39:20", "2025-11-15 12:39:20", "43473", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3104", "wp_mail_smtp_admin_notifications_update", "complete", "2025-11-15 12:38:28", "2025-11-15 12:38:28", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763210308;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763210308;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-15 12:39:20", "2025-11-15 12:39:20", "43473", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3105", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-15 12:38:28", "2025-11-15 12:38:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763210308;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763210308;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-11-15 12:39:20", "2025-11-15 12:39:20", "43473", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3106", "wpforms_process_purge_spam", "complete", "2025-11-16 12:39:20", "2025-11-16 12:39:20", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763296760;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763296760;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-16 12:52:46", "2025-11-16 12:52:46", "43536", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3107", "wpforms_process_forms_locator_save", "complete", "2025-11-15 12:39:20", "2025-11-15 12:39:20", "{\"tasks_meta_id\":1006}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-11-15 12:39:20", "2025-11-15 12:39:20", "43474", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3108", "wpforms_process_forms_locator_scan", "complete", "2025-11-16 12:39:20", "2025-11-16 12:39:20", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763296760;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763296760;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-16 12:52:46", "2025-11-16 12:52:46", "43536", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3109", "wp_mail_smtp_admin_notifications_update", "complete", "2025-11-16 12:39:20", "2025-11-16 12:39:20", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763296760;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763296760;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-16 12:52:46", "2025-11-16 12:52:46", "43536", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3110", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-16 12:39:20", "2025-11-16 12:39:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763296760;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763296760;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-11-16 12:52:46", "2025-11-16 12:52:46", "43536", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3111", "wpforms_process_purge_spam", "complete", "2025-11-17 12:52:46", "2025-11-17 12:52:46", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763383966;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763383966;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-17 13:03:18", "2025-11-17 13:03:18", "43608", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3112", "wpforms_process_forms_locator_save", "complete", "2025-11-16 12:52:46", "2025-11-16 12:52:46", "{\"tasks_meta_id\":1007}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-11-16 12:52:46", "2025-11-16 12:52:46", "43537", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3113", "wpforms_process_forms_locator_scan", "complete", "2025-11-17 12:52:46", "2025-11-17 12:52:46", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763383966;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763383966;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-17 13:03:18", "2025-11-17 13:03:18", "43608", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3114", "wp_mail_smtp_admin_notifications_update", "complete", "2025-11-17 12:52:46", "2025-11-17 12:52:46", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763383966;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763383966;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-17 13:03:19", "2025-11-17 13:03:19", "43608", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3115", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-17 12:52:46", "2025-11-17 12:52:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763383966;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763383966;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-11-17 13:03:19", "2025-11-17 13:03:19", "43608", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3116", "wpforms_process_purge_spam", "complete", "2025-11-18 13:03:18", "2025-11-18 13:03:18", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763470998;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763470998;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-18 13:11:11", "2025-11-18 13:11:11", "43679", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3117", "wpforms_process_forms_locator_save", "complete", "2025-11-17 13:03:18", "2025-11-17 13:03:18", "{\"tasks_meta_id\":1008}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-11-17 13:03:19", "2025-11-17 13:03:19", "43609", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3118", "wpforms_process_forms_locator_scan", "complete", "2025-11-18 13:03:18", "2025-11-18 13:03:18", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763470998;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763470998;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-18 13:11:11", "2025-11-18 13:11:11", "43679", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3119", "wp_mail_smtp_admin_notifications_update", "complete", "2025-11-18 13:03:19", "2025-11-18 13:03:19", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763470999;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763470999;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-18 13:11:11", "2025-11-18 13:11:11", "43679", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3120", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-18 13:03:19", "2025-11-18 13:03:19", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763470999;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763470999;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-11-18 13:11:11", "2025-11-18 13:11:11", "43679", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3121", "wp_mail_smtp_summary_report_email", "complete", "2025-11-24 19:16:50", "2025-11-24 19:16:50", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764011810;s:18:\"\0*\0first_timestamp\";i:1756130400;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764011810;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "5", "1", "2025-11-24 19:25:28", "2025-11-24 19:25:28", "44151", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3122", "wpforms_process_purge_spam", "complete", "2025-11-19 13:11:11", "2025-11-19 13:11:11", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763557871;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763557871;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-19 13:30:02", "2025-11-19 13:30:02", "43742", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3123", "wpforms_process_forms_locator_save", "complete", "2025-11-18 13:11:11", "2025-11-18 13:11:11", "{\"tasks_meta_id\":1009}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-11-18 13:11:11", "2025-11-18 13:11:11", "43680", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3124", "wpforms_process_forms_locator_scan", "complete", "2025-11-19 13:11:11", "2025-11-19 13:11:11", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763557871;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763557871;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-19 13:30:02", "2025-11-19 13:30:02", "43742", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3125", "wp_mail_smtp_admin_notifications_update", "complete", "2025-11-19 13:11:11", "2025-11-19 13:11:11", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763557871;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763557871;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-19 13:30:02", "2025-11-19 13:30:02", "43742", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3126", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-19 13:11:11", "2025-11-19 13:11:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763557871;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763557871;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-11-19 13:30:02", "2025-11-19 13:30:02", "43742", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3127", "wpforms_process_purge_spam", "complete", "2025-11-20 13:30:02", "2025-11-20 13:30:02", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763645402;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763645402;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-20 13:55:47", "2025-11-20 13:55:47", "43807", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3128", "wpforms_process_forms_locator_save", "complete", "2025-11-19 13:30:02", "2025-11-19 13:30:02", "{\"tasks_meta_id\":1010}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-11-19 13:30:02", "2025-11-19 13:30:02", "43743", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3129", "wpforms_process_forms_locator_scan", "complete", "2025-11-20 13:30:02", "2025-11-20 13:30:02", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763645402;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763645402;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-20 13:55:47", "2025-11-20 13:55:47", "43807", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3130", "wp_mail_smtp_admin_notifications_update", "complete", "2025-11-20 13:30:02", "2025-11-20 13:30:02", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763645402;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763645402;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-20 13:55:48", "2025-11-20 13:55:48", "43807", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3131", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-20 13:30:02", "2025-11-20 13:30:02", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763645402;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763645402;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-11-20 13:55:48", "2025-11-20 13:55:48", "43807", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3132", "wpforms_admin_addons_cache_update", "complete", "2025-11-27 02:16:21", "2025-11-27 02:16:21", "{\"tasks_meta_id\":36}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764209781;s:18:\"\0*\0first_timestamp\";i:1677753100;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764209781;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-11-27 02:16:59", "2025-11-27 02:16:59", "44309", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3133", "wpforms_admin_builder_templates_cache_update", "complete", "2025-11-27 02:16:21", "2025-11-27 02:16:21", "{\"tasks_meta_id\":38}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764209781;s:18:\"\0*\0first_timestamp\";i:1677753108;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764209781;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-11-27 02:16:59", "2025-11-27 02:16:59", "44309", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3134", "wpforms_builder_help_cache_update", "complete", "2025-11-27 02:16:21", "2025-11-27 02:16:21", "{\"tasks_meta_id\":39}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764209781;s:18:\"\0*\0first_timestamp\";i:1677753109;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764209781;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-11-27 02:16:59", "2025-11-27 02:16:59", "44309", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3135", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-11-27 02:16:21", "2025-11-27 02:16:21", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764209781;s:18:\"\0*\0first_timestamp\";i:1677095594;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764209781;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-11-27 02:16:59", "2025-11-27 02:16:59", "44309", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3136", "wpforms_process_purge_spam", "complete", "2025-11-21 13:55:47", "2025-11-21 13:55:47", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763733347;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763733347;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-21 14:09:37", "2025-11-21 14:09:37", "43885", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3137", "wpforms_process_forms_locator_save", "complete", "2025-11-20 13:55:47", "2025-11-20 13:55:47", "{\"tasks_meta_id\":1011}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-11-20 13:55:48", "2025-11-20 13:55:48", "43808", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3138", "wpforms_process_forms_locator_scan", "complete", "2025-11-21 13:55:47", "2025-11-21 13:55:47", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763733347;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763733347;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-21 14:09:37", "2025-11-21 14:09:37", "43885", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3139", "wp_mail_smtp_admin_notifications_update", "complete", "2025-11-21 13:55:48", "2025-11-21 13:55:48", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763733348;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763733348;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-21 14:09:37", "2025-11-21 14:09:37", "43885", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3140", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-21 13:55:48", "2025-11-21 13:55:48", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763733348;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763733348;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-11-21 14:09:37", "2025-11-21 14:09:37", "43885", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3141", "wpforms_process_purge_spam", "complete", "2025-11-22 14:09:37", "2025-11-22 14:09:37", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763820577;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763820577;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-22 14:43:43", "2025-11-22 14:43:43", "43974", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3142", "wpforms_process_forms_locator_save", "complete", "2025-11-21 14:09:37", "2025-11-21 14:09:37", "{\"tasks_meta_id\":1012}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-11-21 14:09:37", "2025-11-21 14:09:37", "43886", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3143", "wpforms_process_forms_locator_scan", "complete", "2025-11-22 14:09:37", "2025-11-22 14:09:37", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763820577;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763820577;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-22 14:43:43", "2025-11-22 14:43:43", "43974", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3144", "wp_mail_smtp_admin_notifications_update", "complete", "2025-11-22 14:09:37", "2025-11-22 14:09:37", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763820577;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763820577;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-22 14:43:43", "2025-11-22 14:43:43", "43974", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3145", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-22 14:09:37", "2025-11-22 14:09:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763820577;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763820577;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-11-22 14:43:43", "2025-11-22 14:43:43", "43974", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3146", "wpforms_process_purge_spam", "complete", "2025-11-23 14:43:43", "2025-11-23 14:43:43", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763909023;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763909023;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-23 15:00:04", "2025-11-23 15:00:04", "44038", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3147", "wpforms_process_forms_locator_save", "complete", "2025-11-22 14:43:43", "2025-11-22 14:43:43", "{\"tasks_meta_id\":1013}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-11-22 14:43:43", "2025-11-22 14:43:43", "43975", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3148", "wpforms_process_forms_locator_scan", "complete", "2025-11-23 14:43:43", "2025-11-23 14:43:43", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763909023;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763909023;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-23 15:00:04", "2025-11-23 15:00:04", "44038", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3149", "wp_mail_smtp_admin_notifications_update", "complete", "2025-11-23 14:43:43", "2025-11-23 14:43:43", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763909023;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763909023;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-23 15:00:04", "2025-11-23 15:00:04", "44038", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3150", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-23 14:43:43", "2025-11-23 14:43:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763909023;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763909023;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-11-23 15:00:04", "2025-11-23 15:00:04", "44038", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3151", "wpforms_process_purge_spam", "complete", "2025-11-24 15:00:04", "2025-11-24 15:00:04", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763996404;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763996404;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-24 15:22:35", "2025-11-24 15:22:35", "44132", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3152", "wpforms_process_forms_locator_save", "complete", "2025-11-23 15:00:04", "2025-11-23 15:00:04", "{\"tasks_meta_id\":1014}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-11-23 15:00:04", "2025-11-23 15:00:04", "44039", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3153", "wpforms_process_forms_locator_scan", "complete", "2025-11-24 15:00:04", "2025-11-24 15:00:04", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763996404;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763996404;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-24 15:22:35", "2025-11-24 15:22:35", "44132", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3154", "wp_mail_smtp_admin_notifications_update", "complete", "2025-11-24 15:00:04", "2025-11-24 15:00:04", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763996404;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763996404;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-24 15:22:35", "2025-11-24 15:22:35", "44132", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3155", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-24 15:00:04", "2025-11-24 15:00:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763996404;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763996404;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-11-24 15:22:35", "2025-11-24 15:22:35", "44132", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3156", "wpforms_process_purge_spam", "complete", "2025-11-25 15:22:35", "2025-11-25 15:22:35", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764084155;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764084155;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-25 15:25:06", "2025-11-25 15:25:06", "44207", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3157", "wpforms_process_forms_locator_save", "complete", "2025-11-24 15:22:35", "2025-11-24 15:22:35", "{\"tasks_meta_id\":1015}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-11-24 15:22:35", "2025-11-24 15:22:35", "44133", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3158", "wpforms_process_forms_locator_scan", "complete", "2025-11-25 15:22:35", "2025-11-25 15:22:35", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764084155;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764084155;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-25 15:25:06", "2025-11-25 15:25:06", "44207", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3159", "wp_mail_smtp_admin_notifications_update", "complete", "2025-11-25 15:22:35", "2025-11-25 15:22:35", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764084155;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764084155;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-25 15:25:07", "2025-11-25 15:25:07", "44207", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3160", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-25 15:22:35", "2025-11-25 15:22:35", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764084155;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764084155;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-11-25 15:25:07", "2025-11-25 15:25:07", "44207", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3161", "wp_mail_smtp_summary_report_email", "complete", "2025-12-01 19:25:28", "2025-12-01 19:25:28", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764617128;s:18:\"\0*\0first_timestamp\";i:1756130400;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764617128;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "5", "1", "2025-12-01 19:37:11", "2025-12-01 19:37:11", "44640", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3162", "wpforms_process_purge_spam", "complete", "2025-11-26 15:25:06", "2025-11-26 15:25:06", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764170706;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764170706;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-26 15:31:53", "2025-11-26 15:31:53", "44283", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3163", "wpforms_process_forms_locator_save", "complete", "2025-11-25 15:25:06", "2025-11-25 15:25:06", "{\"tasks_meta_id\":1016}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-11-25 15:25:07", "2025-11-25 15:25:07", "44208", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3164", "wpforms_process_forms_locator_scan", "complete", "2025-11-26 15:25:06", "2025-11-26 15:25:06", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764170706;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764170706;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-26 15:31:53", "2025-11-26 15:31:53", "44283", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3165", "wp_mail_smtp_admin_notifications_update", "complete", "2025-11-26 15:25:07", "2025-11-26 15:25:07", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764170707;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764170707;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-26 15:31:53", "2025-11-26 15:31:53", "44283", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3166", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-26 15:25:07", "2025-11-26 15:25:07", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764170707;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764170707;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-11-26 15:31:53", "2025-11-26 15:31:53", "44283", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3167", "wpforms_process_purge_spam", "complete", "2025-11-27 15:31:53", "2025-11-27 15:31:53", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764257513;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764257513;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-27 16:22:07", "2025-11-27 16:22:07", "44346", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3168", "wpforms_process_forms_locator_save", "complete", "2025-11-26 15:31:53", "2025-11-26 15:31:53", "{\"tasks_meta_id\":1017}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-11-26 15:31:53", "2025-11-26 15:31:53", "44284", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3169", "wpforms_process_forms_locator_scan", "complete", "2025-11-27 15:31:53", "2025-11-27 15:31:53", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764257513;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764257513;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-27 16:22:07", "2025-11-27 16:22:07", "44346", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3170", "wp_mail_smtp_admin_notifications_update", "complete", "2025-11-27 15:31:53", "2025-11-27 15:31:53", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764257513;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764257513;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-27 16:22:07", "2025-11-27 16:22:07", "44346", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3171", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-27 15:31:53", "2025-11-27 15:31:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764257513;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764257513;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-11-27 16:22:07", "2025-11-27 16:22:07", "44346", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3172", "wpforms_admin_addons_cache_update", "complete", "2025-12-04 02:16:59", "2025-12-04 02:16:59", "{\"tasks_meta_id\":36}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764814619;s:18:\"\0*\0first_timestamp\";i:1677753100;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764814619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-12-04 02:55:38", "2025-12-04 02:55:38", "44856", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3173", "wpforms_admin_builder_templates_cache_update", "complete", "2025-12-04 02:16:59", "2025-12-04 02:16:59", "{\"tasks_meta_id\":38}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764814619;s:18:\"\0*\0first_timestamp\";i:1677753108;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764814619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-12-04 02:55:39", "2025-12-04 02:55:39", "44856", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3174", "wpforms_builder_help_cache_update", "complete", "2025-12-04 02:16:59", "2025-12-04 02:16:59", "{\"tasks_meta_id\":39}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764814619;s:18:\"\0*\0first_timestamp\";i:1677753109;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764814619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-12-04 02:55:39", "2025-12-04 02:55:39", "44856", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3175", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-12-04 02:16:59", "2025-12-04 02:16:59", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764814619;s:18:\"\0*\0first_timestamp\";i:1677095594;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764814619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-12-04 02:55:39", "2025-12-04 02:55:39", "44856", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3176", "wpforms_process_purge_spam", "complete", "2025-11-28 16:22:07", "2025-11-28 16:22:07", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764346927;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764346927;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-28 17:04:30", "2025-11-28 17:04:30", "44420", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3177", "wpforms_process_forms_locator_save", "complete", "2025-11-27 16:22:07", "2025-11-27 16:22:07", "{\"tasks_meta_id\":1018}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-11-27 16:22:07", "2025-11-27 16:22:07", "44347", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3178", "wpforms_process_forms_locator_scan", "complete", "2025-11-28 16:22:07", "2025-11-28 16:22:07", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764346927;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764346927;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-28 17:04:30", "2025-11-28 17:04:30", "44420", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3179", "wp_mail_smtp_admin_notifications_update", "complete", "2025-11-28 16:22:07", "2025-11-28 16:22:07", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764346927;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764346927;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-28 17:04:30", "2025-11-28 17:04:30", "44420", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3180", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-28 16:22:07", "2025-11-28 16:22:07", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764346927;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764346927;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-11-28 17:04:30", "2025-11-28 17:04:30", "44420", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3181", "wpforms_process_purge_spam", "complete", "2025-11-29 17:04:30", "2025-11-29 17:04:30", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764435870;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764435870;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-29 17:09:25", "2025-11-29 17:09:25", "44465", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3182", "wpforms_process_forms_locator_save", "complete", "2025-11-28 17:04:30", "2025-11-28 17:04:30", "{\"tasks_meta_id\":1019}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-11-28 17:04:30", "2025-11-28 17:04:30", "44421", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3183", "wpforms_process_forms_locator_scan", "complete", "2025-11-29 17:04:30", "2025-11-29 17:04:30", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764435870;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764435870;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-29 17:09:25", "2025-11-29 17:09:25", "44465", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3184", "wp_mail_smtp_admin_notifications_update", "complete", "2025-11-29 17:04:30", "2025-11-29 17:04:30", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764435870;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764435870;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-29 17:09:25", "2025-11-29 17:09:25", "44465", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3185", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-29 17:04:30", "2025-11-29 17:04:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764435870;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764435870;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-11-29 17:09:25", "2025-11-29 17:09:25", "44465", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3186", "wpforms_process_purge_spam", "complete", "2025-11-30 17:09:25", "2025-11-30 17:09:25", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764522565;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764522565;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-30 17:19:06", "2025-11-30 17:19:06", "44533", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3187", "wpforms_process_forms_locator_save", "complete", "2025-11-29 17:09:25", "2025-11-29 17:09:25", "{\"tasks_meta_id\":1020}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-11-29 17:09:25", "2025-11-29 17:09:25", "44466", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3188", "wpforms_process_forms_locator_scan", "complete", "2025-11-30 17:09:25", "2025-11-30 17:09:25", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764522565;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764522565;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-30 17:19:06", "2025-11-30 17:19:06", "44533", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3189", "wp_mail_smtp_admin_notifications_update", "complete", "2025-11-30 17:09:25", "2025-11-30 17:09:25", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764522565;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764522565;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-30 17:19:06", "2025-11-30 17:19:06", "44533", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3190", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-30 17:09:25", "2025-11-30 17:09:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764522565;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764522565;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-11-30 17:19:06", "2025-11-30 17:19:06", "44533", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3191", "wpforms_process_purge_spam", "complete", "2025-12-01 17:19:06", "2025-12-01 17:19:06", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764609546;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764609546;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-01 17:31:55", "2025-12-01 17:31:55", "44632", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3192", "wpforms_process_forms_locator_save", "complete", "2025-11-30 17:19:06", "2025-11-30 17:19:06", "{\"tasks_meta_id\":1021}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-11-30 17:19:06", "2025-11-30 17:19:06", "44534", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3193", "wpforms_process_forms_locator_scan", "complete", "2025-12-01 17:19:06", "2025-12-01 17:19:06", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764609546;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764609546;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-01 17:31:55", "2025-12-01 17:31:55", "44632", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3194", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-01 17:19:06", "2025-12-01 17:19:06", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764609546;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764609546;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-01 17:31:55", "2025-12-01 17:31:55", "44632", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3195", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-01 17:19:06", "2025-12-01 17:19:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764609546;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764609546;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-01 17:31:55", "2025-12-01 17:31:55", "44632", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3196", "wpforms_process_purge_spam", "complete", "2025-12-02 17:31:55", "2025-12-02 17:31:55", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764696715;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764696715;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-02 17:36:28", "2025-12-02 17:36:28", "44755", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3197", "wpforms_process_forms_locator_save", "complete", "2025-12-01 17:31:55", "2025-12-01 17:31:55", "{\"tasks_meta_id\":1022}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-12-01 17:31:55", "2025-12-01 17:31:55", "44633", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3198", "wpforms_process_forms_locator_scan", "complete", "2025-12-02 17:31:55", "2025-12-02 17:31:55", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764696715;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764696715;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-02 17:36:28", "2025-12-02 17:36:28", "44755", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3199", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-02 17:31:55", "2025-12-02 17:31:55", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764696715;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764696715;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-02 17:36:28", "2025-12-02 17:36:28", "44755", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3200", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-02 17:31:55", "2025-12-02 17:31:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764696715;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764696715;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-02 17:36:28", "2025-12-02 17:36:28", "44755", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3201", "wp_mail_smtp_summary_report_email", "complete", "2025-12-08 19:37:11", "2025-12-08 19:37:11", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765222631;s:18:\"\0*\0first_timestamp\";i:1756130400;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765222631;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "5", "1", "2025-12-08 19:40:07", "2025-12-08 19:40:07", "45154", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3202", "wpforms_process_purge_spam", "complete", "2025-12-03 17:36:28", "2025-12-03 17:36:28", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764783388;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764783388;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-03 18:05:42", "2025-12-03 18:05:42", "44828", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3203", "wpforms_process_forms_locator_save", "complete", "2025-12-02 17:36:28", "2025-12-02 17:36:28", "{\"tasks_meta_id\":1023}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-12-02 17:36:28", "2025-12-02 17:36:28", "44756", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3204", "wpforms_process_forms_locator_scan", "complete", "2025-12-03 17:36:28", "2025-12-03 17:36:28", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764783388;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764783388;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-03 18:05:42", "2025-12-03 18:05:42", "44828", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3205", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-03 17:36:28", "2025-12-03 17:36:28", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764783388;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764783388;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-03 18:05:42", "2025-12-03 18:05:42", "44828", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3206", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-03 17:36:28", "2025-12-03 17:36:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764783388;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764783388;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-03 18:05:42", "2025-12-03 18:05:42", "44828", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3207", "wpforms_process_purge_spam", "complete", "2025-12-04 18:05:42", "2025-12-04 18:05:42", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764871542;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764871542;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-04 18:20:43", "2025-12-04 18:20:43", "44889", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3208", "wpforms_process_forms_locator_save", "complete", "2025-12-03 18:05:42", "2025-12-03 18:05:42", "{\"tasks_meta_id\":1024}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-12-03 18:05:42", "2025-12-03 18:05:42", "44829", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3209", "wpforms_process_forms_locator_scan", "complete", "2025-12-04 18:05:42", "2025-12-04 18:05:42", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764871542;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764871542;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-04 18:20:43", "2025-12-04 18:20:43", "44889", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3210", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-04 18:05:42", "2025-12-04 18:05:42", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764871542;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764871542;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-04 18:20:43", "2025-12-04 18:20:43", "44889", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3211", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-04 18:05:42", "2025-12-04 18:05:42", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764871542;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764871542;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-04 18:20:43", "2025-12-04 18:20:43", "44889", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3212", "wpforms_admin_addons_cache_update", "complete", "2025-12-11 02:55:38", "2025-12-11 02:55:38", "{\"tasks_meta_id\":36}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765421738;s:18:\"\0*\0first_timestamp\";i:1677753100;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765421738;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-12-11 02:56:51", "2025-12-11 02:56:51", "45314", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3213", "wpforms_admin_builder_templates_cache_update", "complete", "2025-12-11 02:55:39", "2025-12-11 02:55:39", "{\"tasks_meta_id\":38}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765421739;s:18:\"\0*\0first_timestamp\";i:1677753108;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765421739;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-12-11 02:56:51", "2025-12-11 02:56:51", "45314", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3214", "wpforms_builder_help_cache_update", "complete", "2025-12-11 02:55:39", "2025-12-11 02:55:39", "{\"tasks_meta_id\":39}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765421739;s:18:\"\0*\0first_timestamp\";i:1677753109;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765421739;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-12-11 02:56:51", "2025-12-11 02:56:51", "45314", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3215", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-12-11 02:55:39", "2025-12-11 02:55:39", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765421739;s:18:\"\0*\0first_timestamp\";i:1677095594;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765421739;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-12-11 02:56:51", "2025-12-11 02:56:51", "45314", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3216", "wpforms_process_purge_spam", "complete", "2025-12-05 18:20:43", "2025-12-05 18:20:43", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764958843;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764958843;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-05 18:41:09", "2025-12-05 18:41:09", "44948", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3217", "wpforms_process_forms_locator_save", "complete", "2025-12-04 18:20:43", "2025-12-04 18:20:43", "{\"tasks_meta_id\":1025}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-12-04 18:20:43", "2025-12-04 18:20:43", "44890", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3218", "wpforms_process_forms_locator_scan", "complete", "2025-12-05 18:20:43", "2025-12-05 18:20:43", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764958843;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764958843;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-05 18:41:09", "2025-12-05 18:41:09", "44948", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3219", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-05 18:20:43", "2025-12-05 18:20:43", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764958843;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764958843;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-05 18:41:09", "2025-12-05 18:41:09", "44948", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3220", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-05 18:20:43", "2025-12-05 18:20:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764958843;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764958843;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-05 18:41:09", "2025-12-05 18:41:09", "44948", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3221", "wpforms_process_purge_spam", "complete", "2025-12-06 18:41:09", "2025-12-06 18:41:09", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765046469;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765046469;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-06 18:52:55", "2025-12-06 18:52:55", "45011", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3222", "wpforms_process_forms_locator_save", "complete", "2025-12-05 18:41:09", "2025-12-05 18:41:09", "{\"tasks_meta_id\":1026}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-12-05 18:41:09", "2025-12-05 18:41:09", "44949", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3223", "wpforms_process_forms_locator_scan", "complete", "2025-12-06 18:41:09", "2025-12-06 18:41:09", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765046469;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765046469;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-06 18:52:55", "2025-12-06 18:52:55", "45011", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3224", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-06 18:41:09", "2025-12-06 18:41:09", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765046469;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765046469;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-06 18:52:55", "2025-12-06 18:52:55", "45011", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3225", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-06 18:41:09", "2025-12-06 18:41:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765046469;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765046469;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-06 18:52:55", "2025-12-06 18:52:55", "45011", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3226", "wpforms_process_purge_spam", "complete", "2025-12-07 18:52:55", "2025-12-07 18:52:55", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765133575;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765133575;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-07 18:58:03", "2025-12-07 18:58:03", "45083", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3227", "wpforms_process_forms_locator_save", "complete", "2025-12-06 18:52:55", "2025-12-06 18:52:55", "{\"tasks_meta_id\":1027}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-12-06 18:52:55", "2025-12-06 18:52:55", "45012", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3228", "wpforms_process_forms_locator_scan", "complete", "2025-12-07 18:52:55", "2025-12-07 18:52:55", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765133575;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765133575;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-07 18:58:03", "2025-12-07 18:58:03", "45083", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3229", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-07 18:52:55", "2025-12-07 18:52:55", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765133575;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765133575;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-07 18:58:04", "2025-12-07 18:58:04", "45083", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3230", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-07 18:52:55", "2025-12-07 18:52:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765133575;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765133575;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-07 18:58:04", "2025-12-07 18:58:04", "45083", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3231", "wpforms_process_purge_spam", "complete", "2025-12-08 18:58:03", "2025-12-08 18:58:03", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765220283;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765220283;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-08 19:40:07", "2025-12-08 19:40:07", "45154", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3232", "wpforms_process_forms_locator_save", "complete", "2025-12-07 18:58:03", "2025-12-07 18:58:03", "{\"tasks_meta_id\":1028}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-12-07 18:58:04", "2025-12-07 18:58:04", "45084", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3233", "wpforms_process_forms_locator_scan", "complete", "2025-12-08 18:58:03", "2025-12-08 18:58:03", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765220283;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765220283;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-08 19:40:07", "2025-12-08 19:40:07", "45154", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3234", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-08 18:58:04", "2025-12-08 18:58:04", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765220284;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765220284;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-08 19:40:07", "2025-12-08 19:40:07", "45154", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3235", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-08 18:58:04", "2025-12-08 18:58:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765220284;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765220284;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-08 19:40:07", "2025-12-08 19:40:07", "45154", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3236", "wpforms_process_purge_spam", "complete", "2025-12-09 19:40:07", "2025-12-09 19:40:07", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765309207;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765309207;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-09 20:30:50", "2025-12-09 20:30:50", "45216", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3237", "wpforms_process_forms_locator_save", "complete", "2025-12-08 19:40:07", "2025-12-08 19:40:07", "{\"tasks_meta_id\":1029}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-12-08 19:40:07", "2025-12-08 19:40:07", "45155", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3238", "wpforms_process_forms_locator_scan", "complete", "2025-12-09 19:40:07", "2025-12-09 19:40:07", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765309207;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765309207;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-09 20:30:50", "2025-12-09 20:30:50", "45216", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3239", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-09 19:40:07", "2025-12-09 19:40:07", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765309207;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765309207;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-09 20:30:50", "2025-12-09 20:30:50", "45216", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3240", "wp_mail_smtp_summary_report_email", "pending", "2025-12-15 19:40:07", "2025-12-15 19:40:07", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765827607;s:18:\"\0*\0first_timestamp\";i:1756130400;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765827607;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "5", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3241", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-09 19:40:07", "2025-12-09 19:40:07", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765309207;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765309207;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-09 20:30:50", "2025-12-09 20:30:50", "45216", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3242", "wpforms_process_purge_spam", "complete", "2025-12-10 20:30:50", "2025-12-10 20:30:50", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765398650;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765398650;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-10 20:42:51", "2025-12-10 20:42:51", "45300", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3243", "wpforms_process_forms_locator_save", "complete", "2025-12-09 20:30:50", "2025-12-09 20:30:50", "{\"tasks_meta_id\":1030}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-12-09 20:30:50", "2025-12-09 20:30:50", "45217", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3244", "wpforms_process_forms_locator_scan", "complete", "2025-12-10 20:30:50", "2025-12-10 20:30:50", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765398650;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765398650;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-10 20:42:51", "2025-12-10 20:42:51", "45300", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3245", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-10 20:30:50", "2025-12-10 20:30:50", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765398650;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765398650;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-10 20:42:51", "2025-12-10 20:42:51", "45300", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3246", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-10 20:30:50", "2025-12-10 20:30:50", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765398650;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765398650;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-10 20:42:51", "2025-12-10 20:42:51", "45300", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3247", "wpforms_process_purge_spam", "complete", "2025-12-11 20:42:51", "2025-12-11 20:42:51", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765485771;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765485771;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-11 21:11:32", "2025-12-11 21:11:32", "45351", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3248", "wpforms_process_forms_locator_save", "complete", "2025-12-10 20:42:51", "2025-12-10 20:42:51", "{\"tasks_meta_id\":1031}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-12-10 20:42:51", "2025-12-10 20:42:51", "45301", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3249", "wpforms_process_forms_locator_scan", "complete", "2025-12-11 20:42:51", "2025-12-11 20:42:51", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765485771;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765485771;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-11 21:11:32", "2025-12-11 21:11:32", "45351", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3250", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-11 20:42:51", "2025-12-11 20:42:51", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765485771;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765485771;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-11 21:11:33", "2025-12-11 21:11:33", "45351", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3251", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-11 20:42:51", "2025-12-11 20:42:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765485771;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765485771;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-11 21:11:33", "2025-12-11 21:11:33", "45351", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3252", "wpforms_admin_addons_cache_update", "pending", "2025-12-18 02:56:51", "2025-12-18 02:56:51", "{\"tasks_meta_id\":36}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766026611;s:18:\"\0*\0first_timestamp\";i:1677753100;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766026611;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3253", "wpforms_admin_builder_templates_cache_update", "pending", "2025-12-18 02:56:51", "2025-12-18 02:56:51", "{\"tasks_meta_id\":38}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766026611;s:18:\"\0*\0first_timestamp\";i:1677753108;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766026611;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3254", "wpforms_builder_help_cache_update", "pending", "2025-12-18 02:56:51", "2025-12-18 02:56:51", "{\"tasks_meta_id\":39}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766026611;s:18:\"\0*\0first_timestamp\";i:1677753109;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766026611;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3255", "wpforms_email_summaries_fetch_info_blocks", "pending", "2025-12-18 02:56:51", "2025-12-18 02:56:51", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766026611;s:18:\"\0*\0first_timestamp\";i:1677095594;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766026611;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3256", "wpforms_process_purge_spam", "complete", "2025-12-12 21:11:32", "2025-12-12 21:11:32", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765573892;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765573892;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-12 21:12:02", "2025-12-12 21:12:02", "45400", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3257", "wpforms_process_forms_locator_save", "complete", "2025-12-11 21:11:32", "2025-12-11 21:11:32", "{\"tasks_meta_id\":1032}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-12-11 21:11:33", "2025-12-11 21:11:33", "45352", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3258", "wpforms_process_forms_locator_scan", "complete", "2025-12-12 21:11:32", "2025-12-12 21:11:32", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765573892;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765573892;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-12 21:12:02", "2025-12-12 21:12:02", "45400", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3259", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-12 21:11:33", "2025-12-12 21:11:33", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765573893;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765573893;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-12 21:12:02", "2025-12-12 21:12:02", "45400", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3260", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-12 21:11:33", "2025-12-12 21:11:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765573893;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765573893;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-12 21:12:02", "2025-12-12 21:12:02", "45400", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3261", "wpforms_process_purge_spam", "complete", "2025-12-13 21:12:02", "2025-12-13 21:12:02", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765660322;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765660322;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-13 21:12:33", "2025-12-13 21:12:33", "45487", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3262", "wpforms_process_forms_locator_save", "complete", "2025-12-12 21:12:02", "2025-12-12 21:12:02", "{\"tasks_meta_id\":1033}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-12-12 21:12:02", "2025-12-12 21:12:02", "45401", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3263", "wpforms_process_forms_locator_scan", "complete", "2025-12-13 21:12:02", "2025-12-13 21:12:02", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765660322;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765660322;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-13 21:12:33", "2025-12-13 21:12:33", "45487", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3264", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-13 21:12:02", "2025-12-13 21:12:02", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765660322;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765660322;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-13 21:12:33", "2025-12-13 21:12:33", "45487", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3265", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-13 21:12:02", "2025-12-13 21:12:02", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765660322;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765660322;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-13 21:12:33", "2025-12-13 21:12:33", "45487", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("3266", "wpforms_admin_notifications_update", "complete", "2025-12-13 19:43:00", "2025-12-13 19:43:00", "{\"tasks_meta_id\":1034}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-12-13 19:44:08", "2025-12-13 19:44:08", "45453", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3267", "wpforms_process_purge_spam", "pending", "2025-12-14 21:12:33", "2025-12-14 21:12:33", "{\"tasks_meta_id\":716}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765746753;s:18:\"\0*\0first_timestamp\";i:1738088902;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765746753;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3268", "wpforms_process_forms_locator_save", "complete", "2025-12-13 21:12:33", "2025-12-13 21:12:33", "{\"tasks_meta_id\":1035}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-12-13 21:12:33", "2025-12-13 21:12:33", "45488", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3269", "wpforms_process_forms_locator_scan", "pending", "2025-12-14 21:12:33", "2025-12-14 21:12:33", "{\"tasks_meta_id\":35}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765746753;s:18:\"\0*\0first_timestamp\";i:1677148300;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765746753;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3270", "wp_mail_smtp_admin_notifications_update", "pending", "2025-12-14 21:12:33", "2025-12-14 21:12:33", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765746753;s:18:\"\0*\0first_timestamp\";i:1755713569;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765746753;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3271", "action_scheduler_run_recurring_actions_schedule_hook", "pending", "2025-12-14 21:12:33", "2025-12-14 21:12:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765746753;s:18:\"\0*\0first_timestamp\";i:1753869667;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765746753;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "20");

/* INSERT TABLE DATA: wp_actionscheduler_claims */
INSERT INTO `wp_actionscheduler_claims` VALUES("775", "2023-02-14 00:18:26");
INSERT INTO `wp_actionscheduler_claims` VALUES("778", "2023-02-14 00:19:28");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "wpforms");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "rocket-preload");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "ActionScheduler");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "wp_mail_smtp");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("87", "39", "action created", "2023-02-13 17:03:05", "2023-02-13 17:03:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("90", "40", "action created", "2023-02-13 17:03:05", "2023-02-13 17:03:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("208", "39", "action started via WP Cron", "2023-02-20 18:43:55", "2023-02-20 18:43:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("209", "39", "action failed via WP Cron: Scheduled action for wpforms_admin_addons_cache_update will not be executed as no callbacks are registered.", "2023-02-20 18:43:55", "2023-02-20 18:43:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("211", "40", "action started via WP Cron", "2023-02-20 18:43:55", "2023-02-20 18:43:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("212", "40", "action failed via WP Cron: Scheduled action for wpforms_admin_builder_templates_cache_update will not be executed as no callbacks are registered.", "2023-02-20 18:43:55", "2023-02-20 18:43:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("268", "98", "action created", "2023-02-22 20:41:48", "2023-02-22 20:41:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("281", "98", "action started via Async Request", "2023-02-22 20:43:05", "2023-02-22 20:43:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("282", "98", "action failed via Async Request: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-02-22 20:43:05", "2023-02-22 20:43:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("9114", "3052", "action created", "2025-11-06 00:34:47", "2025-11-06 00:34:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("9117", "3053", "action created", "2025-11-06 00:34:47", "2025-11-06 00:34:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("9120", "3054", "action created", "2025-11-06 00:34:47", "2025-11-06 00:34:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("9123", "3055", "action created", "2025-11-06 00:34:47", "2025-11-06 00:34:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("9201", "3081", "action created", "2025-11-10 19:03:58", "2025-11-10 19:03:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("9219", "3087", "action created", "2025-11-12 12:02:22", "2025-11-12 12:02:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("9223", "3089", "action created", "2025-11-12 12:02:22", "2025-11-12 12:02:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("9226", "3090", "action created", "2025-11-12 12:02:22", "2025-11-12 12:02:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("9229", "3091", "action created", "2025-11-12 12:02:22", "2025-11-12 12:02:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("9232", "3052", "action started via WP Cron", "2025-11-13 01:54:34", "2025-11-13 01:54:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("9233", "3052", "action complete via WP Cron", "2025-11-13 01:54:34", "2025-11-13 01:54:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("9234", "3092", "action created", "2025-11-13 01:54:34", "2025-11-13 01:54:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("9235", "3053", "action started via WP Cron", "2025-11-13 01:54:34", "2025-11-13 01:54:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("9236", "3053", "action complete via WP Cron", "2025-11-13 01:54:34", "2025-11-13 01:54:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("9237", "3093", "action created", "2025-11-13 01:54:34", "2025-11-13 01:54:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("9238", "3054", "action started via WP Cron", "2025-11-13 01:54:34", "2025-11-13 01:54:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("9239", "3054", "action complete via WP Cron", "2025-11-13 01:54:34", "2025-11-13 01:54:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("9240", "3094", "action created", "2025-11-13 01:54:34", "2025-11-13 01:54:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("9241", "3055", "action started via WP Cron", "2025-11-13 01:54:34", "2025-11-13 01:54:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("9242", "3055", "action complete via WP Cron", "2025-11-13 01:54:34", "2025-11-13 01:54:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("9243", "3095", "action created", "2025-11-13 01:54:34", "2025-11-13 01:54:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("9244", "3087", "action started via WP Cron", "2025-11-13 12:38:12", "2025-11-13 12:38:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("9245", "3087", "action complete via WP Cron", "2025-11-13 12:38:12", "2025-11-13 12:38:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("9246", "3096", "action created", "2025-11-13 12:38:12", "2025-11-13 12:38:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("9247", "3089", "action started via WP Cron", "2025-11-13 12:38:12", "2025-11-13 12:38:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("9248", "3097", "action created", "2025-11-13 12:38:12", "2025-11-13 12:38:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("9249", "3089", "action complete via WP Cron", "2025-11-13 12:38:12", "2025-11-13 12:38:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("9250", "3098", "action created", "2025-11-13 12:38:12", "2025-11-13 12:38:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("9251", "3090", "action started via WP Cron", "2025-11-13 12:38:12", "2025-11-13 12:38:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("9252", "3090", "action complete via WP Cron", "2025-11-13 12:38:12", "2025-11-13 12:38:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("9253", "3099", "action created", "2025-11-13 12:38:12", "2025-11-13 12:38:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("9254", "3091", "action started via WP Cron", "2025-11-13 12:38:12", "2025-11-13 12:38:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("9255", "3091", "action complete via WP Cron", "2025-11-13 12:38:12", "2025-11-13 12:38:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("9256", "3100", "action created", "2025-11-13 12:38:12", "2025-11-13 12:38:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("9257", "3097", "action started via WP Cron", "2025-11-13 12:38:12", "2025-11-13 12:38:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("9258", "3097", "action complete via WP Cron", "2025-11-13 12:38:12", "2025-11-13 12:38:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("9259", "3096", "action started via WP Cron", "2025-11-14 12:38:28", "2025-11-14 12:38:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9260", "3096", "action complete via WP Cron", "2025-11-14 12:38:28", "2025-11-14 12:38:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9261", "3101", "action created", "2025-11-14 12:38:28", "2025-11-14 12:38:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9262", "3098", "action started via WP Cron", "2025-11-14 12:38:28", "2025-11-14 12:38:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9263", "3102", "action created", "2025-11-14 12:38:28", "2025-11-14 12:38:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9264", "3098", "action complete via WP Cron", "2025-11-14 12:38:28", "2025-11-14 12:38:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9265", "3103", "action created", "2025-11-14 12:38:28", "2025-11-14 12:38:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9266", "3099", "action started via WP Cron", "2025-11-14 12:38:28", "2025-11-14 12:38:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9267", "3099", "action complete via WP Cron", "2025-11-14 12:38:28", "2025-11-14 12:38:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9268", "3104", "action created", "2025-11-14 12:38:28", "2025-11-14 12:38:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9269", "3100", "action started via WP Cron", "2025-11-14 12:38:28", "2025-11-14 12:38:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9270", "3100", "action complete via WP Cron", "2025-11-14 12:38:28", "2025-11-14 12:38:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9271", "3105", "action created", "2025-11-14 12:38:28", "2025-11-14 12:38:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9272", "3102", "action started via WP Cron", "2025-11-14 12:38:28", "2025-11-14 12:38:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9273", "3102", "action complete via WP Cron", "2025-11-14 12:38:28", "2025-11-14 12:38:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9274", "3101", "action started via WP Cron", "2025-11-15 12:39:20", "2025-11-15 12:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("9275", "3101", "action complete via WP Cron", "2025-11-15 12:39:20", "2025-11-15 12:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("9276", "3106", "action created", "2025-11-15 12:39:20", "2025-11-15 12:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("9277", "3103", "action started via WP Cron", "2025-11-15 12:39:20", "2025-11-15 12:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("9278", "3107", "action created", "2025-11-15 12:39:20", "2025-11-15 12:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("9279", "3103", "action complete via WP Cron", "2025-11-15 12:39:20", "2025-11-15 12:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("9280", "3108", "action created", "2025-11-15 12:39:20", "2025-11-15 12:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("9281", "3104", "action started via WP Cron", "2025-11-15 12:39:20", "2025-11-15 12:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("9282", "3104", "action complete via WP Cron", "2025-11-15 12:39:20", "2025-11-15 12:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("9283", "3109", "action created", "2025-11-15 12:39:20", "2025-11-15 12:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("9284", "3105", "action started via WP Cron", "2025-11-15 12:39:20", "2025-11-15 12:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("9285", "3105", "action complete via WP Cron", "2025-11-15 12:39:20", "2025-11-15 12:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("9286", "3110", "action created", "2025-11-15 12:39:20", "2025-11-15 12:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("9287", "3107", "action started via WP Cron", "2025-11-15 12:39:20", "2025-11-15 12:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("9288", "3107", "action complete via WP Cron", "2025-11-15 12:39:20", "2025-11-15 12:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("9289", "3106", "action started via WP Cron", "2025-11-16 12:52:46", "2025-11-16 12:52:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("9290", "3106", "action complete via WP Cron", "2025-11-16 12:52:46", "2025-11-16 12:52:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("9291", "3111", "action created", "2025-11-16 12:52:46", "2025-11-16 12:52:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("9292", "3108", "action started via WP Cron", "2025-11-16 12:52:46", "2025-11-16 12:52:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("9293", "3112", "action created", "2025-11-16 12:52:46", "2025-11-16 12:52:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("9294", "3108", "action complete via WP Cron", "2025-11-16 12:52:46", "2025-11-16 12:52:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("9295", "3113", "action created", "2025-11-16 12:52:46", "2025-11-16 12:52:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("9296", "3109", "action started via WP Cron", "2025-11-16 12:52:46", "2025-11-16 12:52:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("9297", "3109", "action complete via WP Cron", "2025-11-16 12:52:46", "2025-11-16 12:52:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("9298", "3114", "action created", "2025-11-16 12:52:46", "2025-11-16 12:52:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("9299", "3110", "action started via WP Cron", "2025-11-16 12:52:46", "2025-11-16 12:52:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("9300", "3110", "action complete via WP Cron", "2025-11-16 12:52:46", "2025-11-16 12:52:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("9301", "3115", "action created", "2025-11-16 12:52:46", "2025-11-16 12:52:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("9302", "3112", "action started via WP Cron", "2025-11-16 12:52:46", "2025-11-16 12:52:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("9303", "3112", "action complete via WP Cron", "2025-11-16 12:52:46", "2025-11-16 12:52:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("9304", "3111", "action started via WP Cron", "2025-11-17 13:03:18", "2025-11-17 13:03:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("9305", "3111", "action complete via WP Cron", "2025-11-17 13:03:18", "2025-11-17 13:03:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("9306", "3116", "action created", "2025-11-17 13:03:18", "2025-11-17 13:03:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("9307", "3113", "action started via WP Cron", "2025-11-17 13:03:18", "2025-11-17 13:03:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("9308", "3117", "action created", "2025-11-17 13:03:18", "2025-11-17 13:03:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("9309", "3113", "action complete via WP Cron", "2025-11-17 13:03:18", "2025-11-17 13:03:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("9310", "3118", "action created", "2025-11-17 13:03:18", "2025-11-17 13:03:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("9311", "3114", "action started via WP Cron", "2025-11-17 13:03:18", "2025-11-17 13:03:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("9312", "3114", "action complete via WP Cron", "2025-11-17 13:03:19", "2025-11-17 13:03:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("9313", "3119", "action created", "2025-11-17 13:03:19", "2025-11-17 13:03:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("9314", "3115", "action started via WP Cron", "2025-11-17 13:03:19", "2025-11-17 13:03:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("9315", "3115", "action complete via WP Cron", "2025-11-17 13:03:19", "2025-11-17 13:03:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("9316", "3120", "action created", "2025-11-17 13:03:19", "2025-11-17 13:03:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("9317", "3117", "action started via WP Cron", "2025-11-17 13:03:19", "2025-11-17 13:03:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("9318", "3117", "action complete via WP Cron", "2025-11-17 13:03:19", "2025-11-17 13:03:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("9319", "3081", "action started via WP Cron", "2025-11-17 19:16:49", "2025-11-17 19:16:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("9320", "3081", "action complete via WP Cron", "2025-11-17 19:16:50", "2025-11-17 19:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("9321", "3121", "action created", "2025-11-17 19:16:50", "2025-11-17 19:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("9322", "3116", "action started via WP Cron", "2025-11-18 13:11:11", "2025-11-18 13:11:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("9323", "3116", "action complete via WP Cron", "2025-11-18 13:11:11", "2025-11-18 13:11:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("9324", "3122", "action created", "2025-11-18 13:11:11", "2025-11-18 13:11:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("9325", "3118", "action started via WP Cron", "2025-11-18 13:11:11", "2025-11-18 13:11:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("9326", "3123", "action created", "2025-11-18 13:11:11", "2025-11-18 13:11:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("9327", "3118", "action complete via WP Cron", "2025-11-18 13:11:11", "2025-11-18 13:11:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("9328", "3124", "action created", "2025-11-18 13:11:11", "2025-11-18 13:11:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("9329", "3119", "action started via WP Cron", "2025-11-18 13:11:11", "2025-11-18 13:11:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("9330", "3119", "action complete via WP Cron", "2025-11-18 13:11:11", "2025-11-18 13:11:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("9331", "3125", "action created", "2025-11-18 13:11:11", "2025-11-18 13:11:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("9332", "3120", "action started via WP Cron", "2025-11-18 13:11:11", "2025-11-18 13:11:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("9333", "3120", "action complete via WP Cron", "2025-11-18 13:11:11", "2025-11-18 13:11:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("9334", "3126", "action created", "2025-11-18 13:11:11", "2025-11-18 13:11:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("9335", "3123", "action started via WP Cron", "2025-11-18 13:11:11", "2025-11-18 13:11:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("9336", "3123", "action complete via WP Cron", "2025-11-18 13:11:11", "2025-11-18 13:11:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("9337", "3122", "action started via WP Cron", "2025-11-19 13:30:02", "2025-11-19 13:30:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9338", "3122", "action complete via WP Cron", "2025-11-19 13:30:02", "2025-11-19 13:30:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9339", "3127", "action created", "2025-11-19 13:30:02", "2025-11-19 13:30:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9340", "3124", "action started via WP Cron", "2025-11-19 13:30:02", "2025-11-19 13:30:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9341", "3128", "action created", "2025-11-19 13:30:02", "2025-11-19 13:30:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9342", "3124", "action complete via WP Cron", "2025-11-19 13:30:02", "2025-11-19 13:30:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9343", "3129", "action created", "2025-11-19 13:30:02", "2025-11-19 13:30:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9344", "3125", "action started via WP Cron", "2025-11-19 13:30:02", "2025-11-19 13:30:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9345", "3125", "action complete via WP Cron", "2025-11-19 13:30:02", "2025-11-19 13:30:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9346", "3130", "action created", "2025-11-19 13:30:02", "2025-11-19 13:30:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9347", "3126", "action started via WP Cron", "2025-11-19 13:30:02", "2025-11-19 13:30:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9348", "3126", "action complete via WP Cron", "2025-11-19 13:30:02", "2025-11-19 13:30:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9349", "3131", "action created", "2025-11-19 13:30:02", "2025-11-19 13:30:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9350", "3128", "action started via WP Cron", "2025-11-19 13:30:02", "2025-11-19 13:30:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9351", "3128", "action complete via WP Cron", "2025-11-19 13:30:02", "2025-11-19 13:30:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9352", "3092", "action started via WP Cron", "2025-11-20 02:16:21", "2025-11-20 02:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("9353", "3092", "action complete via WP Cron", "2025-11-20 02:16:21", "2025-11-20 02:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("9354", "3132", "action created", "2025-11-20 02:16:21", "2025-11-20 02:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("9355", "3093", "action started via WP Cron", "2025-11-20 02:16:21", "2025-11-20 02:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("9356", "3093", "action complete via WP Cron", "2025-11-20 02:16:21", "2025-11-20 02:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("9357", "3133", "action created", "2025-11-20 02:16:21", "2025-11-20 02:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("9358", "3094", "action started via WP Cron", "2025-11-20 02:16:21", "2025-11-20 02:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("9359", "3094", "action complete via WP Cron", "2025-11-20 02:16:21", "2025-11-20 02:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("9360", "3134", "action created", "2025-11-20 02:16:21", "2025-11-20 02:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("9361", "3095", "action started via WP Cron", "2025-11-20 02:16:21", "2025-11-20 02:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("9362", "3095", "action complete via WP Cron", "2025-11-20 02:16:21", "2025-11-20 02:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("9363", "3135", "action created", "2025-11-20 02:16:21", "2025-11-20 02:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("9364", "3127", "action started via WP Cron", "2025-11-20 13:55:47", "2025-11-20 13:55:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("9365", "3127", "action complete via WP Cron", "2025-11-20 13:55:47", "2025-11-20 13:55:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("9366", "3136", "action created", "2025-11-20 13:55:47", "2025-11-20 13:55:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("9367", "3129", "action started via WP Cron", "2025-11-20 13:55:47", "2025-11-20 13:55:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("9368", "3137", "action created", "2025-11-20 13:55:47", "2025-11-20 13:55:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("9369", "3129", "action complete via WP Cron", "2025-11-20 13:55:47", "2025-11-20 13:55:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("9370", "3138", "action created", "2025-11-20 13:55:47", "2025-11-20 13:55:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("9371", "3130", "action started via WP Cron", "2025-11-20 13:55:47", "2025-11-20 13:55:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("9372", "3130", "action complete via WP Cron", "2025-11-20 13:55:48", "2025-11-20 13:55:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("9373", "3139", "action created", "2025-11-20 13:55:48", "2025-11-20 13:55:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("9374", "3131", "action started via WP Cron", "2025-11-20 13:55:48", "2025-11-20 13:55:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("9375", "3131", "action complete via WP Cron", "2025-11-20 13:55:48", "2025-11-20 13:55:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("9376", "3140", "action created", "2025-11-20 13:55:48", "2025-11-20 13:55:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("9377", "3137", "action started via WP Cron", "2025-11-20 13:55:48", "2025-11-20 13:55:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("9378", "3137", "action complete via WP Cron", "2025-11-20 13:55:48", "2025-11-20 13:55:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("9379", "3136", "action started via WP Cron", "2025-11-21 14:09:37", "2025-11-21 14:09:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("9380", "3136", "action complete via WP Cron", "2025-11-21 14:09:37", "2025-11-21 14:09:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("9381", "3141", "action created", "2025-11-21 14:09:37", "2025-11-21 14:09:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("9382", "3138", "action started via WP Cron", "2025-11-21 14:09:37", "2025-11-21 14:09:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("9383", "3142", "action created", "2025-11-21 14:09:37", "2025-11-21 14:09:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("9384", "3138", "action complete via WP Cron", "2025-11-21 14:09:37", "2025-11-21 14:09:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("9385", "3143", "action created", "2025-11-21 14:09:37", "2025-11-21 14:09:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("9386", "3139", "action started via WP Cron", "2025-11-21 14:09:37", "2025-11-21 14:09:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("9387", "3139", "action complete via WP Cron", "2025-11-21 14:09:37", "2025-11-21 14:09:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("9388", "3144", "action created", "2025-11-21 14:09:37", "2025-11-21 14:09:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("9389", "3140", "action started via WP Cron", "2025-11-21 14:09:37", "2025-11-21 14:09:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("9390", "3140", "action complete via WP Cron", "2025-11-21 14:09:37", "2025-11-21 14:09:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("9391", "3145", "action created", "2025-11-21 14:09:37", "2025-11-21 14:09:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("9392", "3142", "action started via WP Cron", "2025-11-21 14:09:37", "2025-11-21 14:09:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("9393", "3142", "action complete via WP Cron", "2025-11-21 14:09:37", "2025-11-21 14:09:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("9394", "3141", "action started via WP Cron", "2025-11-22 14:43:43", "2025-11-22 14:43:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9395", "3141", "action complete via WP Cron", "2025-11-22 14:43:43", "2025-11-22 14:43:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9396", "3146", "action created", "2025-11-22 14:43:43", "2025-11-22 14:43:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9397", "3143", "action started via WP Cron", "2025-11-22 14:43:43", "2025-11-22 14:43:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9398", "3147", "action created", "2025-11-22 14:43:43", "2025-11-22 14:43:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9399", "3143", "action complete via WP Cron", "2025-11-22 14:43:43", "2025-11-22 14:43:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9400", "3148", "action created", "2025-11-22 14:43:43", "2025-11-22 14:43:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9401", "3144", "action started via WP Cron", "2025-11-22 14:43:43", "2025-11-22 14:43:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9402", "3144", "action complete via WP Cron", "2025-11-22 14:43:43", "2025-11-22 14:43:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9403", "3149", "action created", "2025-11-22 14:43:43", "2025-11-22 14:43:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9404", "3145", "action started via WP Cron", "2025-11-22 14:43:43", "2025-11-22 14:43:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9405", "3145", "action complete via WP Cron", "2025-11-22 14:43:43", "2025-11-22 14:43:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9406", "3150", "action created", "2025-11-22 14:43:43", "2025-11-22 14:43:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9407", "3147", "action started via WP Cron", "2025-11-22 14:43:43", "2025-11-22 14:43:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9408", "3147", "action complete via WP Cron", "2025-11-22 14:43:43", "2025-11-22 14:43:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9409", "3146", "action started via WP Cron", "2025-11-23 15:00:04", "2025-11-23 15:00:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("9410", "3146", "action complete via WP Cron", "2025-11-23 15:00:04", "2025-11-23 15:00:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("9411", "3151", "action created", "2025-11-23 15:00:04", "2025-11-23 15:00:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("9412", "3148", "action started via WP Cron", "2025-11-23 15:00:04", "2025-11-23 15:00:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("9413", "3152", "action created", "2025-11-23 15:00:04", "2025-11-23 15:00:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("9414", "3148", "action complete via WP Cron", "2025-11-23 15:00:04", "2025-11-23 15:00:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("9415", "3153", "action created", "2025-11-23 15:00:04", "2025-11-23 15:00:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("9416", "3149", "action started via WP Cron", "2025-11-23 15:00:04", "2025-11-23 15:00:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("9417", "3149", "action complete via WP Cron", "2025-11-23 15:00:04", "2025-11-23 15:00:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("9418", "3154", "action created", "2025-11-23 15:00:04", "2025-11-23 15:00:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("9419", "3150", "action started via WP Cron", "2025-11-23 15:00:04", "2025-11-23 15:00:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("9420", "3150", "action complete via WP Cron", "2025-11-23 15:00:04", "2025-11-23 15:00:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("9421", "3155", "action created", "2025-11-23 15:00:04", "2025-11-23 15:00:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("9422", "3152", "action started via WP Cron", "2025-11-23 15:00:04", "2025-11-23 15:00:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("9423", "3152", "action complete via WP Cron", "2025-11-23 15:00:04", "2025-11-23 15:00:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("9424", "3151", "action started via WP Cron", "2025-11-24 15:22:35", "2025-11-24 15:22:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("9425", "3151", "action complete via WP Cron", "2025-11-24 15:22:35", "2025-11-24 15:22:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("9426", "3156", "action created", "2025-11-24 15:22:35", "2025-11-24 15:22:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("9427", "3153", "action started via WP Cron", "2025-11-24 15:22:35", "2025-11-24 15:22:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("9428", "3157", "action created", "2025-11-24 15:22:35", "2025-11-24 15:22:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("9429", "3153", "action complete via WP Cron", "2025-11-24 15:22:35", "2025-11-24 15:22:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("9430", "3158", "action created", "2025-11-24 15:22:35", "2025-11-24 15:22:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("9431", "3154", "action started via WP Cron", "2025-11-24 15:22:35", "2025-11-24 15:22:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("9432", "3154", "action complete via WP Cron", "2025-11-24 15:22:35", "2025-11-24 15:22:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("9433", "3159", "action created", "2025-11-24 15:22:35", "2025-11-24 15:22:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("9434", "3155", "action started via WP Cron", "2025-11-24 15:22:35", "2025-11-24 15:22:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("9435", "3155", "action complete via WP Cron", "2025-11-24 15:22:35", "2025-11-24 15:22:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("9436", "3160", "action created", "2025-11-24 15:22:35", "2025-11-24 15:22:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("9437", "3157", "action started via WP Cron", "2025-11-24 15:22:35", "2025-11-24 15:22:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("9438", "3157", "action complete via WP Cron", "2025-11-24 15:22:35", "2025-11-24 15:22:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("9439", "3121", "action started via WP Cron", "2025-11-24 19:25:27", "2025-11-24 19:25:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("9440", "3121", "action complete via WP Cron", "2025-11-24 19:25:28", "2025-11-24 19:25:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9441", "3161", "action created", "2025-11-24 19:25:28", "2025-11-24 19:25:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9442", "3156", "action started via WP Cron", "2025-11-25 15:25:06", "2025-11-25 15:25:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("9443", "3156", "action complete via WP Cron", "2025-11-25 15:25:06", "2025-11-25 15:25:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("9444", "3162", "action created", "2025-11-25 15:25:06", "2025-11-25 15:25:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("9445", "3158", "action started via WP Cron", "2025-11-25 15:25:06", "2025-11-25 15:25:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("9446", "3163", "action created", "2025-11-25 15:25:06", "2025-11-25 15:25:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("9447", "3158", "action complete via WP Cron", "2025-11-25 15:25:06", "2025-11-25 15:25:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("9448", "3164", "action created", "2025-11-25 15:25:06", "2025-11-25 15:25:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("9449", "3159", "action started via WP Cron", "2025-11-25 15:25:06", "2025-11-25 15:25:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("9450", "3159", "action complete via WP Cron", "2025-11-25 15:25:07", "2025-11-25 15:25:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9451", "3165", "action created", "2025-11-25 15:25:07", "2025-11-25 15:25:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9452", "3160", "action started via WP Cron", "2025-11-25 15:25:07", "2025-11-25 15:25:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9453", "3160", "action complete via WP Cron", "2025-11-25 15:25:07", "2025-11-25 15:25:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9454", "3166", "action created", "2025-11-25 15:25:07", "2025-11-25 15:25:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9455", "3163", "action started via WP Cron", "2025-11-25 15:25:07", "2025-11-25 15:25:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9456", "3163", "action complete via WP Cron", "2025-11-25 15:25:07", "2025-11-25 15:25:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9457", "3162", "action started via WP Cron", "2025-11-26 15:31:53", "2025-11-26 15:31:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("9458", "3162", "action complete via WP Cron", "2025-11-26 15:31:53", "2025-11-26 15:31:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("9459", "3167", "action created", "2025-11-26 15:31:53", "2025-11-26 15:31:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("9460", "3164", "action started via WP Cron", "2025-11-26 15:31:53", "2025-11-26 15:31:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("9461", "3168", "action created", "2025-11-26 15:31:53", "2025-11-26 15:31:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("9462", "3164", "action complete via WP Cron", "2025-11-26 15:31:53", "2025-11-26 15:31:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("9463", "3169", "action created", "2025-11-26 15:31:53", "2025-11-26 15:31:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("9464", "3165", "action started via WP Cron", "2025-11-26 15:31:53", "2025-11-26 15:31:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("9465", "3165", "action complete via WP Cron", "2025-11-26 15:31:53", "2025-11-26 15:31:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("9466", "3170", "action created", "2025-11-26 15:31:53", "2025-11-26 15:31:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("9467", "3166", "action started via WP Cron", "2025-11-26 15:31:53", "2025-11-26 15:31:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("9468", "3166", "action complete via WP Cron", "2025-11-26 15:31:53", "2025-11-26 15:31:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("9469", "3171", "action created", "2025-11-26 15:31:53", "2025-11-26 15:31:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("9470", "3168", "action started via WP Cron", "2025-11-26 15:31:53", "2025-11-26 15:31:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("9471", "3168", "action complete via WP Cron", "2025-11-26 15:31:53", "2025-11-26 15:31:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("9472", "3132", "action started via WP Cron", "2025-11-27 02:16:59", "2025-11-27 02:16:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("9473", "3132", "action complete via WP Cron", "2025-11-27 02:16:59", "2025-11-27 02:16:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("9474", "3172", "action created", "2025-11-27 02:16:59", "2025-11-27 02:16:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("9475", "3133", "action started via WP Cron", "2025-11-27 02:16:59", "2025-11-27 02:16:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("9476", "3133", "action complete via WP Cron", "2025-11-27 02:16:59", "2025-11-27 02:16:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("9477", "3173", "action created", "2025-11-27 02:16:59", "2025-11-27 02:16:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("9478", "3134", "action started via WP Cron", "2025-11-27 02:16:59", "2025-11-27 02:16:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("9479", "3134", "action complete via WP Cron", "2025-11-27 02:16:59", "2025-11-27 02:16:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("9480", "3174", "action created", "2025-11-27 02:16:59", "2025-11-27 02:16:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("9481", "3135", "action started via WP Cron", "2025-11-27 02:16:59", "2025-11-27 02:16:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("9482", "3135", "action complete via WP Cron", "2025-11-27 02:16:59", "2025-11-27 02:16:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("9483", "3175", "action created", "2025-11-27 02:16:59", "2025-11-27 02:16:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("9484", "3167", "action started via WP Cron", "2025-11-27 16:22:07", "2025-11-27 16:22:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9485", "3167", "action complete via WP Cron", "2025-11-27 16:22:07", "2025-11-27 16:22:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9486", "3176", "action created", "2025-11-27 16:22:07", "2025-11-27 16:22:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9487", "3169", "action started via WP Cron", "2025-11-27 16:22:07", "2025-11-27 16:22:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9488", "3177", "action created", "2025-11-27 16:22:07", "2025-11-27 16:22:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9489", "3169", "action complete via WP Cron", "2025-11-27 16:22:07", "2025-11-27 16:22:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9490", "3178", "action created", "2025-11-27 16:22:07", "2025-11-27 16:22:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9491", "3170", "action started via WP Cron", "2025-11-27 16:22:07", "2025-11-27 16:22:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9492", "3170", "action complete via WP Cron", "2025-11-27 16:22:07", "2025-11-27 16:22:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9493", "3179", "action created", "2025-11-27 16:22:07", "2025-11-27 16:22:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9494", "3171", "action started via WP Cron", "2025-11-27 16:22:07", "2025-11-27 16:22:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9495", "3171", "action complete via WP Cron", "2025-11-27 16:22:07", "2025-11-27 16:22:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9496", "3180", "action created", "2025-11-27 16:22:07", "2025-11-27 16:22:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9497", "3177", "action started via WP Cron", "2025-11-27 16:22:07", "2025-11-27 16:22:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9498", "3177", "action complete via WP Cron", "2025-11-27 16:22:07", "2025-11-27 16:22:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9499", "3176", "action started via WP Cron", "2025-11-28 17:04:30", "2025-11-28 17:04:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("9500", "3176", "action complete via WP Cron", "2025-11-28 17:04:30", "2025-11-28 17:04:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("9501", "3181", "action created", "2025-11-28 17:04:30", "2025-11-28 17:04:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("9502", "3178", "action started via WP Cron", "2025-11-28 17:04:30", "2025-11-28 17:04:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("9503", "3182", "action created", "2025-11-28 17:04:30", "2025-11-28 17:04:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("9504", "3178", "action complete via WP Cron", "2025-11-28 17:04:30", "2025-11-28 17:04:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("9505", "3183", "action created", "2025-11-28 17:04:30", "2025-11-28 17:04:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("9506", "3179", "action started via WP Cron", "2025-11-28 17:04:30", "2025-11-28 17:04:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("9507", "3179", "action complete via WP Cron", "2025-11-28 17:04:30", "2025-11-28 17:04:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("9508", "3184", "action created", "2025-11-28 17:04:30", "2025-11-28 17:04:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("9509", "3180", "action started via WP Cron", "2025-11-28 17:04:30", "2025-11-28 17:04:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("9510", "3180", "action complete via WP Cron", "2025-11-28 17:04:30", "2025-11-28 17:04:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("9511", "3185", "action created", "2025-11-28 17:04:30", "2025-11-28 17:04:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("9512", "3182", "action started via WP Cron", "2025-11-28 17:04:30", "2025-11-28 17:04:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("9513", "3182", "action complete via WP Cron", "2025-11-28 17:04:30", "2025-11-28 17:04:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("9514", "3181", "action started via WP Cron", "2025-11-29 17:09:25", "2025-11-29 17:09:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("9515", "3181", "action complete via WP Cron", "2025-11-29 17:09:25", "2025-11-29 17:09:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("9516", "3186", "action created", "2025-11-29 17:09:25", "2025-11-29 17:09:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("9517", "3183", "action started via WP Cron", "2025-11-29 17:09:25", "2025-11-29 17:09:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("9518", "3187", "action created", "2025-11-29 17:09:25", "2025-11-29 17:09:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("9519", "3183", "action complete via WP Cron", "2025-11-29 17:09:25", "2025-11-29 17:09:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("9520", "3188", "action created", "2025-11-29 17:09:25", "2025-11-29 17:09:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("9521", "3184", "action started via WP Cron", "2025-11-29 17:09:25", "2025-11-29 17:09:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("9522", "3184", "action complete via WP Cron", "2025-11-29 17:09:25", "2025-11-29 17:09:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("9523", "3189", "action created", "2025-11-29 17:09:25", "2025-11-29 17:09:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("9524", "3185", "action started via WP Cron", "2025-11-29 17:09:25", "2025-11-29 17:09:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("9525", "3185", "action complete via WP Cron", "2025-11-29 17:09:25", "2025-11-29 17:09:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("9526", "3190", "action created", "2025-11-29 17:09:25", "2025-11-29 17:09:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("9527", "3187", "action started via WP Cron", "2025-11-29 17:09:25", "2025-11-29 17:09:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("9528", "3187", "action complete via WP Cron", "2025-11-29 17:09:25", "2025-11-29 17:09:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("9529", "3186", "action started via WP Cron", "2025-11-30 17:19:06", "2025-11-30 17:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("9530", "3186", "action complete via WP Cron", "2025-11-30 17:19:06", "2025-11-30 17:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("9531", "3191", "action created", "2025-11-30 17:19:06", "2025-11-30 17:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("9532", "3188", "action started via WP Cron", "2025-11-30 17:19:06", "2025-11-30 17:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("9533", "3192", "action created", "2025-11-30 17:19:06", "2025-11-30 17:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("9534", "3188", "action complete via WP Cron", "2025-11-30 17:19:06", "2025-11-30 17:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("9535", "3193", "action created", "2025-11-30 17:19:06", "2025-11-30 17:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("9536", "3189", "action started via WP Cron", "2025-11-30 17:19:06", "2025-11-30 17:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("9537", "3189", "action complete via WP Cron", "2025-11-30 17:19:06", "2025-11-30 17:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("9538", "3194", "action created", "2025-11-30 17:19:06", "2025-11-30 17:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("9539", "3190", "action started via WP Cron", "2025-11-30 17:19:06", "2025-11-30 17:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("9540", "3190", "action complete via WP Cron", "2025-11-30 17:19:06", "2025-11-30 17:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("9541", "3195", "action created", "2025-11-30 17:19:06", "2025-11-30 17:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("9542", "3192", "action started via WP Cron", "2025-11-30 17:19:06", "2025-11-30 17:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("9543", "3192", "action complete via WP Cron", "2025-11-30 17:19:06", "2025-11-30 17:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("9544", "3191", "action started via WP Cron", "2025-12-01 17:31:55", "2025-12-01 17:31:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9545", "3191", "action complete via WP Cron", "2025-12-01 17:31:55", "2025-12-01 17:31:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9546", "3196", "action created", "2025-12-01 17:31:55", "2025-12-01 17:31:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9547", "3193", "action started via WP Cron", "2025-12-01 17:31:55", "2025-12-01 17:31:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9548", "3197", "action created", "2025-12-01 17:31:55", "2025-12-01 17:31:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9549", "3193", "action complete via WP Cron", "2025-12-01 17:31:55", "2025-12-01 17:31:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9550", "3198", "action created", "2025-12-01 17:31:55", "2025-12-01 17:31:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9551", "3194", "action started via WP Cron", "2025-12-01 17:31:55", "2025-12-01 17:31:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9552", "3194", "action complete via WP Cron", "2025-12-01 17:31:55", "2025-12-01 17:31:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9553", "3199", "action created", "2025-12-01 17:31:55", "2025-12-01 17:31:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9554", "3195", "action started via WP Cron", "2025-12-01 17:31:55", "2025-12-01 17:31:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9555", "3195", "action complete via WP Cron", "2025-12-01 17:31:55", "2025-12-01 17:31:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9556", "3200", "action created", "2025-12-01 17:31:55", "2025-12-01 17:31:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9557", "3197", "action started via WP Cron", "2025-12-01 17:31:55", "2025-12-01 17:31:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9558", "3197", "action complete via WP Cron", "2025-12-01 17:31:55", "2025-12-01 17:31:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9559", "3161", "action started via WP Cron", "2025-12-01 19:37:11", "2025-12-01 19:37:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("9560", "3161", "action complete via WP Cron", "2025-12-01 19:37:11", "2025-12-01 19:37:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("9561", "3201", "action created", "2025-12-01 19:37:11", "2025-12-01 19:37:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("9562", "3196", "action started via WP Cron", "2025-12-02 17:36:28", "2025-12-02 17:36:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9563", "3196", "action complete via WP Cron", "2025-12-02 17:36:28", "2025-12-02 17:36:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9564", "3202", "action created", "2025-12-02 17:36:28", "2025-12-02 17:36:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9565", "3198", "action started via WP Cron", "2025-12-02 17:36:28", "2025-12-02 17:36:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9566", "3203", "action created", "2025-12-02 17:36:28", "2025-12-02 17:36:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9567", "3198", "action complete via WP Cron", "2025-12-02 17:36:28", "2025-12-02 17:36:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9568", "3204", "action created", "2025-12-02 17:36:28", "2025-12-02 17:36:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9569", "3199", "action started via WP Cron", "2025-12-02 17:36:28", "2025-12-02 17:36:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9570", "3199", "action complete via WP Cron", "2025-12-02 17:36:28", "2025-12-02 17:36:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9571", "3205", "action created", "2025-12-02 17:36:28", "2025-12-02 17:36:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9572", "3200", "action started via WP Cron", "2025-12-02 17:36:28", "2025-12-02 17:36:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9573", "3200", "action complete via WP Cron", "2025-12-02 17:36:28", "2025-12-02 17:36:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9574", "3206", "action created", "2025-12-02 17:36:28", "2025-12-02 17:36:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9575", "3203", "action started via WP Cron", "2025-12-02 17:36:28", "2025-12-02 17:36:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9576", "3203", "action complete via WP Cron", "2025-12-02 17:36:28", "2025-12-02 17:36:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("9577", "3202", "action started via WP Cron", "2025-12-03 18:05:42", "2025-12-03 18:05:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("9578", "3202", "action complete via WP Cron", "2025-12-03 18:05:42", "2025-12-03 18:05:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("9579", "3207", "action created", "2025-12-03 18:05:42", "2025-12-03 18:05:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("9580", "3204", "action started via WP Cron", "2025-12-03 18:05:42", "2025-12-03 18:05:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("9581", "3208", "action created", "2025-12-03 18:05:42", "2025-12-03 18:05:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("9582", "3204", "action complete via WP Cron", "2025-12-03 18:05:42", "2025-12-03 18:05:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("9583", "3209", "action created", "2025-12-03 18:05:42", "2025-12-03 18:05:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("9584", "3205", "action started via WP Cron", "2025-12-03 18:05:42", "2025-12-03 18:05:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("9585", "3205", "action complete via WP Cron", "2025-12-03 18:05:42", "2025-12-03 18:05:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("9586", "3210", "action created", "2025-12-03 18:05:42", "2025-12-03 18:05:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("9587", "3206", "action started via WP Cron", "2025-12-03 18:05:42", "2025-12-03 18:05:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("9588", "3206", "action complete via WP Cron", "2025-12-03 18:05:42", "2025-12-03 18:05:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("9589", "3211", "action created", "2025-12-03 18:05:42", "2025-12-03 18:05:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("9590", "3208", "action started via WP Cron", "2025-12-03 18:05:42", "2025-12-03 18:05:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("9591", "3208", "action complete via WP Cron", "2025-12-03 18:05:42", "2025-12-03 18:05:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("9592", "3172", "action started via WP Cron", "2025-12-04 02:55:38", "2025-12-04 02:55:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("9593", "3172", "action complete via WP Cron", "2025-12-04 02:55:38", "2025-12-04 02:55:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("9594", "3212", "action created", "2025-12-04 02:55:38", "2025-12-04 02:55:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("9595", "3173", "action started via WP Cron", "2025-12-04 02:55:38", "2025-12-04 02:55:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("9596", "3173", "action complete via WP Cron", "2025-12-04 02:55:39", "2025-12-04 02:55:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("9597", "3213", "action created", "2025-12-04 02:55:39", "2025-12-04 02:55:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("9598", "3174", "action started via WP Cron", "2025-12-04 02:55:39", "2025-12-04 02:55:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("9599", "3174", "action complete via WP Cron", "2025-12-04 02:55:39", "2025-12-04 02:55:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("9600", "3214", "action created", "2025-12-04 02:55:39", "2025-12-04 02:55:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("9601", "3175", "action started via WP Cron", "2025-12-04 02:55:39", "2025-12-04 02:55:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("9602", "3175", "action complete via WP Cron", "2025-12-04 02:55:39", "2025-12-04 02:55:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("9603", "3215", "action created", "2025-12-04 02:55:39", "2025-12-04 02:55:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("9604", "3207", "action started via WP Cron", "2025-12-04 18:20:43", "2025-12-04 18:20:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9605", "3207", "action complete via WP Cron", "2025-12-04 18:20:43", "2025-12-04 18:20:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9606", "3216", "action created", "2025-12-04 18:20:43", "2025-12-04 18:20:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9607", "3209", "action started via WP Cron", "2025-12-04 18:20:43", "2025-12-04 18:20:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9608", "3217", "action created", "2025-12-04 18:20:43", "2025-12-04 18:20:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9609", "3209", "action complete via WP Cron", "2025-12-04 18:20:43", "2025-12-04 18:20:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9610", "3218", "action created", "2025-12-04 18:20:43", "2025-12-04 18:20:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9611", "3210", "action started via WP Cron", "2025-12-04 18:20:43", "2025-12-04 18:20:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9612", "3210", "action complete via WP Cron", "2025-12-04 18:20:43", "2025-12-04 18:20:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9613", "3219", "action created", "2025-12-04 18:20:43", "2025-12-04 18:20:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9614", "3211", "action started via WP Cron", "2025-12-04 18:20:43", "2025-12-04 18:20:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9615", "3211", "action complete via WP Cron", "2025-12-04 18:20:43", "2025-12-04 18:20:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9616", "3220", "action created", "2025-12-04 18:20:43", "2025-12-04 18:20:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9617", "3217", "action started via WP Cron", "2025-12-04 18:20:43", "2025-12-04 18:20:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9618", "3217", "action complete via WP Cron", "2025-12-04 18:20:43", "2025-12-04 18:20:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("9619", "3216", "action started via WP Cron", "2025-12-05 18:41:09", "2025-12-05 18:41:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("9620", "3216", "action complete via WP Cron", "2025-12-05 18:41:09", "2025-12-05 18:41:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("9621", "3221", "action created", "2025-12-05 18:41:09", "2025-12-05 18:41:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("9622", "3218", "action started via WP Cron", "2025-12-05 18:41:09", "2025-12-05 18:41:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("9623", "3222", "action created", "2025-12-05 18:41:09", "2025-12-05 18:41:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("9624", "3218", "action complete via WP Cron", "2025-12-05 18:41:09", "2025-12-05 18:41:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("9625", "3223", "action created", "2025-12-05 18:41:09", "2025-12-05 18:41:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("9626", "3219", "action started via WP Cron", "2025-12-05 18:41:09", "2025-12-05 18:41:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("9627", "3219", "action complete via WP Cron", "2025-12-05 18:41:09", "2025-12-05 18:41:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("9628", "3224", "action created", "2025-12-05 18:41:09", "2025-12-05 18:41:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("9629", "3220", "action started via WP Cron", "2025-12-05 18:41:09", "2025-12-05 18:41:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("9630", "3220", "action complete via WP Cron", "2025-12-05 18:41:09", "2025-12-05 18:41:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("9631", "3225", "action created", "2025-12-05 18:41:09", "2025-12-05 18:41:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("9632", "3222", "action started via WP Cron", "2025-12-05 18:41:09", "2025-12-05 18:41:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("9633", "3222", "action complete via WP Cron", "2025-12-05 18:41:09", "2025-12-05 18:41:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("9634", "3221", "action started via WP Cron", "2025-12-06 18:52:55", "2025-12-06 18:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9635", "3221", "action complete via WP Cron", "2025-12-06 18:52:55", "2025-12-06 18:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9636", "3226", "action created", "2025-12-06 18:52:55", "2025-12-06 18:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9637", "3223", "action started via WP Cron", "2025-12-06 18:52:55", "2025-12-06 18:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9638", "3227", "action created", "2025-12-06 18:52:55", "2025-12-06 18:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9639", "3223", "action complete via WP Cron", "2025-12-06 18:52:55", "2025-12-06 18:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9640", "3228", "action created", "2025-12-06 18:52:55", "2025-12-06 18:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9641", "3224", "action started via WP Cron", "2025-12-06 18:52:55", "2025-12-06 18:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9642", "3224", "action complete via WP Cron", "2025-12-06 18:52:55", "2025-12-06 18:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9643", "3229", "action created", "2025-12-06 18:52:55", "2025-12-06 18:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9644", "3225", "action started via WP Cron", "2025-12-06 18:52:55", "2025-12-06 18:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9645", "3225", "action complete via WP Cron", "2025-12-06 18:52:55", "2025-12-06 18:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9646", "3230", "action created", "2025-12-06 18:52:55", "2025-12-06 18:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9647", "3227", "action started via WP Cron", "2025-12-06 18:52:55", "2025-12-06 18:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9648", "3227", "action complete via WP Cron", "2025-12-06 18:52:55", "2025-12-06 18:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9649", "3226", "action started via WP Cron", "2025-12-07 18:58:03", "2025-12-07 18:58:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("9650", "3226", "action complete via WP Cron", "2025-12-07 18:58:03", "2025-12-07 18:58:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("9651", "3231", "action created", "2025-12-07 18:58:03", "2025-12-07 18:58:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("9652", "3228", "action started via WP Cron", "2025-12-07 18:58:03", "2025-12-07 18:58:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("9653", "3232", "action created", "2025-12-07 18:58:03", "2025-12-07 18:58:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("9654", "3228", "action complete via WP Cron", "2025-12-07 18:58:03", "2025-12-07 18:58:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("9655", "3233", "action created", "2025-12-07 18:58:03", "2025-12-07 18:58:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("9656", "3229", "action started via WP Cron", "2025-12-07 18:58:04", "2025-12-07 18:58:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("9657", "3229", "action complete via WP Cron", "2025-12-07 18:58:04", "2025-12-07 18:58:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("9658", "3234", "action created", "2025-12-07 18:58:04", "2025-12-07 18:58:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("9659", "3230", "action started via WP Cron", "2025-12-07 18:58:04", "2025-12-07 18:58:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("9660", "3230", "action complete via WP Cron", "2025-12-07 18:58:04", "2025-12-07 18:58:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("9661", "3235", "action created", "2025-12-07 18:58:04", "2025-12-07 18:58:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("9662", "3232", "action started via WP Cron", "2025-12-07 18:58:04", "2025-12-07 18:58:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("9663", "3232", "action complete via WP Cron", "2025-12-07 18:58:04", "2025-12-07 18:58:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("9664", "3231", "action started via WP Cron", "2025-12-08 19:40:07", "2025-12-08 19:40:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9665", "3231", "action complete via WP Cron", "2025-12-08 19:40:07", "2025-12-08 19:40:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9666", "3236", "action created", "2025-12-08 19:40:07", "2025-12-08 19:40:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9667", "3233", "action started via WP Cron", "2025-12-08 19:40:07", "2025-12-08 19:40:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9668", "3237", "action created", "2025-12-08 19:40:07", "2025-12-08 19:40:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9669", "3233", "action complete via WP Cron", "2025-12-08 19:40:07", "2025-12-08 19:40:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9670", "3238", "action created", "2025-12-08 19:40:07", "2025-12-08 19:40:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9671", "3234", "action started via WP Cron", "2025-12-08 19:40:07", "2025-12-08 19:40:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9672", "3234", "action complete via WP Cron", "2025-12-08 19:40:07", "2025-12-08 19:40:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9673", "3239", "action created", "2025-12-08 19:40:07", "2025-12-08 19:40:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9674", "3201", "action started via WP Cron", "2025-12-08 19:40:07", "2025-12-08 19:40:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9675", "3201", "action complete via WP Cron", "2025-12-08 19:40:07", "2025-12-08 19:40:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9676", "3240", "action created", "2025-12-08 19:40:07", "2025-12-08 19:40:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9677", "3235", "action started via WP Cron", "2025-12-08 19:40:07", "2025-12-08 19:40:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9678", "3235", "action complete via WP Cron", "2025-12-08 19:40:07", "2025-12-08 19:40:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9679", "3241", "action created", "2025-12-08 19:40:07", "2025-12-08 19:40:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9680", "3237", "action started via WP Cron", "2025-12-08 19:40:07", "2025-12-08 19:40:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9681", "3237", "action complete via WP Cron", "2025-12-08 19:40:07", "2025-12-08 19:40:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("9682", "3236", "action started via WP Cron", "2025-12-09 20:30:50", "2025-12-09 20:30:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("9683", "3236", "action complete via WP Cron", "2025-12-09 20:30:50", "2025-12-09 20:30:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("9684", "3242", "action created", "2025-12-09 20:30:50", "2025-12-09 20:30:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("9685", "3238", "action started via WP Cron", "2025-12-09 20:30:50", "2025-12-09 20:30:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("9686", "3243", "action created", "2025-12-09 20:30:50", "2025-12-09 20:30:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("9687", "3238", "action complete via WP Cron", "2025-12-09 20:30:50", "2025-12-09 20:30:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("9688", "3244", "action created", "2025-12-09 20:30:50", "2025-12-09 20:30:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("9689", "3239", "action started via WP Cron", "2025-12-09 20:30:50", "2025-12-09 20:30:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("9690", "3239", "action complete via WP Cron", "2025-12-09 20:30:50", "2025-12-09 20:30:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("9691", "3245", "action created", "2025-12-09 20:30:50", "2025-12-09 20:30:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("9692", "3241", "action started via WP Cron", "2025-12-09 20:30:50", "2025-12-09 20:30:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("9693", "3241", "action complete via WP Cron", "2025-12-09 20:30:50", "2025-12-09 20:30:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("9694", "3246", "action created", "2025-12-09 20:30:50", "2025-12-09 20:30:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("9695", "3243", "action started via WP Cron", "2025-12-09 20:30:50", "2025-12-09 20:30:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("9696", "3243", "action complete via WP Cron", "2025-12-09 20:30:50", "2025-12-09 20:30:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("9697", "3242", "action started via WP Cron", "2025-12-10 20:42:51", "2025-12-10 20:42:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9698", "3242", "action complete via WP Cron", "2025-12-10 20:42:51", "2025-12-10 20:42:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9699", "3247", "action created", "2025-12-10 20:42:51", "2025-12-10 20:42:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9700", "3244", "action started via WP Cron", "2025-12-10 20:42:51", "2025-12-10 20:42:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9701", "3248", "action created", "2025-12-10 20:42:51", "2025-12-10 20:42:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9702", "3244", "action complete via WP Cron", "2025-12-10 20:42:51", "2025-12-10 20:42:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9703", "3249", "action created", "2025-12-10 20:42:51", "2025-12-10 20:42:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9704", "3245", "action started via WP Cron", "2025-12-10 20:42:51", "2025-12-10 20:42:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9705", "3245", "action complete via WP Cron", "2025-12-10 20:42:51", "2025-12-10 20:42:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9706", "3250", "action created", "2025-12-10 20:42:51", "2025-12-10 20:42:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9707", "3246", "action started via WP Cron", "2025-12-10 20:42:51", "2025-12-10 20:42:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9708", "3246", "action complete via WP Cron", "2025-12-10 20:42:51", "2025-12-10 20:42:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9709", "3251", "action created", "2025-12-10 20:42:51", "2025-12-10 20:42:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9710", "3248", "action started via WP Cron", "2025-12-10 20:42:51", "2025-12-10 20:42:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9711", "3248", "action complete via WP Cron", "2025-12-10 20:42:51", "2025-12-10 20:42:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9712", "3212", "action started via WP Cron", "2025-12-11 02:56:51", "2025-12-11 02:56:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9713", "3212", "action complete via WP Cron", "2025-12-11 02:56:51", "2025-12-11 02:56:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9714", "3252", "action created", "2025-12-11 02:56:51", "2025-12-11 02:56:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9715", "3213", "action started via WP Cron", "2025-12-11 02:56:51", "2025-12-11 02:56:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9716", "3213", "action complete via WP Cron", "2025-12-11 02:56:51", "2025-12-11 02:56:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9717", "3253", "action created", "2025-12-11 02:56:51", "2025-12-11 02:56:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9718", "3214", "action started via WP Cron", "2025-12-11 02:56:51", "2025-12-11 02:56:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9719", "3214", "action complete via WP Cron", "2025-12-11 02:56:51", "2025-12-11 02:56:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9720", "3254", "action created", "2025-12-11 02:56:51", "2025-12-11 02:56:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9721", "3215", "action started via WP Cron", "2025-12-11 02:56:51", "2025-12-11 02:56:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9722", "3215", "action complete via WP Cron", "2025-12-11 02:56:51", "2025-12-11 02:56:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9723", "3255", "action created", "2025-12-11 02:56:51", "2025-12-11 02:56:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("9724", "3247", "action started via WP Cron", "2025-12-11 21:11:32", "2025-12-11 21:11:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("9725", "3247", "action complete via WP Cron", "2025-12-11 21:11:32", "2025-12-11 21:11:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("9726", "3256", "action created", "2025-12-11 21:11:32", "2025-12-11 21:11:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("9727", "3249", "action started via WP Cron", "2025-12-11 21:11:32", "2025-12-11 21:11:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("9728", "3257", "action created", "2025-12-11 21:11:32", "2025-12-11 21:11:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("9729", "3249", "action complete via WP Cron", "2025-12-11 21:11:32", "2025-12-11 21:11:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("9730", "3258", "action created", "2025-12-11 21:11:32", "2025-12-11 21:11:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("9731", "3250", "action started via WP Cron", "2025-12-11 21:11:32", "2025-12-11 21:11:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("9732", "3250", "action complete via WP Cron", "2025-12-11 21:11:33", "2025-12-11 21:11:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("9733", "3259", "action created", "2025-12-11 21:11:33", "2025-12-11 21:11:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("9734", "3251", "action started via WP Cron", "2025-12-11 21:11:33", "2025-12-11 21:11:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("9735", "3251", "action complete via WP Cron", "2025-12-11 21:11:33", "2025-12-11 21:11:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("9736", "3260", "action created", "2025-12-11 21:11:33", "2025-12-11 21:11:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("9737", "3257", "action started via WP Cron", "2025-12-11 21:11:33", "2025-12-11 21:11:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("9738", "3257", "action complete via WP Cron", "2025-12-11 21:11:33", "2025-12-11 21:11:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("9739", "3256", "action started via WP Cron", "2025-12-12 21:12:02", "2025-12-12 21:12:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9740", "3256", "action complete via WP Cron", "2025-12-12 21:12:02", "2025-12-12 21:12:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9741", "3261", "action created", "2025-12-12 21:12:02", "2025-12-12 21:12:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9742", "3258", "action started via WP Cron", "2025-12-12 21:12:02", "2025-12-12 21:12:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9743", "3262", "action created", "2025-12-12 21:12:02", "2025-12-12 21:12:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9744", "3258", "action complete via WP Cron", "2025-12-12 21:12:02", "2025-12-12 21:12:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9745", "3263", "action created", "2025-12-12 21:12:02", "2025-12-12 21:12:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9746", "3259", "action started via WP Cron", "2025-12-12 21:12:02", "2025-12-12 21:12:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9747", "3259", "action complete via WP Cron", "2025-12-12 21:12:02", "2025-12-12 21:12:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9748", "3264", "action created", "2025-12-12 21:12:02", "2025-12-12 21:12:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9749", "3260", "action started via WP Cron", "2025-12-12 21:12:02", "2025-12-12 21:12:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9750", "3260", "action complete via WP Cron", "2025-12-12 21:12:02", "2025-12-12 21:12:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9751", "3265", "action created", "2025-12-12 21:12:02", "2025-12-12 21:12:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9752", "3262", "action started via WP Cron", "2025-12-12 21:12:02", "2025-12-12 21:12:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9753", "3262", "action complete via WP Cron", "2025-12-12 21:12:02", "2025-12-12 21:12:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("9754", "3266", "action created", "2025-12-13 19:43:00", "2025-12-13 19:43:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("9755", "3266", "action started via Async Request", "2025-12-13 19:44:08", "2025-12-13 19:44:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("9756", "3266", "action complete via Async Request", "2025-12-13 19:44:08", "2025-12-13 19:44:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("9757", "3261", "action started via Async Request", "2025-12-13 21:12:33", "2025-12-13 21:12:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("9758", "3261", "action complete via Async Request", "2025-12-13 21:12:33", "2025-12-13 21:12:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("9759", "3267", "action created", "2025-12-13 21:12:33", "2025-12-13 21:12:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("9760", "3263", "action started via Async Request", "2025-12-13 21:12:33", "2025-12-13 21:12:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("9761", "3268", "action created", "2025-12-13 21:12:33", "2025-12-13 21:12:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("9762", "3263", "action complete via Async Request", "2025-12-13 21:12:33", "2025-12-13 21:12:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("9763", "3269", "action created", "2025-12-13 21:12:33", "2025-12-13 21:12:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("9764", "3264", "action started via Async Request", "2025-12-13 21:12:33", "2025-12-13 21:12:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("9765", "3264", "action complete via Async Request", "2025-12-13 21:12:33", "2025-12-13 21:12:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("9766", "3270", "action created", "2025-12-13 21:12:33", "2025-12-13 21:12:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("9767", "3265", "action started via Async Request", "2025-12-13 21:12:33", "2025-12-13 21:12:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("9768", "3265", "action complete via Async Request", "2025-12-13 21:12:33", "2025-12-13 21:12:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("9769", "3271", "action created", "2025-12-13 21:12:33", "2025-12-13 21:12:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("9770", "3268", "action started via Async Request", "2025-12-13 21:12:33", "2025-12-13 21:12:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("9771", "3268", "action complete via Async Request", "2025-12-13 21:12:33", "2025-12-13 21:12:33");

/* INSERT TABLE DATA: wp_cky_banners */
INSERT INTO `wp_cky_banners` VALUES("1", "GDPR", "gdpr-1", "1", "{\"settings\":{\"id\":\"banner-1\",\"type\":\"classic\",\"preferenceCenterType\":\"pushdown\",\"position\":\"top\",\"versionID\":\"6.0.0\",\"applicableLaw\":\"gdpr\",\"languages\":{\"default\":\"en\",\"selected\":[\"en\"]},\"templateGroup\":\"default\",\"customHtml\":{\"status\":false},\"theme\":\"light\",\"consentExpiry\":{\"status\":true,\"value\":\"365\"},\"ruleSet\":[{\"code\":\"ALL\",\"regions\":[]}]},\"behaviours\":{\"reloadBannerOnAccept\":{\"status\":false},\"loadAnalyticsByDefault\":{\"status\":false},\"animations\":{\"onLoad\":\"animate\",\"onHide\":\"sticky\"},\"legacyFunctions\":{\"accept\":{\"action\":\"acceptClose\",\"newTab\":false},\"reject\":{\"action\":\"rejectClose\",\"newTab\":false},\"idle\":{\"action\":\"acceptClose\",\"delay\":\"1000\"},\"navigation\":{\"action\":\"acceptClose\"},\"pageScroll\":{\"action\":\"acceptClose\"}},\"respectGPC\":{\"status\":false}},\"config\":{\"notice\":{\"status\":true,\"tag\":\"notice\",\"type\":\"container\",\"styles\":{\"background-color\":\"#FFFFFF\",\"border-color\":\"#f4f4f4\"},\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"title\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"description\":{\"type\":\"text\",\"tag\":\"description\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"brandLogo\":{\"status\":false,\"tag\":\"brand-logo\",\"meta\":{\"url\":\"#\"}},\"buttons\":{\"status\":true,\"tag\":\"notice-buttons\",\"type\":\"container\",\"elements\":{\"accept\":{\"status\":true,\"tag\":\"accept-button\",\"type\":\"button\",\"styles\":{\"color\":\"#FFFFFF\",\"background-color\":\"#1863DC\",\"border-color\":\"#1863DC\"}},\"reject\":{\"status\":true,\"tag\":\"reject-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"#1863DC\"}},\"settings\":{\"status\":true,\"tag\":\"settings-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"#1863DC\"}},\"readMore\":{\"status\":false,\"tag\":\"readmore-button\",\"type\":\"link\",\"meta\":{\"noFollow\":true,\"newTab\":true},\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"transparent\"}},\"donotSell\":{\"status\":false,\"tag\":\"donotsell-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"transparent\"}}}},\"closeButton\":{\"status\":false,\"tag\":\"close-button\"}}},\"categoryPreview\":{\"status\":false,\"type\":\"container\",\"tag\":\"detail-category-preview\",\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"detail-category-preview-title\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"toggle\":{\"status\":true,\"tag\":\"detail-category-preview-toggle\",\"type\":\"toggle\",\"states\":{\"active\":{\"styles\":{\"background-color\":\"#1863DC\"}},\"inactive\":{\"styles\":{\"background-color\":\"#D0D5D2\"}}}},\"buttons\":{\"status\":true,\"tag\":\"detail-category-preview-buttons\",\"elements\":{\"save\":{\"status\":true,\"tag\":\"detail-category-preview-save-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"#1863DC\"}}}}}},\"preferenceCenter\":{\"status\":true,\"tag\":\"detail\",\"type\":\"container\",\"styles\":{\"color\":\"#212121\",\"background-color\":\"#FFFFFF\",\"border-color\":\"#f4f4f4\"},\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"detail-title\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"description\":{\"type\":\"text\",\"tag\":\"detail-description\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"closeButton\":{\"status\":true,\"type\":\"button\",\"tag\":\"detail-close\"},\"categories\":{\"status\":true,\"tag\":\"detail-categories\",\"type\":\"container\",\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"detail-category-title\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"description\":{\"type\":\"text\",\"tag\":\"detail-category-description\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"toggle\":{\"status\":true,\"tag\":\"detail-category-toggle\",\"type\":\"toggle\",\"states\":{\"active\":{\"styles\":{\"background-color\":\"#1863DC\"}},\"inactive\":{\"styles\":{\"background-color\":\"#D0D5D2\"}}}}}},\"buttons\":{\"status\":true,\"tag\":\"detail-buttons\",\"type\":\"container\",\"elements\":{\"accept\":{\"status\":true,\"tag\":\"detail-accept-button\",\"type\":\"button\",\"styles\":{\"color\":\"#FFFFFF\",\"background-color\":\"#1863DC\",\"border-color\":\"#1863DC\"}},\"reject\":{\"status\":true,\"tag\":\"detail-reject-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"#1863DC\"}},\"save\":{\"status\":true,\"tag\":\"detail-save-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"#1863DC\"}}}},\"poweredBy\":{\"status\":true,\"tag\":\"detail-powered-by\",\"styles\":{\"background-color\":\"#EDEDED\",\"color\":\"#293C5B\"}}}},\"optoutPopup\":{\"status\":false,\"tag\":\"optout-popup\",\"type\":\"container\",\"styles\":{\"color\":\"#212121\",\"background-color\":\"#FFFFFF\",\"border-color\":\"#F4F4F4\"},\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"optout-title\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"description\":{\"type\":\"text\",\"tag\":\"optout-description\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"optOption\":{\"status\":true,\"tag\":\"optout-option\",\"type\":\"container\",\"elements\":{\"toggle\":{\"status\":true,\"tag\":\"optout-option-toggle\",\"type\":\"toggle\",\"states\":{\"active\":{\"styles\":{\"background-color\":\"#1863dc\"}},\"inactive\":{\"styles\":{\"background-color\":\"#FFFFFF\"}}}},\"title\":{\"type\":\"text\",\"tag\":\"optout-option-title\",\"status\":true,\"styles\":{\"color\":\"#212121\"}}}},\"gpcOption\":{\"type\":\"container\",\"tag\":\"optout-gpc-option\",\"status\":false,\"elements\":{\"description\":{\"type\":\"text\",\"tag\":\"optout-gpc-option-description\",\"status\":true,\"styles\":{\"color\":\"#212121\"}}}},\"poweredBy\":{\"status\":true,\"tag\":\"optout-powered-by\",\"styles\":{\"background-color\":\"#EDEDED\",\"color\":\"#293C5B\"}},\"buttons\":{\"status\":true,\"tag\":\"optout-buttons\",\"type\":\"container\",\"elements\":{\"confirm\":{\"status\":true,\"tag\":\"optout-confirm-button\",\"type\":\"button\",\"styles\":{\"color\":\"#f4f4f4\",\"background-color\":\"#1863dc\",\"border-color\":\"#1863dc\"}},\"cancel\":{\"status\":true,\"tag\":\"optout-cancel-button\",\"type\":\"button\",\"styles\":{\"color\":\"#858585\",\"background-color\":\"#FFFFFF\",\"border-color\":\"#dedfe0\"}}}},\"closeButton\":{\"status\":true,\"tag\":\"optout-close\",\"type\":\"button\"}}},\"auditTable\":{\"status\":true,\"tag\":\"audit-table\",\"type\":\"table\",\"meta\":{\"headers\":[\"id\",\"duration\",\"description\"]},\"styles\":{\"color\":\"#212121\",\"background-color\":\"#f4f4f4\",\"border-color\":\"#ebebeb\"}},\"revisitConsent\":{\"status\":true,\"tag\":\"revisit-consent\",\"position\":\"bottom-left\",\"meta\":{\"url\":\"#\"},\"styles\":{\"background-color\":\"#0056A7\"},\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"revisit-consent-title\",\"status\":true,\"styles\":{\"color\":\"#0056a7\"}}}},\"videoPlaceholder\":{\"status\":true,\"tag\":\"video-placeholder\",\"styles\":{\"background-color\":\"#000000\",\"border-color\":\"#000000\"},\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"placeholder-title\",\"status\":true,\"styles\":{\"color\":\"#ffffff\"}}}}},\"meta\":{\"customCSS\":\"\",\"customHTML\":\"\"}}", "1", "{\"en\":{\"notice\":{\"elements\":{\"title\":\"We value your privacy\",\"description\":\"<p>We use cookies to enhance your browsing experience, serve personalized ads or content, and analyze our traffic. By clicking \\\"Accept All\\\", you consent to our use of cookies.<\\/p>\",\"privacyLink\":\"\",\"buttons\":{\"elements\":{\"accept\":\"Accept All\",\"reject\":\"Reject All\",\"settings\":\"Customize\",\"readMore\":\"Cookie Policy\",\"donotSell\":\"Do Not Sell or Share My Personal Information\"}},\"closeButton\":\"Close\"}},\"categoryPreview\":{\"elements\":{\"buttons\":{\"elements\":{\"save\":\"Save My Preferences\"}}}},\"preferenceCenter\":{\"elements\":{\"title\":\"Customize Consent Preferences\",\"description\":\"<p>We use cookies to help you navigate efficiently and perform certain functions. You will find detailed information about all cookies under each consent category below.<\\/p><p>The cookies that are categorized as \\\"Necessary\\\" are stored on your browser as they are essential for enabling the basic functionalities of the site. <\\/p><p>We also use third-party cookies that help us analyze how you use this website, store your preferences, and provide the content and advertisements that are relevant to you. These cookies will only be stored in your browser with your prior consent.<\\/p><p>You can choose to enable or disable some or all of these cookies but disabling some of them may affect your browsing experience.<\\/p>\",\"showMore\":\"Show more\",\"showLess\":\"Show less\",\"category\":{\"elements\":{\"alwaysEnabled\":\"Always Active\",\"enable\":\"Enable\",\"disable\":\"Disable\"}},\"buttons\":{\"elements\":{\"accept\":\"Accept All\",\"save\":\"Save My Preferences\",\"reject\":\"Reject All\"}},\"closeButton\":\"Close\"}},\"optoutPopup\":{\"elements\":{\"title\":\"Opt-out Preferences\",\"description\":\"<p>We use third-party cookies that help us analyze how you use this website, store your preferences, and provide the content and advertisements that are relevant to you. However, you can opt out of these cookies by checking \\\"Do Not Sell or Share My Personal Information\\\" and clicking the \\\"Save My Preferences\\\" button. Once you opt out, you can opt in again at any time by unchecking \\\"Do Not Sell or Share My Personal Information\\\" and clicking the \\\"Save My Preferences\\\" button.<\\/p>\",\"optOption\":{\"elements\":{\"title\":\"Do Not Sell or Share My Personal Information\",\"enable\":\"Enable\",\"disable\":\"Disable\"}},\"gpcOption\":{\"elements\":{\"description\":\"<p>Your opt-out settings for this website have been respected since we detected a <b>Global Privacy Control<\\/b> signal from your browser and, therefore, you cannot change this setting.<\\/p>\"}},\"showLess\":\"Show less\",\"showMore\":\"Show more\",\"buttons\":{\"elements\":{\"cancel\":\"Cancel\",\"confirm\":\"Save My Preferences\"}},\"closeButton\":\"Close\"}},\"revisitConsent\":{\"elements\":{\"title\":\"Cookie Settings\"}},\"auditTable\":{\"elements\":{\"headers\":{\"elements\":{\"id\":\"Cookie\",\"duration\":\"Duration\",\"description\":\"Description\"}},\"message\":\"No cookies to display.\"}},\"videoPlaceholder\":{\"elements\":{\"title\":\"Please accept cookies to access this content\"}}},\"es\":{\"notice\":{\"elements\":{\"title\":\"Valoramos tu privacidad\",\"description\":\"<p>Usamos cookies para mejorar su experiencia de navegaci\\u00f3n, mostrarle anuncios o contenidos personalizados y analizar nuestro tr\\u00e1fico. Al hacer clic en \\u201cAceptar todo\\u201d usted da su consentimiento a nuestro uso de las cookies.<\\/p>\",\"privacyLink\":\"\",\"buttons\":{\"elements\":{\"accept\":\"Aceptar todo\",\"reject\":\"Rechazar todo\",\"settings\":\"Personalizar\",\"readMore\":\"Pol\\u00edtica de cookies\",\"donotSell\":\"No vendan ni compartan mi informaci\\u00f3n personal\"}},\"closeButton\":\"Cerca\"}},\"categoryPreview\":{\"elements\":{\"buttons\":{\"elements\":{\"save\":\"Guardar mis preferencias\"}}}},\"preferenceCenter\":{\"elements\":{\"title\":\"Personalizar las preferencias de consentimiento\",\"description\":\"<p>Usamos cookies para ayudarle a navegar de manera eficiente y realizar ciertas funciones. Encontrar\\u00e1 informaci\\u00f3n detallada sobre cada una de las cookies bajo cada categor\\u00eda de consentimiento a continuaci\\u00f3n.<\\/p><p>Las cookies categorizadas como \\u201cNecesarias\\u201d se guardan en su navegador, ya que son esenciales para permitir las funcionalidades b\\u00e1sicas del sitio web.<\\/p><p>Tambi\\u00e9n utilizamos cookies de terceros que nos ayudan a analizar c\\u00f3mo usted utiliza este sitio web, guardar sus preferencias y aportar el contenido y la publicidad que le sean relevantes. Estas cookies solo se guardan en su navegador previo consentimiento por su parte.<\\/p><p>Puede optar por activar o desactivar alguna o todas estas cookies, aunque la desactivaci\\u00f3n de algunas podr\\u00eda afectar a su experiencia de navegaci\\u00f3n.<\\/p>\",\"showMore\":\"Mostrar m\\u00e1s\",\"showLess\":\"Mostrar menos\",\"category\":{\"elements\":{\"alwaysEnabled\":\"Siempre activas\",\"enable\":\"Permitir\",\"disable\":\"Desactivar\"}},\"buttons\":{\"elements\":{\"accept\":\"Aceptar todo\",\"save\":\"Guardar mis preferencias\",\"reject\":\"Rechazar todo\"}},\"closeButton\":\"Cerca\"}},\"optoutPopup\":{\"elements\":{\"title\":\"Preferencias de exclusi\\u00f3n voluntaria\",\"description\":\"<p>Utilizamos cookies de terceros que nos ayudan a analizar el uso que usted hace de este sitio web, a almacenar sus preferencias y a ofrecerle el contenido y la publicidad que le resulten de inter\\u00e9s. Sin embargo, usted puede excluirse de estas cookies marcando \\u00abNo vendan ni compartan mi informaci\\u00f3n personal\\u00bb y haciendo clic en el bot\\u00f3n \\u00abGuardar mis preferencias\\u00bb. Una vez que haya optado por la exclusi\\u00f3n, podr\\u00e1 cancelarlo en cualquier momento desmarcando \\u00abNo vendan ni compartan mi informaci\\u00f3n personal\\u00bb y haciendo clic en el bot\\u00f3n \\u00abGuardar mis preferencias\\u00bb.<\\/p>\",\"optOption\":{\"elements\":{\"title\":\"No vendan ni compartan mi informaci\\u00f3n personal\",\"enable\":\"Permitir\",\"disable\":\"Desactivar\"}},\"gpcOption\":{\"elements\":{\"description\":\"<p>Su configuraci\\u00f3n de exclusi\\u00f3n voluntaria para este sitio web se ha respetado desde que detectamos una se\\u00f1al de control de privacidad global de su navegador y, por lo tanto, no puede cambiar esta configuraci\\u00f3n.<\\/p>\"}},\"showLess\":\"Mostrar m\\u00e1s\",\"showMore\":\"Mostrar menos\",\"buttons\":{\"elements\":{\"cancel\":\"Cancelar\",\"confirm\":\"Guardar mis preferencias\"}},\"closeButton\":\"Cerca\"}},\"revisitConsent\":{\"elements\":{\"title\":\"Configuraci\\u00f3n de cookies\"}},\"auditTable\":{\"elements\":{\"headers\":{\"elements\":{\"id\":\"Cookie\",\"duration\":\"Duraci\\u00f3n\",\"description\":\"Descripci\\u00f3n\"}},\"message\":\"No hay cookies para mostrar.\"}},\"videoPlaceholder\":{\"elements\":{\"title\":\"Por favor acepte el consentimiento de cookies\"}}}}", "2023-02-27 21:22:35", "2023-02-27 21:22:35");
INSERT INTO `wp_cky_banners` VALUES("2", "CCPA", "ccpa-2", "0", "{\"settings\":{\"id\":\"banner-1\",\"type\":\"box\",\"preferenceCenterType\":\"popup\",\"position\":\"bottom-left\",\"versionID\":\"6.0.0\",\"applicableLaw\":\"ccpa\",\"languages\":{\"default\":\"en\",\"selected\":[\"en\"]},\"templateGroup\":\"default\",\"customHtml\":{\"status\":false},\"theme\":\"light\",\"consentExpiry\":{\"status\":true,\"value\":\"365\"},\"ruleSet\":[{\"code\":\"ALL\",\"regions\":[]}]},\"behaviours\":{\"reloadBannerOnAccept\":{\"status\":false},\"loadAnalyticsByDefault\":{\"status\":false},\"animations\":{\"onLoad\":\"animate\",\"onHide\":\"sticky\"},\"legacyFunctions\":{\"accept\":{\"action\":\"acceptClose\",\"newTab\":false},\"reject\":{\"action\":\"rejectClose\",\"newTab\":false},\"idle\":{\"action\":\"acceptClose\",\"delay\":\"1000\"},\"navigation\":{\"action\":\"acceptClose\"},\"pageScroll\":{\"action\":\"acceptClose\"}},\"respectGPC\":{\"status\":false}},\"config\":{\"notice\":{\"status\":true,\"tag\":\"notice\",\"type\":\"container\",\"styles\":{\"background-color\":\"#FFFFFF\",\"border-color\":\"#f4f4f4\"},\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"title\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"description\":{\"type\":\"text\",\"tag\":\"description\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"brandLogo\":{\"status\":false,\"tag\":\"brand-logo\",\"meta\":{\"url\":\"#\"}},\"buttons\":{\"status\":true,\"tag\":\"notice-buttons\",\"type\":\"container\",\"elements\":{\"accept\":{\"status\":false,\"tag\":\"accept-button\",\"type\":\"button\",\"styles\":{\"color\":\"#FFFFFF\",\"background-color\":\"#1863DC\",\"border-color\":\"#1863DC\"}},\"reject\":{\"status\":false,\"tag\":\"reject-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"#1863DC\"}},\"settings\":{\"status\":false,\"tag\":\"settings-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"#1863DC\"}},\"readMore\":{\"status\":false,\"tag\":\"readmore-button\",\"type\":\"link\",\"meta\":{\"noFollow\":true,\"newTab\":true},\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"transparent\"}},\"donotSell\":{\"status\":true,\"tag\":\"donotsell-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"transparent\"}}}},\"closeButton\":{\"status\":true,\"tag\":\"close-button\"}}},\"categoryPreview\":{\"status\":false,\"type\":\"container\",\"tag\":\"detail-category-preview\",\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"detail-category-preview-title\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"toggle\":{\"status\":true,\"tag\":\"detail-category-preview-toggle\",\"type\":\"toggle\",\"states\":{\"active\":{\"styles\":{\"background-color\":\"#1863DC\"}},\"inactive\":{\"styles\":{\"background-color\":\"#D0D5D2\"}}}},\"buttons\":{\"status\":true,\"tag\":\"detail-category-preview-buttons\",\"elements\":{\"save\":{\"status\":true,\"tag\":\"detail-category-preview-save-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"#1863DC\"}}}}}},\"preferenceCenter\":{\"status\":false,\"tag\":\"detail\",\"type\":\"container\",\"styles\":{\"color\":\"#212121\",\"background-color\":\"#FFFFFF\",\"border-color\":\"#f4f4f4\"},\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"detail-title\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"description\":{\"type\":\"text\",\"tag\":\"detail-description\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"closeButton\":{\"status\":true,\"type\":\"button\",\"tag\":\"detail-close\"},\"categories\":{\"status\":true,\"tag\":\"detail-categories\",\"type\":\"container\",\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"detail-category-title\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"description\":{\"type\":\"text\",\"tag\":\"detail-category-description\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"toggle\":{\"status\":true,\"tag\":\"detail-category-toggle\",\"type\":\"toggle\",\"states\":{\"active\":{\"styles\":{\"background-color\":\"#1863DC\"}},\"inactive\":{\"styles\":{\"background-color\":\"#D0D5D2\"}}}}}},\"buttons\":{\"status\":true,\"tag\":\"detail-buttons\",\"type\":\"container\",\"elements\":{\"accept\":{\"status\":true,\"tag\":\"detail-accept-button\",\"type\":\"button\",\"styles\":{\"color\":\"#FFFFFF\",\"background-color\":\"#1863DC\",\"border-color\":\"#1863DC\"}},\"reject\":{\"status\":true,\"tag\":\"detail-reject-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"#1863DC\"}},\"save\":{\"status\":true,\"tag\":\"detail-save-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"#1863DC\"}}}},\"poweredBy\":{\"status\":true,\"tag\":\"detail-powered-by\",\"styles\":{\"background-color\":\"#EDEDED\",\"color\":\"#293C5B\"}}}},\"optoutPopup\":{\"status\":true,\"tag\":\"optout-popup\",\"type\":\"container\",\"styles\":{\"color\":\"#212121\",\"background-color\":\"#FFFFFF\",\"border-color\":\"#F4F4F4\"},\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"optout-title\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"description\":{\"type\":\"text\",\"tag\":\"optout-description\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"optOption\":{\"status\":true,\"tag\":\"optout-option\",\"type\":\"container\",\"elements\":{\"toggle\":{\"status\":true,\"tag\":\"optout-option-toggle\",\"type\":\"toggle\",\"states\":{\"active\":{\"styles\":{\"background-color\":\"#1863dc\"}},\"inactive\":{\"styles\":{\"background-color\":\"#FFFFFF\"}}}},\"title\":{\"type\":\"text\",\"tag\":\"optout-option-title\",\"status\":true,\"styles\":{\"color\":\"#212121\"}}}},\"gpcOption\":{\"type\":\"container\",\"tag\":\"optout-gpc-option\",\"status\":false,\"elements\":{\"description\":{\"type\":\"text\",\"tag\":\"optout-gpc-option-description\",\"status\":true,\"styles\":{\"color\":\"#212121\"}}}},\"poweredBy\":{\"status\":true,\"tag\":\"optout-powered-by\",\"styles\":{\"background-color\":\"#EDEDED\",\"color\":\"#293C5B\"}},\"buttons\":{\"status\":true,\"tag\":\"optout-buttons\",\"type\":\"container\",\"elements\":{\"confirm\":{\"status\":true,\"tag\":\"optout-confirm-button\",\"type\":\"button\",\"styles\":{\"color\":\"#f4f4f4\",\"background-color\":\"#1863dc\",\"border-color\":\"#1863dc\"}},\"cancel\":{\"status\":true,\"tag\":\"optout-cancel-button\",\"type\":\"button\",\"styles\":{\"color\":\"#858585\",\"background-color\":\"#FFFFFF\",\"border-color\":\"#dedfe0\"}}}},\"closeButton\":{\"status\":true,\"tag\":\"optout-close\",\"type\":\"button\"}}},\"auditTable\":{\"status\":false,\"tag\":\"audit-table\",\"type\":\"table\",\"meta\":{\"headers\":[\"id\",\"duration\",\"description\"]},\"styles\":{\"color\":\"#212121\",\"background-color\":\"#f4f4f4\",\"border-color\":\"#ebebeb\"}},\"revisitConsent\":{\"status\":true,\"tag\":\"revisit-consent\",\"position\":\"bottom-left\",\"meta\":{\"url\":\"#\"},\"styles\":{\"background-color\":\"#0056A7\"},\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"revisit-consent-title\",\"status\":true,\"styles\":{\"color\":\"#0056a7\"}}}},\"videoPlaceholder\":{\"status\":true,\"tag\":\"video-placeholder\",\"styles\":{\"background-color\":\"#000000\",\"border-color\":\"#000000\"},\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"placeholder-title\",\"status\":true,\"styles\":{\"color\":\"#ffffff\"}}}}},\"meta\":{\"customCSS\":\"\",\"customHTML\":\"\"}}", "0", "{\"en\":{\"notice\":{\"elements\":{\"title\":\"We value your privacy\",\"description\":\"This website or its third-party tools process personal data. You can opt out of the sale of your personal information by clicking on the \\\"Do Not Sell or Share My Personal Information\\\" link.\",\"privacyLink\":\"\",\"buttons\":{\"elements\":{\"accept\":\"Accept All\",\"reject\":\"Reject All\",\"settings\":\"Customize\",\"readMore\":\"Cookie Policy\",\"donotSell\":\"Do Not Sell or Share My Personal Information\"}},\"closeButton\":\"Close\"}},\"categoryPreview\":{\"elements\":{\"buttons\":{\"elements\":{\"save\":\"Save My Preferences\"}}}},\"preferenceCenter\":{\"elements\":{\"title\":\"Customize Consent Preferences\",\"description\":\"<p>We use cookies to help you navigate efficiently and perform certain functions. You will find detailed information about all cookies under each consent category below.<\\/p><p>The cookies that are categorized as \\\"Necessary\\\" are stored on your browser as they are essential for enabling the basic functionalities of the site. <\\/p><p>We also use third-party cookies that help us analyze how you use this website, store your preferences, and provide the content and advertisements that are relevant to you. These cookies will only be stored in your browser with your prior consent.<\\/p><p>You can choose to enable or disable some or all of these cookies but disabling some of them may affect your browsing experience.<\\/p>\",\"showMore\":\"Show more\",\"showLess\":\"Show less\",\"category\":{\"elements\":{\"alwaysEnabled\":\"Always Active\",\"enable\":\"Enable\",\"disable\":\"Disable\"}},\"buttons\":{\"elements\":{\"accept\":\"Accept All\",\"save\":\"Save My Preferences\",\"reject\":\"Reject All\"}},\"closeButton\":\"Close\"}},\"optoutPopup\":{\"elements\":{\"title\":\"Opt-out Preferences\",\"description\":\"<p>We use third-party cookies that help us analyze how you use this website, store your preferences, and provide the content and advertisements that are relevant to you. However, you can opt out of these cookies by checking \\\"Do Not Sell or Share My Personal Information\\\" and clicking the \\\"Save My Preferences\\\" button. Once you opt out, you can opt in again at any time by unchecking \\\"Do Not Sell or Share My Personal Information\\\" and clicking the \\\"Save My Preferences\\\" button.<\\/p>\",\"optOption\":{\"elements\":{\"title\":\"Do Not Sell or Share My Personal Information\",\"enable\":\"Enable\",\"disable\":\"Disable\"}},\"gpcOption\":{\"elements\":{\"description\":\"<p>Your opt-out settings for this website have been respected since we detected a <b>Global Privacy Control<\\/b> signal from your browser and, therefore, you cannot change this setting.<\\/p>\"}},\"showLess\":\"Show less\",\"showMore\":\"Show more\",\"buttons\":{\"elements\":{\"cancel\":\"Cancel\",\"confirm\":\"Save My Preferences\"}},\"closeButton\":\"Close\"}},\"revisitConsent\":{\"elements\":{\"title\":\"Cookie Settings\"}},\"auditTable\":{\"elements\":{\"headers\":{\"elements\":{\"id\":\"Cookie\",\"duration\":\"Duration\",\"description\":\"Description\"}},\"message\":\"No cookies to display.\"}},\"videoPlaceholder\":{\"elements\":{\"title\":\"Please accept cookies to access this content\"}}},\"es\":{\"notice\":{\"elements\":{\"title\":\"Valoramos tu privacidad\",\"description\":\"Este sitio web o sus herramientas de terceros procesan datos personales. Puede optar por no participar en la venta de su informaci\\u00f3n personal haciendo clic en el enlace \\\"No vendan ni compartan mi informaci\\u00f3n personal\\\".\",\"privacyLink\":\"\",\"buttons\":{\"elements\":{\"accept\":\"Aceptar todo\",\"reject\":\"Rechazar todo\",\"settings\":\"Personalizar\",\"readMore\":\"Pol\\u00edtica de cookies\",\"donotSell\":\"No vendan ni compartan mi informaci\\u00f3n personal\"}},\"closeButton\":\"Cerca\"}},\"categoryPreview\":{\"elements\":{\"buttons\":{\"elements\":{\"save\":\"Guardar mis preferencias\"}}}},\"preferenceCenter\":{\"elements\":{\"title\":\"Personalizar las preferencias de consentimiento\",\"description\":\"<p>Usamos cookies para ayudarle a navegar de manera eficiente y realizar ciertas funciones. Encontrar\\u00e1 informaci\\u00f3n detallada sobre cada una de las cookies bajo cada categor\\u00eda de consentimiento a continuaci\\u00f3n.<\\/p><p>Las cookies categorizadas como \\u201cNecesarias\\u201d se guardan en su navegador, ya que son esenciales para permitir las funcionalidades b\\u00e1sicas del sitio web.<\\/p><p>Tambi\\u00e9n utilizamos cookies de terceros que nos ayudan a analizar c\\u00f3mo usted utiliza este sitio web, guardar sus preferencias y aportar el contenido y la publicidad que le sean relevantes. Estas cookies solo se guardan en su navegador previo consentimiento por su parte.<\\/p><p>Puede optar por activar o desactivar alguna o todas estas cookies, aunque la desactivaci\\u00f3n de algunas podr\\u00eda afectar a su experiencia de navegaci\\u00f3n.<\\/p>\",\"showMore\":\"Mostrar m\\u00e1s\",\"showLess\":\"Mostrar menos\",\"category\":{\"elements\":{\"alwaysEnabled\":\"Siempre activas\",\"enable\":\"Permitir\",\"disable\":\"Desactivar\"}},\"buttons\":{\"elements\":{\"accept\":\"Aceptar todo\",\"save\":\"Guardar mis preferencias\",\"reject\":\"Rechazar todo\"}},\"closeButton\":\"Cerca\"}},\"optoutPopup\":{\"elements\":{\"title\":\"Preferencias de exclusi\\u00f3n voluntaria\",\"description\":\"<p>Utilizamos cookies de terceros que nos ayudan a analizar el uso que usted hace de este sitio web, a almacenar sus preferencias y a ofrecerle el contenido y la publicidad que le resulten de inter\\u00e9s. Sin embargo, usted puede excluirse de estas cookies marcando \\u00abNo vendan ni compartan mi informaci\\u00f3n personal\\u00bb y haciendo clic en el bot\\u00f3n \\u00abGuardar mis preferencias\\u00bb. Una vez que haya optado por la exclusi\\u00f3n, podr\\u00e1 cancelarlo en cualquier momento desmarcando \\u00abNo vendan ni compartan mi informaci\\u00f3n personal\\u00bb y haciendo clic en el bot\\u00f3n \\u00abGuardar mis preferencias\\u00bb.<\\/p>\",\"optOption\":{\"elements\":{\"title\":\"No vendan ni compartan mi informaci\\u00f3n personal\",\"enable\":\"Permitir\",\"disable\":\"Desactivar\"}},\"gpcOption\":{\"elements\":{\"description\":\"<p>Su configuraci\\u00f3n de exclusi\\u00f3n voluntaria para este sitio web se ha respetado desde que detectamos una se\\u00f1al de control de privacidad global de su navegador y, por lo tanto, no puede cambiar esta configuraci\\u00f3n.<\\/p>\"}},\"showLess\":\"Mostrar m\\u00e1s\",\"showMore\":\"Mostrar menos\",\"buttons\":{\"elements\":{\"cancel\":\"Cancelar\",\"confirm\":\"Guardar mis preferencias\"}},\"closeButton\":\"Cerca\"}},\"revisitConsent\":{\"elements\":{\"title\":\"Configuraci\\u00f3n de cookies\"}},\"auditTable\":{\"elements\":{\"headers\":{\"elements\":{\"id\":\"Cookie\",\"duration\":\"Duraci\\u00f3n\",\"description\":\"Descripci\\u00f3n\"}},\"message\":\"No hay cookies para mostrar.\"}},\"videoPlaceholder\":{\"elements\":{\"title\":\"Por favor acepte el consentimiento de cookies\"}}}}", "2023-02-27 21:22:35", "2023-02-27 21:22:35");

/* INSERT TABLE DATA: wp_cky_cookie_categories */
INSERT INTO `wp_cky_cookie_categories` VALUES("1", "{\"en\":\"Necessary\",\"es\":\"Necesaria\"}", "necessary", "{\"en\":\"<p>Necessary cookies are required to enable the basic features of this site, such as providing secure log-in or adjusting your consent preferences. These cookies do not store any personally identifiable data.<\\/p>\",\"es\":\"<p>Las cookies necesarias son cruciales para las funciones b\\u00e1sicas del sitio web y el sitio web no funcionar\\u00e1 de la forma prevista sin ellas. Estas cookies no almacenan ning\\u00fan dato de identificaci\\u00f3n personal.<\\/p>\"}", "1", "1", "0", "1", "[]", "0000-00-00 00:00:00", "0000-00-00 00:00:00");
INSERT INTO `wp_cky_cookie_categories` VALUES("2", "{\"en\":\"Functional\",\"es\":\"Funcional\"}", "functional", "{\"en\":\"<p>Functional cookies help perform certain functionalities like sharing the content of the website on social media platforms, collecting feedback, and other third-party features.<\\/p>\",\"es\":\"<p>Las cookies funcionales ayudan a realizar ciertas funcionalidades, como compartir el contenido del sitio web en plataformas de redes sociales, recopilar comentarios y otras caracter\\u00edsticas de terceros.<\\/p>\"}", "0", "1", "0", "1", "[]", "0000-00-00 00:00:00", "0000-00-00 00:00:00");
INSERT INTO `wp_cky_cookie_categories` VALUES("3", "{\"en\":\"Analytics\",\"es\":\"Anal\\u00edtica\"}", "analytics", "{\"en\":\"<p>Analytical cookies are used to understand how visitors interact with the website. These cookies help provide information on metrics such as the number of visitors, bounce rate, traffic source, etc.<\\/p>\",\"es\":\"<p>Las cookies anal\\u00edticas se utilizan para comprender c\\u00f3mo interact\\u00faan los visitantes con el sitio web. Estas cookies ayudan a proporcionar informaci\\u00f3n sobre m\\u00e9tricas el n\\u00famero de visitantes, el porcentaje de rebote, la fuente de tr\\u00e1fico, etc.<\\/p>\"}", "0", "1", "0", "1", "[]", "0000-00-00 00:00:00", "0000-00-00 00:00:00");
INSERT INTO `wp_cky_cookie_categories` VALUES("4", "{\"en\":\"Performance\",\"es\":\"El rendimiento\"}", "performance", "{\"en\":\"<p>Performance cookies are used to understand and analyze the key performance indexes of the website which helps in delivering a better user experience for the visitors.<\\/p>\",\"es\":\"<p>Las cookies de rendimiento se utilizan para comprender y analizar los \\u00edndices de rendimiento clave del sitio web, lo que ayuda a proporcionar una mejor experiencia de usuario para los visitantes.<\\/p>\"}", "0", "1", "0", "1", "[]", "0000-00-00 00:00:00", "0000-00-00 00:00:00");
INSERT INTO `wp_cky_cookie_categories` VALUES("5", "{\"en\":\"Advertisement\",\"es\":\"Anuncio\"}", "advertisement", "{\"en\":\"<p>Advertisement cookies are used to provide visitors with customized advertisements based on the pages you visited previously and to analyze the effectiveness of the ad campaigns.<\\/p>\",\"es\":\"<p>Las cookies publicitarias se utilizan para entregar a los visitantes anuncios personalizados basados \\u200b\\u200ben las p\\u00e1ginas que visitaron antes y analizar la efectividad de la campa\\u00f1a publicitaria.<\\/p>\"}", "0", "1", "0", "1", "[]", "0000-00-00 00:00:00", "0000-00-00 00:00:00");

/* INSERT TABLE DATA: wp_cky_cookies */
INSERT INTO `wp_cky_cookies` VALUES("1", "cookieyes-consent", "cookieyes-consent", "{\"en\":\"\",\"es\":\"<p>Cookie para el funcionamiento de la p\\u00e1gina<\\/p>\"}", "{\"en\":\"7 d\\u00edas\",\"es\":\"7 d\\u00edas\"}", "procuradorgalicia.es", "1", "0", "0", "", "[]", "2023-02-28 19:56:46", "2023-02-28 19:56:46");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("43", "37", "IslaMartin", "isla.m@example.org", "https://isla-explores.org", "2a01:7e03::f03c:95ff:fef2:5509", "2025-11-11 18:41:06", "2025-11-11 18:41:06", "Looking forward to reading more from you.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Firefox/127.0", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("44", "1", "益群网", "helloboy1979@gmail.com", "https://www.53278.xyz/", "112.33.25.179", "2025-11-18 18:35:19", "2025-11-18 18:35:19", "益群网：终身分红，逆向推荐，不拉下线，也有钱赚！尖端资源，价值百万，一网打尽，瞬间拥有！多重收益，五五倍增，八级提成，后劲无穷！网址：1199.pw", "0", "0", "Go-http-client/2.0", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("45", "198", "stiiizy pro battery", "gadget.cove26@gmail.com", "https://www.obtainhigh.com/product/stiiizy-pro-battery-kit/", "2a09:bac1:76c0:15f8::3ff:19", "2025-11-21 06:08:47", "2025-11-21 06:08:47", "order weed online fast from trusted sources", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20251213", "ea9c550d418c0a0e7932_20251213211250", "23", "2025-12-13 21:13:18", "agorajuridicasl", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-13 21:12:50\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:6:\"11.8.3\";s:10:\"VersionPHP\";s:6:\"8.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:8:\"20251213\";s:4:\"Hash\";s:35:\"ea9c550d418c0a0e7932_20251213211250\";s:8:\"NameHash\";s:44:\"20251213_ea9c550d418c0a0e7932_20251213211250\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:54:\"20251213_ea9c550d418c0a0e7932_20251213211250_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"23.0\";s:6:\"WPUser\";s:15:\"agorajuridicasl\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:56:\"20251213_ea9c550d418c0a0e7932_20251213211250_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:57:\"/home/u176508502/domains/procuradorgalicia.es/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:3009;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:18368;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-13 21:12:50\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:6:\"11.8.3\";s:10:\"VersionPHP\";s:6:\"8.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:8:\"20251213\";s:4:\"Hash\";s:35:\"ea9c550d418c0a0e7932_20251213211250\";s:8:\"NameHash\";s:44:\"20251213_ea9c550d418c0a0e7932_20251213211250\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:62:\"20251213_ea9c550d418c0a0e7932_20251213211250_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:71:\"/home/u176508502/domains/procuradorgalicia.es/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:57:\"20251213_ea9c550d418c0a0e7932_20251213211250_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:147:\"/home/u176508502/domains/procuradorgalicia.es/public_html/wp-content/backups-dup-lite/tmp/20251213_ea9c550d418c0a0e7932_20251213211250_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:66:\"/home/u176508502/domains/procuradorgalicia.es/public_html/wp-admin\";i:1;s:69:\"/home/u176508502/domains/procuradorgalicia.es/public_html/wp-includes\";i:2;s:78:\"/home/u176508502/domains/procuradorgalicia.es/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:57:\"/home/u176508502/domains/procuradorgalicia.es/public_html\";i:1;s:57:\"/home/u176508502/domains/procuradorgalicia.es/public_html\";i:2;s:68:\"/home/u176508502/domains/procuradorgalicia.es/public_html/wp-content\";i:3;s:76:\"/home/u176508502/domains/procuradorgalicia.es/public_html/wp-content/uploads\";i:4;s:76:\"/home/u176508502/domains/procuradorgalicia.es/public_html/wp-content/plugins\";i:5;s:79:\"/home/u176508502/domains/procuradorgalicia.es/public_html/wp-content/mu-plugins\";i:6;s:75:\"/home/u176508502/domains/procuradorgalicia.es/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:89:\"/home/u176508502/domains/procuradorgalicia.es/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_e_events */
INSERT INTO `wp_e_events` VALUES("1", "{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2023-02-02T01:48:30.047-01:00\"}", "2023-02-02 01:48:30");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://procuradorgalicia.es", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://procuradorgalicia.es", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "agorajuridicasl@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "j \\d\\e F \\d\\e Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "H:i", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "j \\d\\e F \\d\\e Y H:i", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:175:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:12:\"^sp-login/?$\";s:42:\"index.php?post_type=seedprod&name=sp-login\";s:12:\"portfolio/?$\";s:29:\"index.php?post_type=portfolio\";s:42:\"portfolio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:37:\"portfolio/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:29:\"portfolio/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:36:\"seedprod/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"seedprod/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"seedprod/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"seedprod/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"seedprod/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"seedprod/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"seedprod/([^/]+)/embed/?$\";s:41:\"index.php?seedprod=$matches[1]&embed=true\";s:29:\"seedprod/([^/]+)/trackback/?$\";s:35:\"index.php?seedprod=$matches[1]&tb=1\";s:37:\"seedprod/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?seedprod=$matches[1]&paged=$matches[2]\";s:44:\"seedprod/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?seedprod=$matches[1]&cpage=$matches[2]\";s:33:\"seedprod/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?seedprod=$matches[1]&page=$matches[2]\";s:25:\"seedprod/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"seedprod/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"seedprod/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"seedprod/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"seedprod/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"seedprod/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"penci_slider/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"penci_slider/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"penci_slider/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"penci_slider/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"penci_slider/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"penci_slider/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"penci_slider/([^/]+)/embed/?$\";s:45:\"index.php?penci_slider=$matches[1]&embed=true\";s:33:\"penci_slider/([^/]+)/trackback/?$\";s:39:\"index.php?penci_slider=$matches[1]&tb=1\";s:41:\"penci_slider/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?penci_slider=$matches[1]&paged=$matches[2]\";s:48:\"penci_slider/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?penci_slider=$matches[1]&cpage=$matches[2]\";s:37:\"penci_slider/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?penci_slider=$matches[1]&page=$matches[2]\";s:29:\"penci_slider/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"penci_slider/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"penci_slider/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"penci_slider/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"penci_slider/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"penci_slider/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"mc4wp-form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"mc4wp-form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"mc4wp-form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"mc4wp-form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"mc4wp-form/([^/]+)/embed/?$\";s:43:\"index.php?mc4wp-form=$matches[1]&embed=true\";s:31:\"mc4wp-form/([^/]+)/trackback/?$\";s:37:\"index.php?mc4wp-form=$matches[1]&tb=1\";s:39:\"mc4wp-form/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&paged=$matches[2]\";s:46:\"mc4wp-form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&cpage=$matches[2]\";s:35:\"mc4wp-form/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?mc4wp-form=$matches[1]&page=$matches[2]\";s:27:\"mc4wp-form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"mc4wp-form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"mc4wp-form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"mc4wp-form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:50:\"portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:45:\"portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"portfolio-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio-category=$matches[1]&feed=$matches[2]\";s:54:\"portfolio-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio-category=$matches[1]&feed=$matches[2]\";s:35:\"portfolio-category/([^/]+)/embed/?$\";s:51:\"index.php?portfolio-category=$matches[1]&embed=true\";s:47:\"portfolio-category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?portfolio-category=$matches[1]&paged=$matches[2]\";s:29:\"portfolio-category/([^/]+)/?$\";s:40:\"index.php?portfolio-category=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:23:\"index.php?sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=4&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:21:{i:0;s:51:\"all-in-one-wp-migration/all-in-one-wp-migration.php\";i:1;s:27:\"coming-soon/coming-soon.php\";i:2;s:36:\"contact-form-7/wp-contact-form-7.php\";i:3;s:35:\"cookie-law-info/cookie-law-info.php\";i:4;s:25:\"duplicator/duplicator.php\";i:5;s:23:\"elementor/elementor.php\";i:6;s:53:\"famethemes-demo-importer/famethemes-demo-importer.php\";i:7;s:55:\"hostinger-easy-onboarding/hostinger-easy-onboarding.php\";i:8;s:23:\"hostinger/hostinger.php\";i:9;s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";i:10;s:29:\"pdf-embedder/pdf_embedder.php\";i:11;s:24:\"penci-portfolio/init.php\";i:12;s:21:\"penci-recipe/init.php\";i:13;s:21:\"penci-review/init.php\";i:14;s:25:\"penci-shortcodes/init.php\";i:15;s:29:\"penci-soledad-slider/init.php\";i:16;s:27:\"updraftplus/updraftplus.php\";i:17;s:55:\"vafpress-post-formats-ui-develop/vp-post-formats-ui.php\";i:18;s:29:\"wp-mail-smtp/wp_mail_smtp.php\";i:19;s:37:\"wp-whatsapp-chat/wp-whatsapp-chat.php\";i:20;s:24:\"wpforms-lite/wpforms.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "https://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:5:{i:0;s:95:\"/home/u176508502/domains/procuradorgalicia.es/public_html/wp-content/themes/onepress/footer.php\";i:2;s:95:\"/home/u176508502/domains/procuradorgalicia.es/public_html/wp-content/themes/onepress/header.php\";i:3;s:94:\"/home/u176508502/domains/procuradorgalicia.es/public_html/wp-content/themes/onepress/style.css\";i:4;s:93:\"/home/u176508502/domains/procuradorgalicia.es/public_html/wp-content/themes/onepress/home.php\";i:5;s:107:\"/home/u176508502/domains/procuradorgalicia.es/public_html/wp-content/themes/onepress/template-frontpage.php\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "onepress", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "onepress", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "60717", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:4:{i:1;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:1;s:12:\"hierarchical\";i:1;s:8:\"dropdown\";i:0;}i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:1;s:12:\"hierarchical\";i:1;s:8:\"dropdown\";i:0;}i:3;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:5:{i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:298:\"<img class=\"alignnone wp-image-237\" src=\"https://demosoledad.pencidesign.net/soledad-law-firm-multipurpose/wp-content/uploads/sites/31/2019/11/logo2-300x152.png\" alt=\"\" width=\"180\" height=\"91\" />\r\n\r\nSed ut perspiciatis unde omnis iste natus error sit voluptatem accusan tium dolor emque laudantium.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:2;a:4:{s:5:\"title\";s:12:\"Contact Info\";s:4:\"text\";s:191:\"<strong>Address:</strong>  123 Beverly Hill, New York\r\n\r\n<strong>Phone:</strong>  0123 456 789\r\n\r\n<strong>Email:</strong>  <a href=\"mailto:pencidesign@gmail.com\">pencidesign@gmail.com</a>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:298:\"<img class=\"alignnone wp-image-237\" src=\"https://demosoledad.pencidesign.net/soledad-law-firm-multipurpose/wp-content/uploads/sites/31/2019/11/logo2-300x152.png\" alt=\"\" width=\"180\" height=\"91\" />\r\n\r\nSed ut perspiciatis unde omnis iste natus error sit voluptatem accusan tium dolor emque laudantium.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:4;a:4:{s:5:\"title\";s:12:\"Contact Info\";s:4:\"text\";s:191:\"<strong>Address:</strong>  123 Beverly Hill, New York\r\n\r\n<strong>Phone:</strong>  0123 456 789\r\n\r\n<strong>Email:</strong>  <a href=\"mailto:pencidesign@gmail.com\">pencidesign@gmail.com</a>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:3:{s:35:\"litespeed-cache/litespeed-cache.php\";s:47:\"LiteSpeed\\Activation::uninstall_litespeed_cache\";s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:53:\"webp-converter-for-media/webp-converter-for-media.php\";a:2:{i:0;s:30:\"WebpConverter\\Plugin\\Uninstall\";i:1;s:22:\"load_uninstall_actions\";}}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "4", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1770886943", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("99", "initial_db_version", "53496", "yes");
INSERT INTO `wp_options` VALUES("100", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("101", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("102", "user_count", "3", "off");
INSERT INTO `wp_options` VALUES("103", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:160:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Entradas recientes</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:233:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Comentarios recientes</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archivos</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:151:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categorías</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "sidebars_widgets", "a:1:{s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-3\";i:1;s:14:\"recent-posts-1\";i:2;s:17:\"recent-comments-1\";i:3;s:10:\"archives-1\";i:4;s:12:\"categories-3\";i:5;s:6:\"meta-1\";}}", "yes");
INSERT INTO `wp_options` VALUES("105", "cron", "a:24:{i:1765660410;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1765662253;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1765664944;a:1:{s:33:\"updraftplus_clean_temporary_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765670400;a:1:{s:22:\"wdev_logger_clear_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765673071;a:3:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765673122;a:4:{s:21:\"ai1wm_storage_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765673123;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765673299;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765673473;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765676865;a:1:{s:48:\"puc_cron_check_updates-hostinger-easy-onboarding\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765690080;a:1:{s:29:\"mc4wp_refresh_mailchimp_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765743571;a:1:{s:29:\"astra_get_knowledge_base_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765744294;a:1:{s:22:\"seedprod_notifications\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765756800;a:2:{s:28:\"wpforms_email_summaries_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}s:33:\"wpforms_weekly_entries_count_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1765807200;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765834359;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765843547;a:1:{s:27:\"rocket_update_dynamic_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765844147;a:1:{s:36:\"rocket_preload_clean_rows_time_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765844306;a:1:{s:34:\"rocket_rucss_clean_rows_time_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765908189;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1766097449;a:1:{s:26:\"run_weekly_affiliate_astra\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1766105071;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1766249592;a:1:{s:24:\"run_weekly_partner_astra\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("106", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_archives", "a:2:{i:1;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_meta", "a:2:{i:1;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_search", "a:4:{i:1;a:1:{s:5:\"title\";s:0:\"\";}i:2;a:1:{s:5:\"title\";s:0:\"\";}i:3;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "widget_recent-posts", "a:2:{i:1;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("116", "widget_recent-comments", "a:2:{i:1;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("117", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("118", "widget_nav_menu", "a:5:{i:1;a:2:{s:5:\"title\";s:9:\"Resources\";s:8:\"nav_menu\";i:8;}i:2;a:2:{s:5:\"title\";s:12:\"Useful Links\";s:8:\"nav_menu\";i:9;}i:3;a:2:{s:5:\"title\";s:9:\"Resources\";s:8:\"nav_menu\";i:8;}i:4;a:2:{s:5:\"title\";s:12:\"Useful Links\";s:8:\"nav_menu\";i:9;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("119", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("121", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("124", "theme_mods_twentytwentythree", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1675298869;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("127", "https_detection_errors", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("131", "optin_monster_api_activation_redirect_disabled", "true", "yes");
INSERT INTO `wp_options` VALUES("132", "wpforms_activation_redirect", "true", "yes");
INSERT INTO `wp_options` VALUES("133", "aioseo_activation_redirect", "false", "yes");
INSERT INTO `wp_options` VALUES("138", "hostinger_show_onboarding", "1", "yes");
INSERT INTO `wp_options` VALUES("143", "litespeed.conf.__activation", "-1", "yes");
INSERT INTO `wp_options` VALUES("144", "recently_activated", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("145", "litespeed.cloud._summary", "{\"curr_request.ver\":0,\"last_request.ver\":1675298685,\"news.utime\":1676307919,\"curr_request.news\":0,\"last_request.news\":1676307919}", "yes");
INSERT INTO `wp_options` VALUES("146", "litespeed.conf._version", "5.3.2", "yes");
INSERT INTO `wp_options` VALUES("147", "litespeed.conf.hash", "RZr7hgp58GgW9rgroP7JB3699IBMydbJ", "yes");
INSERT INTO `wp_options` VALUES("148", "litespeed.conf.auto_upgrade", "", "yes");
INSERT INTO `wp_options` VALUES("149", "litespeed.conf.api_key", "", "yes");
INSERT INTO `wp_options` VALUES("150", "litespeed.conf.server_ip", "", "yes");
INSERT INTO `wp_options` VALUES("151", "litespeed.conf.guest", "", "yes");
INSERT INTO `wp_options` VALUES("152", "litespeed.conf.guest_optm", "", "yes");
INSERT INTO `wp_options` VALUES("153", "litespeed.conf.news", "1", "yes");
INSERT INTO `wp_options` VALUES("154", "litespeed.conf.guest_uas", "[\"Lighthouse\",\"GTmetrix\",\"Google\",\"Pingdom\",\"bot\",\"PTST\",\"HeadlessChrome\"]", "yes");
INSERT INTO `wp_options` VALUES("155", "litespeed.conf.guest_ips", "[\"208.70.247.157\",\"172.255.48.130\",\"172.255.48.131\",\"172.255.48.132\",\"172.255.48.133\",\"172.255.48.134\",\"172.255.48.135\",\"172.255.48.136\",\"172.255.48.137\",\"172.255.48.138\",\"172.255.48.139\",\"172.255.48.140\",\"172.255.48.141\",\"172.255.48.142\",\"172.255.48.143\",\"172.255.48.144\",\"172.255.48.145\",\"172.255.48.146\",\"172.255.48.147\",\"52.229.122.240\",\"104.214.72.101\",\"13.66.7.11\",\"13.85.24.83\",\"13.85.24.90\",\"13.85.82.26\",\"40.74.242.253\",\"40.74.243.13\",\"40.74.243.176\",\"104.214.48.247\",\"157.55.189.189\",\"104.214.110.135\",\"70.37.83.240\",\"65.52.36.250\",\"13.78.216.56\",\"52.162.212.163\",\"23.96.34.105\",\"65.52.113.236\",\"172.255.61.34\",\"172.255.61.35\",\"172.255.61.36\",\"172.255.61.37\",\"172.255.61.38\",\"172.255.61.39\",\"172.255.61.40\",\"104.41.2.19\",\"191.235.98.164\",\"191.235.99.221\",\"191.232.194.51\",\"52.237.235.185\",\"52.237.250.73\",\"52.237.236.145\",\"104.211.143.8\",\"104.211.165.53\",\"52.172.14.87\",\"40.83.89.214\",\"52.175.57.81\",\"20.188.63.151\",\"20.52.36.49\",\"52.246.165.153\",\"51.144.102.233\",\"13.76.97.224\",\"102.133.169.66\",\"52.231.199.170\",\"13.53.162.7\",\"40.123.218.94\"]", "yes");
INSERT INTO `wp_options` VALUES("156", "litespeed.conf.cache", "1", "yes");
INSERT INTO `wp_options` VALUES("157", "litespeed.conf.cache-priv", "1", "yes");
INSERT INTO `wp_options` VALUES("158", "litespeed.conf.cache-commenter", "1", "yes");
INSERT INTO `wp_options` VALUES("159", "litespeed.conf.cache-rest", "1", "yes");
INSERT INTO `wp_options` VALUES("160", "litespeed.conf.cache-page_login", "1", "yes");
INSERT INTO `wp_options` VALUES("161", "litespeed.conf.cache-favicon", "1", "yes");
INSERT INTO `wp_options` VALUES("162", "litespeed.conf.cache-resources", "1", "yes");
INSERT INTO `wp_options` VALUES("163", "litespeed.conf.cache-mobile", "", "yes");
INSERT INTO `wp_options` VALUES("164", "litespeed.conf.cache-mobile_rules", "[\"Mobile\",\"Android\",\"Silk\\/\",\"Kindle\",\"BlackBerry\",\"Opera Mini\",\"Opera Mobi\"]", "yes");
INSERT INTO `wp_options` VALUES("165", "litespeed.conf.cache-browser", "", "yes");
INSERT INTO `wp_options` VALUES("166", "litespeed.conf.cache-exc_useragents", "[]", "yes");
INSERT INTO `wp_options` VALUES("167", "litespeed.conf.cache-exc_cookies", "[]", "yes");
INSERT INTO `wp_options` VALUES("168", "litespeed.conf.cache-exc_qs", "[]", "yes");
INSERT INTO `wp_options` VALUES("169", "litespeed.conf.cache-exc_cat", "[]", "yes");
INSERT INTO `wp_options` VALUES("170", "litespeed.conf.cache-exc_tag", "[]", "yes");
INSERT INTO `wp_options` VALUES("171", "litespeed.conf.cache-force_uri", "[]", "yes");
INSERT INTO `wp_options` VALUES("172", "litespeed.conf.cache-force_pub_uri", "[]", "yes");
INSERT INTO `wp_options` VALUES("173", "litespeed.conf.cache-priv_uri", "[]", "yes");
INSERT INTO `wp_options` VALUES("174", "litespeed.conf.cache-exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("175", "litespeed.conf.cache-exc_roles", "[]", "yes");
INSERT INTO `wp_options` VALUES("176", "litespeed.conf.cache-drop_qs", "[\"fbclid\",\"gclid\",\"utm*\",\"_ga\"]", "yes");
INSERT INTO `wp_options` VALUES("177", "litespeed.conf.cache-ttl_pub", "604800", "yes");
INSERT INTO `wp_options` VALUES("178", "litespeed.conf.cache-ttl_priv", "1800", "yes");
INSERT INTO `wp_options` VALUES("179", "litespeed.conf.cache-ttl_frontpage", "604800", "yes");
INSERT INTO `wp_options` VALUES("180", "litespeed.conf.cache-ttl_feed", "604800", "yes");
INSERT INTO `wp_options` VALUES("181", "litespeed.conf.cache-ttl_rest", "604800", "yes");
INSERT INTO `wp_options` VALUES("182", "litespeed.conf.cache-ttl_browser", "31557600", "yes");
INSERT INTO `wp_options` VALUES("183", "litespeed.conf.cache-ttl_status", "[\"404 3600\",\"500 600\"]", "yes");
INSERT INTO `wp_options` VALUES("184", "litespeed.conf.cache-login_cookie", "", "yes");
INSERT INTO `wp_options` VALUES("185", "litespeed.conf.cache-vary_group", "[]", "yes");
INSERT INTO `wp_options` VALUES("186", "litespeed.conf.purge-upgrade", "1", "yes");
INSERT INTO `wp_options` VALUES("187", "litespeed.conf.purge-stale", "", "yes");
INSERT INTO `wp_options` VALUES("188", "litespeed.conf.purge-post_all", "", "yes");
INSERT INTO `wp_options` VALUES("189", "litespeed.conf.purge-post_f", "1", "yes");
INSERT INTO `wp_options` VALUES("190", "litespeed.conf.purge-post_h", "1", "yes");
INSERT INTO `wp_options` VALUES("191", "litespeed.conf.purge-post_p", "1", "yes");
INSERT INTO `wp_options` VALUES("192", "litespeed.conf.purge-post_pwrp", "1", "yes");
INSERT INTO `wp_options` VALUES("193", "litespeed.conf.purge-post_a", "1", "yes");
INSERT INTO `wp_options` VALUES("194", "litespeed.conf.purge-post_y", "", "yes");
INSERT INTO `wp_options` VALUES("195", "litespeed.conf.purge-post_m", "1", "yes");
INSERT INTO `wp_options` VALUES("196", "litespeed.conf.purge-post_d", "", "yes");
INSERT INTO `wp_options` VALUES("197", "litespeed.conf.purge-post_t", "1", "yes");
INSERT INTO `wp_options` VALUES("198", "litespeed.conf.purge-post_pt", "1", "yes");
INSERT INTO `wp_options` VALUES("199", "litespeed.conf.purge-timed_urls", "[]", "yes");
INSERT INTO `wp_options` VALUES("200", "litespeed.conf.purge-timed_urls_time", "", "yes");
INSERT INTO `wp_options` VALUES("201", "litespeed.conf.purge-hook_all", "[\"switch_theme\",\"wp_create_nav_menu\",\"wp_update_nav_menu\",\"wp_delete_nav_menu\",\"create_term\",\"edit_terms\",\"delete_term\",\"add_link\",\"edit_link\",\"delete_link\"]", "yes");
INSERT INTO `wp_options` VALUES("202", "litespeed.conf.esi", "", "yes");
INSERT INTO `wp_options` VALUES("203", "litespeed.conf.esi-cache_admbar", "1", "yes");
INSERT INTO `wp_options` VALUES("204", "litespeed.conf.esi-cache_commform", "1", "yes");
INSERT INTO `wp_options` VALUES("205", "litespeed.conf.esi-nonce", "[\"stats_nonce\",\"subscribe_nonce\"]", "yes");
INSERT INTO `wp_options` VALUES("206", "litespeed.conf.util-instant_click", "", "yes");
INSERT INTO `wp_options` VALUES("207", "litespeed.conf.util-no_https_vary", "", "yes");
INSERT INTO `wp_options` VALUES("208", "litespeed.conf.debug-disable_all", "", "yes");
INSERT INTO `wp_options` VALUES("209", "litespeed.conf.debug", "", "yes");
INSERT INTO `wp_options` VALUES("210", "litespeed.conf.debug-ips", "[\"127.0.0.1\"]", "yes");
INSERT INTO `wp_options` VALUES("211", "litespeed.conf.debug-level", "", "yes");
INSERT INTO `wp_options` VALUES("212", "litespeed.conf.debug-filesize", "3", "yes");
INSERT INTO `wp_options` VALUES("213", "litespeed.conf.debug-cookie", "", "yes");
INSERT INTO `wp_options` VALUES("214", "litespeed.conf.debug-collaps_qs", "", "yes");
INSERT INTO `wp_options` VALUES("215", "litespeed.conf.debug-inc", "[]", "yes");
INSERT INTO `wp_options` VALUES("216", "litespeed.conf.debug-exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("217", "litespeed.conf.debug-exc_strings", "[]", "yes");
INSERT INTO `wp_options` VALUES("218", "litespeed.conf.db_optm-revisions_max", "0", "yes");
INSERT INTO `wp_options` VALUES("219", "litespeed.conf.db_optm-revisions_age", "0", "yes");
INSERT INTO `wp_options` VALUES("220", "litespeed.conf.optm-css_min", "", "yes");
INSERT INTO `wp_options` VALUES("221", "litespeed.conf.optm-css_comb", "", "yes");
INSERT INTO `wp_options` VALUES("222", "litespeed.conf.optm-css_comb_ext_inl", "1", "yes");
INSERT INTO `wp_options` VALUES("223", "litespeed.conf.optm-ucss", "", "yes");
INSERT INTO `wp_options` VALUES("224", "litespeed.conf.optm-ucss_inline", "", "yes");
INSERT INTO `wp_options` VALUES("225", "litespeed.conf.optm-ucss_whitelist", "[]", "yes");
INSERT INTO `wp_options` VALUES("226", "litespeed.conf.optm-ucss_file_exc_inline", "[]", "yes");
INSERT INTO `wp_options` VALUES("227", "litespeed.conf.optm-ucss_exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("228", "litespeed.conf.optm-css_exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("229", "litespeed.conf.optm-js_min", "", "yes");
INSERT INTO `wp_options` VALUES("230", "litespeed.conf.optm-js_comb", "", "yes");
INSERT INTO `wp_options` VALUES("231", "litespeed.conf.optm-js_comb_ext_inl", "1", "yes");
INSERT INTO `wp_options` VALUES("232", "litespeed.conf.optm-js_exc", "[\"jquery.js\",\"jquery.min.js\"]", "yes");
INSERT INTO `wp_options` VALUES("233", "litespeed.conf.optm-html_min", "", "yes");
INSERT INTO `wp_options` VALUES("234", "litespeed.conf.optm-html_lazy", "[]", "yes");
INSERT INTO `wp_options` VALUES("235", "litespeed.conf.optm-qs_rm", "", "yes");
INSERT INTO `wp_options` VALUES("236", "litespeed.conf.optm-ggfonts_rm", "", "yes");
INSERT INTO `wp_options` VALUES("237", "litespeed.conf.optm-css_async", "", "yes");
INSERT INTO `wp_options` VALUES("238", "litespeed.conf.optm-ccss_per_url", "", "yes");
INSERT INTO `wp_options` VALUES("239", "litespeed.conf.optm-ccss_sep_posttype", "[\"page\"]", "yes");
INSERT INTO `wp_options` VALUES("240", "litespeed.conf.optm-ccss_sep_uri", "[]", "yes");
INSERT INTO `wp_options` VALUES("241", "litespeed.conf.optm-css_async_inline", "1", "yes");
INSERT INTO `wp_options` VALUES("242", "litespeed.conf.optm-css_font_display", "", "yes");
INSERT INTO `wp_options` VALUES("243", "litespeed.conf.optm-js_defer", "", "yes");
INSERT INTO `wp_options` VALUES("244", "litespeed.conf.optm-emoji_rm", "", "yes");
INSERT INTO `wp_options` VALUES("245", "litespeed.conf.optm-noscript_rm", "", "yes");
INSERT INTO `wp_options` VALUES("246", "litespeed.conf.optm-ggfonts_async", "", "yes");
INSERT INTO `wp_options` VALUES("247", "litespeed.conf.optm-exc_roles", "[]", "yes");
INSERT INTO `wp_options` VALUES("248", "litespeed.conf.optm-ccss_con", "", "yes");
INSERT INTO `wp_options` VALUES("249", "litespeed.conf.optm-js_defer_exc", "[\"jquery.js\",\"jquery.min.js\",\"gtm.js\",\"analytics.js\"]", "yes");
INSERT INTO `wp_options` VALUES("250", "litespeed.conf.optm-gm_js_exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("251", "litespeed.conf.optm-dns_prefetch", "[]", "yes");
INSERT INTO `wp_options` VALUES("252", "litespeed.conf.optm-dns_prefetch_ctrl", "", "yes");
INSERT INTO `wp_options` VALUES("253", "litespeed.conf.optm-exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("254", "litespeed.conf.optm-guest_only", "1", "yes");
INSERT INTO `wp_options` VALUES("255", "litespeed.conf.object", "", "yes");
INSERT INTO `wp_options` VALUES("256", "litespeed.conf.object-kind", "", "yes");
INSERT INTO `wp_options` VALUES("257", "litespeed.conf.object-host", "localhost", "yes");
INSERT INTO `wp_options` VALUES("258", "litespeed.conf.object-port", "11211", "yes");
INSERT INTO `wp_options` VALUES("259", "litespeed.conf.object-life", "360", "yes");
INSERT INTO `wp_options` VALUES("260", "litespeed.conf.object-persistent", "1", "yes");
INSERT INTO `wp_options` VALUES("261", "litespeed.conf.object-admin", "1", "yes");
INSERT INTO `wp_options` VALUES("262", "litespeed.conf.object-transients", "1", "yes");
INSERT INTO `wp_options` VALUES("263", "litespeed.conf.object-db_id", "0", "yes");
INSERT INTO `wp_options` VALUES("264", "litespeed.conf.object-user", "", "yes");
INSERT INTO `wp_options` VALUES("265", "litespeed.conf.object-pswd", "", "yes");
INSERT INTO `wp_options` VALUES("266", "litespeed.conf.object-global_groups", "[\"users\",\"userlogins\",\"useremail\",\"userslugs\",\"usermeta\",\"user_meta\",\"site-transient\",\"site-options\",\"site-lookup\",\"site-details\",\"blog-lookup\",\"blog-details\",\"blog-id-cache\",\"rss\",\"global-posts\",\"global-cache-test\"]", "yes");
INSERT INTO `wp_options` VALUES("267", "litespeed.conf.object-non_persistent_groups", "[\"comment\",\"counts\",\"plugins\",\"wc_session_id\"]", "yes");
INSERT INTO `wp_options` VALUES("268", "litespeed.conf.discuss-avatar_cache", "", "yes");
INSERT INTO `wp_options` VALUES("269", "litespeed.conf.discuss-avatar_cron", "", "yes");
INSERT INTO `wp_options` VALUES("270", "litespeed.conf.discuss-avatar_cache_ttl", "604800", "yes");
INSERT INTO `wp_options` VALUES("271", "litespeed.conf.optm-localize", "", "yes");
INSERT INTO `wp_options` VALUES("272", "litespeed.conf.optm-localize_domains", "[\"### Popular scripts ###\",\"https:\\/\\/platform.twitter.com\\/widgets.js\",\"https:\\/\\/connect.facebook.net\\/en_US\\/fbevents.js\"]", "yes");
INSERT INTO `wp_options` VALUES("273", "litespeed.conf.media-lazy", "", "yes");
INSERT INTO `wp_options` VALUES("274", "litespeed.conf.media-lazy_placeholder", "", "yes");
INSERT INTO `wp_options` VALUES("275", "litespeed.conf.media-placeholder_resp", "", "yes");
INSERT INTO `wp_options` VALUES("276", "litespeed.conf.media-placeholder_resp_color", "#cfd4db", "yes");
INSERT INTO `wp_options` VALUES("277", "litespeed.conf.media-placeholder_resp_svg", "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"{width}\" height=\"{height}\" viewBox=\"0 0 {width} {height}\"><rect width=\"100%\" height=\"100%\" style=\"fill:{color};fill-opacity: 0.1;\"/></svg>", "yes");
INSERT INTO `wp_options` VALUES("278", "litespeed.conf.media-lqip", "", "yes");
INSERT INTO `wp_options` VALUES("279", "litespeed.conf.media-lqip_qual", "4", "yes");
INSERT INTO `wp_options` VALUES("280", "litespeed.conf.media-lqip_min_w", "150", "yes");
INSERT INTO `wp_options` VALUES("281", "litespeed.conf.media-lqip_min_h", "150", "yes");
INSERT INTO `wp_options` VALUES("282", "litespeed.conf.media-placeholder_resp_async", "1", "yes");
INSERT INTO `wp_options` VALUES("283", "litespeed.conf.media-iframe_lazy", "", "yes");
INSERT INTO `wp_options` VALUES("284", "litespeed.conf.media-add_missing_sizes", "", "yes");
INSERT INTO `wp_options` VALUES("285", "litespeed.conf.media-lazy_exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("286", "litespeed.conf.media-lazy_cls_exc", "[\"wmu-preview-img\"]", "yes");
INSERT INTO `wp_options` VALUES("287", "litespeed.conf.media-lazy_parent_cls_exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("288", "litespeed.conf.media-iframe_lazy_cls_exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("289", "litespeed.conf.media-iframe_lazy_parent_cls_exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("290", "litespeed.conf.media-lazy_uri_exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("291", "litespeed.conf.media-lqip_exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("292", "litespeed.conf.media-vpi", "", "yes");
INSERT INTO `wp_options` VALUES("293", "litespeed.conf.media-vpi_cron", "", "yes");
INSERT INTO `wp_options` VALUES("294", "litespeed.conf.img_optm-auto", "", "yes");
INSERT INTO `wp_options` VALUES("295", "litespeed.conf.img_optm-cron", "1", "yes");
INSERT INTO `wp_options` VALUES("296", "litespeed.conf.img_optm-ori", "1", "yes");
INSERT INTO `wp_options` VALUES("297", "litespeed.conf.img_optm-rm_bkup", "", "yes");
INSERT INTO `wp_options` VALUES("298", "litespeed.conf.img_optm-webp", "", "yes");
INSERT INTO `wp_options` VALUES("299", "litespeed.conf.img_optm-lossless", "", "yes");
INSERT INTO `wp_options` VALUES("300", "litespeed.conf.img_optm-exif", "1", "yes");
INSERT INTO `wp_options` VALUES("301", "litespeed.conf.img_optm-webp_attr", "[\"img.src\",\"div.data-thumb\",\"img.data-src\",\"img.data-lazyload\",\"div.data-large_image\",\"img.retina_logo_url\",\"div.data-parallax-image\",\"div.data-vc-parallax-image\",\"video.poster\"]", "yes");
INSERT INTO `wp_options` VALUES("302", "litespeed.conf.img_optm-webp_replace_srcset", "", "yes");
INSERT INTO `wp_options` VALUES("303", "litespeed.conf.img_optm-jpg_quality", "82", "yes");
INSERT INTO `wp_options` VALUES("304", "litespeed.conf.crawler", "", "yes");
INSERT INTO `wp_options` VALUES("305", "litespeed.conf.crawler-usleep", "500", "yes");
INSERT INTO `wp_options` VALUES("306", "litespeed.conf.crawler-run_duration", "400", "yes");
INSERT INTO `wp_options` VALUES("307", "litespeed.conf.crawler-run_interval", "600", "yes");
INSERT INTO `wp_options` VALUES("308", "litespeed.conf.crawler-crawl_interval", "302400", "yes");
INSERT INTO `wp_options` VALUES("309", "litespeed.conf.crawler-threads", "3", "yes");
INSERT INTO `wp_options` VALUES("310", "litespeed.conf.crawler-timeout", "30", "yes");
INSERT INTO `wp_options` VALUES("311", "litespeed.conf.crawler-load_limit", "1", "yes");
INSERT INTO `wp_options` VALUES("312", "litespeed.conf.crawler-sitemap", "", "yes");
INSERT INTO `wp_options` VALUES("313", "litespeed.conf.crawler-drop_domain", "1", "yes");
INSERT INTO `wp_options` VALUES("314", "litespeed.conf.crawler-map_timeout", "120", "yes");
INSERT INTO `wp_options` VALUES("315", "litespeed.conf.crawler-roles", "[]", "yes");
INSERT INTO `wp_options` VALUES("316", "litespeed.conf.crawler-cookies", "[]", "yes");
INSERT INTO `wp_options` VALUES("317", "litespeed.conf.misc-heartbeat_front", "", "yes");
INSERT INTO `wp_options` VALUES("318", "litespeed.conf.misc-heartbeat_front_ttl", "60", "yes");
INSERT INTO `wp_options` VALUES("319", "litespeed.conf.misc-heartbeat_back", "", "yes");
INSERT INTO `wp_options` VALUES("320", "litespeed.conf.misc-heartbeat_back_ttl", "60", "yes");
INSERT INTO `wp_options` VALUES("321", "litespeed.conf.misc-heartbeat_editor", "", "yes");
INSERT INTO `wp_options` VALUES("322", "litespeed.conf.misc-heartbeat_editor_ttl", "15", "yes");
INSERT INTO `wp_options` VALUES("323", "litespeed.conf.cdn", "", "yes");
INSERT INTO `wp_options` VALUES("324", "litespeed.conf.cdn-ori", "[]", "yes");
INSERT INTO `wp_options` VALUES("325", "litespeed.conf.cdn-ori_dir", "[\"wp-content\",\"wp-includes\"]", "yes");
INSERT INTO `wp_options` VALUES("326", "litespeed.conf.cdn-exc", "[]", "yes");
INSERT INTO `wp_options` VALUES("327", "litespeed.conf.cdn-quic", "", "yes");
INSERT INTO `wp_options` VALUES("328", "litespeed.conf.cdn-cloudflare", "", "yes");
INSERT INTO `wp_options` VALUES("329", "litespeed.conf.cdn-cloudflare_email", "", "yes");
INSERT INTO `wp_options` VALUES("330", "litespeed.conf.cdn-cloudflare_key", "", "yes");
INSERT INTO `wp_options` VALUES("331", "litespeed.conf.cdn-cloudflare_name", "", "yes");
INSERT INTO `wp_options` VALUES("332", "litespeed.conf.cdn-cloudflare_zone", "", "yes");
INSERT INTO `wp_options` VALUES("333", "litespeed.conf.cdn-mapping", "[{\"url\":\"\",\"inc_img\":\"1\",\"inc_css\":\"1\",\"inc_js\":\"1\",\"filetype\":[\".aac\",\".css\",\".eot\",\".gif\",\".jpeg\",\".jpg\",\".js\",\".less\",\".mp3\",\".mp4\",\".ogg\",\".otf\",\".pdf\",\".png\",\".svg\",\".ttf\",\".webp\",\".woff\",\".woff2\"]}]", "yes");
INSERT INTO `wp_options` VALUES("334", "litespeed.conf.cdn-attr", "[\".src\",\".data-src\",\".href\",\".poster\",\"source.srcset\"]", "yes");
INSERT INTO `wp_options` VALUES("335", "litespeed.conf.qc-token", "", "yes");
INSERT INTO `wp_options` VALUES("336", "litespeed.conf.qc-nameservers", "", "yes");
INSERT INTO `wp_options` VALUES("339", "ai1wm_secret_key", "MoUggLq3DNzF", "yes");
INSERT INTO `wp_options` VALUES("341", "litespeed.purge.queue", "-1", "yes");
INSERT INTO `wp_options` VALUES("342", "litespeed.purge.queue2", "-1", "yes");
INSERT INTO `wp_options` VALUES("345", "action_scheduler_hybrid_store_demarkation", "4", "yes");
INSERT INTO `wp_options` VALUES("346", "schema-ActionScheduler_StoreSchema", "8.0.1753769463", "yes");
INSERT INTO `wp_options` VALUES("347", "schema-ActionScheduler_LoggerSchema", "3.0.1675298686", "yes");
INSERT INTO `wp_options` VALUES("350", "wpforms_version", "1.7.9.1", "yes");
INSERT INTO `wp_options` VALUES("351", "wpforms_version_lite", "1.7.9.1", "yes");
INSERT INTO `wp_options` VALUES("352", "wpforms_activated", "a:2:{s:4:\"lite\";i:1675298686;s:3:\"pro\";i:1675685642;}", "yes");
INSERT INTO `wp_options` VALUES("358", "wpforms_versions_lite", "a:26:{s:5:\"1.5.9\";i:0;s:7:\"1.6.7.2\";i:0;s:5:\"1.6.8\";i:0;s:5:\"1.7.5\";i:0;s:7:\"1.7.5.1\";i:0;s:5:\"1.7.7\";i:0;s:5:\"1.7.8\";i:1675685639;s:7:\"1.7.9.1\";i:1675298688;s:7:\"1.8.0.1\";i:1677530365;s:5:\"1.8.2\";i:1738088899;s:5:\"1.8.3\";i:1738088907;s:5:\"1.8.4\";i:1738088907;s:5:\"1.8.6\";i:1738088907;s:5:\"1.8.7\";i:1738088907;s:5:\"1.9.1\";i:1738088899;s:5:\"1.9.2\";i:1738088916;s:7:\"1.9.3.2\";i:1738088899;s:5:\"1.9.6\";i:1750089378;s:7:\"1.9.6.1\";i:1750744447;s:7:\"1.9.6.2\";i:1752559431;s:5:\"1.9.7\";i:1754981427;s:7:\"1.9.7.1\";i:1754376375;s:7:\"1.9.7.3\";i:1754981427;s:7:\"1.9.8.1\";i:1759216724;s:7:\"1.9.8.2\";i:1761034307;s:7:\"1.9.8.4\";i:1762845281;}", "yes");
INSERT INTO `wp_options` VALUES("359", "widget_wpforms-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("361", "action_scheduler_lock_async-request-runner", "693dd6c0e7cf39.34397490|1765660412", "yes");
INSERT INTO `wp_options` VALUES("365", "wpforms_admin_notices", "a:2:{s:14:\"review_request\";a:2:{s:4:\"time\";i:1675298722;s:9:\"dismissed\";b:0;}s:19:\"review_lite_request\";a:2:{s:4:\"time\";i:1677532015;s:9:\"dismissed\";b:1;}}", "yes");
INSERT INTO `wp_options` VALUES("370", "litespeed.gui.lscwp_whm_install", "-1", "yes");
INSERT INTO `wp_options` VALUES("371", "litespeed.gui.dismiss", "-1", "yes");
INSERT INTO `wp_options` VALUES("372", "litespeed.gui._summary", "{\"new_version\":1675903523,\"score\":1676508323}", "yes");
INSERT INTO `wp_options` VALUES("373", "litespeed.data.upgrading", "-1", "yes");
INSERT INTO `wp_options` VALUES("374", "litespeed.admin_display.messages", "[\"<div class=\\\"litespeed_icon notice notice-success is-dismissible\\\"><p>Se han borrado todas las colas de servicio de QUIC.cloud<\\/p><\\/div>\",\"<div class=\\\"litespeed_icon notice notice-success is-dismissible\\\"><p>Vaciado de todas las cach\\u00e9s correctamente.<\\/p><\\/div>\"]", "yes");
INSERT INTO `wp_options` VALUES("376", "_transient_wpforms_htaccess_file", "a:3:{s:4:\"size\";i:737;s:5:\"mtime\";i:1676307785;s:5:\"ctime\";i:1676307785;}", "yes");
INSERT INTO `wp_options` VALUES("399", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("402", "_site_transient_ai1wm_last_check_for_updates", "1765632895", "off");
INSERT INTO `wp_options` VALUES("403", "ai1wm_updater", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("417", "current_theme", "OnePress", "yes");
INSERT INTO `wp_options` VALUES("418", "theme_mods_soledad-child", "a:102:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:9:\"main-menu\";i:10;}s:18:\"custom_css_post_id\";i:-1;s:26:\"penci_speed_delay_css_type\";s:6:\"onload\";s:19:\"penci_header_layout\";s:8:\"header-6\";s:23:\"penci_header_menu_style\";s:12:\"menu-style-2\";s:23:\"penci_header_social_nav\";b:0;s:15:\"penci_go_to_top\";b:1;s:24:\"penci_go_to_top_floating\";b:0;s:26:\"penci_footer_social_around\";b:1;s:22:\"penci_footer_copyright\";s:155:\"@2022 - Todos los derechos reservados </br>Diseñado y Monitorizado por <a href=\"https://www.villamilenterprise.es\" target=\"_blank\">Villamil Enterprise</a>\";s:36:\"penci_footer_copyright_remove_italic\";b:1;s:15:\"penci_instagram\";s:0:\"\";s:15:\"penci_pinterest\";s:0:\"\";s:13:\"penci_youtube\";s:0:\"\";s:14:\"penci_linkedin\";s:0:\"\";s:31:\"penci_footer_copyright_bg_color\";s:7:\"#111111\";s:32:\"penci_footer_social_border_color\";s:7:\"#212121\";s:18:\"penci_color_accent\";s:7:\"#ffffff\";s:31:\"penci_header_social_color_hover\";s:7:\"#8c6239\";s:27:\"penci_main_bar_color_active\";s:7:\"#8c6239\";s:27:\"penci_drop_text_hover_color\";s:7:\"#8c6239\";s:24:\"penci_drop_border_style2\";s:7:\"#8c6239\";s:23:\"penci_mega_accent_color\";s:7:\"#8c6239\";s:32:\"penci_ver_nav_accent_hover_color\";s:7:\"#8c6239\";s:37:\"penci_masonry_categories_accent_color\";s:7:\"#8c6239\";s:28:\"penci_masonry_box_icon_hover\";s:7:\"#8c6239\";s:26:\"penci_masonry_accent_color\";s:7:\"#8c6239\";s:40:\"penci_photography_title_post_hover_color\";s:7:\"#8c6239\";s:30:\"penci_photography_accent_color\";s:7:\"#8c6239\";s:34:\"penci_overlay_cat_hover_post_color\";s:7:\"#8c6239\";s:35:\"penci_sidebar_heading_border_color7\";s:7:\"#8c6239\";s:32:\"penci_sidebar_accent_hover_color\";s:7:\"#8c6239\";s:38:\"penci_footer_widget_accent_hover_color\";s:0:\"\";s:29:\"penci_footer_icon_hover_color\";s:7:\"#8c6239\";s:36:\"penci_footer_social_hover_text_color\";s:7:\"#8c6239\";s:31:\"penci_footer_go_top_float_color\";s:7:\"#8c6239\";s:29:\"penci_footer_menu_color_hover\";s:7:\"#8c6239\";s:35:\"penci_footer_copyright_accent_color\";s:7:\"#ffffff\";s:22:\"penci_single_cat_color\";s:7:\"#8c6239\";s:35:\"penci_single_share_icon_hover_color\";s:7:\"#8c6239\";s:30:\"penci_single_number_like_color\";s:7:\"#8c6239\";s:25:\"penci_single_accent_color\";s:7:\"#8c6239\";s:24:\"penci_single_color_links\";s:7:\"#8c6239\";s:24:\"penci_rltpop_title_hover\";s:7:\"#8c6239\";s:28:\"penci_footer_widget_bg_image\";s:61:\"https://procuradorgalicia.es/wp-content/uploads/2023/02/1.jpg\";s:19:\"penci_footer_social\";b:1;s:24:\"penci_disable_breadcrumb\";b:1;s:20:\"penci_sidebar_sticky\";b:1;s:19:\"penci_font_for_body\";s:93:\"\"Rubik\", \"300:300italic:regular:italic:500:500italic:700:700italic:900:900italic\", sans-serif\";s:24:\"penci_font_for_size_body\";i:15;s:20:\"penci_font_for_title\";s:117:\"\"Source Sans Pro\", \"200:200italic:300:300italic:regular:italic:600:600italic:700:700italic:900:900italic\", sans-serif\";s:23:\"penci_font_weight_title\";s:3:\"600\";s:19:\"penci_font_for_menu\";s:117:\"\"Source Sans Pro\", \"200:200italic:300:300italic:regular:italic:600:600italic:700:700italic:900:900italic\", sans-serif\";s:22:\"penci_font_weight_menu\";s:3:\"600\";s:27:\"penci_topbar_menu_uppercase\";b:1;s:19:\"penci_font_size_lv1\";i:17;s:10:\"penci_logo\";s:85:\"https://procuradorgalicia.es/wp-content/uploads/2023/02/LogoProcuradorGaliciaLogo.png\";s:35:\"penci_footer_widget_area_text_color\";s:7:\"#ffffff\";s:31:\"penci_footer_widget_area_layout\";s:7:\"style-4\";s:36:\"penci_footer_widget_area_list_border\";s:7:\"#212121\";s:25:\"penci_footer_widget_color\";s:7:\"#ffffff\";s:38:\"penci_footer_widget_title_border_color\";s:7:\"#212121\";s:32:\"penci_footer_widget_accent_color\";s:7:\"#ffffff\";s:23:\"penci_footer_icon_color\";s:7:\"#212121\";s:18:\"penci_single_style\";s:7:\"style-6\";s:30:\"penci_off_uppercase_post_title\";b:1;s:28:\"penci_single_title_font_size\";i:30;s:33:\"penci_off_letter_space_post_title\";b:1;s:27:\"penci_align_left_post_title\";b:1;s:38:\"penci_off_uppercase_post_title_related\";b:1;s:31:\"penci_post_remove_lines_related\";b:1;s:24:\"penci_post_nav_thumbnail\";b:1;s:34:\"penci_off_uppercase_post_title_nav\";b:1;s:32:\"penci_related_posts_title_length\";i:14;s:27:\"penci_sidebar_heading_style\";s:8:\"style-12\";s:27:\"penci_sidebar_heading_align\";s:12:\"pcalign-left\";s:17:\"penci_map_api_key\";s:39:\"AIzaSyCgMt6qJvlOWI4RnXtL3dfYRKTlFC5GIVk\";s:27:\"penci_footer_widget_area_bg\";s:7:\"#111111\";s:16:\"penci_custom_css\";s:1036:\"#widget-area {border-top: none}\nsvg{\n    display:none;\n}\n.wpforms-form textarea,.wpforms-form label,.wpforms-form input, .wpforms-field-label, wpforms-447-field_3,.wpforms-form input,.wpforms-form select, .wpforms-form label.wpforms-field-label {\ncolor: #B5B2B2\n!important;\n}\n/* This styles the submit button */\n.wpf-center .wpforms-submit-container  {\n    display: inline-block;\n    text-align: center;\n    width: 100% !important;\n}\n/* This styles all pagebreak elements */\n.wpf-center .wpforms-field-pagebreak  {\n    display: inline-block;\n    text-align: center;\n    width: 100% !important;\n}\n/* This styles all labels, field descriptions, form titles, and form descriptions */\n.wpf-center .wpforms-title, \n.wpf-center .wpforms-description,\n.wpf-center .wpforms-field-label,\n.wpf-center .wpforms-field-sublabel, \n.wpf-center .wpforms-field-description {\n    text-align: center;\n}\n.wpf-center .wpforms-pagebreak-left .wpforms-page-button:before,.wpf-center .wpforms-pagebreak-left .wpforms-page-button:after {\n    content: none;\n} \n \n\";s:20:\"penci_toppost_enable\";b:1;s:25:\"penci_featured_image_size\";s:10:\"horizontal\";s:25:\"penci_topbar_search_check\";b:1;s:31:\"penci_footer_social_remove_text\";b:1;s:24:\"penci_footer_widget_area\";b:1;s:13:\"penci_favicon\";s:89:\"https://procuradorgalicia.es/wp-content/uploads/2023/02/AVATAR-agora-servicios-negro1.png\";s:24:\"penci_single_title_color\";s:0:\"\";s:27:\"penci_single_subtitle_color\";s:0:\"\";s:23:\"penci_single_meta_color\";s:0:\"\";s:29:\"penci_single_color_title_s568\";s:0:\"\";s:22:\"penci_single_tag_color\";s:7:\"#eeee22\";s:14:\"penci_facebook\";s:0:\"\";s:13:\"penci_twitter\";s:0:\"\";s:24:\"penci_header_slogan_text\";s:52:\"Procurador Galicia, asesoramiento y representación.\";s:31:\"penci_header_logo_mobile_center\";b:0;s:23:\"penci_enable_cookie_law\";b:1;s:21:\"penci_gprd_btn_accept\";s:6:\"Acepto\";s:16:\"penci_gprd_rmore\";s:9:\"Leer Más\";s:22:\"penci_gprd_policy_text\";s:20:\"Política de Cookies\";s:15:\"penci_gprd_desc\";s:150:\"Este sitio web utiliza cookies para mejorar su experiencia. Asumiremos que está de acuerdo con esto, pero puede optar por no participar si lo desea. \";s:21:\"penci_gprd_rmore_link\";s:49:\"https://procuradorgalicia.es/politica-de-cookies/\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1677096882;s:4:\"data\";a:25:{s:19:\"wp_inactive_widgets\";a:0:{}s:12:\"main-sidebar\";a:8:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:21:\"penci_social_widget-1\";i:4;s:8:\"search-1\";i:5;s:26:\"penci_latest_news_widget-1\";i:6;s:19:\"mc4wp_form_widget-1\";i:7;s:12:\"categories-1\";}s:17:\"main-sidebar-left\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:8:\"footer-1\";a:1:{i:0;s:6:\"text-1\";}s:8:\"footer-2\";a:1:{i:0;s:10:\"nav_menu-1\";}s:8:\"footer-3\";a:1:{i:0;s:10:\"nav_menu-2\";}s:8:\"footer-4\";a:2:{i:0;s:6:\"text-2\";i:1;s:21:\"penci_social_widget-2\";}s:18:\"header-signup-form\";a:0:{}s:18:\"footer-signup-form\";a:0:{}s:16:\"footer-instagram\";a:0:{}s:13:\"top-instagram\";a:0:{}s:16:\"menu_hamburger_1\";a:0:{}s:16:\"menu_hamburger_2\";a:0:{}s:18:\"penci-shop-sidebar\";a:0:{}s:17:\"penci-shop-single\";a:0:{}s:16:\"custom-sidebar-1\";a:0:{}s:16:\"custom-sidebar-2\";a:0:{}s:16:\"custom-sidebar-3\";a:0:{}s:16:\"custom-sidebar-4\";a:0:{}s:16:\"custom-sidebar-5\";a:0:{}s:16:\"custom-sidebar-6\";a:0:{}s:16:\"custom-sidebar-7\";a:0:{}s:16:\"custom-sidebar-8\";a:0:{}s:16:\"custom-sidebar-9\";a:0:{}s:17:\"custom-sidebar-10\";a:0:{}}}}", "off");
INSERT INTO `wp_options` VALUES("419", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("420", "litespeed.optimize.timestamp_purge_css", "1676333187", "yes");
INSERT INTO `wp_options` VALUES("421", "penci_soledad_is_activated", "1", "yes");
INSERT INTO `wp_options` VALUES("422", "soledad_active_status_last_time", "1675298870", "yes");
INSERT INTO `wp_options` VALUES("423", "widget_penci_social_widget", "a:3:{i:1;a:43:{s:5:\"title\";s:14:\"Social Connect\";s:4:\"text\";s:2:\"on\";s:5:\"align\";s:12:\"pc_alignleft\";s:6:\"circle\";s:0:\"\";s:13:\"border_radius\";s:0:\"\";s:11:\"brand_color\";s:0:\"\";s:9:\"size_icon\";s:2:\"14\";s:10:\"size_upper\";s:0:\"\";s:9:\"size_text\";s:2:\"13\";s:8:\"facebook\";s:2:\"on\";s:7:\"twitter\";s:2:\"on\";s:9:\"instagram\";s:2:\"on\";s:8:\"linkedin\";s:2:\"on\";s:6:\"flickr\";s:0:\"\";s:7:\"behance\";s:0:\"\";s:7:\"youtube\";s:2:\"on\";s:6:\"tumblr\";s:0:\"\";s:9:\"pinterest\";s:2:\"on\";s:5:\"email\";s:0:\"\";s:2:\"vk\";s:0:\"\";s:9:\"bloglovin\";s:0:\"\";s:4:\"vine\";s:0:\"\";s:10:\"soundcloud\";s:0:\"\";s:8:\"snapchat\";s:0:\"\";s:7:\"spotify\";s:0:\"\";s:6:\"github\";s:0:\"\";s:5:\"stack\";s:0:\"\";s:6:\"twitch\";s:0:\"\";s:5:\"vimeo\";s:0:\"\";s:5:\"steam\";s:0:\"\";s:4:\"xing\";s:0:\"\";s:8:\"whatsapp\";s:0:\"\";s:8:\"telegram\";s:0:\"\";s:6:\"reddit\";s:0:\"\";s:2:\"ok\";s:0:\"\";s:5:\"500px\";s:0:\"\";s:11:\"stumbleupon\";s:0:\"\";s:6:\"wechat\";s:0:\"\";s:5:\"weibo\";s:0:\"\";s:4:\"line\";s:0:\"\";s:5:\"viber\";s:0:\"\";s:7:\"discord\";s:0:\"\";s:3:\"rss\";s:0:\"\";}i:2;a:43:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:0:\"\";s:5:\"align\";s:12:\"pc_alignleft\";s:6:\"circle\";s:2:\"on\";s:13:\"border_radius\";s:0:\"\";s:11:\"brand_color\";s:0:\"\";s:9:\"size_icon\";s:2:\"14\";s:10:\"size_upper\";s:0:\"\";s:9:\"size_text\";s:2:\"13\";s:8:\"facebook\";s:2:\"on\";s:7:\"twitter\";s:2:\"on\";s:9:\"instagram\";s:2:\"on\";s:8:\"linkedin\";s:2:\"on\";s:6:\"flickr\";s:0:\"\";s:7:\"behance\";s:0:\"\";s:7:\"youtube\";s:2:\"on\";s:6:\"tumblr\";s:0:\"\";s:9:\"pinterest\";s:0:\"\";s:5:\"email\";s:2:\"on\";s:2:\"vk\";s:0:\"\";s:9:\"bloglovin\";s:0:\"\";s:4:\"vine\";s:0:\"\";s:10:\"soundcloud\";s:0:\"\";s:8:\"snapchat\";s:0:\"\";s:7:\"spotify\";s:0:\"\";s:6:\"github\";s:0:\"\";s:5:\"stack\";s:0:\"\";s:6:\"twitch\";s:0:\"\";s:5:\"vimeo\";s:0:\"\";s:5:\"steam\";s:0:\"\";s:4:\"xing\";s:0:\"\";s:8:\"whatsapp\";s:0:\"\";s:8:\"telegram\";s:0:\"\";s:6:\"reddit\";s:0:\"\";s:2:\"ok\";s:0:\"\";s:5:\"500px\";s:0:\"\";s:11:\"stumbleupon\";s:0:\"\";s:6:\"wechat\";s:0:\"\";s:5:\"weibo\";s:0:\"\";s:4:\"line\";s:0:\"\";s:5:\"viber\";s:0:\"\";s:7:\"discord\";s:0:\"\";s:3:\"rss\";s:2:\"on\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("424", "widget_penci_about_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("425", "widget_penci_latest_news_widget", "a:2:{i:1;a:13:{s:5:\"title\";s:12:\"Recent Posts\";s:10:\"categories\";s:3:\"all\";s:6:\"number\";s:1:\"5\";s:6:\"offset\";s:0:\"\";s:12:\"title_length\";s:0:\"\";s:8:\"featured\";s:0:\"\";s:9:\"twocolumn\";s:0:\"\";s:9:\"featured2\";s:0:\"\";s:11:\"allfeatured\";s:0:\"\";s:10:\"thumbright\";s:0:\"\";s:8:\"postdate\";s:2:\"on\";s:4:\"icon\";s:0:\"\";s:10:\"image_type\";s:7:\"default\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("426", "widget_penci_popular_news_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("427", "widget_penci_block_heading_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("428", "widget_penci_facebook_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("429", "widget_penci_related_news_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("430", "widget_penci_slider_posts_news_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("431", "widget_penci_quote_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("432", "widget_penci_pinterest_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("433", "widget_penci_list_bannner_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("434", "widget_penci_login_register_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("435", "widget_penci_videoplaylist_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("436", "widget_penci_social_counter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("437", "widget_penci-insta-slider", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("438", "elementor_cpt_support", "a:4:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:14:\"e-landing-page\";i:3;s:9:\"portfolio\";}", "yes");
INSERT INTO `wp_options` VALUES("442", "penci_validate_check", "1677890870", "yes");
INSERT INTO `wp_options` VALUES("447", "wpcf7", "a:2:{s:7:\"version\";s:5:\"6.1.4\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1750089717;s:7:\"version\";s:5:\"6.0.6\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:2;}}", "yes");
INSERT INTO `wp_options` VALUES("448", "elementor_active_kit", "8", "yes");
INSERT INTO `wp_options` VALUES("449", "elementor_font_display", "swap", "yes");
INSERT INTO `wp_options` VALUES("453", "elementor_version", "3.33.4", "yes");
INSERT INTO `wp_options` VALUES("454", "elementor_install_history", "a:20:{s:6:\"3.10.2\";i:1675298912;s:6:\"3.11.2\";i:1677530365;s:6:\"3.27.2\";i:1750089168;s:6:\"3.29.2\";i:1750089259;s:6:\"3.30.1\";i:1751954486;s:6:\"3.30.2\";i:1752559432;s:6:\"3.30.3\";i:1753769457;s:6:\"3.30.4\";i:1754374424;s:6:\"3.31.2\";i:1754979409;s:6:\"3.31.3\";i:1756794464;s:6:\"3.31.4\";i:1757399446;s:6:\"3.32.0\";i:1758004558;s:6:\"3.32.2\";i:1758609418;s:6:\"3.32.3\";i:1759214381;s:6:\"3.32.4\";i:1759819366;s:6:\"3.32.5\";i:1761634314;s:6:\"3.33.0\";i:1762844726;s:6:\"3.33.1\";i:1763449254;s:6:\"3.33.2\";i:1764054214;s:6:\"3.33.4\";i:1765264017;}", "yes");
INSERT INTO `wp_options` VALUES("455", "elementor_events_db_version", "1.0.0", "no");
INSERT INTO `wp_options` VALUES("456", "widget_mc4wp_form_widget", "a:3:{i:1;a:1:{s:5:\"title\";s:10:\"Newsletter\";}i:2;a:1:{s:5:\"title\";s:10:\"Newsletter\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("457", "widget_penci_latest_tweets_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("462", "mc4wp_version", "4.10.9", "yes");
INSERT INTO `wp_options` VALUES("463", "elementor_log", "a:43:{s:32:\"06d33ee18238e69641570d138c406fed\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-16 06:35:58\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-16 06:35:58\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"1586b8d6179daf05f4dc2b8885e21294\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-16 06:35:58\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.31.4\";s:2:\"to\";s:6:\"3.32.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-16 06:35:58\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.31.4\";s:2:\"to\";s:6:\"3.32.0\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"8d1baf481c7ee5c82a9c6bf61ddd5cbb\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-16 06:35:58\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.31.4\";s:2:\"to\";s:6:\"3.32.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-16 06:35:58\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.31.4\";s:2:\"to\";s:6:\"3.32.0\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"8c4269c1f1dcbf3453c1499652b1d00b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-23 06:36:58\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-23 06:36:58\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"f09cc60c478b7fb19d7068641faa924e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-23 06:36:58\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-23 06:36:58\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"6e882d77c473c22366c639d73c50ed01\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-23 06:36:58\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-23 06:36:58\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"e6c61e1a81e7e2fda2d6a43ebefb1ed3\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-23 06:36:58\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.0\";s:2:\"to\";s:6:\"3.32.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-23 06:36:58\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.0\";s:2:\"to\";s:6:\"3.32.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"de0094997e64ab94c77eb0e9a701ec70\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-23 06:36:58\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.0\";s:2:\"to\";s:6:\"3.32.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-23 06:36:58\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.0\";s:2:\"to\";s:6:\"3.32.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"556b57bdbc0148c31f45fe7b5188e7be\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-30 06:39:41\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-30 06:39:41\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"a1d679556f1355d0af45cebbc4139df2\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-30 06:39:41\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-30 06:39:41\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"7f92ad0bb9e82d0115bf1902ef28ae8c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-30 06:39:41\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-30 06:39:41\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"9e5fa7f0a303c22dcd9a0d9396760561\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-30 06:39:41\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.2\";s:2:\"to\";s:6:\"3.32.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-30 06:39:41\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.2\";s:2:\"to\";s:6:\"3.32.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"33d176db3e0681cc18153dfbcd330c8b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-30 06:39:41\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.2\";s:2:\"to\";s:6:\"3.32.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-30 06:39:41\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.2\";s:2:\"to\";s:6:\"3.32.3\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"6e7397f554a8f69c9e191857087ee3c4\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-07 06:42:46\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-07 06:42:46\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"11c45dce8db1f64e360971418aa48804\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-07 06:42:46\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-07 06:42:46\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"12bbde87f91867f1144b15fe761b70aa\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-07 06:42:46\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-07 06:42:46\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"9b2fdf52c94bfcdf57588bea659a6a3c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-07 06:42:46\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.3\";s:2:\"to\";s:6:\"3.32.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-07 06:42:46\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.3\";s:2:\"to\";s:6:\"3.32.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"6dc95728c14fe9b51655a4211fa920f0\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-07 06:42:46\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.3\";s:2:\"to\";s:6:\"3.32.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-07 06:42:46\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.3\";s:2:\"to\";s:6:\"3.32.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"4927cc08c1a7571c54e481ad32f9a3b3\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-28 06:51:54\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-28 06:51:54\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"fb78c9da7a0ce470fd2fc461f5f0551e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-28 06:51:54\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-28 06:51:54\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"dda078b2ca0828cc2805da75e9c7ce13\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-28 06:51:54\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-28 06:51:54\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"7b19b17edc18dce9602eb9c3d438b7b5\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-28 06:51:54\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.4\";s:2:\"to\";s:6:\"3.32.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-28 06:51:54\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.4\";s:2:\"to\";s:6:\"3.32.5\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"224896cc85cc084d491fb3e2d94b2305\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-28 06:51:54\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.4\";s:2:\"to\";s:6:\"3.32.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-28 06:51:54\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.4\";s:2:\"to\";s:6:\"3.32.5\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"63c24b9488d4f013960e7c21c4f63dc8\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-11 07:05:26\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-11 07:05:26\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"e4a55c68dab6a062b194b0c06da7babb\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-11 07:05:26\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-11 07:05:26\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"fb83bafeac972967e502d996279166ae\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-11 07:05:26\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-11 07:05:26\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"52a9cda996cde6d7757d06dd54ec7e83\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-11 07:05:26\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.5\";s:2:\"to\";s:6:\"3.33.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-11 07:05:26\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.5\";s:2:\"to\";s:6:\"3.33.0\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"2c0f13d748876c80ff2dd55325335026\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-11 07:05:26\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.5\";s:2:\"to\";s:6:\"3.33.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-11 07:05:26\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.5\";s:2:\"to\";s:6:\"3.33.0\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"44f1274a3ff6b5a698e6987f213a64f3\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-18 07:00:54\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-18 07:00:54\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"a7ebf2bcc946eaeccff31bd49de8ea0d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-18 07:00:54\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-18 07:00:54\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"e26d357a965355552de588e8c30375d8\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-18 07:00:54\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-18 07:00:54\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"252e92d410cb661c04387d7ebf52215b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-18 07:00:54\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.0\";s:2:\"to\";s:6:\"3.33.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-18 07:00:54\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.0\";s:2:\"to\";s:6:\"3.33.1\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"b9bdf60510f6f4057568929c09174592\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-18 07:00:54\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.0\";s:2:\"to\";s:6:\"3.33.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-18 07:00:54\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.0\";s:2:\"to\";s:6:\"3.33.1\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"b64a184df7b6adbfae532c093034679e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-25 07:03:34\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-25 07:03:34\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"a5532461c1944ebb43d8d00f682b5895\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-25 07:03:34\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-25 07:03:34\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"870ca7237e53b9615623612d36ce253d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-25 07:03:34\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-25 07:03:34\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"1cd0450778def4989fb99d185a595d1b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-25 07:03:34\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.1\";s:2:\"to\";s:6:\"3.33.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-25 07:03:34\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.1\";s:2:\"to\";s:6:\"3.33.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"a1a525e2feadad86e5edfa25041b0b88\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-25 07:03:34\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.1\";s:2:\"to\";s:6:\"3.33.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-25 07:03:34\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.1\";s:2:\"to\";s:6:\"3.33.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"5d535d4730edb58792d389d93d6b217a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-09 07:06:57\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-09 07:06:57\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"8ca7f0f830e790ff81b57d33798f7caf\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-09 07:06:57\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-09 07:06:57\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"db1cf5fd7b01f79d0209edfb72c4eac0\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-09 07:06:57\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-09 07:06:57\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"cf06b583d516099b2bbd539c0e50a629\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-09 07:06:57\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.2\";s:2:\"to\";s:6:\"3.33.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-09 07:06:57\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.2\";s:2:\"to\";s:6:\"3.33.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"15c1aa7fbecd65a71bcbe9769583294a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-09 07:06:57\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.2\";s:2:\"to\";s:6:\"3.33.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-09 07:06:57\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.2\";s:2:\"to\";s:6:\"3.33.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}}", "off");
INSERT INTO `wp_options` VALUES("464", "elementor_onboarded", "1", "yes");
INSERT INTO `wp_options` VALUES("465", "_elementor_installed_time", "1675298922", "yes");
INSERT INTO `wp_options` VALUES("466", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}", "off");
INSERT INTO `wp_options` VALUES("467", "elementor_remote_info_feed_data", "a:3:{i:0;a:5:{s:5:\"title\";s:76:\"Introducing Elementor 3.32: Transitions, Transform, Size Variables, and More\";s:7:\"excerpt\";s:250:\"Elementor 3.32 is here, accelerating Editor V4 Alpha with transform controls and layered transitions, system-wide Size Variables and streamlined class management. This release empowers you to build more consistent, dynamic, and professional websites.\";s:7:\"created\";i:1759243152;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:138:\"https://elementor.com/blog/elementor-332-v4-transform-transitions/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:67:\"What Is an MCP? The AI Breakthrough Web Creators Shouldn’t Ignore\";s:7:\"excerpt\";s:143:\"Discover how Model Context Protocol (MCP) is shaping AI-tool interaction and redefining how pro web creators build, manage, and scale websites.\";s:7:\"created\";i:1754310811;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:130:\"https://elementor.com/blog/mcp-explained-for-web-creators/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "off");
INSERT INTO `wp_options` VALUES("470", "mc4wp_flash_messages", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("473", "wp_calendar_block_has_published_posts", "1", "yes");
INSERT INTO `wp_options` VALUES("478", "mc4wp_default_form_id", "837", "yes");
INSERT INTO `wp_options` VALUES("480", "nav_menus_created_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("484", "penci_block_category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("493", "elementor_scheme_color", "a:4:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";}", "yes");
INSERT INTO `wp_options` VALUES("494", "elementor_scheme_typography", "a:4:{i:1;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"600\";}i:2;a:2:{s:11:\"font_family\";s:11:\"Roboto Slab\";s:11:\"font_weight\";s:3:\"400\";}i:3;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"400\";}i:4;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"500\";}}", "yes");
INSERT INTO `wp_options` VALUES("495", "elementor_scheme_color-picker", "a:8:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";i:5;s:7:\"#4054b2\";i:6;s:7:\"#23a455\";i:7;s:4:\"#000\";i:8;s:4:\"#fff\";}", "yes");
INSERT INTO `wp_options` VALUES("510", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("579", "_transient_health-check-site-status-result", "{\"good\":17,\"recommended\":5,\"critical\":1}", "yes");
INSERT INTO `wp_options` VALUES("614", "wpforms_email_summaries_fetch_info_blocks_last_run", "1765421811", "yes");
INSERT INTO `wp_options` VALUES("680", "penci_regenerate_version", "1676332946", "yes");
INSERT INTO `wp_options` VALUES("842", "WPLANG", "es_ES", "yes");
INSERT INTO `wp_options` VALUES("843", "new_admin_email", "agorajuridicasl@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("881", "wpforms_challenge", "a:13:{s:6:\"status\";s:7:\"skipped\";s:4:\"step\";i:0;s:7:\"user_id\";i:1;s:7:\"form_id\";i:0;s:10:\"embed_page\";i:0;s:16:\"embed_page_title\";s:0:\"\";s:16:\"started_date_gmt\";s:19:\"2023-02-06 12:08:14\";s:17:\"finished_date_gmt\";s:19:\"2023-02-06 12:08:14\";s:13:\"seconds_spent\";i:0;s:12:\"seconds_left\";i:300;s:13:\"feedback_sent\";b:0;s:19:\"feedback_contact_me\";b:0;s:13:\"window_closed\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("884", "wpforms_builder_opened_date", "1675685326", "no");
INSERT INTO `wp_options` VALUES("886", "wpforms_forms_first_created", "1675685337", "no");
INSERT INTO `wp_options` VALUES("903", "wpforms_license", "a:5:{s:4:\"type\";s:5:\"Elite\";s:3:\"key\";s:10:\"**********\";s:10:\"is_expired\";b:0;s:11:\"is_disabled\";b:0;s:10:\"is_invalid\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("905", "wpforms_versions", "a:12:{s:5:\"1.1.6\";i:0;s:5:\"1.3.3\";i:0;s:5:\"1.4.3\";i:0;s:5:\"1.5.0\";i:0;s:5:\"1.5.9\";i:0;s:5:\"1.6.5\";i:0;s:5:\"1.6.8\";i:0;s:5:\"1.7.3\";i:0;s:5:\"1.7.5\";i:0;s:5:\"1.7.6\";i:0;s:5:\"1.7.8\";i:1675685639;s:7:\"1.7.9.1\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("906", "wpforms_version_upgraded_from", "1.9.7.1", "yes");
INSERT INTO `wp_options` VALUES("928", "wpforms_settings", "a:15:{s:16:\"captcha-provider\";s:9:\"recaptcha\";s:14:\"recaptcha-type\";s:2:\"v2\";s:18:\"recaptcha-site-key\";s:40:\"6Lcn0lgkAAAAANySdgZclc1pTyUKawYDmMBf7wv3\";s:17:\"hcaptcha-site-key\";s:0:\"\";s:20:\"recaptcha-secret-key\";s:40:\"6Lcn0lgkAAAAAOIzlHxRcbvYVtNLybXml8sog14y\";s:19:\"hcaptcha-secret-key\";s:0:\"\";s:18:\"recaptcha-fail-msg\";s:91:\"Ha fallado la verificación de Google reCAPTCHA, por favor, inténtalo de nuevo más tarde.\";s:17:\"hcaptcha-fail-msg\";s:83:\"Ha fallado la verificación de hCaptcha. Por favor, inténtalo de nuevo más tarde.\";s:22:\"recaptcha-v3-threshold\";d:0.4;s:20:\"recaptcha-noconflict\";b:0;s:4:\"gdpr\";b:0;s:17:\"gdpr-disable-uuid\";b:0;s:20:\"gdpr-disable-details\";b:0;s:13:\"modern-markup\";s:1:\"0\";s:20:\"modern-markup-is-set\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("934", "wpforms_crypto_secret_key", "3dpgPOWZALWc+OegrWT+nd1PFxI6C5NbwH6gmxrRfxI=", "yes");
INSERT INTO `wp_options` VALUES("944", "secret_key", "_zh+P.r}G61D-H^01o[{mijc]@rMz{sn@mDYENNkG_Mv{R216LD/|-yjJF]<j(%r", "no");
INSERT INTO `wp_options` VALUES("1845", "_elementor_editor_upgrade_notice_dismissed", "1755713318", "yes");
INSERT INTO `wp_options` VALUES("1897", "wpforms_process_forms_locator_status", "completed", "yes");
INSERT INTO `wp_options` VALUES("1926", "elementor_allow_tracking", "no", "yes");
INSERT INTO `wp_options` VALUES("1927", "elementor_tracker_notice", "1", "yes");
INSERT INTO `wp_options` VALUES("2182", "wp-smush-settings", "a:25:{s:4:\"auto\";b:1;s:5:\"lossy\";b:1;s:10:\"strip_exif\";b:1;s:6:\"resize\";b:0;s:9:\"detection\";b:0;s:8:\"original\";b:0;s:6:\"backup\";b:0;s:8:\"no_scale\";b:0;s:10:\"png_to_jpg\";b:0;s:7:\"nextgen\";b:0;s:2:\"s3\";b:0;s:9:\"gutenberg\";b:0;s:10:\"js_builder\";b:0;s:5:\"gform\";b:0;s:3:\"cdn\";b:0;s:11:\"auto_resize\";b:0;s:4:\"webp\";b:1;s:5:\"usage\";b:0;s:17:\"accessible_colors\";b:0;s:9:\"keep_data\";b:1;s:9:\"lazy_load\";b:0;s:17:\"background_images\";b:1;s:16:\"rest_api_support\";b:0;s:8:\"webp_mod\";b:0;s:16:\"background_email\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("2183", "wp-smush-install-type", "existing", "no");
INSERT INTO `wp_options` VALUES("2184", "wp-smush-version", "3.12.4", "no");
INSERT INTO `wp_options` VALUES("2187", "wdev-frash", "a:3:{s:7:\"plugins\";a:1:{s:23:\"wp-smushit/wp-smush.php\";i:1676308011;}s:5:\"queue\";a:2:{s:32:\"7de3619981caadc55f30a002bfb299f6\";a:4:{s:6:\"plugin\";s:23:\"wp-smushit/wp-smush.php\";s:4:\"type\";s:5:\"email\";s:7:\"show_at\";i:1676308011;s:6:\"sticky\";b:1;}s:32:\"fc50097023d0d34c5a66f6cddcf77694\";a:3:{s:6:\"plugin\";s:23:\"wp-smushit/wp-smush.php\";s:4:\"type\";s:4:\"rate\";s:7:\"show_at\";i:1676912811;}}s:4:\"done\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("2188", "wpmudev_recommended_plugins_registered", "a:1:{s:23:\"wp-smushit/wp-smush.php\";a:1:{s:13:\"registered_at\";i:1676308011;}}", "no");
INSERT INTO `wp_options` VALUES("2190", "smush_global_stats", "a:9:{s:11:\"size_before\";i:24694999;s:10:\"size_after\";i:20475209;s:7:\"percent\";d:17.1;s:5:\"human\";s:6:\"4,0 MB\";s:5:\"bytes\";i:4219790;s:12:\"total_images\";i:403;s:12:\"resize_count\";i:0;s:14:\"resize_savings\";i:0;s:18:\"conversion_savings\";i:0;}", "no");
INSERT INTO `wp_options` VALUES("2191", "wp-smush-preset_configs", "a:1:{i:0;a:5:{s:2:\"id\";i:1;s:4:\"name\";s:18:\"Ajuste por defecto\";s:11:\"description\";s:64:\"Configuración de rendimiento recomendada para todos los sitios.\";s:7:\"default\";b:1;s:6:\"config\";a:2:{s:7:\"configs\";a:1:{s:8:\"settings\";a:22:{s:4:\"auto\";b:1;s:5:\"lossy\";b:1;s:10:\"strip_exif\";b:1;s:6:\"resize\";b:0;s:9:\"detection\";b:0;s:8:\"original\";b:1;s:6:\"backup\";b:1;s:10:\"png_to_jpg\";b:1;s:7:\"nextgen\";b:0;s:2:\"s3\";b:0;s:9:\"gutenberg\";b:0;s:10:\"js_builder\";b:0;s:3:\"cdn\";b:0;s:11:\"auto_resize\";b:0;s:4:\"webp\";b:1;s:5:\"usage\";b:0;s:17:\"accessible_colors\";b:0;s:9:\"keep_data\";b:1;s:9:\"lazy_load\";b:0;s:17:\"background_images\";b:1;s:16:\"rest_api_support\";b:0;s:8:\"webp_mod\";b:0;}}s:7:\"strings\";a:6:{s:10:\"bulk_smush\";a:1:{i:0;s:237:\"Compresión automática - Activa\nSuper-reducir - Activa\nMetadatos - Activa\nRedimensionado de imagen - Inactivo\nImágenes originales - Inactivo\nCopia de seguridad de las imágenes originales - Inactivo\nConversión de PNG a JPEG - Inactivo\";}s:9:\"lazy_load\";a:1:{i:0;s:8:\"Inactivo\";}s:3:\"cdn\";a:1:{i:0;s:8:\"Inactivo\";}s:8:\"webp_mod\";a:1:{i:0;s:8:\"Inactivo\";}s:12:\"integrations\";a:1:{i:0;s:120:\"Compatibilidad con Gutenberg - Inactivo\nWPBakery Page Builder - Inactivo\nAmazon S3 - Inactivo\nNextGen Gallery - Inactivo\";}s:8:\"settings\";a:1:{i:0;s:155:\"Detección de cambio de tamaño de imagen - Inactivo\nAccesibilidad de color - Inactivo\nSeguimiento de uso - Inactivo\nMantener datos al desinstalar - Activa\";}}}}}", "no");
INSERT INTO `wp_options` VALUES("2192", "skip-smush-setup", "1", "yes");
INSERT INTO `wp_options` VALUES("2193", "dir_smush_stats", "a:2:{s:9:\"dir_smush\";a:2:{s:5:\"total\";i:0;s:9:\"optimised\";i:0;}s:14:\"combined_stats\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("2202", "wp_smush_bulk_smush_background_process_status", "a:6:{s:13:\"in_processing\";b:0;s:12:\"is_cancelled\";b:0;s:12:\"is_completed\";b:1;s:11:\"total_items\";i:37;s:15:\"processed_items\";i:37;s:12:\"failed_items\";i:0;}", "no");
INSERT INTO `wp_options` VALUES("2329", "wp-smush-lazy_load", "a:9:{s:6:\"format\";a:6:{s:4:\"jpeg\";b:1;s:3:\"png\";b:1;s:4:\"webp\";b:1;s:3:\"gif\";b:1;s:3:\"svg\";b:1;s:6:\"iframe\";b:1;}s:6:\"output\";a:4:{s:7:\"content\";b:1;s:7:\"widgets\";b:1;s:10:\"thumbnails\";b:1;s:9:\"gravatars\";b:1;}s:9:\"animation\";a:4:{s:8:\"selected\";s:6:\"fadein\";s:6:\"fadein\";a:2:{s:8:\"duration\";i:400;s:5:\"delay\";i:0;}s:7:\"spinner\";a:2:{s:8:\"selected\";i:1;s:6:\"custom\";a:0:{}}s:11:\"placeholder\";a:3:{s:8:\"selected\";i:1;s:6:\"custom\";a:0:{}s:5:\"color\";s:7:\"#F3F3F3\";}}s:7:\"include\";a:7:{s:9:\"frontpage\";b:1;s:4:\"home\";b:1;s:4:\"page\";b:1;s:6:\"single\";b:1;s:7:\"archive\";b:1;s:8:\"category\";b:1;s:3:\"tag\";b:1;}s:13:\"exclude-pages\";a:0:{}s:15:\"exclude-classes\";a:0:{}s:6:\"footer\";b:1;s:6:\"native\";b:0;s:8:\"noscript\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("2786", "litespeed.admin_display.msg_pin", "[\"<div class=\\\"litespeed_icon notice notice-error litespeed-irremovable\\\"><p><div id=\\\"lscwp-incompatible-plugin-notice\\\">Debido a que puede haber conflictos con LiteSpeed Cache, por favor, considera desactivar los siguientes plugins:<p style=\\\"color: red; font-weight: 700;\\\">WP Rocket<\\/p><\\/div><\\/p><\\/div>\"]", "yes");
INSERT INTO `wp_options` VALUES("3089", "wpforms_send_usage_last_run", "1677045882", "yes");
INSERT INTO `wp_options` VALUES("3726", "hostinger_first_login_at", "2023-02-22 20:06:40", "yes");
INSERT INTO `wp_options` VALUES("3764", "theme_mods_onepress", "a:89:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:35;}s:26:\"penci_speed_delay_css_type\";s:6:\"onload\";s:18:\"custom_css_post_id\";i:-1;s:15:\"onepress_layout\";s:10:\"no-sidebar\";s:21:\"onepress_header_width\";s:9:\"contained\";s:25:\"onepress_transparent_logo\";s:85:\"https://procuradorgalicia.es/wp-content/uploads/2023/02/LogoProcuradorGaliciaLogo.png\";s:11:\"custom_logo\";i:1434;s:23:\"onepress_hide_sitetitle\";i:1;s:20:\"onepress_logo_height\";s:2:\"50\";s:20:\"onepress_btt_disable\";i:1;s:30:\"onepress_sticky_header_disable\";i:0;s:28:\"onepress_vertical_align_menu\";i:0;s:27:\"onepress_header_transparent\";i:0;s:36:\"onepress_sections_nav___enable_label\";s:1:\"1\";s:22:\"penci_recipe_btn_color\";s:0:\"\";s:20:\"onepress_contact_cf7\";s:33:\"[wpforms id=\"1432\" title=\"false\"]\";s:21:\"onepress_contact_text\";s:231:\"No dudes en compartir con nosotros todas tus preocupaciones y consultas. Estaremos encantados de ponernos en contacto contigo a la mayor brevedad posible para brindarte una respuesta clara y efectiva. ¡Estamos aquí para ayudarte!\";s:30:\"onepress_contact_address_title\";s:24:\"Información de contacto\";s:24:\"onepress_contact_address\";s:144:\"Dirección Santiago c/ Monte dos Postes, 4-bajo 3 15703 Santiago de Compostela (Coruña)  Dirección Vigo c/ Zaragoza,34 36203 VIGO (Pontevedra)\";s:22:\"onepress_contact_phone\";s:47:\"Teléfono: 986 06 94 62  / Móvil: 698 16 50 96\";s:22:\"onepress_contact_email\";s:30:\"procuradorgalicia.es@gmail.com\";s:20:\"onepress_contact_fax\";s:0:\"\";s:23:\"onepress_social_disable\";i:1;s:23:\"onepress_social_twitter\";s:1:\"#\";s:24:\"onepress_social_facebook\";s:1:\"#\";s:22:\"onepress_social_google\";s:1:\"#\";s:25:\"onepress_social_instagram\";s:1:\"#\";s:27:\"onepress_newsletter_disable\";i:1;s:29:\"onepress_newsletter_mailchimp\";s:94:\"//famethemes.us8.list-manage.com/subscribe/post?u=521c400d049a59a4b9c0550c2&#038;id=83187e0006\";s:21:\"onepress_team_members\";a:4:{i:0;a:2:{s:7:\"user_id\";a:2:{s:3:\"url\";s:83:\"https://demos.famethemes.com/onepress/wp-content/uploads/sites/17/2016/02/team5.jpg\";s:2:\"id\";i:11;}s:4:\"link\";s:0:\"\";}i:1;a:2:{s:7:\"user_id\";a:2:{s:3:\"url\";s:83:\"https://demos.famethemes.com/onepress/wp-content/uploads/sites/17/2016/02/team3.jpg\";s:2:\"id\";i:9;}s:4:\"link\";s:0:\"\";}i:2;a:2:{s:7:\"user_id\";a:2:{s:3:\"url\";s:83:\"https://demos.famethemes.com/onepress/wp-content/uploads/sites/17/2016/02/team2.jpg\";s:2:\"id\";i:8;}s:4:\"link\";s:0:\"\";}i:3;a:2:{s:7:\"user_id\";a:2:{s:3:\"url\";s:83:\"https://demos.famethemes.com/onepress/wp-content/uploads/sites/17/2016/02/team6.jpg\";s:2:\"id\";i:12;}s:4:\"link\";s:0:\"\";}}s:20:\"onepress_hero_images\";a:1:{i:0;a:1:{s:5:\"image\";a:2:{s:3:\"url\";s:87:\"https://procuradorgalicia.es/wp-content/uploads/2023/02/Portada_ProcuradorGalicia-2.png\";s:2:\"id\";i:803;}}}s:27:\"onepress_hero_overlay_color\";s:15:\"rgba(0,0,0,0.3)\";s:24:\"onepress_site_image_logo\";s:64:\"https://procuradorgalicia.es/wp-content/uploads/2023/02/logo.png\";s:20:\"onepress_about_boxes\";a:3:{i:0;a:3:{s:12:\"content_page\";s:4:\"1437\";s:10:\"hide_title\";s:0:\"\";s:11:\"enable_link\";s:0:\"\";}i:1;a:3:{s:12:\"content_page\";s:4:\"1441\";s:10:\"hide_title\";s:0:\"\";s:11:\"enable_link\";s:0:\"\";}i:2;a:3:{s:12:\"content_page\";s:4:\"1453\";s:10:\"hide_title\";s:0:\"\";s:11:\"enable_link\";s:0:\"\";}}s:17:\"onepress_services\";a:2:{i:0;a:5:{s:9:\"icon_type\";s:4:\"icon\";s:4:\"icon\";s:13:\"balance-scale\";s:5:\"image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:12:\"content_page\";s:4:\"1465\";s:11:\"enable_link\";s:0:\"\";}i:1;a:5:{s:9:\"icon_type\";s:4:\"icon\";s:4:\"icon\";s:17:\"fa fa-newspaper-o\";s:5:\"image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:12:\"content_page\";s:4:\"1467\";s:11:\"enable_link\";s:0:\"\";}}s:23:\"onepress_news_more_link\";s:42:\"https://demos.famethemes.com/onepress/news\";s:28:\"onepress_videolightbox_title\";s:44:\"Parallax Effect - <strong>Perfected</strong>\";s:26:\"onepress_videolightbox_url\";s:43:\"https://www.youtube.com/watch?v=yUCFRL43Zm4\";s:28:\"onepress_videolightbox_image\";i:36;s:22:\"onepress_counter_title\";s:0:\"\";s:25:\"onepress_counter_subtitle\";s:32:\"Some Fun Facts about our agency?\";s:22:\"onepress_counter_boxes\";a:4:{i:0;a:4:{s:5:\"title\";s:18:\"Projects completed\";s:6:\"number\";s:3:\"368\";s:11:\"unit_before\";s:0:\"\";s:10:\"unit_after\";s:0:\"\";}i:1;a:4:{s:5:\"title\";s:17:\"Positive feedback\";s:6:\"number\";s:2:\"99\";s:11:\"unit_before\";s:0:\"\";s:10:\"unit_after\";s:1:\"%\";}i:2;a:4:{s:5:\"title\";s:14:\"Pizzas ordered\";s:6:\"number\";s:3:\"254\";s:11:\"unit_before\";s:0:\"\";s:10:\"unit_after\";s:0:\"\";}i:3;a:4:{s:5:\"title\";s:21:\"Average cost per hour\";s:6:\"number\";s:2:\"32\";s:11:\"unit_before\";s:1:\"$\";s:10:\"unit_after\";s:0:\"\";}}s:24:\"onepress_hero_fullscreen\";i:0;s:29:\"onepress_hero_overlay_opacity\";s:3:\"0.6\";s:19:\"onepress_about_desc\";s:501:\"<font size=\"3\">Nos esforzamos por brindar una representación técnica procesal de alta calidad ante todos los juzgados y tribunales de Galicia y en\ncualquier partido judicial de la Comunidad de Galicia. Para lograrlo, contamos con un equipo de Procuradores altamente capacitados y\nexperimentados, y trabajamos en colaboración con otros Procuradores de la región. Juntos, nos aseguramos de que nuestros clientes\nreciban la mejor defensa posible en cualquier caso o asunto legal que presenten.</font>\";s:23:\"onepress_features_boxes\";a:4:{i:0;a:6:{s:5:\"title\";s:17:\"Responsive Design\";s:9:\"icon_type\";s:4:\"icon\";s:4:\"icon\";s:9:\"fa-laptop\";s:5:\"image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:4:\"desc\";s:71:\"The theme is responsive, your website will look great on touch devices.\";s:4:\"link\";s:0:\"\";}i:1;a:6:{s:5:\"title\";s:15:\"Parallax Effect\";s:9:\"icon_type\";s:4:\"icon\";s:4:\"icon\";s:5:\"photo\";s:5:\"image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:4:\"desc\";s:72:\"Create memorable pages with smooth parallax effects that everyone loves.\";s:4:\"link\";s:0:\"\";}i:2;a:6:{s:5:\"title\";s:11:\"WooCommerce\";s:9:\"icon_type\";s:4:\"icon\";s:4:\"icon\";s:18:\"fa-cart-arrow-down\";s:5:\"image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:4:\"desc\";s:57:\"Build a front page for your WooCommerce store in minutes.\";s:4:\"link\";s:0:\"\";}i:3;a:6:{s:5:\"title\";s:14:\"Content Blocks\";s:9:\"icon_type\";s:4:\"icon\";s:4:\"icon\";s:7:\"reorder\";s:5:\"image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:4:\"desc\";s:75:\"Change the sections contents, display each block exactly where you need it.\";s:4:\"link\";s:0:\"\";}}s:21:\"onepress_hide_tagline\";i:1;s:24:\"onepress_gallery_disable\";i:1;s:21:\"onepress_gallery_desc\";s:90:\"NEW: Gallery section support advanced layouts: Grid, Slider, Carousel, Masonry, Justified.\";s:28:\"onepress_gallery_source_page\";s:4:\"1245\";s:23:\"onepress_gallery_layout\";s:10:\"full-width\";s:24:\"onepress_gallery_display\";s:7:\"masonry\";s:18:\"onepress_g_spacing\";s:1:\"2\";s:14:\"onepress_g_col\";s:1:\"5\";s:22:\"onepress_hero_parallax\";i:0;s:30:\"onepress_sections_nav___enable\";s:1:\"1\";s:26:\"onepress_sections_nav_hero\";i:1;s:34:\"onepress_sections_nav_hero_inverse\";i:1;s:30:\"onepress_sections_nav_features\";i:1;s:27:\"onepress_sections_nav_about\";i:1;s:30:\"onepress_sections_nav_services\";i:1;s:35:\"onepress_sections_nav_videolightbox\";i:1;s:43:\"onepress_sections_nav_videolightbox_inverse\";i:1;s:29:\"onepress_sections_nav_gallery\";i:1;s:29:\"onepress_sections_nav_counter\";i:0;s:26:\"onepress_sections_nav_team\";i:1;s:26:\"onepress_sections_nav_news\";i:1;s:29:\"onepress_sections_nav_contact\";i:1;s:29:\"onepress_sections_nav___color\";s:0:\"\";s:20:\"onepress_hero_layout\";s:1:\"1\";s:23:\"onepress_hcl1_largetext\";s:113:\"<span style=\"vertical-align: inherit\"><span style=\"vertical-align: inherit\">PROCURADORES EN GALICIA</span></span>\";s:23:\"onepress_hcl1_smalltext\";s:193:\"desde el año 2010\nA Coruña Pontevedra Ourense Lugo\nPresupuestos inmediatos (con arreglo al nuevo Real Decreto 307/2021)\n<strong>Trabajamos en todos los partidos judiciales de Galicia</strong>\";s:23:\"onepress_about_subtitle\";s:18:\"Desde el año 2010\";s:25:\"onepress_features_disable\";i:1;s:26:\"onepress_services_subtitle\";s:64:\"Ofrecemos gran cantidad de servicios adaptados a tus necesidades\";s:31:\"onepress_service_content_source\";s:7:\"content\";s:30:\"onepress_videolightbox_disable\";i:1;s:21:\"onepress_team_disable\";i:1;s:21:\"onepress_news_disable\";i:1;s:25:\"onepress_contact_subtitle\";s:0:\"\";s:24:\"onepress_counter_disable\";i:1;s:23:\"onepress_hcl1_btn2_text\";s:8:\"Contacto\";s:17:\"onepress_about_id\";s:6:\"acerca\";s:19:\"onepress_contact_id\";s:7:\"contact\";s:23:\"onepress_hcl1_btn1_link\";s:36:\"https://procuradorgalicia.es/#servic\";s:23:\"onepress_hcl1_btn2_link\";s:37:\"https://procuradorgalicia.es/#contact\";s:25:\"onepress_services_disable\";i:0;s:20:\"onepress_services_id\";s:6:\"servic\";}", "yes");
INSERT INTO `wp_options` VALUES("3802", "theme_mods_astra", "a:5:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:10;}s:26:\"penci_speed_delay_css_type\";s:6:\"onload\";s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1677097523;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:9:\"sidebar-1\";a:6:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:8:\"search-1\";i:4;s:19:\"mc4wp_form_widget-1\";i:5;s:12:\"categories-1\";}s:13:\"header-widget\";a:0:{}s:15:\"footer-widget-1\";a:1:{i:0;s:6:\"text-1\";}s:15:\"footer-widget-2\";a:1:{i:0;s:10:\"nav_menu-1\";}s:24:\"advanced-footer-widget-1\";a:1:{i:0;s:10:\"nav_menu-2\";}s:24:\"advanced-footer-widget-2\";a:1:{i:0;s:6:\"text-2\";}s:24:\"advanced-footer-widget-3\";a:0:{}s:24:\"advanced-footer-widget-4\";a:0:{}}}}", "off");
INSERT INTO `wp_options` VALUES("3804", "astra-settings", "a:2:{s:18:\"theme-auto-version\";s:5:\"4.0.2\";s:22:\"is_theme_queue_running\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("3809", "astra_docs_data", "O:8:\"stdClass\":2:{s:10:\"categories\";O:8:\"stdClass\":10:{s:24:\"installation-and-updates\";O:8:\"stdClass\":2:{s:4:\"name\";s:24:\"Installation and Updates\";s:13:\"subcategories\";a:0:{}}s:28:\"astra-theme-walkthrough-docs\";O:8:\"stdClass\":2:{s:4:\"name\";s:23:\"Astra Theme Walkthrough\";s:13:\"subcategories\";a:0:{}}s:25:\"astra-customizer-settings\";O:8:\"stdClass\":2:{s:4:\"name\";s:19:\"Customizer Settings\";s:13:\"subcategories\";O:8:\"stdClass\":10:{s:17:\"header-and-footer\";O:8:\"stdClass\":2:{s:4:\"name\";s:19:\"Header &amp; Footer\";s:13:\"subcategories\";O:8:\"stdClass\":2:{s:24:\"header-footer-before-3-0\";O:8:\"stdClass\":2:{s:4:\"name\";s:43:\"Old Header &amp; Footer (Before Astra v3.0)\";s:13:\"subcategories\";a:0:{}}s:23:\"header-footer-after-3-0\";O:8:\"stdClass\":2:{s:4:\"name\";s:41:\"Header &amp; Footer Builder (Astra v3.0+)\";s:13:\"subcategories\";a:0:{}}}}s:6:\"global\";O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Global\";s:13:\"subcategories\";a:0:{}}s:10:\"breadcrumb\";O:8:\"stdClass\":2:{s:4:\"name\";s:10:\"Breadcrumb\";s:13:\"subcategories\";a:0:{}}s:4:\"blog\";O:8:\"stdClass\":2:{s:4:\"name\";s:4:\"Blog\";s:13:\"subcategories\";a:0:{}}s:7:\"sidebar\";O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Sidebar\";s:13:\"subcategories\";a:0:{}}s:9:\"learndash\";O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"LearnDash\";s:13:\"subcategories\";a:0:{}}s:22:\"easy-digital-downloads\";O:8:\"stdClass\":2:{s:4:\"name\";s:22:\"Easy Digital Downloads\";s:13:\"subcategories\";a:0:{}}s:9:\"lifterlms\";O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"LifterLMS\";s:13:\"subcategories\";a:0:{}}s:16:\"woocommerce-free\";O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"WooCommerce\";s:13:\"subcategories\";a:0:{}}s:13:\"meta-settings\";O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"Meta Settings\";s:13:\"subcategories\";a:0:{}}}}s:17:\"astra-pro-modules\";O:8:\"stdClass\":2:{s:4:\"name\";s:17:\"Astra Pro Modules\";s:13:\"subcategories\";O:8:\"stdClass\":18:{s:11:\"white-label\";O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"White Label\";s:13:\"subcategories\";a:0:{}}s:13:\"mobile-header\";O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"Mobile Header\";s:13:\"subcategories\";a:0:{}}s:8:\"nav-menu\";O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Nav Menu\";s:13:\"subcategories\";a:0:{}}s:14:\"typography-pro\";O:8:\"stdClass\":2:{s:4:\"name\";s:10:\"Typography\";s:13:\"subcategories\";a:0:{}}s:21:\"colors-background-pro\";O:8:\"stdClass\":2:{s:4:\"name\";s:23:\"Colors &amp; Background\";s:13:\"subcategories\";a:0:{}}s:21:\"custom-layouts-module\";O:8:\"stdClass\":2:{s:4:\"name\";s:21:\"Custom Layouts Module\";s:13:\"subcategories\";a:0:{}}s:11:\"site-layout\";O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"Site Layout\";s:13:\"subcategories\";a:0:{}}s:15:\"header-sections\";O:8:\"stdClass\":2:{s:4:\"name\";s:15:\"Header Sections\";s:13:\"subcategories\";a:0:{}}s:13:\"sticky-header\";O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"Sticky Header\";s:13:\"subcategories\";a:0:{}}s:12:\"page-headers\";O:8:\"stdClass\":2:{s:4:\"name\";s:12:\"Page Headers\";s:13:\"subcategories\";a:0:{}}s:8:\"blog-pro\";O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Blog Pro\";s:13:\"subcategories\";a:0:{}}s:21:\"footer-widgets-module\";O:8:\"stdClass\":2:{s:4:\"name\";s:21:\"Footer Widgets Module\";s:13:\"subcategories\";a:0:{}}s:7:\"spacing\";O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Spacing\";s:13:\"subcategories\";a:0:{}}s:3:\"woo\";O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"WooCommerce\";s:13:\"subcategories\";a:0:{}}s:27:\"learndash-astra-pro-modules\";O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"LearnDash\";s:13:\"subcategories\";a:0:{}}s:19:\"lifterlms-astra-pro\";O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"LifterLMS\";s:13:\"subcategories\";a:0:{}}s:29:\"easy-digital-downloads-module\";O:8:\"stdClass\":2:{s:4:\"name\";s:29:\"Easy Digital Downloads Module\";s:13:\"subcategories\";a:0:{}}s:18:\"native-amp-support\";O:8:\"stdClass\":2:{s:4:\"name\";s:18:\"Native AMP Support\";s:13:\"subcategories\";a:0:{}}}}s:17:\"starter-templates\";O:8:\"stdClass\":2:{s:4:\"name\";s:17:\"Starter Templates\";s:13:\"subcategories\";a:0:{}}s:15:\"translate-astra\";O:8:\"stdClass\":2:{s:4:\"name\";s:15:\"Translate Astra\";s:13:\"subcategories\";a:0:{}}s:7:\"general\";O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"General\";s:13:\"subcategories\";a:0:{}}s:17:\"account-and-store\";O:8:\"stdClass\":2:{s:4:\"name\";s:17:\"Account and Store\";s:13:\"subcategories\";a:0:{}}s:20:\"custom-code-snippets\";O:8:\"stdClass\":2:{s:4:\"name\";s:20:\"Custom Code Snippets\";s:13:\"subcategories\";O:8:\"stdClass\":5:{s:23:\"astra-theme-pro-filters\";O:8:\"stdClass\":2:{s:4:\"name\";s:29:\"Astra Theme &amp; Pro Filters\";s:13:\"subcategories\";a:0:{}}s:27:\"astra-header-footer-filters\";O:8:\"stdClass\":2:{s:4:\"name\";s:33:\"Astra Header &amp; Footer Filters\";s:13:\"subcategories\";a:0:{}}s:12:\"blog-filters\";O:8:\"stdClass\":2:{s:4:\"name\";s:12:\"Blog Filters\";s:13:\"subcategories\";a:0:{}}s:19:\"woocommerce-filters\";O:8:\"stdClass\":2:{s:4:\"name\";s:19:\"WooCommerce Filters\";s:13:\"subcategories\";a:0:{}}s:10:\"custom-css\";O:8:\"stdClass\":2:{s:4:\"name\";s:10:\"Custom CSS\";s:13:\"subcategories\";a:0:{}}}}s:15:\"troubleshooting\";O:8:\"stdClass\":2:{s:4:\"name\";s:15:\"Troubleshooting\";s:13:\"subcategories\";a:0:{}}}s:4:\"docs\";a:453:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:27:\"Astra 4.0.0 Nav Menu Module\";s:3:\"url\";s:41:\"https://wpastra.com/docs/nav-menu-module/\";s:8:\"category\";a:1:{i:0;s:8:\"nav-menu\";}}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:58:\"We are facing a temporary issue in importing this template\";s:3:\"url\";s:84:\"https://wpastra.com/docs/we-are-facing-a-temporary-issue-in-importing-this-template/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"How to use dynamic customizer from Astra 4.0.0\";s:3:\"url\";s:70:\"https://wpastra.com/docs/how-to-use-dynamic-customizer-from-astra-4-0/\";s:8:\"category\";a:1:{i:0;s:25:\"astra-customizer-settings\";}}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:63:\"Changing the Post Title&#8217;s Tag of the Related Post Section\";s:3:\"url\";s:82:\"https://wpastra.com/docs/changing-the-post-titles-tag-of-the-related-post-section/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:4;O:8:\"stdClass\":3:{s:5:\"title\";s:37:\"Narrow Width &#8211; Container Layout\";s:3:\"url\";s:55:\"https://wpastra.com/docs/narrow-width-container-layout/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:5;O:8:\"stdClass\":3:{s:5:\"title\";s:67:\"Quick admin bar navigation to edit custom layout &#038; page header\";s:3:\"url\";s:86:\"https://wpastra.com/docs/quick-admin-bar-navigation-to-edit-custom-layout-page-header/\";s:8:\"category\";a:1:{i:0;s:21:\"custom-layouts-module\";}}i:6;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"Mega Menu Support for all Builder Menus\";s:3:\"url\";s:65:\"https://wpastra.com/docs/mega-menu-support-for-all-builder-menus/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:7;O:8:\"stdClass\":3:{s:5:\"title\";s:30:\"Improved Spectra Compatibility\";s:3:\"url\";s:56:\"https://wpastra.com/docs/improved-spectra-compatibility/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:8;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"How to add a custom cart button in WordPress\";s:3:\"url\";s:70:\"https://wpastra.com/docs/how-to-add-a-custom-cart-button-in-wordpress/\";s:8:\"category\";a:0:{}}i:9;O:8:\"stdClass\":3:{s:5:\"title\";s:34:\"Show Password eye icon not visible\";s:3:\"url\";s:60:\"https://wpastra.com/docs/show-password-eye-icon-not-visible/\";s:8:\"category\";a:1:{i:0;s:19:\"woocommerce-filters\";}}i:10;O:8:\"stdClass\":3:{s:5:\"title\";s:64:\"Revert support for Single Product&#8217;s legacy Gallery layouts\";s:3:\"url\";s:83:\"https://wpastra.com/docs/revert-support-for-single-products-legacy-gallery-layouts/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:11;O:8:\"stdClass\":3:{s:5:\"title\";s:38:\"Revert support for old Astra cart icon\";s:3:\"url\";s:64:\"https://wpastra.com/docs/revert-support-for-old-astra-cart-icon/\";s:8:\"category\";a:1:{i:0;s:19:\"woocommerce-filters\";}}i:12;O:8:\"stdClass\":3:{s:5:\"title\";s:45:\"How to Manage WooCommerce Product Image Width\";s:3:\"url\";s:71:\"https://wpastra.com/docs/how-to-manage-woocommerce-product-image-width/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:13;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"How to enable Product Quantity (Plus-Minus)?\";s:3:\"url\";s:67:\"https://wpastra.com/docs/how-to-enable-product-quantity-plus-minus/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:14;O:8:\"stdClass\":3:{s:5:\"title\";s:30:\"Sticky Header Background Color\";s:3:\"url\";s:56:\"https://wpastra.com/docs/sticky-header-background-color/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:15;O:8:\"stdClass\":3:{s:5:\"title\";s:58:\"How to remove Author&#8217;s name from a Single Blog Post?\";s:3:\"url\";s:76:\"https://wpastra.com/docs/how-to-remove-authors-name-from-a-single-blog-post/\";s:8:\"category\";a:1:{i:0;s:4:\"blog\";}}i:16;O:8:\"stdClass\":3:{s:5:\"title\";s:37:\"How to Highlight the active menu item\";s:3:\"url\";s:63:\"https://wpastra.com/docs/how-to-highlight-the-active-menu-item/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:17;O:8:\"stdClass\":3:{s:5:\"title\";s:52:\"How to Change &#8220;Add to Cart&#8221; button text?\";s:3:\"url\";s:63:\"https://wpastra.com/docs/how-to-change-add-to-cart-button-text/\";s:8:\"category\";a:1:{i:0;s:15:\"translate-astra\";}}i:18;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"How to change site background color in Astra\";s:3:\"url\";s:70:\"https://wpastra.com/docs/how-to-change-site-background-color-in-astra/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:19;O:8:\"stdClass\":3:{s:5:\"title\";s:36:\"Fix Mobile Usability Issues on Astra\";s:3:\"url\";s:62:\"https://wpastra.com/docs/fix-mobile-usability-issues-on-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:20;O:8:\"stdClass\":3:{s:5:\"title\";s:84:\"How to remove horizontal &#038; vertical gallery layouts from a single product page?\";s:3:\"url\";s:102:\"https://wpastra.com/docs/how-to-remove-horizontal-vertical-gallery-layouts-from-a-single-product-page/\";s:8:\"category\";a:1:{i:0;s:20:\"custom-code-snippets\";}}i:21;O:8:\"stdClass\":3:{s:5:\"title\";s:64:\"Transparent Header Menu Color not working with Mobile Breakpoint\";s:3:\"url\";s:90:\"https://wpastra.com/docs/transparent-header-menu-color-not-working-with-mobile-breakpoint/\";s:8:\"category\";a:1:{i:0;s:10:\"custom-css\";}}i:22;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"cURL error 60: unable to install Astra Pro plugin\";s:3:\"url\";s:74:\"https://wpastra.com/docs/curl-error-60-unable-to-install-astra-pro-plugin/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:23;O:8:\"stdClass\":3:{s:5:\"title\";s:60:\"WP_Error-cURL error 7: Failed to connect to websitedemos.net\";s:3:\"url\";s:85:\"https://wpastra.com/docs/wp_error-curl-error-7-failed-to-connect-to-websitedemos-net/\";s:8:\"category\";a:2:{i:0;s:15:\"troubleshooting\";i:1;s:17:\"starter-templates\";}}i:24;O:8:\"stdClass\":3:{s:5:\"title\";s:66:\"How to create a multisite network and use Astra child theme on it.\";s:3:\"url\";s:83:\"https://wpastra.com/docs/how-to-create-a-multisite-network-using-astra-child-theme/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:25;O:8:\"stdClass\":3:{s:5:\"title\";s:61:\"How to ensure text remains visible during web font load Astra\";s:3:\"url\";s:87:\"https://wpastra.com/docs/how-to-ensure-text-remains-visible-during-web-font-load-astra/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:26;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"How to create a sticky sidebar in Astra\";s:3:\"url\";s:65:\"https://wpastra.com/docs/how-to-create-a-sticky-sidebar-in-astra/\";s:8:\"category\";a:1:{i:0;s:25:\"astra-customizer-settings\";}}i:27;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"Change Color of Sale Badge &#8211; WooCommerce\";s:3:\"url\";s:64:\"https://wpastra.com/docs/change-color-of-sale-badge-woocommerce/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:28;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"How to design Footer Background in Astra\";s:3:\"url\";s:57:\"https://wpastra.com/docs/how-to-design-footer-background/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:29;O:8:\"stdClass\":3:{s:5:\"title\";s:28:\"How to disable logo cropping\";s:3:\"url\";s:54:\"https://wpastra.com/docs/how-to-disable-logo-cropping/\";s:8:\"category\";a:1:{i:0;s:25:\"astra-customizer-settings\";}}i:30;O:8:\"stdClass\":3:{s:5:\"title\";s:24:\"Misc &#8211; WooCommerce\";s:3:\"url\";s:42:\"https://wpastra.com/docs/misc-woocommerce/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:31;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"How To add Custom CSS for Specific Pages\";s:3:\"url\";s:66:\"https://wpastra.com/docs/how-to-add-custom-css-for-specific-pages/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:32;O:8:\"stdClass\":3:{s:5:\"title\";s:27:\"How to create a Mobile Menu\";s:3:\"url\";s:53:\"https://wpastra.com/docs/how-to-create-a-mobile-menu/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:33;O:8:\"stdClass\":3:{s:5:\"title\";s:66:\"Uploaded file exceeds the upload_max_filesize directive in php.ini\";s:3:\"url\";s:92:\"https://wpastra.com/docs/uploaded-file-exceeds-the-upload_max_filesize-directive-in-php-ini/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:34;O:8:\"stdClass\":3:{s:5:\"title\";s:47:\"What are the Best Astra Settings for Elementor?\";s:3:\"url\";s:72:\"https://wpastra.com/docs/what-are-the-best-astra-settings-for-elementor/\";s:8:\"category\";a:1:{i:0;s:13:\"meta-settings\";}}i:35;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"Astra theme string translation for WooCommerce\";s:3:\"url\";s:72:\"https://wpastra.com/docs/astra-theme-string-translation-for-woocommerce/\";s:8:\"category\";a:1:{i:0;s:15:\"translate-astra\";}}i:36;O:8:\"stdClass\":3:{s:5:\"title\";s:73:\"How To Fix Not Being Able To Edit Submenu Colors, Above and Below Header?\";s:3:\"url\";s:97:\"https://wpastra.com/docs/how-to-fix-not-being-able-to-edit-submenu-colors-above-and-below-header/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:37;O:8:\"stdClass\":3:{s:5:\"title\";s:48:\"How to Import / Export Astra Customizer Settings\";s:3:\"url\";s:72:\"https://wpastra.com/docs/how-to-import-export-astra-customizer-settings/\";s:8:\"category\";a:1:{i:0;s:25:\"astra-customizer-settings\";}}i:38;O:8:\"stdClass\":3:{s:5:\"title\";s:45:\"How to disable cart fragments on WooCommerce?\";s:3:\"url\";s:70:\"https://wpastra.com/docs/how-to-disable-cart-fragments-on-woocommerce/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:39;O:8:\"stdClass\":3:{s:5:\"title\";s:51:\"How to add custom CSS and JavaScript to Astra theme\";s:3:\"url\";s:77:\"https://wpastra.com/docs/how-to-add-custom-css-and-javascript-to-astra-theme/\";s:8:\"category\";a:1:{i:0;s:10:\"custom-css\";}}i:40;O:8:\"stdClass\":3:{s:5:\"title\";s:48:\"How to add custom post type with the Astra theme\";s:3:\"url\";s:74:\"https://wpastra.com/docs/how-to-add-custom-post-type-with-the-astra-theme/\";s:8:\"category\";a:1:{i:0;s:8:\"blog-pro\";}}i:41;O:8:\"stdClass\":3:{s:5:\"title\";s:43:\"How to change the menu color in Astra theme\";s:3:\"url\";s:69:\"https://wpastra.com/docs/how-to-change-the-menu-color-in-astra-theme/\";s:8:\"category\";a:1:{i:0;s:21:\"colors-background-pro\";}}i:42;O:8:\"stdClass\":3:{s:5:\"title\";s:47:\"How to use the color palette of the Astra theme\";s:3:\"url\";s:73:\"https://wpastra.com/docs/how-to-use-the-color-palette-of-the-astra-theme/\";s:8:\"category\";a:2:{i:0;s:25:\"astra-customizer-settings\";i:1;s:6:\"global\";}}i:43;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"How to create a correct format svg logo?\";s:3:\"url\";s:65:\"https://wpastra.com/docs/how-to-create-a-correct-format-svg-logo/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:44;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"How to translate the WooCommerce string?\";s:3:\"url\";s:65:\"https://wpastra.com/docs/how-to-translate-the-woocommerce-string/\";s:8:\"category\";a:1:{i:0;s:15:\"translate-astra\";}}i:45;O:8:\"stdClass\":3:{s:5:\"title\";s:8:\"SVG Icon\";s:3:\"url\";s:34:\"https://wpastra.com/docs/svg-icon/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:46;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"Using Advanced Custom Fields with Astra\";s:3:\"url\";s:65:\"https://wpastra.com/docs/using-advanced-custom-fields-with-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:47;O:8:\"stdClass\":3:{s:5:\"title\";s:56:\"How to add a wishlist button to your WooCommerce Website\";s:3:\"url\";s:82:\"https://wpastra.com/docs/how-to-add-a-wishlist-button-to-your-woocommerce-website/\";s:8:\"category\";a:2:{i:0;s:7:\"general\";i:1;s:3:\"woo\";}}i:48;O:8:\"stdClass\":3:{s:5:\"title\";s:69:\"Error 406 while importing Starter Templates on your WordPress website\";s:3:\"url\";s:95:\"https://wpastra.com/docs/error-406-while-importing-starter-templates-on-your-wordpress-website/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:49;O:8:\"stdClass\":3:{s:5:\"title\";s:51:\"How to import Starter Templates with WP CLI Command\";s:3:\"url\";s:77:\"https://wpastra.com/docs/how-to-import-starter-templates-with-wp-cli-command/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:50;O:8:\"stdClass\":3:{s:5:\"title\";s:26:\"Auto Update Plugin Support\";s:3:\"url\";s:52:\"https://wpastra.com/docs/auto-update-plugin-support/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:51;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"The blank screen in the Customizer area \";s:3:\"url\";s:65:\"https://wpastra.com/docs/the-blank-screen-in-the-customizer-area/\";s:8:\"category\";a:2:{i:0;s:25:\"astra-customizer-settings\";i:1;s:17:\"starter-templates\";}}i:52;O:8:\"stdClass\":3:{s:5:\"title\";s:13:\"Mixed Content\";s:3:\"url\";s:39:\"https://wpastra.com/docs/mixed-content/\";s:8:\"category\";a:2:{i:0;s:7:\"general\";i:1;s:15:\"troubleshooting\";}}i:53;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"How to check JavaScript errors/conflicts?\";s:3:\"url\";s:66:\"https://wpastra.com/docs/how-to-check-javascript-errors-conflicts/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:54;O:8:\"stdClass\":3:{s:5:\"title\";s:60:\"How Astra is tuned for performance and is the fastest theme?\";s:3:\"url\";s:85:\"https://wpastra.com/docs/how-astra-is-tuned-for-performance-and-is-the-fastest-theme/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:55;O:8:\"stdClass\":3:{s:5:\"title\";s:26:\"Transparent Header for HFB\";s:3:\"url\";s:52:\"https://wpastra.com/docs/transparent-header-for-hfb/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:56;O:8:\"stdClass\":3:{s:5:\"title\";s:47:\"How &#8216;Enable Filter Accordion&#8217; Works\";s:3:\"url\";s:59:\"https://wpastra.com/docs/how-enable-filter-accordion-works/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:57;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"How to improve the CLS score with the Astra theme\";s:3:\"url\";s:75:\"https://wpastra.com/docs/how-to-improve-the-cls-score-with-the-astra-theme/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:58;O:8:\"stdClass\":3:{s:5:\"title\";s:34:\"System requirement for Astra Theme\";s:3:\"url\";s:60:\"https://wpastra.com/docs/system-requirement-for-astra-theme/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:59;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"WooCommerce hooks\";s:3:\"url\";s:43:\"https://wpastra.com/docs/woocommerce-hooks/\";s:8:\"category\";a:1:{i:0;s:16:\"woocommerce-free\";}}i:60;O:8:\"stdClass\":3:{s:5:\"title\";s:45:\"Set shop page as homepage &#8211; Woocommerce\";s:3:\"url\";s:63:\"https://wpastra.com/docs/set-shop-page-as-homepage-woocommerce/\";s:8:\"category\";a:1:{i:0;s:16:\"woocommerce-free\";}}i:61;O:8:\"stdClass\":3:{s:5:\"title\";s:35:\"Astra &#8211; Customize the submenu\";s:3:\"url\";s:53:\"https://wpastra.com/docs/astra-customize-the-submenu/\";s:8:\"category\";a:1:{i:0;s:25:\"astra-customizer-settings\";}}i:62;O:8:\"stdClass\":3:{s:5:\"title\";s:45:\"Remove default stretched block layout spacing\";s:3:\"url\";s:71:\"https://wpastra.com/docs/remove-default-stretched-block-layout-spacing/\";s:8:\"category\";a:1:{i:0;s:20:\"custom-code-snippets\";}}i:63;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"Improvements on the CheckOut page(Astra 3.9.0)\";s:3:\"url\";s:70:\"https://wpastra.com/docs/improvements-on-the-checkout-pageastra-3-9-0/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:64;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"Improvments on the Cart Page(Astra 3.9.0)\";s:3:\"url\";s:54:\"https://wpastra.com/docs/improvments-on-the-cart-page/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:65;O:8:\"stdClass\":3:{s:5:\"title\";s:52:\"Astra WooCommerce update (version 3.9.0) Misc Update\";s:3:\"url\";s:76:\"https://wpastra.com/docs/astra-woocommerce-update-version-3-9-0-misc-update/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:66;O:8:\"stdClass\":3:{s:5:\"title\";s:56:\"Astra WooCommerce update (version 3.9.0) My Account Page\";s:3:\"url\";s:80:\"https://wpastra.com/docs/astra-woocommerce-update-version-3-9-0-my-account-page/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:67;O:8:\"stdClass\":3:{s:5:\"title\";s:60:\"Astra WooCommerce update (version 3.9.0) Single Product Page\";s:3:\"url\";s:84:\"https://wpastra.com/docs/astra-woocommerce-update-version-3-9-0-single-product-page/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:68;O:8:\"stdClass\":3:{s:5:\"title\";s:50:\"Astra WooCommerce update (version 3.9.0) Shop Page\";s:3:\"url\";s:74:\"https://wpastra.com/docs/astra-woocommerce-update-version-3-9-0-shop-page/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:69;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"Astra WooCommerce update (version 3.9.0)\";s:3:\"url\";s:64:\"https://wpastra.com/docs/astra-woocommerce-update-version-3-9-0/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:70;O:8:\"stdClass\":3:{s:5:\"title\";s:61:\"Improvement: WooCommerce &#8211; Modify the Cart label design\";s:3:\"url\";s:78:\"https://wpastra.com/docs/improvement-woocommerce-modify-the-cart-label-design/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:71;O:8:\"stdClass\":3:{s:5:\"title\";s:43:\"Improved Block Editor Experience with Astra\";s:3:\"url\";s:58:\"https://wpastra.com/docs/improved-block-editor-experience/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:72;O:8:\"stdClass\":3:{s:5:\"title\";s:54:\"How to Remove Google Fonts Suggestions in Astra Theme?\";s:3:\"url\";s:72:\"https://wpastra.com/docs/remove-google-fonts-suggestions-in-astra-theme/\";s:8:\"category\";a:1:{i:0;s:20:\"custom-code-snippets\";}}i:73;O:8:\"stdClass\":3:{s:5:\"title\";s:66:\"How to Resolve Repeater Fields Not Working in Widget Block Editor?\";s:3:\"url\";s:86:\"https://wpastra.com/docs/resolving-repeater-fields-not-working-in-widget-block-editor/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:74;O:8:\"stdClass\":3:{s:5:\"title\";s:62:\"Enhancement: Applying Content Background to Full-Width Layouts\";s:3:\"url\";s:75:\"https://wpastra.com/docs/applying-content-background-to-full-width-layouts/\";s:8:\"category\";a:1:{i:0;s:21:\"colors-background-pro\";}}i:75;O:8:\"stdClass\":3:{s:5:\"title\";s:33:\"Move Related Posts Below Comments\";s:3:\"url\";s:59:\"https://wpastra.com/docs/move-related-posts-below-comments/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:76;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"Disable Astra Global Colors In Elementor\";s:3:\"url\";s:66:\"https://wpastra.com/docs/disable-astra-global-colors-in-elementor/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:77;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"Remove Woocommerce Product Category Archive Title\";s:3:\"url\";s:67:\"https://wpastra.com/docs/remove-woocommerce-category-archive-title/\";s:8:\"category\";a:1:{i:0;s:19:\"woocommerce-filters\";}}i:78;O:8:\"stdClass\":3:{s:5:\"title\";s:42:\"Remove Astra Customization for WooCommerce\";s:3:\"url\";s:68:\"https://wpastra.com/docs/remove-astra-customization-for-woocommerce/\";s:8:\"category\";a:1:{i:0;s:19:\"woocommerce-filters\";}}i:79;O:8:\"stdClass\":3:{s:5:\"title\";s:34:\"How To Change Web Stories Position\";s:3:\"url\";s:53:\"https://wpastra.com/docs/change-web-stories-position/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:80;O:8:\"stdClass\":3:{s:5:\"title\";s:30:\"Manage Astra Pro With Composer\";s:3:\"url\";s:56:\"https://wpastra.com/docs/manage-astra-pro-with-composer/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:81;O:8:\"stdClass\":3:{s:5:\"title\";s:59:\"How to Turn Astra Website Multilingual with TranslatePress?\";s:3:\"url\";s:69:\"https://wpastra.com/docs/turn-astra-multilingual-with-translatepress/\";s:8:\"category\";a:1:{i:0;s:15:\"translate-astra\";}}i:82;O:8:\"stdClass\":3:{s:5:\"title\";s:22:\"Starter Templates FAQs\";s:3:\"url\";s:48:\"https://wpastra.com/docs/starter-templates-faqs/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:83;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"Building Your Website With Starter Templates\";s:3:\"url\";s:70:\"https://wpastra.com/docs/building-your-website-with-starter-templates/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:84;O:8:\"stdClass\":3:{s:5:\"title\";s:27:\"Starter Templates Importing\";s:3:\"url\";s:53:\"https://wpastra.com/docs/starter-templates-importing/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:85;O:8:\"stdClass\":3:{s:5:\"title\";s:38:\"Getting Started With Starter Templates\";s:3:\"url\";s:64:\"https://wpastra.com/docs/getting-started-with-starter-templates/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:86;O:8:\"stdClass\":3:{s:5:\"title\";s:56:\"Creating Your Header and Footer With Astra or Elementor?\";s:3:\"url\";s:62:\"https://wpastra.com/docs/astra-or-elementor-header-and-footer/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:87;O:8:\"stdClass\":3:{s:5:\"title\";s:64:\"Gutenberg Editor And Frontend UI Improvements With Astra (3.7.4)\";s:3:\"url\";s:62:\"https://wpastra.com/docs/gutenberg-ui-improvements-with-astra/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:88;O:8:\"stdClass\":3:{s:5:\"title\";s:50:\"Replace Deprecated Astra Theme and Astra Pro Hooks\";s:3:\"url\";s:48:\"https://wpastra.com/docs/deprecated-astra-hooks/\";s:8:\"category\";a:2:{i:0;s:23:\"astra-theme-pro-filters\";i:1;s:27:\"astra-header-footer-filters\";}}i:89;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"Hide the Text by Setting the Font Size to Zero\";s:3:\"url\";s:51:\"https://wpastra.com/docs/setting-font-size-to-zero/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:90;O:8:\"stdClass\":3:{s:5:\"title\";s:66:\"How to Translate Categories, Tags, and Astra Strings with Polylang\";s:3:\"url\";s:77:\"https://wpastra.com/docs/translate-categories-tags-and-strings-with-polylang/\";s:8:\"category\";a:1:{i:0;s:15:\"translate-astra\";}}i:91;O:8:\"stdClass\":3:{s:5:\"title\";s:73:\"What To Do When Product Count Is Not Visible on Mini Cart With Astra Pro?\";s:3:\"url\";s:45:\"https://wpastra.com/docs/product-count-color/\";s:8:\"category\";a:2:{i:0;s:3:\"woo\";i:1;s:15:\"troubleshooting\";}}i:92;O:8:\"stdClass\":3:{s:5:\"title\";s:48:\"How to Roll Back to A Previous Version of Astra?\";s:3:\"url\";s:61:\"https://wpastra.com/docs/roll-back-to-previous-astra-version/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:93;O:8:\"stdClass\":3:{s:5:\"title\";s:53:\"How to Turn Astra Website Multilingual with Polylang?\";s:3:\"url\";s:63:\"https://wpastra.com/docs/turn-astra-multilingual-with-polylang/\";s:8:\"category\";a:1:{i:0;s:15:\"translate-astra\";}}i:94;O:8:\"stdClass\":3:{s:5:\"title\";s:42:\"Starter Templates &#8211; Wireframe Blocks\";s:3:\"url\";s:60:\"https://wpastra.com/docs/starter-templates-wireframe-blocks/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:95;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"How to Enable Debugging in WordPress (Debug Mode)\";s:3:\"url\";s:55:\"https://wpastra.com/docs/enable-debugging-in-wordpress/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:96;O:8:\"stdClass\":3:{s:5:\"title\";s:52:\"How To Override Astra’s theme.json in Child Theme?\";s:3:\"url\";s:52:\"https://wpastra.com/docs/override-astras-theme-json/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:97;O:8:\"stdClass\":3:{s:5:\"title\";s:63:\"How To Hide Quantity Number When the Woocommerce Cart Is Empty?\";s:3:\"url\";s:58:\"https://wpastra.com/docs/hide-quantity-when-cart-is-empty/\";s:8:\"category\";a:1:{i:0;s:19:\"woocommerce-filters\";}}i:98;O:8:\"stdClass\":3:{s:5:\"title\";s:58:\"How to Display the Post Category as a Related Posts Title?\";s:3:\"url\";s:65:\"https://wpastra.com/docs/display-category-as-related-posts-title/\";s:8:\"category\";a:1:{i:0;s:12:\"blog-filters\";}}i:99;O:8:\"stdClass\":3:{s:5:\"title\";s:48:\"How To Remove the Astra Header From Entire Site?\";s:3:\"url\";s:62:\"https://wpastra.com/docs/remove-astra-header-from-entire-site/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:100;O:8:\"stdClass\":3:{s:5:\"title\";s:55:\"How To Change Navigation Links Text for a Blog Archive?\";s:3:\"url\";s:65:\"https://wpastra.com/docs/replace-blog-archive-navigation-strings/\";s:8:\"category\";a:1:{i:0;s:12:\"blog-filters\";}}i:101;O:8:\"stdClass\":3:{s:5:\"title\";s:43:\"Frequently Asked Questions &#8211; VIP Care\";s:3:\"url\";s:39:\"https://wpastra.com/docs/faqs-vip-care/\";s:8:\"category\";a:1:{i:0;s:17:\"account-and-store\";}}i:102;O:8:\"stdClass\":3:{s:5:\"title\";s:72:\"How To Remove Underlined Content Links on Buttons and Specifics Classes?\";s:3:\"url\";s:57:\"https://wpastra.com/docs/remove-underlined-content-links/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:103;O:8:\"stdClass\":3:{s:5:\"title\";s:24:\"Astra Typography Presets\";s:3:\"url\";s:50:\"https://wpastra.com/docs/astra-typography-presets/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:104;O:8:\"stdClass\":3:{s:5:\"title\";s:20:\"Astra Button Presets\";s:3:\"url\";s:53:\"https://wpastra.com/docs/astra-button-styles-presets/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:105;O:8:\"stdClass\":3:{s:5:\"title\";s:26:\"Astra Global Color Palette\";s:3:\"url\";s:61:\"https://wpastra.com/docs/astra-global-color-palette-settings/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:106;O:8:\"stdClass\":3:{s:5:\"title\";s:51:\"How To Disable the Block Editor Support for Widgets\";s:3:\"url\";s:61:\"https://wpastra.com/docs/disable-widget-block-editor-support/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:107;O:8:\"stdClass\":3:{s:5:\"title\";s:80:\"How To Enable Design Options for Header and Footer Widgets in Block-Based Editor\";s:3:\"url\";s:60:\"https://wpastra.com/docs/enable-astra-widget-design-options/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:108;O:8:\"stdClass\":3:{s:5:\"title\";s:52:\"Restrict Search Results to WooCommerce Products Only\";s:3:\"url\";s:58:\"https://wpastra.com/docs/restrict-search-results-products/\";s:8:\"category\";a:1:{i:0;s:19:\"woocommerce-filters\";}}i:109;O:8:\"stdClass\":3:{s:5:\"title\";s:58:\"Fix Swap Sections Not Working on Mobile (Old Astra Header)\";s:3:\"url\";s:55:\"https://wpastra.com/docs/fix-swap-sections-not-working/\";s:8:\"category\";a:1:{i:0;s:20:\"custom-code-snippets\";}}i:110;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"Remove Spacing Around Elementor Pro TOC Widget\";s:3:\"url\";s:54:\"https://wpastra.com/docs/remove-spacing-elementor-toc/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:111;O:8:\"stdClass\":3:{s:5:\"title\";s:61:\"Fix Woocommerce Cart Becoming Transparent With Header Builder\";s:3:\"url\";s:58:\"https://wpastra.com/docs/fix-transparent-woocommerce-cart/\";s:8:\"category\";a:1:{i:0;s:19:\"woocommerce-filters\";}}i:112;O:8:\"stdClass\":3:{s:5:\"title\";s:53:\"How To Fix Right Margin for the Footer Widget Element\";s:3:\"url\";s:56:\"https://wpastra.com/docs/fix-footer-widget-right-margin/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:113;O:8:\"stdClass\":3:{s:5:\"title\";s:47:\"How to Add Elementor Template to the Mega Menu?\";s:3:\"url\";s:51:\"https://wpastra.com/docs/add-template-to-mega-menu/\";s:8:\"category\";a:1:{i:0;s:8:\"nav-menu\";}}i:114;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"The Recommended Size for Featured Image Upload\";s:3:\"url\";s:61:\"https://wpastra.com/docs/recommended-size-for-featured-image/\";s:8:\"category\";a:2:{i:0;s:7:\"general\";i:1;s:4:\"blog\";}}i:115;O:8:\"stdClass\":3:{s:5:\"title\";s:48:\"Why Doesn’t Parallax Scrolling Work on Mobile?\";s:3:\"url\";s:56:\"https://wpastra.com/docs/parallax-not-working-on-mobile/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:116;O:8:\"stdClass\":3:{s:5:\"title\";s:63:\"How To Fix Horizontal Scrollbar on Mobile When Using Elementor?\";s:3:\"url\";s:60:\"https://wpastra.com/docs/fix-horizontal-scrollbar-on-mobile/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:117;O:8:\"stdClass\":3:{s:5:\"title\";s:47:\"How To Apply New Default Button Padding Values?\";s:3:\"url\";s:54:\"https://wpastra.com/docs/apply-default-button-padding/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:118;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"Responsive Editing With the Astra Theme\";s:3:\"url\";s:61:\"https://wpastra.com/docs/responsive-editing-with-astra-theme/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:119;O:8:\"stdClass\":3:{s:5:\"title\";s:51:\"How To Hide Astra Settings for Specific User Roles?\";s:3:\"url\";s:60:\"https://wpastra.com/docs/hide-astra-settings-for-user-roles/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:120;O:8:\"stdClass\":3:{s:5:\"title\";s:67:\"How To Create a Header With a Centrally Positioned Logo With Astra?\";s:3:\"url\";s:70:\"https://wpastra.com/docs/create-header-with-centrally-positioned-logo/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:121;O:8:\"stdClass\":3:{s:5:\"title\";s:59:\"Manage Your Site Identity With Astra&#8217;s Header Builder\";s:3:\"url\";s:55:\"https://wpastra.com/docs/manage-site-identity-and-logo/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:122;O:8:\"stdClass\":3:{s:5:\"title\";s:58:\"How to Change the Heading Tag for the Related Posts Title?\";s:3:\"url\";s:60:\"https://wpastra.com/docs/change-tag-for-related-posts-title/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:123;O:8:\"stdClass\":3:{s:5:\"title\";s:56:\"Host Google Fonts Locally &#8211; Performance Is the Key\";s:3:\"url\";s:48:\"https://wpastra.com/docs/performance-is-the-key/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:124;O:8:\"stdClass\":3:{s:5:\"title\";s:36:\"How To Improve CLS For the SVG Logo?\";s:3:\"url\";s:50:\"https://wpastra.com/docs/improve-cls-for-svg-logo/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:125;O:8:\"stdClass\":3:{s:5:\"title\";s:53:\"How to Fix Font-Weight Not Applying To Widget Titles?\";s:3:\"url\";s:55:\"https://wpastra.com/docs/font-weight-for-widget-titles/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:126;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"How to Self-Host Google Fonts in Astra?\";s:3:\"url\";s:50:\"https://wpastra.com/docs/self-hosted-google-fonts/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:127;O:8:\"stdClass\":3:{s:5:\"title\";s:57:\"Gutenberg Plugin Causing Issues With the Astra Customizer\";s:3:\"url\";s:62:\"https://wpastra.com/docs/astra-customizer-options-unavailable/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:128;O:8:\"stdClass\":3:{s:5:\"title\";s:89:\"Change the &#8220;Shopping Cart&#8221; Text for WooCommerce &#038; EDD Mobile Header Cart\";s:3:\"url\";s:50:\"https://wpastra.com/docs/update-mobile-cart-title/\";s:8:\"category\";a:1:{i:0;s:19:\"woocommerce-filters\";}}i:129;O:8:\"stdClass\":3:{s:5:\"title\";s:29:\"Modify Your PHP Configuration\";s:3:\"url\";s:55:\"https://wpastra.com/docs/modify-your-php-configuration/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:130;O:8:\"stdClass\":3:{s:5:\"title\";s:48:\"Could not store XML file in /wp-content/ folder?\";s:3:\"url\";s:68:\"https://wpastra.com/docs/could-not-store-files-in-wp-content-folder/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:131;O:8:\"stdClass\":3:{s:5:\"title\";s:56:\"How to Fix 5XX Error While Importing a Starter Template?\";s:3:\"url\";s:53:\"https://wpastra.com/docs/5xx-error-starter-templates/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:132;O:8:\"stdClass\":3:{s:5:\"title\";s:69:\"How to Fix Blocked Requests Error While Importing a Starter Template?\";s:3:\"url\";s:66:\"https://wpastra.com/docs/blocked-requests-error-starter-templates/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:133;O:8:\"stdClass\":3:{s:5:\"title\";s:68:\"How to Fix Operation Timed Error While Importing a Starter Template?\";s:3:\"url\";s:65:\"https://wpastra.com/docs/operation-timed-error-starter-templates/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:134;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"How to Fix Starter Template Importing Issues\";s:3:\"url\";s:63:\"https://wpastra.com/docs/fix-starter-template-importing-issues/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:135;O:8:\"stdClass\":3:{s:5:\"title\";s:73:\"How to Remove Border Around the Cart? (Issue After Updating to Astra 3.4)\";s:3:\"url\";s:51:\"https://wpastra.com/docs/remove-border-around-cart/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:136;O:8:\"stdClass\":3:{s:5:\"title\";s:35:\"Getting the Most Out of Astra Theme\";s:3:\"url\";s:53:\"https://wpastra.com/docs/getting-the-most-with-astra/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:137;O:8:\"stdClass\":3:{s:5:\"title\";s:36:\"How To Build Quick Sites With Astra?\";s:3:\"url\";s:46:\"https://wpastra.com/docs/build-quick-websites/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:138;O:8:\"stdClass\":3:{s:5:\"title\";s:28:\"See Other Customizer Options\";s:3:\"url\";s:50:\"https://wpastra.com/docs/other-customizer-options/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:139;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"Build Your Footer\";s:3:\"url\";s:48:\"https://wpastra.com/docs/footer-builder-options/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:140;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"Add Your Sidebars\";s:3:\"url\";s:45:\"https://wpastra.com/docs/how-to-add-sidebars/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:141;O:8:\"stdClass\":3:{s:5:\"title\";s:16:\"Set Up Your Blog\";s:3:\"url\";s:43:\"https://wpastra.com/docs/how-to-setup-blog/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:142;O:8:\"stdClass\":3:{s:5:\"title\";s:29:\"Find the Way With Breadcrumbs\";s:3:\"url\";s:43:\"https://wpastra.com/docs/using-breadcrumbs/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:143;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"Build Your Header\";s:3:\"url\";s:48:\"https://wpastra.com/docs/header-builder-options/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:144;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"Style Your Website With Global Settings\";s:3:\"url\";s:52:\"https://wpastra.com/docs/style-with-global-settings/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:145;O:8:\"stdClass\":3:{s:5:\"title\";s:23:\"This Is Your Customizer\";s:3:\"url\";s:51:\"https://wpastra.com/docs/manage-customizer-options/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:146;O:8:\"stdClass\":3:{s:5:\"title\";s:23:\"Astra Theme Walkthrough\";s:3:\"url\";s:49:\"https://wpastra.com/docs/astra-theme-walkthrough/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:147;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"Display Related Posts on Single Blog Post\";s:3:\"url\";s:47:\"https://wpastra.com/docs/display-related-posts/\";s:8:\"category\";a:1:{i:0;s:4:\"blog\";}}i:148;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"How do I check my Support Ticket History?\";s:3:\"url\";s:54:\"https://wpastra.com/docs/check-support-ticket-history/\";s:8:\"category\";a:1:{i:0;s:17:\"account-and-store\";}}i:149;O:8:\"stdClass\":3:{s:5:\"title\";s:69:\"How to Resolve Fatal Error: Call to Undefined function ctype_xdigit()\";s:3:\"url\";s:50:\"https://wpastra.com/docs/fatal-error-ctype-xdigit/\";s:8:\"category\";a:2:{i:0;s:24:\"installation-and-updates\";i:1;s:15:\"troubleshooting\";}}i:150;O:8:\"stdClass\":3:{s:5:\"title\";s:56:\"Toggle Button for Desktop &#8211; Header Builder Element\";s:3:\"url\";s:51:\"https://wpastra.com/docs/toggle-button-for-desktop/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:151;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"Astra’s Default Font Icons Replaced With SVG\";s:3:\"url\";s:47:\"https://wpastra.com/docs/ast-font-icons-to-svg/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:152;O:8:\"stdClass\":3:{s:5:\"title\";s:38:\"Fix Spacing Issues in Gutenberg Blocks\";s:3:\"url\";s:47:\"https://wpastra.com/docs/fix-spacing-gb-blocks/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:153;O:8:\"stdClass\":3:{s:5:\"title\";s:74:\"Optimize Astra HTML and CSS &#8211; For Existing Astra Users (Before v3.3)\";s:3:\"url\";s:54:\"https://wpastra.com/docs/optimize-css-html-before-3-3/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:154;O:8:\"stdClass\":3:{s:5:\"title\";s:67:\"FAQs &#8211; Astra Pro 3.2 &#8211; Custom Layout Inside Pages/Posts\";s:3:\"url\";s:44:\"https://wpastra.com/docs/faqs-astra-pro-3-2/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:155;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"Inside Page/Post Content Custom Layouts\";s:3:\"url\";s:52:\"https://wpastra.com/docs/custom-layouts-inside-page/\";s:8:\"category\";a:1:{i:0;s:21:\"custom-layouts-module\";}}i:156;O:8:\"stdClass\":3:{s:5:\"title\";s:73:\"How to Remove the White Bars in the Safari Browser on iPhone X and Higher\";s:3:\"url\";s:53:\"https://wpastra.com/docs/remove-white-bars-on-safari/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:157;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"Sorry, You Are Not Allowed To Access This Page\";s:3:\"url\";s:52:\"https://wpastra.com/docs/not-allowed-to-access-page/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:158;O:8:\"stdClass\":3:{s:5:\"title\";s:34:\"Getting Started with Growth Bundle\";s:3:\"url\";s:55:\"https://wpastra.com/docs/getting-started-growth-bundle/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:159;O:8:\"stdClass\":3:{s:5:\"title\";s:37:\"Getting Started with Essential Bundle\";s:3:\"url\";s:58:\"https://wpastra.com/docs/getting-started-essential-bundle/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:160;O:8:\"stdClass\":3:{s:5:\"title\";s:67:\"Can&#8217;t See Newly Added Templates in Starter Templates Library?\";s:3:\"url\";s:48:\"https://wpastra.com/docs/sync-starter-templates/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:161;O:8:\"stdClass\":3:{s:5:\"title\";s:55:\"Filter to Remove Starter Templates Button on Post Types\";s:3:\"url\";s:67:\"https://wpastra.com/docs/filter-to-remove-starter-templates-button/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:162;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"Using Language Switcher Element with WPML\";s:3:\"url\";s:49:\"https://wpastra.com/docs/using-language-switcher/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:163;O:8:\"stdClass\":3:{s:5:\"title\";s:51:\"Importing Gutenberg Pages, Patterns, and Wireframes\";s:3:\"url\";s:50:\"https://wpastra.com/docs/import-gb-pages-patterns/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:164;O:8:\"stdClass\":3:{s:5:\"title\";s:33:\"Revamped Astra&#8217;s Customizer\";s:3:\"url\";s:51:\"https://wpastra.com/docs/revamped-astra-customizer/\";s:8:\"category\";a:2:{i:0;s:23:\"header-footer-after-3-0\";i:1;s:7:\"general\";}}i:165;O:8:\"stdClass\":3:{s:5:\"title\";s:50:\"Clone and Delete Elements in Header Footer Builder\";s:3:\"url\";s:50:\"https://wpastra.com/docs/clone-delete-hf-elements/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:166;O:8:\"stdClass\":3:{s:5:\"title\";s:33:\"How to Clear Astra&#8217;s Cache?\";s:3:\"url\";s:43:\"https://wpastra.com/docs/clear-astra-cache/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:167;O:8:\"stdClass\":3:{s:5:\"title\";s:67:\"FAQs &#8211; Astra Header/Footer Builder &#8211; Existing Customers\";s:3:\"url\";s:51:\"https://wpastra.com/docs/faqs-hf-builder-old-users/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:168;O:8:\"stdClass\":3:{s:5:\"title\";s:54:\"How To Create Mobile Header With Astra Header Builder?\";s:3:\"url\";s:66:\"https://wpastra.com/docs/create-mobile-header-with-header-builder/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:169;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"How To Create a Footer With Astra Footer Builder?\";s:3:\"url\";s:59:\"https://wpastra.com/docs/create-footer-with-footer-builder/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:170;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"How To Create a Header With Astra Header Builder?\";s:3:\"url\";s:59:\"https://wpastra.com/docs/create-header-with-header-builder/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:171;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"Add Multiple Elements in Header Footer Builder\";s:3:\"url\";s:60:\"https://wpastra.com/docs/multiple-elements-in-header-footer/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:172;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"FAQs &#8211; Astra Header/Footer Builder\";s:3:\"url\";s:58:\"https://wpastra.com/docs/faqs-astra-header-footer-builder/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:173;O:8:\"stdClass\":3:{s:5:\"title\";s:64:\"Elements in Header/Footer Builder With Astra Theme and Astra Pro\";s:3:\"url\";s:59:\"https://wpastra.com/docs/elements-in-header-footer-builder/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:174;O:8:\"stdClass\":3:{s:5:\"title\";s:42:\"How to Add Gutenberg Design Compatibility?\";s:3:\"url\";s:49:\"https://wpastra.com/docs/gb-design-compatibility/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:175;O:8:\"stdClass\":3:{s:5:\"title\";s:56:\"New Color Controls in Astra theme &#038; Astra Pro Addon\";s:3:\"url\";s:53:\"https://wpastra.com/docs/new-color-controls-in-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:176;O:8:\"stdClass\":3:{s:5:\"title\";s:30:\"Astra Pro Shortcodes Reference\";s:3:\"url\";s:56:\"https://wpastra.com/docs/astra-pro-shortcodes-reference/\";s:8:\"category\";a:0:{}}i:177;O:8:\"stdClass\":3:{s:5:\"title\";s:68:\"Filter to Add Global Button Settings Support for WooCommerce Buttons\";s:3:\"url\";s:71:\"https://wpastra.com/docs/global-button-support-for-woocommerce-buttons/\";s:8:\"category\";a:1:{i:0;s:19:\"woocommerce-filters\";}}i:178;O:8:\"stdClass\":3:{s:5:\"title\";s:72:\"Blog Featured Image Size Not Working / Error in Image Processing Library\";s:3:\"url\";s:57:\"https://wpastra.com/docs/blog-featured-image-size-issues/\";s:8:\"category\";a:2:{i:0;s:15:\"troubleshooting\";i:1;s:12:\"blog-filters\";}}i:179;O:8:\"stdClass\":3:{s:5:\"title\";s:50:\"Unable to find &#8220;No Toggle&#8221; Menu Style?\";s:3:\"url\";s:61:\"https://wpastra.com/docs/unable-to-find-no-toggle-menu-style/\";s:8:\"category\";a:1:{i:0;s:13:\"mobile-header\";}}i:180;O:8:\"stdClass\":3:{s:5:\"title\";s:58:\"Filters to Support CPTs for Blog Meta and Single Blog Meta\";s:3:\"url\";s:52:\"https://wpastra.com/docs/add-blog-meta-support-cpts/\";s:8:\"category\";a:1:{i:0;s:12:\"blog-filters\";}}i:181;O:8:\"stdClass\":3:{s:5:\"title\";s:29:\"Header Improvements in Astra!\";s:3:\"url\";s:54:\"https://wpastra.com/docs/header-improvements-in-astra/\";s:8:\"category\";a:1:{i:0;s:15:\"header-sections\";}}i:182;O:8:\"stdClass\":3:{s:5:\"title\";s:58:\"Filter to Add Support for Gutenberg Cover and Group blocks\";s:3:\"url\";s:70:\"https://wpastra.com/docs/support-for-gutenberg-cover-and-group-blocks/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:183;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"Change Footer Widget Title&#8217;s Heading Tag\";s:3:\"url\";s:64:\"https://wpastra.com/docs/change-footer-widget-title-heading-tag/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:184;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"How to Modify/Change the Quick View text?\";s:3:\"url\";s:48:\"https://wpastra.com/docs/modify-quick-view-text/\";s:8:\"category\";a:1:{i:0;s:19:\"woocommerce-filters\";}}i:185;O:8:\"stdClass\":3:{s:5:\"title\";s:30:\"Deprecated Google Fonts Filter\";s:3:\"url\";s:56:\"https://wpastra.com/docs/deprecated-google-fonts-filter/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:186;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"Mountain Template With Elementor Theme Style\";s:3:\"url\";s:65:\"https://wpastra.com/docs/mountain-template-elementor-theme-style/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:187;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"Plugin Installation Failed &#8211; Multisite\";s:3:\"url\";s:62:\"https://wpastra.com/docs/plugin-installation-failed-multisite/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:188;O:8:\"stdClass\":3:{s:5:\"title\";s:58:\"How to Modify Read Time Text on Blog and Single Post Page?\";s:3:\"url\";s:47:\"https://wpastra.com/docs/modify-read-time-text/\";s:8:\"category\";a:0:{}}i:189;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"System Requirements &#8211;  Starter Templates\";s:3:\"url\";s:63:\"https://wpastra.com/docs/system-requirements-starter-templates/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:190;O:8:\"stdClass\":3:{s:5:\"title\";s:58:\"Custom Layout not Rendering Correctly with Beaver Builder?\";s:3:\"url\";s:56:\"https://wpastra.com/docs/custom-layouts-rendering-issue/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:191;O:8:\"stdClass\":3:{s:5:\"title\";s:83:\"Unable to Upload the Astra Pro ZIP File because it is Unzipped During the Download?\";s:3:\"url\";s:65:\"https://wpastra.com/docs/unable-to-upload-the-astra-pro-zip-file/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:192;O:8:\"stdClass\":3:{s:5:\"title\";s:64:\"How to Update Responsive Breakpoints for Tablet+Mobile in Astra?\";s:3:\"url\";s:71:\"https://wpastra.com/docs/set-update-breakpoints-tablet-mobile-in-astra/\";s:8:\"category\";a:2:{i:0;s:23:\"header-footer-after-3-0\";i:1;s:27:\"astra-header-footer-filters\";}}i:193;O:8:\"stdClass\":3:{s:5:\"title\";s:14:\"Usage Tracking\";s:3:\"url\";s:40:\"https://wpastra.com/docs/usage-tracking/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:194;O:8:\"stdClass\":3:{s:5:\"title\";s:47:\"How to Install Starter Templates (Free) Plugin?\";s:3:\"url\";s:56:\"https://wpastra.com/docs/install-free-starter-templates/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:195;O:8:\"stdClass\":3:{s:5:\"title\";s:51:\"Starter Templates &#8211; Restore Customizer Backup\";s:3:\"url\";s:51:\"https://wpastra.com/docs/restore-customizer-backup/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:196;O:8:\"stdClass\":3:{s:5:\"title\";s:34:\"How to Update Your Payment Method?\";s:3:\"url\";s:47:\"https://wpastra.com/docs/update-payment-method/\";s:8:\"category\";a:0:{}}i:197;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"How to Setup Custom Adobe Fonts (Typekit) Plugin?\";s:3:\"url\";s:65:\"https://wpastra.com/docs/setup-custom-adobe-fonts-typekit-plugin/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:198;O:8:\"stdClass\":3:{s:5:\"title\";s:56:\"Can I Import Starter Templates Site on Existing Website?\";s:3:\"url\";s:62:\"https://wpastra.com/docs/import-templates-on-existing-website/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:199;O:8:\"stdClass\":3:{s:5:\"title\";s:62:\"Premium Starter Templates &#8211; Install and Activate License\";s:3:\"url\";s:59:\"https://wpastra.com/docs/install-premium-starter-templates/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:200;O:8:\"stdClass\":3:{s:5:\"title\";s:43:\"Not Valid License &#8211; Starter Templates\";s:3:\"url\";s:43:\"https://wpastra.com/docs/not-valid-license/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:201;O:8:\"stdClass\":3:{s:5:\"title\";s:50:\"Starter Templates &#8211; Requires plugins missing\";s:3:\"url\";s:52:\"https://wpastra.com/docs/plugin-installation-failed/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:202;O:8:\"stdClass\":3:{s:5:\"title\";s:55:\"Filter to Remove Link From Featured Images on Blog Page\";s:3:\"url\";s:65:\"https://wpastra.com/docs/remove-featured-image-link-on-blog-page/\";s:8:\"category\";a:1:{i:0;s:12:\"blog-filters\";}}i:203;O:8:\"stdClass\":3:{s:5:\"title\";s:58:\"Set Parallax Effect on Responsive Devices with Page Header\";s:3:\"url\";s:46:\"https://wpastra.com/docs/parallax-page-header/\";s:8:\"category\";a:1:{i:0;s:12:\"page-headers\";}}i:204;O:8:\"stdClass\":3:{s:5:\"title\";s:50:\"Starter Templates &#8211; Free Images from Pixabay\";s:3:\"url\";s:58:\"https://wpastra.com/docs/starter-templates-pixabay-images/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:205;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"Starter Templates &#8211; Elementor Popup\";s:3:\"url\";s:59:\"https://wpastra.com/docs/starter-templates-elementor-popup/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:206;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"Update Required Plugins &#8211; Starter Templates\";s:3:\"url\";s:49:\"https://wpastra.com/docs/update-required-plugins/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:207;O:8:\"stdClass\":3:{s:5:\"title\";s:51:\"XMLReader Support Missing &#8211; Starter Templates\";s:3:\"url\";s:43:\"https://wpastra.com/docs/xmlreader-missing/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:208;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"Disable Debug Mode &#8211; Starter Templates\";s:3:\"url\";s:44:\"https://wpastra.com/docs/disable-debug-mode/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:209;O:8:\"stdClass\":3:{s:5:\"title\";s:59:\"Required File Permissions Missing &#8211; Starter Templates\";s:3:\"url\";s:51:\"https://wpastra.com/docs/required-file-permissions/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:210;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"cURL Support Missing &#8211; Starter Templates\";s:3:\"url\";s:46:\"https://wpastra.com/docs/curl-support-missing/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:211;O:8:\"stdClass\":3:{s:5:\"title\";s:35:\"Starter Templates with Other Themes\";s:3:\"url\";s:61:\"https://wpastra.com/docs/starter-templates-with-other-themes/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:212;O:8:\"stdClass\":3:{s:5:\"title\";s:53:\"How to Import A Complete Site With Starter Templates?\";s:3:\"url\";s:57:\"https://wpastra.com/docs/starter-templates-complete-site/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:213;O:8:\"stdClass\":3:{s:5:\"title\";s:37:\"Starter Templates — Basics and FAQs\";s:3:\"url\";s:55:\"https://wpastra.com/docs/starter-templates-basics-faqs/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:214;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"How to Import Single Page With Starter Templates?\";s:3:\"url\";s:48:\"https://wpastra.com/docs/import-single-template/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:215;O:8:\"stdClass\":3:{s:5:\"title\";s:59:\"New Header Button Options in Astra theme (Old Astra Header)\";s:3:\"url\";s:59:\"https://wpastra.com/docs/new-button-options-in-astra-theme/\";s:8:\"category\";a:1:{i:0;s:24:\"header-footer-before-3-0\";}}i:216;O:8:\"stdClass\":3:{s:5:\"title\";s:53:\"How to Enable Astra Comment Box on Custom Post Types?\";s:3:\"url\";s:57:\"https://wpastra.com/docs/enable-astra-comment-box-on-cpt/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:217;O:8:\"stdClass\":3:{s:5:\"title\";s:28:\"Astra 2.2 for Existing Users\";s:3:\"url\";s:54:\"https://wpastra.com/docs/astra-2-2-for-existing-users/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:218;O:8:\"stdClass\":3:{s:5:\"title\";s:50:\"How to Remove Featured Image Link on Archive Page?\";s:3:\"url\";s:68:\"https://wpastra.com/docs/remove-featured-image-link-on-archive-page/\";s:8:\"category\";a:2:{i:0;s:7:\"general\";i:1;s:12:\"blog-filters\";}}i:219;O:8:\"stdClass\":3:{s:5:\"title\";s:47:\"Display Settings of Custom Layouts in Astra Pro\";s:3:\"url\";s:48:\"https://wpastra.com/docs/display-rules-in-astra/\";s:8:\"category\";a:1:{i:0;s:21:\"custom-layouts-module\";}}i:220;O:8:\"stdClass\":3:{s:5:\"title\";s:53:\"Get SkillJet Access &#8211; Brainstorm Force Customer\";s:3:\"url\";s:48:\"https://wpastra.com/docs/unlock-skilljet-access/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:221;O:8:\"stdClass\":3:{s:5:\"title\";s:53:\"How to Disable Product Quantity (Plus-Minus) Buttons?\";s:3:\"url\";s:52:\"https://wpastra.com/docs/disable-plus-minus-buttons/\";s:8:\"category\";a:1:{i:0;s:19:\"woocommerce-filters\";}}i:222;O:8:\"stdClass\":3:{s:5:\"title\";s:52:\"Change Placeholder for Search Box (Old Astra Header)\";s:3:\"url\";s:51:\"https://wpastra.com/docs/change-search-placeholder/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:223;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"How to Disable Schema Markup Added by Astra?\";s:3:\"url\";s:47:\"https://wpastra.com/docs/disable-schema-markup/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:224;O:8:\"stdClass\":3:{s:5:\"title\";s:50:\"Change the String &#8220;Search Results For&#8221;\";s:3:\"url\";s:46:\"https://wpastra.com/docs/change-search-string/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:225;O:8:\"stdClass\":3:{s:5:\"title\";s:37:\"Restrict Search Results to Posts Only\";s:3:\"url\";s:54:\"https://wpastra.com/docs/restrict-search-results-post/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:226;O:8:\"stdClass\":3:{s:5:\"title\";s:32:\"How to Remove Page Header Title?\";s:3:\"url\";s:50:\"https://wpastra.com/docs/remove-page-header-title/\";s:8:\"category\";a:1:{i:0;s:12:\"page-headers\";}}i:227;O:8:\"stdClass\":3:{s:5:\"title\";s:45:\"Naming Convention for Astra 2.1.0 CSS File(s)\";s:3:\"url\";s:53:\"https://wpastra.com/docs/naming-convention-astra-2-1/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:228;O:8:\"stdClass\":3:{s:5:\"title\";s:43:\"How to Get Started with CSS File Generation\";s:3:\"url\";s:52:\"https://wpastra.com/docs/enable-css-file-generation/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:229;O:8:\"stdClass\":3:{s:5:\"title\";s:24:\"Browser Support by Astra\";s:3:\"url\";s:50:\"https://wpastra.com/docs/browser-support-by-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:230;O:8:\"stdClass\":3:{s:5:\"title\";s:33:\"Structuring Shop WooCommerce Page\";s:3:\"url\";s:44:\"https://wpastra.com/docs/shop-woocommerce-2/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:231;O:8:\"stdClass\":3:{s:5:\"title\";s:66:\"How to Deal with Update Issues in Astra Theme and Astra Pro Addon?\";s:3:\"url\";s:59:\"https://wpastra.com/docs/overcoming-update-issues-in-astra/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:232;O:8:\"stdClass\":3:{s:5:\"title\";s:31:\"How to Manage License on Store?\";s:3:\"url\";s:56:\"https://wpastra.com/docs/how-to-manage-license-on-store/\";s:8:\"category\";a:1:{i:0;s:17:\"account-and-store\";}}i:233;O:8:\"stdClass\":3:{s:5:\"title\";s:35:\"How to Update Astra Theme Manually?\";s:3:\"url\";s:47:\"https://wpastra.com/docs/update-theme-manually/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:234;O:8:\"stdClass\":3:{s:5:\"title\";s:55:\"How to Change the Heading Tag for the Page/Post Titles?\";s:3:\"url\";s:59:\"https://wpastra.com/docs/change-heading-tag-for-post-title/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:235;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"Astra Compatibility with LearnDash Version 3.0\";s:3:\"url\";s:64:\"https://wpastra.com/docs/astra-compatibility-with-learndash-3-0/\";s:8:\"category\";a:2:{i:0;s:27:\"learndash-astra-pro-modules\";i:1;s:9:\"learndash\";}}i:236;O:8:\"stdClass\":3:{s:5:\"title\";s:34:\"Modify font-display Property Value\";s:3:\"url\";s:60:\"https://wpastra.com/docs/modify-font-display-property-value/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:237;O:8:\"stdClass\":3:{s:5:\"title\";s:50:\"How to Change HTML tag for Site Title and Tagline?\";s:3:\"url\";s:60:\"https://wpastra.com/docs/change-site-title-tagline-html-tag/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:238;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"Why font-display property is added to Astra?\";s:3:\"url\";s:56:\"https://wpastra.com/docs/font-display-property-in-astra/\";s:8:\"category\";a:0:{}}i:239;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"Disable All Meta Settings of Page/Post by Default\";s:3:\"url\";s:75:\"https://wpastra.com/docs/disable-all-meta-settings-of-page-post-by-default/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:240;O:8:\"stdClass\":3:{s:5:\"title\";s:36:\"How to Remove Inline CSS from Astra?\";s:3:\"url\";s:54:\"https://wpastra.com/docs/remove-inline-css-from-astra/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:241;O:8:\"stdClass\":3:{s:5:\"title\";s:35:\"How to Add RTL CSS via Child Theme?\";s:3:\"url\";s:49:\"https://wpastra.com/docs/rtl-css-via-child-theme/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:242;O:8:\"stdClass\":3:{s:5:\"title\";s:66:\"How to Change Previous and Next Link Text from a Single Blog Post?\";s:3:\"url\";s:67:\"https://wpastra.com/docs/replace-navigation-strings-on-single-post/\";s:8:\"category\";a:1:{i:0;s:12:\"blog-filters\";}}i:243;O:8:\"stdClass\":3:{s:5:\"title\";s:75:\"Add Title attribute to Header Background Image as a Substitute for Alt Text\";s:3:\"url\";s:68:\"https://wpastra.com/docs/title-attribute-in-header-background-image/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:244;O:8:\"stdClass\":3:{s:5:\"title\";s:52:\"How to Switch From Existing Breadcrumb to New Trail?\";s:3:\"url\";s:64:\"https://wpastra.com/docs/filter-to-switch-bread-from-old-to-new/\";s:8:\"category\";a:1:{i:0;s:10:\"breadcrumb\";}}i:245;O:8:\"stdClass\":3:{s:5:\"title\";s:74:\"How to Display a Breadcrumb Anywhere within a Page or Post with Shortcode?\";s:3:\"url\";s:59:\"https://wpastra.com/docs/display-breadcrumb-with-shortcode/\";s:8:\"category\";a:1:{i:0;s:10:\"breadcrumb\";}}i:246;O:8:\"stdClass\":3:{s:5:\"title\";s:54:\"How to Add Breadcrumbs in WordPress Website with Astra\";s:3:\"url\";s:52:\"https://wpastra.com/docs/add-breadcrumbs-with-astra/\";s:8:\"category\";a:1:{i:0;s:10:\"breadcrumb\";}}i:247;O:8:\"stdClass\":3:{s:5:\"title\";s:42:\"Disable Astra’s Native AMP Functionality\";s:3:\"url\";s:51:\"https://wpastra.com/docs/disable-astra-amp-support/\";s:8:\"category\";a:2:{i:0;s:18:\"native-amp-support\";i:1;s:23:\"astra-theme-pro-filters\";}}i:248;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"Astra Options that won&#8217;t work with AMP\";s:3:\"url\";s:63:\"https://wpastra.com/docs/astra-options-that-wont-work-with-amp/\";s:8:\"category\";a:2:{i:0;s:18:\"native-amp-support\";i:1;s:7:\"general\";}}i:249;O:8:\"stdClass\":3:{s:5:\"title\";s:20:\"Configure AMP Plugin\";s:3:\"url\";s:46:\"https://wpastra.com/docs/configure-amp-plugin/\";s:8:\"category\";a:2:{i:0;s:18:\"native-amp-support\";i:1;s:7:\"general\";}}i:250;O:8:\"stdClass\":3:{s:5:\"title\";s:59:\"How to Activate the License for Astra Premium Sites Plugin?\";s:3:\"url\";s:73:\"https://wpastra.com/docs/activate-license-for-astra-premium-sites-plugin/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:251;O:8:\"stdClass\":3:{s:5:\"title\";s:51:\"White Label Constants to Change Strings Permanently\";s:3:\"url\";s:77:\"https://wpastra.com/docs/white-label-constants-to-change-strings-permanently/\";s:8:\"category\";a:1:{i:0;s:11:\"white-label\";}}i:252;O:8:\"stdClass\":3:{s:5:\"title\";s:30:\"Manually Install Astra via FTP\";s:3:\"url\";s:56:\"https://wpastra.com/docs/manually-install-astra-via-ftp/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:253;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"Change Sidebar Widget Title Heading Tag\";s:3:\"url\";s:65:\"https://wpastra.com/docs/change-sidebar-widget-title-heading-tag/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:254;O:8:\"stdClass\":3:{s:5:\"title\";s:48:\"How to Change the Direction for Submenu Opening?\";s:3:\"url\";s:66:\"https://wpastra.com/docs/change-the-direction-for-submenu-opening/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:255;O:8:\"stdClass\":3:{s:5:\"title\";s:51:\"Display Products from Same Category with Navigation\";s:3:\"url\";s:78:\"https://wpastra.com/docs/products-from-same-directed-category-with-navigation/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:256;O:8:\"stdClass\":3:{s:5:\"title\";s:27:\"Native AMP Support in Astra\";s:3:\"url\";s:50:\"https://wpastra.com/docs/astra-native-amp-support/\";s:8:\"category\";a:2:{i:0;s:18:\"native-amp-support\";i:1;s:7:\"general\";}}i:257;O:8:\"stdClass\":3:{s:5:\"title\";s:52:\"How to Disable the White Label Settings Permanently?\";s:3:\"url\";s:77:\"https://wpastra.com/docs/how-to-disable-the-white-label-settings-permanently/\";s:8:\"category\";a:2:{i:0;s:11:\"white-label\";i:1;s:7:\"general\";}}i:258;O:8:\"stdClass\":3:{s:5:\"title\";s:73:\"Troubleshooting Steps ( with Health Check &#038; Troubleshooting plugin )\";s:3:\"url\";s:47:\"https://wpastra.com/docs/troubleshooting-steps/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:259;O:8:\"stdClass\":3:{s:5:\"title\";s:31:\"How to Add Icons to Menu Items?\";s:3:\"url\";s:56:\"https://wpastra.com/docs/how-to-add-icons-to-menu-items/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:260;O:8:\"stdClass\":3:{s:5:\"title\";s:67:\"How Translations can be Manually Exported and Uploaded to the Site?\";s:3:\"url\";s:54:\"https://wpastra.com/docs/manually-upload-translations/\";s:8:\"category\";a:1:{i:0;s:15:\"translate-astra\";}}i:261;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"How to Add Button as Last Item in Menu?\";s:3:\"url\";s:57:\"https://wpastra.com/docs/add-button-as-last-item-in-menu/\";s:8:\"category\";a:2:{i:0;s:7:\"general\";i:1;s:24:\"header-footer-before-3-0\";}}i:262;O:8:\"stdClass\":3:{s:5:\"title\";s:33:\"Transparent Header in Astra Theme\";s:3:\"url\";s:50:\"https://wpastra.com/docs/astra-transparent-header/\";s:8:\"category\";a:1:{i:0;s:24:\"header-footer-before-3-0\";}}i:263;O:8:\"stdClass\":3:{s:5:\"title\";s:77:\"&#8216;The preview could not be loaded&#8217; Pop Up with Astra and Elementor\";s:3:\"url\";s:64:\"https://wpastra.com/docs/the-preview-could-not-be-loaded-pop-up/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:264;O:8:\"stdClass\":3:{s:5:\"title\";s:36:\"Change Woocommerce Out of Stock Text\";s:3:\"url\";s:62:\"https://wpastra.com/docs/change-woocommerce-out-of-stock-text/\";s:8:\"category\";a:1:{i:0;s:19:\"woocommerce-filters\";}}i:265;O:8:\"stdClass\":3:{s:5:\"title\";s:50:\"Does White Label Feature Make Changes in the Code?\";s:3:\"url\";s:97:\"https://wpastra.com/docs/does-white-label-feature-in-astra-pro-make-changes-in-the-frontend-code/\";s:8:\"category\";a:1:{i:0;s:11:\"white-label\";}}i:266;O:8:\"stdClass\":3:{s:5:\"title\";s:26:\"Typography options for EDD\";s:3:\"url\";s:52:\"https://wpastra.com/docs/typography-options-for-edd/\";s:8:\"category\";a:1:{i:0;s:29:\"easy-digital-downloads-module\";}}i:267;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"Colors &#038; Background options for EDD\";s:3:\"url\";s:59:\"https://wpastra.com/docs/colors-background-options-for-edd/\";s:8:\"category\";a:1:{i:0;s:29:\"easy-digital-downloads-module\";}}i:268;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"Checkout Page &#8211; EDD Module Options\";s:3:\"url\";s:58:\"https://wpastra.com/docs/checkout-page-edd-module-options/\";s:8:\"category\";a:1:{i:0;s:29:\"easy-digital-downloads-module\";}}i:269;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"Single Product &#8211; EDD Module Options\";s:3:\"url\";s:59:\"https://wpastra.com/docs/single-product-edd-module-options/\";s:8:\"category\";a:1:{i:0;s:29:\"easy-digital-downloads-module\";}}i:270;O:8:\"stdClass\":3:{s:5:\"title\";s:42:\"Product Archive &#8211; EDD Module Options\";s:3:\"url\";s:60:\"https://wpastra.com/docs/product-archive-edd-module-options/\";s:8:\"category\";a:1:{i:0;s:29:\"easy-digital-downloads-module\";}}i:271;O:8:\"stdClass\":3:{s:5:\"title\";s:34:\"General &#8211; EDD Module Options\";s:3:\"url\";s:52:\"https://wpastra.com/docs/general-edd-module-options/\";s:8:\"category\";a:1:{i:0;s:29:\"easy-digital-downloads-module\";}}i:272;O:8:\"stdClass\":3:{s:5:\"title\";s:50:\"EDD &#8211; Easy Digital Downloads Module Overview\";s:3:\"url\";s:64:\"https://wpastra.com/docs/easy-digital-downloads-module-overview/\";s:8:\"category\";a:1:{i:0;s:29:\"easy-digital-downloads-module\";}}i:273;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"EDD Integration Overview in Free Astra Theme\";s:3:\"url\";s:62:\"https://wpastra.com/docs/edd-integration-overview-astra-theme/\";s:8:\"category\";a:1:{i:0;s:22:\"easy-digital-downloads\";}}i:274;O:8:\"stdClass\":3:{s:5:\"title\";s:68:\"How to Display a Mini Cart Anywhere Using Shortcode? (Astra and EDD)\";s:3:\"url\";s:49:\"https://wpastra.com/docs/edd-mini-cart-shortcode/\";s:8:\"category\";a:2:{i:0;s:29:\"easy-digital-downloads-module\";i:1;s:7:\"general\";}}i:275;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"How to Add EDD Cart in Header? (Old Astra Header)\";s:3:\"url\";s:44:\"https://wpastra.com/docs/edd-cart-in-header/\";s:8:\"category\";a:3:{i:0;s:7:\"general\";i:1;s:22:\"easy-digital-downloads\";i:2;s:29:\"easy-digital-downloads-module\";}}i:276;O:8:\"stdClass\":3:{s:5:\"title\";s:72:\"How to Add Download Archive Pages to the Menu When Using Astra with EDD?\";s:3:\"url\";s:59:\"https://wpastra.com/docs/add-download-archive-page-to-menu/\";s:8:\"category\";a:3:{i:0;s:7:\"general\";i:1;s:22:\"easy-digital-downloads\";i:2;s:29:\"easy-digital-downloads-module\";}}i:277;O:8:\"stdClass\":3:{s:5:\"title\";s:35:\"How to Disable EDD Inbuilt Styling?\";s:3:\"url\";s:53:\"https://wpastra.com/docs/disable-edd-inbuilt-styling/\";s:8:\"category\";a:3:{i:0;s:7:\"general\";i:1;s:22:\"easy-digital-downloads\";i:2;s:29:\"easy-digital-downloads-module\";}}i:278;O:8:\"stdClass\":3:{s:5:\"title\";s:77:\"How to Apply For Brainstorm Force Affiliate Program? (Become Astra Affiliate)\";s:3:\"url\";s:48:\"https://wpastra.com/docs/become-astra-affiliate/\";s:8:\"category\";a:1:{i:0;s:17:\"account-and-store\";}}i:279;O:8:\"stdClass\":3:{s:5:\"title\";s:33:\"How to Add Custom Fonts in Astra?\";s:3:\"url\";s:58:\"https://wpastra.com/docs/how-to-add-custom-fonts-in-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:280;O:8:\"stdClass\":3:{s:5:\"title\";s:28:\"How to Upgrade to Astra Pro?\";s:3:\"url\";s:46:\"https://wpastra.com/docs/upgrade-to-astra-pro/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:281;O:8:\"stdClass\":3:{s:5:\"title\";s:32:\"Typography Improvement for Astra\";s:3:\"url\";s:58:\"https://wpastra.com/docs/typography-improvement-for-astra/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:282;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"How Does Astra Work with the Gutenberg Editor?\";s:3:\"url\";s:53:\"https://wpastra.com/docs/astra-with-gutenberg-editor/\";s:8:\"category\";a:0:{}}i:283;O:8:\"stdClass\":3:{s:5:\"title\";s:63:\"How to Create Different Headers on Different Pages Using Astra?\";s:3:\"url\";s:62:\"https://wpastra.com/docs/different-headers-on-different-pages/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:284;O:8:\"stdClass\":3:{s:5:\"title\";s:25:\"Dim Content on Menu Hover\";s:3:\"url\";s:51:\"https://wpastra.com/docs/dim-content-on-menu-hover/\";s:8:\"category\";a:1:{i:0;s:10:\"custom-css\";}}i:285;O:8:\"stdClass\":3:{s:5:\"title\";s:42:\"Which Zip Should I Install from the Store?\";s:3:\"url\";s:46:\"https://wpastra.com/docs/which-zip-to-install/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:286;O:8:\"stdClass\":3:{s:5:\"title\";s:37:\"How to Set Animation To The Sub Menu?\";s:3:\"url\";s:62:\"https://wpastra.com/docs/how-to-set-animation-to-the-sub-menu/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:287;O:8:\"stdClass\":3:{s:5:\"title\";s:37:\"Display SubMenu Just Below the Header\";s:3:\"url\";s:59:\"https://wpastra.com/docs/display-sub-menu-below-the-header/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:288;O:8:\"stdClass\":3:{s:5:\"title\";s:77:\"How to Duplicate &#8216;Custom Layouts&#8217; and &#8216;Page Headers&#8217;?\";s:3:\"url\";s:67:\"https://wpastra.com/docs/duplicate-custom-layouts-and-page-headers/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:289;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"How to Set up a WordPress Staging Site?\";s:3:\"url\";s:54:\"https://wpastra.com/docs/how-to-set-up-a-staging-site/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:290;O:8:\"stdClass\":3:{s:5:\"title\";s:30:\"How to Disable Primary Header?\";s:3:\"url\";s:55:\"https://wpastra.com/docs/how-to-disable-primary-header/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:291;O:8:\"stdClass\":3:{s:5:\"title\";s:36:\"Nav Menu Module [Create a Mega Menu]\";s:3:\"url\";s:40:\"https://wpastra.com/docs/nav-menu-addon/\";s:8:\"category\";a:1:{i:0;s:8:\"nav-menu\";}}i:292;O:8:\"stdClass\":3:{s:5:\"title\";s:42:\"How to Switch to Astra from Another Theme?\";s:3:\"url\";s:48:\"https://wpastra.com/docs/how-to-switch-to-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:293;O:8:\"stdClass\":3:{s:5:\"title\";s:35:\"Google Fonts Not Loading with Astra\";s:3:\"url\";s:61:\"https://wpastra.com/docs/google-fonts-not-loading-with-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:294;O:8:\"stdClass\":3:{s:5:\"title\";s:74:\"Adding Custom Sidebar to the Theme with Lightweight Sidebar Manager plugin\";s:3:\"url\";s:47:\"https://wpastra.com/docs/adding-custom-sidebar/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:295;O:8:\"stdClass\":3:{s:5:\"title\";s:32:\"Automatic Beta Updates for Astra\";s:3:\"url\";s:58:\"https://wpastra.com/docs/automatic-beta-updates-for-astra/\";s:8:\"category\";a:2:{i:0;s:7:\"general\";i:1;s:24:\"installation-and-updates\";}}i:296;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"How to Add Font Awesome Icons in Astra?\";s:3:\"url\";s:57:\"https://wpastra.com/docs/add-font-awesome-icons-in-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:297;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"Color for Anchor Tag Inside Heading Tag\";s:3:\"url\";s:55:\"https://wpastra.com/docs/anchor-tag-inside-heading-tag/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:298;O:8:\"stdClass\":3:{s:5:\"title\";s:43:\"Search Shortcode to Add Search Box in Astra\";s:3:\"url\";s:55:\"https://wpastra.com/docs/search-box-shortcode-in-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:299;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"LifterLMS Shortcode to Add Profile Link\";s:3:\"url\";s:62:\"https://wpastra.com/docs/lifterlms-shortcode-for-profile-link/\";s:8:\"category\";a:2:{i:0;s:7:\"general\";i:1;s:19:\"lifterlms-astra-pro\";}}i:300;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"LearnDash Shortcode to Add Profile Link\";s:3:\"url\";s:62:\"https://wpastra.com/docs/learndash-shortcode-for-profile-link/\";s:8:\"category\";a:2:{i:0;s:7:\"general\";i:1;s:27:\"learndash-astra-pro-modules\";}}i:301;O:8:\"stdClass\":3:{s:5:\"title\";s:71:\"How to Download Older Version of Astra Theme or Astra Pro Addon plugin?\";s:3:\"url\";s:57:\"https://wpastra.com/docs/download-older-version-of-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:302;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"How to Add Google Tag Manager Code to Astra?\";s:3:\"url\";s:69:\"https://wpastra.com/docs/how-to-add-google-tag-manager-code-to-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:303;O:8:\"stdClass\":3:{s:5:\"title\";s:56:\"Mobile Header with Above/Below Header (Old Astra Header)\";s:3:\"url\";s:63:\"https://wpastra.com/docs/mobile-header-with-above-below-header/\";s:8:\"category\";a:1:{i:0;s:13:\"mobile-header\";}}i:304;O:8:\"stdClass\":3:{s:5:\"title\";s:56:\"How to Stick Footer to Bottom when Page Content is Less?\";s:3:\"url\";s:81:\"https://wpastra.com/docs/how-to-stick-footer-to-bottom-when-page-content-is-less/\";s:8:\"category\";a:2:{i:0;s:7:\"general\";i:1;s:21:\"footer-widgets-module\";}}i:305;O:8:\"stdClass\":3:{s:5:\"title\";s:35:\"Quick View for WooCommerce Products\";s:3:\"url\";s:61:\"https://wpastra.com/docs/quick-view-for-woocommerce-products/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:306;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"Off Canvas Sidebar for WooCommerce Shop Page\";s:3:\"url\";s:70:\"https://wpastra.com/docs/off-canvas-sidebar-for-woocommerce-shop-page/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:307;O:8:\"stdClass\":3:{s:5:\"title\";s:74:\"Colors &#038; Background Options for Transparent Header (Old Astra Header)\";s:3:\"url\";s:74:\"https://wpastra.com/docs/colors-background-options-for-transparent-header/\";s:8:\"category\";a:1:{i:0;s:24:\"header-footer-before-3-0\";}}i:308;O:8:\"stdClass\":3:{s:5:\"title\";s:74:\"Colors/Background and Typography options for Footer Bar (Old Astra Footer)\";s:3:\"url\";s:81:\"https://wpastra.com/docs/colors-background-and-typography-options-for-footer-bar/\";s:8:\"category\";a:1:{i:0;s:24:\"header-footer-before-3-0\";}}i:309;O:8:\"stdClass\":3:{s:5:\"title\";s:62:\"How to Add WooCommerce Mini Cart in Header? (Old Astra Header)\";s:3:\"url\";s:61:\"https://wpastra.com/docs/add-woocommerce-mini-cart-to-header/\";s:8:\"category\";a:3:{i:0;s:7:\"general\";i:1;s:16:\"woocommerce-free\";i:2;s:3:\"woo\";}}i:310;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"How to Translate Astra Strings with WPML?\";s:3:\"url\";s:53:\"https://wpastra.com/docs/translate-astra-string-wpml/\";s:8:\"category\";a:1:{i:0;s:15:\"translate-astra\";}}i:311;O:8:\"stdClass\":3:{s:5:\"title\";s:61:\"Know More about Astra Beta Versions? How to Download and Use?\";s:3:\"url\";s:45:\"https://wpastra.com/docs/about-beta-versions/\";s:8:\"category\";a:2:{i:0;s:7:\"general\";i:1;s:24:\"installation-and-updates\";}}i:312;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"How to Add Social Media Icons to Header?\";s:3:\"url\";s:65:\"https://wpastra.com/docs/how-to-add-social-media-icons-to-header/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:313;O:8:\"stdClass\":3:{s:5:\"title\";s:42:\"How to Translate Custom Layouts with WPML?\";s:3:\"url\";s:67:\"https://wpastra.com/docs/how-to-translate-custom-layouts-with-wpml/\";s:8:\"category\";a:2:{i:0;s:15:\"translate-astra\";i:1;s:21:\"custom-layouts-module\";}}i:314;O:8:\"stdClass\":3:{s:5:\"title\";s:22:\"Why Is My Logo Blurry?\";s:3:\"url\";s:47:\"https://wpastra.com/docs/why-is-my-logo-blurry/\";s:8:\"category\";a:1:{i:0;s:24:\"header-footer-before-3-0\";}}i:315;O:8:\"stdClass\":3:{s:5:\"title\";s:58:\"How to Disable Title on Posts, Pages, or Other Post Types?\";s:3:\"url\";s:52:\"https://wpastra.com/docs/disable-title-on-post-type/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:316;O:8:\"stdClass\":3:{s:5:\"title\";s:59:\"Disable Featured Image on Posts, Pages, or Other Post Types\";s:3:\"url\";s:61:\"https://wpastra.com/docs/disable-featured-image-on-post-type/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:317;O:8:\"stdClass\":3:{s:5:\"title\";s:81:\"How to Display &#8220;Last Updated&#8221; instead of &#8220;Published&#8221; Date\";s:3:\"url\";s:62:\"https://wpastra.com/docs/show-last-updated-not-published-date/\";s:8:\"category\";a:3:{i:0;s:8:\"blog-pro\";i:1;s:12:\"blog-filters\";i:2;s:4:\"blog\";}}i:318;O:8:\"stdClass\":3:{s:5:\"title\";s:36:\"How To Reset WordPress Installation?\";s:3:\"url\";s:61:\"https://wpastra.com/docs/how-to-reset-wordpress-installation/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:319;O:8:\"stdClass\":3:{s:5:\"title\";s:43:\"Mobile Header with Astra (Old Astra Header)\";s:3:\"url\";s:50:\"https://wpastra.com/docs/mobile-header-with-astra/\";s:8:\"category\";a:1:{i:0;s:13:\"mobile-header\";}}i:320;O:8:\"stdClass\":3:{s:5:\"title\";s:35:\"Disable featured image on all pages\";s:3:\"url\";s:61:\"https://wpastra.com/docs/disable-featured-image-on-all-pages/\";s:8:\"category\";a:0:{}}i:321;O:8:\"stdClass\":3:{s:5:\"title\";s:60:\"Elementor Error: The Content Area Was Not Found in Your Page\";s:3:\"url\";s:79:\"https://wpastra.com/docs/elementor-the-content-area-was-not-found-in-your-page/\";s:8:\"category\";a:0:{}}i:322;O:8:\"stdClass\":3:{s:5:\"title\";s:68:\"Sidebar / Container Options in Customizer for Learndash Not Working?\";s:3:\"url\";s:91:\"https://wpastra.com/docs/sidebar-container-options-in-customizer-for-learndash-not-working/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:323;O:8:\"stdClass\":3:{s:5:\"title\";s:38:\"About Icons Font That Comes with Astra\";s:3:\"url\";s:57:\"https://wpastra.com/docs/default-font-icon-list-in-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:324;O:8:\"stdClass\":3:{s:5:\"title\";s:29:\"How to Add Background Images?\";s:3:\"url\";s:82:\"https://wpastra.com/docs/how-to-add-background-images-to-various-sections-on-site/\";s:8:\"category\";a:3:{i:0;s:21:\"colors-background-pro\";i:1;s:24:\"header-footer-before-3-0\";i:2;s:7:\"sidebar\";}}i:325;O:8:\"stdClass\":3:{s:5:\"title\";s:56:\"Default Structured Data and Schema Markup in Astra Theme\";s:3:\"url\";s:68:\"https://wpastra.com/docs/structured-data-and-schema-markup-in-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:326;O:8:\"stdClass\":3:{s:5:\"title\";s:20:\"Below Header Section\";s:3:\"url\";s:46:\"https://wpastra.com/docs/below-header-section/\";s:8:\"category\";a:1:{i:0;s:15:\"header-sections\";}}i:327;O:8:\"stdClass\":3:{s:5:\"title\";s:20:\"Above Header Section\";s:3:\"url\";s:46:\"https://wpastra.com/docs/above-header-section/\";s:8:\"category\";a:1:{i:0;s:15:\"header-sections\";}}i:328;O:8:\"stdClass\":3:{s:5:\"title\";s:27:\"How to Install Astra Theme?\";s:3:\"url\";s:52:\"https://wpastra.com/docs/how-to-install-astra-theme/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:329;O:8:\"stdClass\":3:{s:5:\"title\";s:50:\"Not Receiving Update Notification for Astra Theme?\";s:3:\"url\";s:75:\"https://wpastra.com/docs/not-receiving-update-notification-for-astra-theme/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:330;O:8:\"stdClass\":3:{s:5:\"title\";s:62:\"Do Not See License Activation Form for Astra Pro Addon Plugin?\";s:3:\"url\";s:60:\"https://wpastra.com/docs/do-not-see-license-activation-form/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:331;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"How to Refresh / Flush WordPress Permalinks?\";s:3:\"url\";s:61:\"https://wpastra.com/docs/how-to-refresh-wordpress-permalinks/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:332;O:8:\"stdClass\":3:{s:5:\"title\";s:71:\"How to Merge Above/Below Header Menu with a Primary Menu in Responsive?\";s:3:\"url\";s:96:\"https://wpastra.com/docs/how-to-merge-above-below-header-menu-with-a-primary-menu-in-responsive/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:333;O:8:\"stdClass\":3:{s:5:\"title\";s:50:\"How to add Google Analytics code with Astra theme?\";s:3:\"url\";s:75:\"https://wpastra.com/docs/how-to-add-google-analytics-code-with-astra-theme/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:334;O:8:\"stdClass\":3:{s:5:\"title\";s:104:\"Getting error &#8211; The package could not be installed. The theme is missing the style.css stylesheet?\";s:3:\"url\";s:120:\"https://wpastra.com/docs/getting-error-the-package-could-not-be-installed-the-theme-is-missing-the-style-css-stylesheet/\";s:8:\"category\";a:2:{i:0;s:24:\"installation-and-updates\";i:1;s:15:\"troubleshooting\";}}i:335;O:8:\"stdClass\":3:{s:5:\"title\";s:34:\"Typography Options for WooCommerce\";s:3:\"url\";s:60:\"https://wpastra.com/docs/typography-options-for-woocommerce/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:336;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"Getting Started with Astra Pro Addon Plugin!\";s:3:\"url\";s:56:\"https://wpastra.com/docs/getting-started-with-astra-pro/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:337;O:8:\"stdClass\":3:{s:5:\"title\";s:48:\"Colors &#038; Background options for WooCommerce\";s:3:\"url\";s:67:\"https://wpastra.com/docs/colors-background-options-for-woocommerce/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:338;O:8:\"stdClass\":3:{s:5:\"title\";s:51:\"How to Activate License Key on WordPress Multisite?\";s:3:\"url\";s:76:\"https://wpastra.com/docs/how-to-activate-license-key-on-wordpress-multisite/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:339;O:8:\"stdClass\":3:{s:5:\"title\";s:37:\"How to Edit style.css in Child Theme?\";s:3:\"url\";s:62:\"https://wpastra.com/docs/how-to-edit-style-css-in-child-theme/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:340;O:8:\"stdClass\":3:{s:5:\"title\";s:61:\"How to Display WooCommerce Sidebar on Top for Mobile Devices?\";s:3:\"url\";s:77:\"https://wpastra.com/docs/how-to-display-woocommerce-sidebar-on-top-on-mobile/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:341;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"How to Set Background Image for the Site?\";s:3:\"url\";s:66:\"https://wpastra.com/docs/how-to-set-background-image-for-the-site/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:342;O:8:\"stdClass\":3:{s:5:\"title\";s:60:\"How to add Google Analytics code with Custom Layouts Module?\";s:3:\"url\";s:85:\"https://wpastra.com/docs/how-to-add-google-analytics-code-with-custom-layouts-module/\";s:8:\"category\";a:0:{}}i:343;O:8:\"stdClass\":3:{s:5:\"title\";s:124:\"Fix for- cURL error 51: SSL: no alternative certificate subject name matches target host name &#8216;websitedemos.net&#8217;\";s:3:\"url\";s:133:\"https://wpastra.com/docs/fix-for-curl-error-51-ssl-no-alternative-certificate-subject-name-matches-target-host-name-websitedemos-net/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:344;O:8:\"stdClass\":3:{s:5:\"title\";s:61:\"How to Remove Previous and Next Link from a Single Blog Post?\";s:3:\"url\";s:84:\"https://wpastra.com/docs/how-to-remove-previous-and-next-link-from-single-blog-post/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:345;O:8:\"stdClass\":3:{s:5:\"title\";s:15:\"Custom 404 Page\";s:3:\"url\";s:41:\"https://wpastra.com/docs/custom-404-page/\";s:8:\"category\";a:1:{i:0;s:21:\"custom-layouts-module\";}}i:346;O:8:\"stdClass\":3:{s:5:\"title\";s:27:\"Custom Layout &#8211; Hooks\";s:3:\"url\";s:45:\"https://wpastra.com/docs/custom-layout-hooks/\";s:8:\"category\";a:1:{i:0;s:21:\"custom-layouts-module\";}}i:347;O:8:\"stdClass\":3:{s:5:\"title\";s:13:\"Custom Footer\";s:3:\"url\";s:39:\"https://wpastra.com/docs/custom-footer/\";s:8:\"category\";a:1:{i:0;s:21:\"custom-layouts-module\";}}i:348;O:8:\"stdClass\":3:{s:5:\"title\";s:13:\"Custom Header\";s:3:\"url\";s:39:\"https://wpastra.com/docs/custom-header/\";s:8:\"category\";a:1:{i:0;s:21:\"custom-layouts-module\";}}i:349;O:8:\"stdClass\":3:{s:5:\"title\";s:61:\"Cannot edit Custom Layouts / Custom Layouts having 404 error?\";s:3:\"url\";s:84:\"https://wpastra.com/docs/cannot-edit-custom-layouts-custom-layouts-having-404-error/\";s:8:\"category\";a:1:{i:0;s:21:\"custom-layouts-module\";}}i:350;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"Astra Options Page &#8211; All Settings Explained\";s:3:\"url\";s:54:\"https://wpastra.com/docs/new-welcome-screen-for-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:351;O:8:\"stdClass\":3:{s:5:\"title\";s:25:\"How to White Label Astra?\";s:3:\"url\";s:50:\"https://wpastra.com/docs/how-to-white-label-astra/\";s:8:\"category\";a:1:{i:0;s:11:\"white-label\";}}i:352;O:8:\"stdClass\":3:{s:5:\"title\";s:32:\"How to Install Astra Pro Plugin?\";s:3:\"url\";s:63:\"https://wpastra.com/docs/how-to-install-astra-pro-addon-plugin/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:353;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"Backup Your Website in Less than 10 Minutes!\";s:3:\"url\";s:69:\"https://wpastra.com/docs/backup-your-website-in-less-than-10-minutes/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:354;O:8:\"stdClass\":3:{s:5:\"title\";s:29:\"How to use RGBA color picker?\";s:3:\"url\";s:54:\"https://wpastra.com/docs/how-to-use-rgba-color-picker/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:355;O:8:\"stdClass\":3:{s:5:\"title\";s:47:\"How to fix Fatal Error / White Screen of Death?\";s:3:\"url\";s:66:\"https://wpastra.com/docs/fixing-fatal-error-white-screen-of-death/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:356;O:8:\"stdClass\":3:{s:5:\"title\";s:65:\"Fix for &#8211;  Parse error: syntax error, unexpected T_FUNCTION\";s:3:\"url\";s:79:\"https://wpastra.com/docs/fixing-parse-error-syntax-error-unexpected-t-function/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:357;O:8:\"stdClass\":3:{s:5:\"title\";s:75:\"How to Disable the Loading of Astra&#8217;s Default Font File? (Astra.woff)\";s:3:\"url\";s:77:\"https://wpastra.com/docs/disable-loading-astras-default-font-file-astra-woff/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:358;O:8:\"stdClass\":3:{s:5:\"title\";s:48:\"Overview of LearnDash Integration in Astra Theme\";s:3:\"url\";s:56:\"https://wpastra.com/docs/learndash-integration-overview/\";s:8:\"category\";a:1:{i:0;s:9:\"learndash\";}}i:359;O:8:\"stdClass\":3:{s:5:\"title\";s:34:\"LearnDash Integration in Astra Pro\";s:3:\"url\";s:60:\"https://wpastra.com/docs/learndash-integration-in-astra-pro/\";s:8:\"category\";a:1:{i:0;s:27:\"learndash-astra-pro-modules\";}}i:360;O:8:\"stdClass\":3:{s:5:\"title\";s:25:\"Checkout Page WooCommerce\";s:3:\"url\";s:51:\"https://wpastra.com/docs/checkout-page-woocommerce/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:361;O:8:\"stdClass\":3:{s:5:\"title\";s:26:\"Single Product WooCommerce\";s:3:\"url\";s:52:\"https://wpastra.com/docs/single-product-woocommerce/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:362;O:8:\"stdClass\":3:{s:5:\"title\";s:84:\"How to Design a Product Catalog Page or Shop Page Using WooCommerce Module in Astra?\";s:3:\"url\";s:42:\"https://wpastra.com/docs/shop-woocommerce/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:363;O:8:\"stdClass\":3:{s:5:\"title\";s:27:\"WooCommerce Module Overview\";s:3:\"url\";s:53:\"https://wpastra.com/docs/woocommerce-module-overview/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:364;O:8:\"stdClass\":3:{s:5:\"title\";s:19:\"General WooCommerce\";s:3:\"url\";s:45:\"https://wpastra.com/docs/general-woocommerce/\";s:8:\"category\";a:0:{}}i:365;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"Typography Module\";s:3:\"url\";s:43:\"https://wpastra.com/docs/typography-module/\";s:8:\"category\";a:1:{i:0;s:14:\"typography-pro\";}}i:366;O:8:\"stdClass\":3:{s:5:\"title\";s:37:\"Global Typography &#8211; Astra Theme\";s:3:\"url\";s:41:\"https://wpastra.com/docs/typography-free/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:367;O:8:\"stdClass\":3:{s:5:\"title\";s:31:\"Colors &#038; Background Module\";s:3:\"url\";s:50:\"https://wpastra.com/docs/colors-background-module/\";s:8:\"category\";a:1:{i:0;s:21:\"colors-background-pro\";}}i:368;O:8:\"stdClass\":3:{s:5:\"title\";s:33:\"Global Colors &#8211; Astra Theme\";s:3:\"url\";s:43:\"https://wpastra.com/docs/colors-background/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:369;O:8:\"stdClass\":3:{s:5:\"title\";s:37:\"Astra WooCommerce Mini Cart Shortcode\";s:3:\"url\";s:55:\"https://wpastra.com/docs/shortcode-for-astra-mini-cart/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:370;O:8:\"stdClass\":3:{s:5:\"title\";s:34:\"LifterLMS Integration in Astra Pro\";s:3:\"url\";s:46:\"https://wpastra.com/docs/lifterlms-module-pro/\";s:8:\"category\";a:1:{i:0;s:19:\"lifterlms-astra-pro\";}}i:371;O:8:\"stdClass\":3:{s:5:\"title\";s:18:\"LifterLMS Overview\";s:3:\"url\";s:44:\"https://wpastra.com/docs/lifterlms-overview/\";s:8:\"category\";a:1:{i:0;s:9:\"lifterlms\";}}i:372;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"LifterLMS Integration in Free Astra Theme\";s:3:\"url\";s:40:\"https://wpastra.com/docs/lifterlms-free/\";s:8:\"category\";a:1:{i:0;s:9:\"lifterlms\";}}i:373;O:8:\"stdClass\":3:{s:5:\"title\";s:43:\"How to Manage Sidebars in Free Astra Theme?\";s:3:\"url\";s:38:\"https://wpastra.com/docs/sidebar-free/\";s:8:\"category\";a:1:{i:0;s:7:\"sidebar\";}}i:374;O:8:\"stdClass\":3:{s:5:\"title\";s:25:\"Single post with Blog Pro\";s:3:\"url\";s:46:\"https://wpastra.com/docs/single-post-blog-pro/\";s:8:\"category\";a:1:{i:0;s:8:\"blog-pro\";}}i:375;O:8:\"stdClass\":3:{s:5:\"title\";s:28:\"Blog / Archive with Blog Pro\";s:3:\"url\";s:47:\"https://wpastra.com/docs/blog-archive-blog-pro/\";s:8:\"category\";a:1:{i:0;s:8:\"blog-pro\";}}i:376;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"Blog Pro Overview\";s:3:\"url\";s:43:\"https://wpastra.com/docs/blog-pro-overview/\";s:8:\"category\";a:1:{i:0;s:8:\"blog-pro\";}}i:377;O:8:\"stdClass\":3:{s:5:\"title\";s:11:\"Single Post\";s:3:\"url\";s:37:\"https://wpastra.com/docs/single-post/\";s:8:\"category\";a:1:{i:0;s:4:\"blog\";}}i:378;O:8:\"stdClass\":3:{s:5:\"title\";s:14:\"Blog / Archive\";s:3:\"url\";s:38:\"https://wpastra.com/docs/blog-archive/\";s:8:\"category\";a:1:{i:0;s:4:\"blog\";}}i:379;O:8:\"stdClass\":3:{s:5:\"title\";s:13:\"Blog Overview\";s:3:\"url\";s:39:\"https://wpastra.com/docs/blog-overview/\";s:8:\"category\";a:1:{i:0;s:4:\"blog\";}}i:380;O:8:\"stdClass\":3:{s:5:\"title\";s:13:\"Scroll To Top\";s:3:\"url\";s:43:\"https://wpastra.com/docs/scroll-to-top-pro/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:381;O:8:\"stdClass\":3:{s:5:\"title\";s:23:\"Custom Layouts Overview\";s:3:\"url\";s:44:\"https://wpastra.com/docs/custom-layouts-pro/\";s:8:\"category\";a:1:{i:0;s:21:\"custom-layouts-module\";}}i:382;O:8:\"stdClass\":3:{s:5:\"title\";s:36:\"Footer Widgets Module with Astra Pro\";s:3:\"url\";s:50:\"https://wpastra.com/docs/footer-widgets-astra-pro/\";s:8:\"category\";a:1:{i:0;s:21:\"footer-widgets-module\";}}i:383;O:8:\"stdClass\":3:{s:5:\"title\";s:15:\"Footer Overview\";s:3:\"url\";s:41:\"https://wpastra.com/docs/footer-overview/\";s:8:\"category\";a:1:{i:0;s:24:\"header-footer-before-3-0\";}}i:384;O:8:\"stdClass\":3:{s:5:\"title\";s:10:\"Footer Bar\";s:3:\"url\";s:36:\"https://wpastra.com/docs/footer-bar/\";s:8:\"category\";a:1:{i:0;s:24:\"header-footer-before-3-0\";}}i:385;O:8:\"stdClass\":3:{s:5:\"title\";s:14:\"Footer Widgets\";s:3:\"url\";s:40:\"https://wpastra.com/docs/footer-widgets/\";s:8:\"category\";a:1:{i:0;s:24:\"header-footer-before-3-0\";}}i:386;O:8:\"stdClass\":3:{s:5:\"title\";s:19:\"Astra Meta Settings\";s:3:\"url\";s:44:\"https://wpastra.com/docs/page-meta-settings/\";s:8:\"category\";a:1:{i:0;s:13:\"meta-settings\";}}i:387;O:8:\"stdClass\":3:{s:5:\"title\";s:45:\"How to Manage Spacing in Headers Using Astra?\";s:3:\"url\";s:49:\"https://wpastra.com/docs/header-spacing-controls/\";s:8:\"category\";a:1:{i:0;s:7:\"spacing\";}}i:388;O:8:\"stdClass\":3:{s:5:\"title\";s:24:\"Sidebar Spacing Controls\";s:3:\"url\";s:50:\"https://wpastra.com/docs/sidebar-spacing-controls/\";s:8:\"category\";a:1:{i:0;s:7:\"spacing\";}}i:389;O:8:\"stdClass\":3:{s:5:\"title\";s:51:\"How to Manage Spacing on the Blog Page Using Astra?\";s:3:\"url\";s:55:\"https://wpastra.com/docs/blog-archive-spacing-controls/\";s:8:\"category\";a:1:{i:0;s:7:\"spacing\";}}i:390;O:8:\"stdClass\":3:{s:5:\"title\";s:23:\"Footer Spacing Controls\";s:3:\"url\";s:49:\"https://wpastra.com/docs/footer-spacing-controls/\";s:8:\"category\";a:1:{i:0;s:7:\"spacing\";}}i:391;O:8:\"stdClass\":3:{s:5:\"title\";s:21:\"Page Headers Overview\";s:3:\"url\";s:47:\"https://wpastra.com/docs/page-headers-overview/\";s:8:\"category\";a:1:{i:0;s:12:\"page-headers\";}}i:392;O:8:\"stdClass\":3:{s:5:\"title\";s:43:\"Header Sections Overview (Old Astra Header)\";s:3:\"url\";s:45:\"https://wpastra.com/docs/header-sections-pro/\";s:8:\"category\";a:1:{i:0;s:15:\"header-sections\";}}i:393;O:8:\"stdClass\":3:{s:5:\"title\";s:62:\"How to Set the Full-width/Stretched Container Layout in Astra?\";s:3:\"url\";s:63:\"https://wpastra.com/docs/full-width-stretched-container-layout/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:394;O:8:\"stdClass\":3:{s:5:\"title\";s:43:\"Full Width / Contained – Container Layout\";s:3:\"url\";s:63:\"https://wpastra.com/docs/full-width-contained-container-layout/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:395;O:8:\"stdClass\":3:{s:5:\"title\";s:38:\"Content Boxed &#8211; Container Layout\";s:3:\"url\";s:56:\"https://wpastra.com/docs/content-boxed-container-layout/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:396;O:8:\"stdClass\":3:{s:5:\"title\";s:26:\"Boxed – Container Layout\";s:3:\"url\";s:48:\"https://wpastra.com/docs/boxed-container-layout/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:397;O:8:\"stdClass\":3:{s:5:\"title\";s:26:\"Container Spacing Controls\";s:3:\"url\";s:52:\"https://wpastra.com/docs/container-spacing-controls/\";s:8:\"category\";a:1:{i:0;s:7:\"spacing\";}}i:398;O:8:\"stdClass\":3:{s:5:\"title\";s:30:\"Site Identity Spacing Controls\";s:3:\"url\";s:56:\"https://wpastra.com/docs/site-identity-spacing-controls/\";s:8:\"category\";a:1:{i:0;s:7:\"spacing\";}}i:399;O:8:\"stdClass\":3:{s:5:\"title\";s:22:\"Spacing Addon Overview\";s:3:\"url\";s:48:\"https://wpastra.com/docs/spacing-addon-overview/\";s:8:\"category\";a:1:{i:0;s:7:\"spacing\";}}i:400;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"Color and Typography for Primary Header\";s:3:\"url\";s:57:\"https://wpastra.com/docs/color-typography-primary-header/\";s:8:\"category\";a:1:{i:0;s:24:\"header-footer-before-3-0\";}}i:401;O:8:\"stdClass\":3:{s:5:\"title\";s:14:\"Primary Header\";s:3:\"url\";s:40:\"https://wpastra.com/docs/primary-header/\";s:8:\"category\";a:1:{i:0;s:24:\"header-footer-before-3-0\";}}i:402;O:8:\"stdClass\":3:{s:5:\"title\";s:15:\"Header Overview\";s:3:\"url\";s:41:\"https://wpastra.com/docs/header-overview/\";s:8:\"category\";a:1:{i:0;s:24:\"header-footer-before-3-0\";}}i:403;O:8:\"stdClass\":3:{s:5:\"title\";s:36:\"Global Container &#8211; Astra Theme\";s:3:\"url\";s:44:\"https://wpastra.com/docs/container-overview/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:404;O:8:\"stdClass\":3:{s:5:\"title\";s:71:\"How to Add Logo, Favicon, and Site Title with Astra? (Old Astra Header)\";s:3:\"url\";s:46:\"https://wpastra.com/docs/manage-site-identity/\";s:8:\"category\";a:1:{i:0;s:24:\"header-footer-before-3-0\";}}i:405;O:8:\"stdClass\":3:{s:5:\"title\";s:64:\"How to Add a Sticky Header or On-Scroll Fixed Header with Astra?\";s:3:\"url\";s:43:\"https://wpastra.com/docs/sticky-header-pro/\";s:8:\"category\";a:1:{i:0;s:13:\"sticky-header\";}}i:406;O:8:\"stdClass\":3:{s:5:\"title\";s:18:\"Padded Site Layout\";s:3:\"url\";s:44:\"https://wpastra.com/docs/padded-site-layout/\";s:8:\"category\";a:1:{i:0;s:11:\"site-layout\";}}i:407;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"Fluid Site Layout\";s:3:\"url\";s:43:\"https://wpastra.com/docs/fluid-site-layout/\";s:8:\"category\";a:1:{i:0;s:11:\"site-layout\";}}i:408;O:8:\"stdClass\":3:{s:5:\"title\";s:21:\"Max Width Site Layout\";s:3:\"url\";s:47:\"https://wpastra.com/docs/max-width-site-layout/\";s:8:\"category\";a:1:{i:0;s:11:\"site-layout\";}}i:409;O:8:\"stdClass\":3:{s:5:\"title\";s:22:\"Full Width Site Layout\";s:3:\"url\";s:48:\"https://wpastra.com/docs/full-width-site-layout/\";s:8:\"category\";a:1:{i:0;s:11:\"site-layout\";}}i:410;O:8:\"stdClass\":3:{s:5:\"title\";s:20:\"Site Layout Overview\";s:3:\"url\";s:46:\"https://wpastra.com/docs/site-layout-overview/\";s:8:\"category\";a:1:{i:0;s:11:\"site-layout\";}}i:411;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"Change the Astra Header Breakpoint Width\";s:3:\"url\";s:62:\"https://wpastra.com/docs/change-astra-header-breakpoint-width/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:412;O:8:\"stdClass\":3:{s:5:\"title\";s:43:\"How to Add Custom Javascript Code in Astra?\";s:3:\"url\";s:58:\"https://wpastra.com/docs/add-custom-javascript-code-astra/\";s:8:\"category\";a:0:{}}i:413;O:8:\"stdClass\":3:{s:5:\"title\";s:31:\"What is a Favicon or Site Icon?\";s:3:\"url\";s:43:\"https://wpastra.com/docs/favicon-site-icon/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:414;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"Complete List of WordPress Locale Codes\";s:3:\"url\";s:62:\"https://wpastra.com/docs/complete-list-wordpress-locale-codes/\";s:8:\"category\";a:0:{}}i:415;O:8:\"stdClass\":3:{s:5:\"title\";s:53:\"Fix for &#8211; The PCLZIP_ERR_BAD_FORMAT (-10) Error\";s:3:\"url\";s:60:\"https://wpastra.com/docs/fix-pclzip-err-bad-format-10-error/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:416;O:8:\"stdClass\":3:{s:5:\"title\";s:27:\"How to Add Custom PHP Code?\";s:3:\"url\";s:45:\"https://wpastra.com/docs/add-custom-php-code/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:417;O:8:\"stdClass\":3:{s:5:\"title\";s:52:\"WooCommerce Integration Overview in Free Astra Theme\";s:3:\"url\";s:58:\"https://wpastra.com/docs/woocommerce-integration-overview/\";s:8:\"category\";a:1:{i:0;s:16:\"woocommerce-free\";}}i:418;O:8:\"stdClass\":3:{s:5:\"title\";s:38:\"How to Replicate the Astra Screenshot?\";s:3:\"url\";s:52:\"https://wpastra.com/docs/replicating-the-screenshot/\";s:8:\"category\";a:0:{}}i:419;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"How to Turn Astra Multilingual with WPML?\";s:3:\"url\";s:59:\"https://wpastra.com/docs/turn-astra-multilingual-with-wpml/\";s:8:\"category\";a:1:{i:0;s:15:\"translate-astra\";}}i:420;O:8:\"stdClass\":3:{s:5:\"title\";s:81:\"How to Build Advanced Websites Based on Custom Post Types with Toolset and Astra?\";s:3:\"url\";s:57:\"https://wpastra.com/docs/custom-post-types-toolset-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:421;O:8:\"stdClass\":3:{s:5:\"title\";s:36:\"How to Get License Key of Astra Pro?\";s:3:\"url\";s:42:\"https://wpastra.com/docs/get-license-keys/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:422;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"How to Activate Astra Pro Addon License?\";s:3:\"url\";s:58:\"https://wpastra.com/docs/activate-astra-pro-addon-license/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:423;O:8:\"stdClass\":3:{s:5:\"title\";s:35:\"How to Design Bullets &#038; Lists?\";s:3:\"url\";s:46:\"https://wpastra.com/docs/design-bullets-lists/\";s:8:\"category\";a:1:{i:0;s:10:\"custom-css\";}}i:424;O:8:\"stdClass\":3:{s:5:\"title\";s:45:\"How to Disable Comments on WordPress website?\";s:3:\"url\";s:49:\"https://wpastra.com/docs/how-to-disable-comments/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:425;O:8:\"stdClass\":3:{s:5:\"title\";s:37:\"How to Highlight a Certain Menu Item?\";s:3:\"url\";s:53:\"https://wpastra.com/docs/highlight-certain-menu-item/\";s:8:\"category\";a:1:{i:0;s:10:\"custom-css\";}}i:426;O:8:\"stdClass\":3:{s:5:\"title\";s:76:\"How to Bulk Edit Astra Meta Settings on Multiple Pages &#038; Posts at Once?\";s:3:\"url\";s:76:\"https://wpastra.com/docs/bulk-edit-astra-meta-settings-multiple-pages-posts/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:427;O:8:\"stdClass\":3:{s:5:\"title\";s:14:\"Font Selection\";s:3:\"url\";s:40:\"https://wpastra.com/docs/font-selection/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:428;O:8:\"stdClass\":3:{s:5:\"title\";s:28:\"How to Renew Yearly License?\";s:3:\"url\";s:46:\"https://wpastra.com/docs/renew-yearly-license/\";s:8:\"category\";a:1:{i:0;s:17:\"account-and-store\";}}i:429;O:8:\"stdClass\":3:{s:5:\"title\";s:52:\"How to Increase PHP Time Limit for a WordPress Site?\";s:3:\"url\";s:65:\"https://wpastra.com/docs/increase-php-time-limit-wordpress-sites/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:430;O:8:\"stdClass\":3:{s:5:\"title\";s:25:\"Astra Pro WP CLI Commands\";s:3:\"url\";s:41:\"https://wpastra.com/docs/wp-cli-commands/\";s:8:\"category\";a:2:{i:0;s:7:\"general\";i:1;s:23:\"astra-theme-pro-filters\";}}i:431;O:8:\"stdClass\":3:{s:5:\"title\";s:29:\"How Do License Upgrades Work?\";s:3:\"url\";s:51:\"https://wpastra.com/docs/how-license-upgrades-work/\";s:8:\"category\";a:1:{i:0;s:17:\"account-and-store\";}}i:432;O:8:\"stdClass\":3:{s:5:\"title\";s:59:\"Recommended Settings for Beaver Builder and the Astra Theme\";s:3:\"url\";s:67:\"https://wpastra.com/docs/recommended-settings-beaver-builder-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:433;O:8:\"stdClass\":3:{s:5:\"title\";s:54:\"Recommended Settings for Elementor and the Astra Theme\";s:3:\"url\";s:60:\"https://wpastra.com/docs/recommended-settings-for-elementor/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:434;O:8:\"stdClass\":3:{s:5:\"title\";s:27:\"How to Force Check Updates?\";s:3:\"url\";s:45:\"https://wpastra.com/docs/force-check-updates/\";s:8:\"category\";a:0:{}}i:435;O:8:\"stdClass\":3:{s:5:\"title\";s:56:\"How to Disable or Change Position of the Featured Image?\";s:3:\"url\";s:64:\"https://wpastra.com/docs/disable-change-position-featured-image/\";s:8:\"category\";a:0:{}}i:436;O:8:\"stdClass\":3:{s:5:\"title\";s:42:\"How do I manage margin between paragraphs?\";s:3:\"url\";s:50:\"https://wpastra.com/docs/manage-margin-paragraphs/\";s:8:\"category\";a:0:{}}i:437;O:8:\"stdClass\":3:{s:5:\"title\";s:57:\"How to Update the Plugin Manually from WordPress Backend?\";s:3:\"url\";s:66:\"https://wpastra.com/docs/update-plugin-manually-wordpress-backend/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:438;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"How to Adjust the Width of Your Sidebar?\";s:3:\"url\";s:46:\"https://wpastra.com/docs/adjust-width-sidebar/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:439;O:8:\"stdClass\":3:{s:5:\"title\";s:51:\"Where Does Astra Primary Color Setting Take Effect?\";s:3:\"url\";s:65:\"https://wpastra.com/docs/astra-primary-color-setting-take-effect/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:440;O:8:\"stdClass\":3:{s:5:\"title\";s:59:\"How to Disable Header or Footer for a Landing Page or Post?\";s:3:\"url\";s:65:\"https://wpastra.com/docs/disable-header-footer-landing-page-post/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:441;O:8:\"stdClass\":3:{s:5:\"title\";s:54:\"What Is a Child Theme and How To Install It for Astra?\";s:3:\"url\";s:51:\"https://wpastra.com/docs/install-astra-child-theme/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:442;O:8:\"stdClass\":3:{s:5:\"title\";s:47:\"Increasing the PHP Memory Limit of Your Website\";s:3:\"url\";s:61:\"https://wpastra.com/docs/increasing-php-memory-limit-website/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:443;O:8:\"stdClass\":3:{s:5:\"title\";s:76:\"How to Translate Astra Theme / Plugins in Your Own Language using GlotPress?\";s:3:\"url\";s:42:\"https://wpastra.com/docs/how-to-translate/\";s:8:\"category\";a:1:{i:0;s:15:\"translate-astra\";}}i:444;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"Does Astra support Beaver Themer Plugin?\";s:3:\"url\";s:65:\"https://wpastra.com/docs/does-astra-support-beaver-themer-plugin/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:445;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"Remove Primary Navigation Menu with Hook\";s:3:\"url\";s:63:\"https://wpastra.com/docs/how-to-remove-primary-navigation-menu/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:446;O:8:\"stdClass\":3:{s:5:\"title\";s:33:\"Footer Custom Text Helper Strings\";s:3:\"url\";s:59:\"https://wpastra.com/docs/footer-custom-text-helper-strings/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:447;O:8:\"stdClass\":3:{s:5:\"title\";s:24:\"What is Astra Pro Addon?\";s:3:\"url\";s:41:\"https://wpastra.com/docs/astra-pro-addon/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:448;O:8:\"stdClass\":3:{s:5:\"title\";s:51:\"How to Change the Destination URL for Website Logo?\";s:3:\"url\";s:40:\"https://wpastra.com/docs/astra-logo-url/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:449;O:8:\"stdClass\":3:{s:5:\"title\";s:20:\"Using Hooks in Astra\";s:3:\"url\";s:37:\"https://wpastra.com/docs/using-hooks/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:450;O:8:\"stdClass\":3:{s:5:\"title\";s:59:\"Standard server 404 page showing instead of custom 404 page\";s:3:\"url\";s:85:\"https://wpastra.com/docs/standard-server-404-page-showing-instead-of-custom-404-page/\";s:8:\"category\";a:0:{}}i:451;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"How to Change the Default Astra Strings\";s:3:\"url\";s:47:\"https://wpastra.com/docs/astra-default-strings/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:452;O:8:\"stdClass\":3:{s:5:\"title\";s:55:\"How to Add Custom CSS Code Without Editing Theme Files?\";s:3:\"url\";s:48:\"https://wpastra.com/docs/adding-custom-css-code/\";s:8:\"category\";a:1:{i:0;s:10:\"custom-css\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("3812", "astra_partials_config_cache", "a:2:{s:8:\"settings\";a:834:{s:35:\"astra-settings[button-preset-style]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[theme-button-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[theme-button-bg-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[theme-button-border-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[theme-button-border-group-border-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:56:\"astra-settings[theme-button-border-group-border-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:28:\"astra-settings[button-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[button-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:31:\"astra-settings[button-bg-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[button-bg-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[theme-button-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";i:14;s:5:\"right\";i:28;s:6:\"bottom\";i:14;s:4:\"left\";i:28;}s:6:\"mobile\";a:4:{s:3:\"top\";i:12;s:5:\"right\";i:24;s:6:\"bottom\";i:12;s:4:\"left\";i:24;}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:53:\"astra-settings[theme-button-border-group-border-size]\";a:4:{s:7:\"default\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:29:\"astra-settings[button-radius]\";a:4:{s:7:\"default\";i:2;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[site-content-width]\";a:4:{s:7:\"default\";i:1200;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[narrow-container-max-width]\";a:4:{s:7:\"default\";i:750;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[different-retina-logo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[ast-header-retina-logo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:11:\"esc_url_raw\";}s:37:\"astra-settings[different-mobile-logo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[mobile-header-logo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";s:11:\"esc_url_raw\";}s:48:\"astra-settings[ast-header-responsive-logo-width]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[display-site-title-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[display-site-tagline-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:0;s:6:\"tablet\";i:0;s:6:\"mobile\";i:0;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[logo-title-inline]\";a:4:{s:7:\"default\";i:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[site-identity-title-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[header-color-site-title]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-color-h-site-title]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-color-site-tagline]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[site-icon-link]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:26:\"astra-settings[blog-width]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[blog-max-width]\";a:4:{s:7:\"default\";i:1200;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[blog-post-content]\";a:4:{s:7:\"default\";s:7:\"excerpt\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[archive-post-content-structure-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[blog-post-structure]\";a:4:{s:7:\"default\";a:2:{i:0;s:5:\"image\";i:1;s:10:\"title-meta\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:25:\"astra-settings[blog-meta]\";a:4:{s:7:\"default\";a:3:{i:0;s:8:\"comments\";i:1;s:8:\"category\";i:2;s:6:\"author\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:29:\"section-blog-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[blog-single-width]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[blog-single-max-width]\";a:4:{s:7:\"default\";i:1200;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[section-blog-single-spacing-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[single-post-outside-spacing]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:36:\"section-blog-single-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[site-sidebar-layout]\";a:4:{s:7:\"default\";s:10:\"no-sidebar\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[site-sidebar-width]\";a:4:{s:7:\"default\";i:30;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[site-sidebar-width-description]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";s:0:\"\";}s:37:\"astra-settings[ast-sidebar-pro-items]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[site-content-layout]\";a:4:{s:7:\"default\";s:23:\"content-boxed-container\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[surface-colors-title]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[site-layout-outside-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:8:{s:16:\"background-color\";s:25:\"var(--ast-global-color-4)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}s:6:\"tablet\";a:8:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}s:6:\"mobile\";a:8:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[content-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:8:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}s:6:\"tablet\";a:8:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}s:6:\"mobile\";a:8:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[ast-site-layout-button-link]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[global-color-palette]\";a:4:{s:7:\"default\";a:1:{s:7:\"palette\";a:9:{i:0;s:7:\"#046bd2\";i:1;s:7:\"#045cb4\";i:2;s:7:\"#1e293b\";i:3;s:7:\"#334155\";i:4;s:7:\"#f9fafb\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#e2e8f0\";i:7;s:7:\"#cbd5e1\";i:8;s:7:\"#94a3b8\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:20:\"astra-color-palettes\";a:4:{s:7:\"default\";a:2:{s:14:\"currentPalette\";s:9:\"palette_1\";s:8:\"palettes\";a:3:{s:9:\"palette_1\";a:9:{i:0;s:7:\"#046bd2\";i:1;s:7:\"#045cb4\";i:2;s:7:\"#1e293b\";i:3;s:7:\"#334155\";i:4;s:7:\"#f9fafb\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#e2e8f0\";i:7;s:7:\"#cbd5e1\";i:8;s:7:\"#94a3b8\";}s:9:\"palette_2\";a:9:{i:0;s:7:\"#0170B9\";i:1;s:7:\"#3a3a3a\";i:2;s:7:\"#3a3a3a\";i:3;s:7:\"#4B4F58\";i:4;s:7:\"#F5F5F5\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#F2F5F7\";i:7;s:7:\"#424242\";i:8;s:7:\"#000000\";}s:9:\"palette_3\";a:9:{i:0;s:7:\"#0170B9\";i:1;s:7:\"#3a3a3a\";i:2;s:7:\"#3a3a3a\";i:3;s:7:\"#4B4F58\";i:4;s:7:\"#F5F5F5\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#F2F5F7\";i:7;s:7:\"#424242\";i:8;s:7:\"#000000\";}}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[theme-color-divider-reset]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:27:\"astra-settings[theme-color]\";a:4:{s:7:\"default\";s:25:\"var(--ast-global-color-0)\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[base-link-colors-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:26:\"astra-settings[link-color]\";a:4:{s:7:\"default\";s:25:\"var(--ast-global-color-0)\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:28:\"astra-settings[link-h-color]\";a:4:{s:7:\"default\";s:25:\"var(--ast-global-color-1)\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:26:\"astra-settings[text-color]\";a:4:{s:7:\"default\";s:25:\"var(--ast-global-color-3)\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:28:\"astra-settings[border-color]\";a:4:{s:7:\"default\";s:25:\"var(--ast-global-color-6)\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[ast-blog-pro-items]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[font-size-page-title]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:26;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[ast-body-font-settings-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[ast-body-font-settings]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:32:\"astra-settings[body-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:33:\"astra-settings[body-font-variant]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:21:\"sanitize_font_variant\";}}s:32:\"astra-settings[body-font-weight]\";a:4:{s:7:\"default\";s:3:\"400\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:30:\"astra-settings[font-size-body]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:32:\"astra-settings[body-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:3:\"1.6\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[ast-headings-font-settings]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[ast-headings-font-settings-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[headings-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:37:\"astra-settings[headings-font-variant]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:21:\"sanitize_font_variant\";}}s:36:\"astra-settings[headings-font-weight]\";a:4:{s:7:\"default\";s:3:\"600\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:36:\"astra-settings[headings-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[para-margin-bottom]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[underline-content-links]\";a:4:{s:7:\"default\";b:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[ast-heading-h1-typo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[ast-heading-h2-typo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[ast-heading-h3-typo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[ast-heading-h4-typo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[ast-heading-h5-typo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[ast-heading-h6-typo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:28:\"astra-settings[wp-blocks-ui]\";a:4:{s:7:\"default\";s:7:\"comfort\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[wp-blocks-global-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:40:\"astra-settings[wp-blocks-ui-description]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";s:0:\"\";}s:30:\"astra-settings[font-family-h1]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:30:\"astra-settings[font-weight-h1]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:28:\"astra-settings[font-size-h1]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:40;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[font-extras-h1]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:3:\"1.4\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[font-family-h2]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:30:\"astra-settings[font-weight-h2]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:28:\"astra-settings[font-size-h2]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:32;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[font-extras-h2]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:4:\"1.25\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[font-family-h3]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:30:\"astra-settings[font-weight-h3]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:28:\"astra-settings[font-size-h3]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:26;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[font-extras-h3]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:3:\"1.2\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[font-family-h4]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:30:\"astra-settings[font-weight-h4]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:28:\"astra-settings[font-size-h4]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:24;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[font-extras-h4]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:3:\"1.2\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[font-family-h5]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:30:\"astra-settings[font-weight-h5]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:28:\"astra-settings[font-size-h5]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:20;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[font-extras-h5]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:3:\"1.2\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[font-family-h6]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:30:\"astra-settings[font-weight-h6]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:28:\"astra-settings[font-size-h6]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[font-extras-h6]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:4:\"1.25\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[font-size-site-title]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:26;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[font-size-site-tagline]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[ast-single-post-items]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:24:\"astra-typography-presets\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[enable-scroll-to-id]\";a:4:{s:7:\"default\";b:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[astra-pro-section-notice]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[single-portfolio-content-layout]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[single-portfolio-sidebar-layout]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:45:\"ast-dynamic-single-portfolio-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[ast-single-portfolio-title]\";a:4:{s:7:\"default\";b:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[ast-dynamic-single-portfolio-layout]\";a:4:{s:7:\"default\";s:8:\"layout-1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:62:\"astra-settings[ast-dynamic-single-portfolio-banner-width-type]\";a:4:{s:7:\"default\";s:9:\"fullwidth\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:64:\"astra-settings[ast-dynamic-single-portfolio-banner-custom-width]\";a:4:{s:7:\"default\";i:1200;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[ast-dynamic-single-portfolio-structure]\";a:4:{s:7:\"default\";a:2:{i:0;s:34:\"ast-dynamic-single-portfolio-title\";i:1;s:33:\"ast-dynamic-single-portfolio-meta\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:67:\"astra-settings[ast-dynamic-single-portfolio-featured-as-background]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:68:\"astra-settings[ast-dynamic-single-portfolio-banner-featured-overlay]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:65:\"astra-settings[ast-dynamic-single-portfolio-featured-help-notice]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:67:\"astra-settings[ast-dynamic-single-portfolio-taxonomy-clone-tracker]\";a:4:{s:7:\"default\";i:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[ast-dynamic-single-portfolio-metadata]\";a:4:{s:7:\"default\";a:3:{i:0;s:8:\"comments\";i:1;s:6:\"author\";i:2;s:4:\"date\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:65:\"astra-settings[ast-dynamic-single-portfolio-horizontal-alignment]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:63:\"astra-settings[ast-dynamic-single-portfolio-vertical-alignment]\";a:4:{s:7:\"default\";s:6:\"center\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-single-portfolio-banner-height]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-single-portfolio-elements-gap]\";a:4:{s:7:\"default\";i:10;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:62:\"astra-settings[ast-dynamic-single-portfolio-banner-background]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:8:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}s:6:\"tablet\";a:8:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}s:6:\"mobile\";a:8:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:63:\"astra-settings[ast-dynamic-single-portfolio-banner-title-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:62:\"astra-settings[ast-dynamic-single-portfolio-banner-text-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:62:\"astra-settings[ast-dynamic-single-portfolio-banner-link-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:68:\"astra-settings[ast-dynamic-single-portfolio-banner-link-hover-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:74:\"astra-settings[ast-dynamic-single-portfolio-banner-title-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:73:\"astra-settings[ast-dynamic-single-portfolio-banner-text-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:61:\"astra-settings[ast-dynamic-single-portfolio-text-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:61:\"astra-settings[ast-dynamic-single-portfolio-text-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:59:\"astra-settings[ast-dynamic-single-portfolio-text-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:61:\"astra-settings[ast-dynamic-single-portfolio-text-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:62:\"astra-settings[ast-dynamic-single-portfolio-title-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:62:\"astra-settings[ast-dynamic-single-portfolio-title-font-weight]\";a:4:{s:7:\"default\";s:3:\"600\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:60:\"astra-settings[ast-dynamic-single-portfolio-title-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:2:\"32\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:62:\"astra-settings[ast-dynamic-single-portfolio-title-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:73:\"astra-settings[ast-dynamic-single-portfolio-banner-meta-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:61:\"astra-settings[ast-dynamic-single-portfolio-meta-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:61:\"astra-settings[ast-dynamic-single-portfolio-meta-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:59:\"astra-settings[ast-dynamic-single-portfolio-meta-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:61:\"astra-settings[ast-dynamic-single-portfolio-meta-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-single-portfolio-banner-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:59:\"astra-settings[ast-dynamic-single-portfolio-banner-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:3;s:5:\"right\";i:3;s:6:\"bottom\";i:3;s:4:\"left\";i:3;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:53:\"astra-settings[ast-dynamic-single-portfolio-taxonomy]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:55:\"astra-settings[ast-dynamic-single-portfolio-taxonomy-1]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:55:\"astra-settings[ast-dynamic-single-portfolio-taxonomy-2]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[single-post-content-layout]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[single-post-sidebar-layout]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"ast-dynamic-single-post-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[ast-single-post-title]\";a:4:{s:7:\"default\";b:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[ast-dynamic-single-post-layout]\";a:4:{s:7:\"default\";s:8:\"layout-1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-single-post-banner-width-type]\";a:4:{s:7:\"default\";s:9:\"fullwidth\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:59:\"astra-settings[ast-dynamic-single-post-banner-custom-width]\";a:4:{s:7:\"default\";i:1200;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[ast-dynamic-single-post-structure]\";a:4:{s:7:\"default\";a:2:{i:0;s:29:\"ast-dynamic-single-post-title\";i:1;s:28:\"ast-dynamic-single-post-meta\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:62:\"astra-settings[ast-dynamic-single-post-featured-as-background]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:63:\"astra-settings[ast-dynamic-single-post-banner-featured-overlay]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[ast-dynamic-single-post-featured-help-notice]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:62:\"astra-settings[ast-dynamic-single-post-taxonomy-clone-tracker]\";a:4:{s:7:\"default\";i:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[ast-dynamic-single-post-metadata]\";a:4:{s:7:\"default\";a:3:{i:0;s:8:\"comments\";i:1;s:6:\"author\";i:2;s:4:\"date\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[ast-dynamic-single-post-horizontal-alignment]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-single-post-vertical-alignment]\";a:4:{s:7:\"default\";s:6:\"center\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[ast-dynamic-single-post-banner-height]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[ast-dynamic-single-post-elements-gap]\";a:4:{s:7:\"default\";i:10;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-single-post-banner-background]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:8:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}s:6:\"tablet\";a:8:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}s:6:\"mobile\";a:8:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-single-post-banner-title-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-single-post-banner-text-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-single-post-banner-link-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:63:\"astra-settings[ast-dynamic-single-post-banner-link-hover-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:69:\"astra-settings[ast-dynamic-single-post-banner-title-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:68:\"astra-settings[ast-dynamic-single-post-banner-text-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[ast-dynamic-single-post-text-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:56:\"astra-settings[ast-dynamic-single-post-text-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:54:\"astra-settings[ast-dynamic-single-post-text-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[ast-dynamic-single-post-text-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-single-post-title-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:57:\"astra-settings[ast-dynamic-single-post-title-font-weight]\";a:4:{s:7:\"default\";s:3:\"600\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:55:\"astra-settings[ast-dynamic-single-post-title-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:2:\"32\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-single-post-title-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:68:\"astra-settings[ast-dynamic-single-post-banner-meta-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[ast-dynamic-single-post-meta-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:56:\"astra-settings[ast-dynamic-single-post-meta-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:54:\"astra-settings[ast-dynamic-single-post-meta-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[ast-dynamic-single-post-meta-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[ast-dynamic-single-post-banner-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:54:\"astra-settings[ast-dynamic-single-post-banner-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:3;s:5:\"right\";i:3;s:6:\"bottom\";i:3;s:4:\"left\";i:3;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:48:\"astra-settings[ast-dynamic-single-post-taxonomy]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[ast-dynamic-single-post-taxonomy-1]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[ast-dynamic-single-post-taxonomy-2]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[single-page-content-layout]\";a:4:{s:7:\"default\";s:15:\"plain-container\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[single-page-sidebar-layout]\";a:4:{s:7:\"default\";s:10:\"no-sidebar\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"ast-dynamic-single-page-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[ast-single-page-title]\";a:4:{s:7:\"default\";b:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[ast-dynamic-single-page-layout]\";a:4:{s:7:\"default\";s:8:\"layout-1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-single-page-banner-width-type]\";a:4:{s:7:\"default\";s:9:\"fullwidth\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:59:\"astra-settings[ast-dynamic-single-page-banner-custom-width]\";a:4:{s:7:\"default\";i:1200;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[ast-dynamic-single-page-structure]\";a:4:{s:7:\"default\";a:2:{i:0;s:29:\"ast-dynamic-single-page-image\";i:1;s:29:\"ast-dynamic-single-page-title\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:62:\"astra-settings[ast-dynamic-single-page-featured-as-background]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:63:\"astra-settings[ast-dynamic-single-page-banner-featured-overlay]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[ast-dynamic-single-page-featured-help-notice]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:62:\"astra-settings[ast-dynamic-single-page-taxonomy-clone-tracker]\";a:4:{s:7:\"default\";i:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[ast-dynamic-single-page-metadata]\";a:4:{s:7:\"default\";a:3:{i:0;s:8:\"comments\";i:1;s:6:\"author\";i:2;s:4:\"date\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[ast-dynamic-single-page-horizontal-alignment]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-single-page-vertical-alignment]\";a:4:{s:7:\"default\";s:6:\"center\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[ast-dynamic-single-page-banner-height]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[ast-dynamic-single-page-elements-gap]\";a:4:{s:7:\"default\";i:10;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-single-page-banner-background]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:8:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}s:6:\"tablet\";a:8:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}s:6:\"mobile\";a:8:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-single-page-banner-title-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-single-page-banner-text-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-single-page-banner-link-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:63:\"astra-settings[ast-dynamic-single-page-banner-link-hover-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:69:\"astra-settings[ast-dynamic-single-page-banner-title-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:68:\"astra-settings[ast-dynamic-single-page-banner-text-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[ast-dynamic-single-page-text-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:56:\"astra-settings[ast-dynamic-single-page-text-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:54:\"astra-settings[ast-dynamic-single-page-text-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[ast-dynamic-single-page-text-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-single-page-title-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:57:\"astra-settings[ast-dynamic-single-page-title-font-weight]\";a:4:{s:7:\"default\";s:3:\"600\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:55:\"astra-settings[ast-dynamic-single-page-title-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:2:\"32\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-single-page-title-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:68:\"astra-settings[ast-dynamic-single-page-banner-meta-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[ast-dynamic-single-page-meta-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:56:\"astra-settings[ast-dynamic-single-page-meta-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:54:\"astra-settings[ast-dynamic-single-page-meta-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[ast-dynamic-single-page-meta-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[ast-dynamic-single-page-banner-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:54:\"astra-settings[ast-dynamic-single-page-banner-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:3;s:5:\"right\";i:3;s:6:\"bottom\";i:3;s:4:\"left\";i:3;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:48:\"astra-settings[archive-portfolio-content-layout]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[archive-portfolio-sidebar-layout]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:46:\"ast-dynamic-archive-portfolio-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[ast-archive-portfolio-title]\";a:4:{s:7:\"default\";b:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[ast-dynamic-archive-portfolio-layout]\";a:4:{s:7:\"default\";s:8:\"layout-1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:63:\"astra-settings[ast-dynamic-archive-portfolio-banner-width-type]\";a:4:{s:7:\"default\";s:9:\"fullwidth\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:65:\"astra-settings[ast-dynamic-archive-portfolio-banner-custom-width]\";a:4:{s:7:\"default\";i:1200;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:55:\"astra-settings[ast-dynamic-archive-portfolio-structure]\";a:4:{s:7:\"default\";a:2:{i:0;s:35:\"ast-dynamic-archive-portfolio-title\";i:1;s:41:\"ast-dynamic-archive-portfolio-description\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-archive-portfolio-custom-title]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:66:\"astra-settings[ast-dynamic-archive-portfolio-custom-title-support]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:64:\"astra-settings[ast-dynamic-archive-portfolio-custom-description]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:72:\"astra-settings[ast-dynamic-archive-portfolio-custom-description-support]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:66:\"astra-settings[ast-dynamic-archive-portfolio-horizontal-alignment]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:64:\"astra-settings[ast-dynamic-archive-portfolio-vertical-alignment]\";a:4:{s:7:\"default\";s:6:\"center\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:59:\"astra-settings[ast-dynamic-archive-portfolio-banner-height]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-archive-portfolio-elements-gap]\";a:4:{s:7:\"default\";i:10;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:63:\"astra-settings[ast-dynamic-archive-portfolio-banner-image-type]\";a:4:{s:7:\"default\";s:4:\"none\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:62:\"astra-settings[ast-dynamic-archive-portfolio-banner-custom-bg]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:8:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}s:6:\"tablet\";a:8:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}s:6:\"mobile\";a:8:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:64:\"astra-settings[ast-dynamic-archive-portfolio-banner-title-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:63:\"astra-settings[ast-dynamic-archive-portfolio-banner-text-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:63:\"astra-settings[ast-dynamic-archive-portfolio-banner-link-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:69:\"astra-settings[ast-dynamic-archive-portfolio-banner-link-hover-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:75:\"astra-settings[ast-dynamic-archive-portfolio-banner-title-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:74:\"astra-settings[ast-dynamic-archive-portfolio-banner-text-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:62:\"astra-settings[ast-dynamic-archive-portfolio-text-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:62:\"astra-settings[ast-dynamic-archive-portfolio-text-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:60:\"astra-settings[ast-dynamic-archive-portfolio-text-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:62:\"astra-settings[ast-dynamic-archive-portfolio-text-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:63:\"astra-settings[ast-dynamic-archive-portfolio-title-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:63:\"astra-settings[ast-dynamic-archive-portfolio-title-font-weight]\";a:4:{s:7:\"default\";s:3:\"600\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:61:\"astra-settings[ast-dynamic-archive-portfolio-title-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:2:\"32\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:63:\"astra-settings[ast-dynamic-archive-portfolio-title-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:59:\"astra-settings[ast-dynamic-archive-portfolio-banner-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:60:\"astra-settings[ast-dynamic-archive-portfolio-banner-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:3;s:5:\"right\";i:3;s:6:\"bottom\";i:3;s:4:\"left\";i:3;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:43:\"astra-settings[archive-post-content-layout]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[archive-post-sidebar-layout]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:41:\"ast-dynamic-archive-post-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[ast-archive-post-title]\";a:4:{s:7:\"default\";b:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[ast-dynamic-archive-post-layout]\";a:4:{s:7:\"default\";s:8:\"layout-1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-archive-post-banner-width-type]\";a:4:{s:7:\"default\";s:9:\"fullwidth\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[ast-dynamic-archive-post-banner-custom-width]\";a:4:{s:7:\"default\";i:1200;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[ast-dynamic-archive-post-structure]\";a:4:{s:7:\"default\";a:2:{i:0;s:30:\"ast-dynamic-archive-post-title\";i:1;s:36:\"ast-dynamic-archive-post-description\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[ast-dynamic-archive-post-custom-title]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:61:\"astra-settings[ast-dynamic-archive-post-custom-title-support]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:59:\"astra-settings[ast-dynamic-archive-post-custom-description]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:67:\"astra-settings[ast-dynamic-archive-post-custom-description-support]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:61:\"astra-settings[ast-dynamic-archive-post-horizontal-alignment]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:59:\"astra-settings[ast-dynamic-archive-post-vertical-alignment]\";a:4:{s:7:\"default\";s:6:\"center\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[ast-dynamic-archive-post-banner-height]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[ast-dynamic-archive-post-elements-gap]\";a:4:{s:7:\"default\";i:10;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-archive-post-banner-image-type]\";a:4:{s:7:\"default\";s:4:\"none\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-archive-post-banner-custom-bg]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:8:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}s:6:\"tablet\";a:8:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}s:6:\"mobile\";a:8:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:59:\"astra-settings[ast-dynamic-archive-post-banner-title-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-archive-post-banner-text-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-archive-post-banner-link-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:64:\"astra-settings[ast-dynamic-archive-post-banner-link-hover-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:70:\"astra-settings[ast-dynamic-archive-post-banner-title-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:69:\"astra-settings[ast-dynamic-archive-post-banner-text-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-archive-post-text-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:57:\"astra-settings[ast-dynamic-archive-post-text-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:55:\"astra-settings[ast-dynamic-archive-post-text-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-archive-post-text-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-archive-post-title-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:58:\"astra-settings[ast-dynamic-archive-post-title-font-weight]\";a:4:{s:7:\"default\";s:3:\"600\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:56:\"astra-settings[ast-dynamic-archive-post-title-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:2:\"32\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-archive-post-title-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[ast-dynamic-archive-post-banner-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:55:\"astra-settings[ast-dynamic-archive-post-banner-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:3;s:5:\"right\";i:3;s:6:\"bottom\";i:3;s:4:\"left\";i:3;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:55:\"astra-settings[ast-dynamic-archive-post-banner-on-blog]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[related-posts-section-heading]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[enable-related-posts]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[related-posts-title]\";a:4:{s:7:\"default\";s:21:\"Entradas relacionadas\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[releted-posts-title-alignment]\";a:4:{s:7:\"default\";s:4:\"left\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[related-posts-structure]\";a:4:{s:7:\"default\";a:2:{i:0;s:14:\"featured-image\";i:1;s:10:\"title-meta\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[related-posts-meta-structure]\";a:4:{s:7:\"default\";a:3:{i:0;s:8:\"comments\";i:1;s:8:\"category\";i:2;s:6:\"author\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[enable-related-posts-excerpt]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[related-posts-excerpt-count]\";a:4:{s:7:\"default\";i:25;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[related-posts-total-count]\";a:4:{s:7:\"default\";i:2;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[related-posts-grid-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:7:\"2-equal\";s:6:\"tablet\";s:7:\"2-equal\";s:6:\"mobile\";s:4:\"full\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[related-posts-query-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[related-posts-based-on]\";a:4:{s:7:\"default\";s:10:\"categories\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[related-posts-order-by]\";a:4:{s:7:\"default\";s:4:\"date\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[related-posts-order]\";a:4:{s:7:\"default\";s:3:\"asc\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[related-posts-colors-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[related-posts-section-title-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[related-posts-title-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[related-posts-meta-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[related-posts-content-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[related-posts-text-color]\";a:4:{s:7:\"default\";s:25:\"var(--ast-global-color-2)\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[related-posts-link-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[related-posts-design-section-heading]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[related-posts-title-color]\";a:4:{s:7:\"default\";s:25:\"var(--ast-global-color-2)\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:46:\"astra-settings[related-posts-background-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:40:\"astra-settings[related-posts-meta-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[related-posts-link-hover-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[related-posts-meta-link-hover-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[related-posts-title-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:47:\"astra-settings[related-posts-title-font-weight]\";a:4:{s:7:\"default\";s:3:\"500\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:45:\"astra-settings[related-posts-title-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:2:\"20\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[related-posts-title-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:1:\"1\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:55:\"astra-settings[related-posts-section-title-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:55:\"astra-settings[related-posts-section-title-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:53:\"astra-settings[related-posts-section-title-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:2:\"26\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:55:\"astra-settings[related-posts-section-title-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:3:\"1.6\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[related-posts-meta-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:46:\"astra-settings[related-posts-meta-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:44:\"astra-settings[related-posts-meta-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:2:\"14\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[related-posts-meta-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:3:\"1.6\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[related-posts-content-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:49:\"astra-settings[related-posts-content-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:47:\"astra-settings[related-posts-content-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[related-posts-content-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[transparent-header-bg-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:62:\"astra-settings[transparent-header-color-site-title-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:64:\"astra-settings[transparent-header-color-h-site-title-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[transparent-menu-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[transparent-menu-bg-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[transparent-menu-h-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[transparent-submenu-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:55:\"astra-settings[transparent-submenu-bg-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[transparent-submenu-h-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:65:\"astra-settings[transparent-content-section-link-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:67:\"astra-settings[transparent-content-section-link-h-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[transparent-header-enable]\";a:4:{s:7:\"default\";i:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[transparent-header-disable-archive]\";a:4:{s:7:\"default\";i:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[transparent-header-disable-index]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:61:\"astra-settings[transparent-header-disable-latest-posts-index]\";a:4:{s:7:\"default\";i:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[transparent-header-disable-page]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[transparent-header-disable-posts]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[transparent-header-on-devices]\";a:4:{s:7:\"default\";s:4:\"both\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[different-transparent-logo]\";a:4:{s:7:\"default\";i:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[transparent-header-logo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";s:11:\"esc_url_raw\";}s:49:\"astra-settings[different-transparent-retina-logo]\";a:4:{s:7:\"default\";i:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[transparent-header-retina-logo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";s:11:\"esc_url_raw\";}s:45:\"astra-settings[transparent-header-logo-width]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:150;s:6:\"tablet\";i:120;s:6:\"mobile\";i:100;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[transparent-header-main-sep]\";a:4:{s:7:\"default\";i:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[transparent-header-main-sep-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:47:\"astra-settings[divider-sec-transparent-styling]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[transparent-header-colors]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[transparent-header-colors-menu]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[transparent-header-colors-submenu]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"section-transparent-header-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:61:\"astra-settings[transparent-header-social-text-colors-content]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:67:\"astra-settings[transparent-header-social-background-colors-content]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[transparent-header-social-icons-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:55:\"astra-settings[transparent-header-social-icons-h-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[transparent-header-social-icons-bg-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[transparent-header-social-icons-bg-h-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[transparent-header-html-colors-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[transparent-header-html-text-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:50:\"astra-settings[transparent-header-html-link-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:52:\"astra-settings[transparent-header-html-link-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:52:\"astra-settings[transparent-header-search-icon-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:62:\"astra-settings[transparent-header-search-box-background-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:53:\"astra-settings[transparent-header-buttons-text-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:59:\"astra-settings[transparent-header-buttons-background-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[transparent-header-button-text-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:54:\"astra-settings[transparent-header-button-text-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:50:\"astra-settings[transparent-header-button-bg-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:52:\"astra-settings[transparent-header-button-bg-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:46:\"astra-settings[transparent-account-icon-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:51:\"astra-settings[transparent-account-type-text-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:51:\"astra-settings[transparent-header-toggle-btn-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[transparent-header-toggle-btn-bg-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[transparent-header-toggle-border-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[breadcrumb-position]\";a:4:{s:7:\"default\";s:4:\"none\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[breadcrumb-position-none-notice]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";s:0:\"\";}s:49:\"astra-settings[breadcrumb-disable-layout-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[breadcrumb-disable-home-page]\";a:4:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[breadcrumb-disable-blog-posts-page]\";a:4:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[breadcrumb-disable-search]\";a:4:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[breadcrumb-disable-archive]\";a:4:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[breadcrumb-disable-single-page]\";a:4:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[breadcrumb-disable-single-post]\";a:4:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[breadcrumb-disable-singular]\";a:4:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[breadcrumb-disable-404-page]\";a:4:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[breadcrumb-alignment]\";a:4:{s:7:\"default\";s:4:\"left\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[breadcrumb-spacing]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:45:\"astra-settings[breadcrumb-separator-selector]\";a:4:{s:7:\"default\";s:5:\"\\003E\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[breadcrumb-separator]\";a:4:{s:7:\"default\";s:5:\"\\00bb\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"section-breadcrumb-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[breadcrumb-color-section-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[breadcrumb-bg-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[breadcrumb-active-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[breadcrumb-separator-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[section-breadcrumb-link-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[breadcrumb-text-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[breadcrumb-hover-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[section-breadcrumb-typo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[breadcrumb-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:38:\"astra-settings[breadcrumb-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:36:\"astra-settings[breadcrumb-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[breadcrumb-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[scroll-to-top-enable]\";a:4:{s:7:\"default\";b:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[scroll-to-top-on-devices]\";a:4:{s:7:\"default\";s:4:\"both\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[scroll-to-top-icon-position]\";a:4:{s:7:\"default\";s:5:\"right\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[scroll-to-top-icon-size]\";a:4:{s:7:\"default\";i:15;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[scroll-on-top-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[scroll-on-top-bg-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[scroll-to-top-icon-radius]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[scroll-to-top-icon-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:43:\"astra-settings[scroll-to-top-icon-bg-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:42:\"astra-settings[scroll-to-top-icon-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:45:\"astra-settings[scroll-to-top-icon-h-bg-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:38:\"section-scroll-to-top-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[enable-scroll-to-top-notice]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";s:0:\"\";}s:34:\"astra-settings[heading-base-color]\";a:4:{s:7:\"default\";s:25:\"var(--ast-global-color-2)\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:38:\"astra-settings[button-text-typography]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[font-family-button]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:34:\"astra-settings[font-weight-button]\";a:4:{s:7:\"default\";s:3:\"500\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:32:\"astra-settings[font-size-button]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:2:\"16\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[font-extras-button]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";i:1;s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"section-header-builder-layout-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[cloned-component-track]\";a:4:{s:7:\"default\";a:12:{s:13:\"header-button\";i:2;s:13:\"footer-button\";i:2;s:11:\"header-html\";i:2;s:11:\"footer-html\";i:2;s:11:\"header-menu\";i:2;s:13:\"header-widget\";i:4;s:13:\"footer-widget\";i:4;s:19:\"header-social-icons\";i:1;s:19:\"footer-social-icons\";i:1;s:14:\"header-divider\";i:0;s:14:\"footer-divider\";i:0;s:13:\"removed-items\";a:0:{}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[builder-header]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[header-desktop-items]\";a:4:{s:7:\"default\";a:4:{s:5:\"popup\";a:1:{s:13:\"popup_content\";a:1:{i:0;s:11:\"mobile-menu\";}}s:5:\"above\";a:5:{s:10:\"above_left\";a:0:{}s:17:\"above_left_center\";a:0:{}s:12:\"above_center\";a:0:{}s:18:\"above_right_center\";a:0:{}s:11:\"above_right\";a:0:{}}s:7:\"primary\";a:5:{s:12:\"primary_left\";a:1:{i:0;s:4:\"logo\";}s:19:\"primary_left_center\";a:0:{}s:14:\"primary_center\";a:0:{}s:20:\"primary_right_center\";a:0:{}s:13:\"primary_right\";a:1:{i:0;s:6:\"menu-1\";}}s:5:\"below\";a:5:{s:10:\"below_left\";a:0:{}s:17:\"below_left_center\";a:0:{}s:12:\"below_center\";a:0:{}s:18:\"below_right_center\";a:0:{}s:11:\"below_right\";a:0:{}}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[header-desktop-draggable-items]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[header-mobile-items]\";a:4:{s:7:\"default\";a:4:{s:5:\"popup\";a:1:{s:13:\"popup_content\";a:1:{i:0;s:11:\"mobile-menu\";}}s:5:\"above\";a:3:{s:10:\"above_left\";a:0:{}s:12:\"above_center\";a:0:{}s:11:\"above_right\";a:0:{}}s:7:\"primary\";a:3:{s:12:\"primary_left\";a:1:{i:0;s:4:\"logo\";}s:14:\"primary_center\";a:0:{}s:13:\"primary_right\";a:1:{i:0;s:14:\"mobile-trigger\";}}s:5:\"below\";a:3:{s:10:\"below_left\";a:0:{}s:12:\"below_center\";a:0:{}s:11:\"below_right\";a:0:{}}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[header-mobile-draggable-items]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-mobile-popup-items]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[header-transparent-link-heading]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[header-transparant-link]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[hb-header-main-layout-width]\";a:4:{s:7:\"default\";s:7:\"content\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[section-header-builder-layout-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:40:\"astra-settings[header-builder-pro-items]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:46:\"section-footer-builder-layout-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[builder-footer]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[footer-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"tablet\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"mobile\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[footer-bg-obj-responsive-description]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";s:0:\"\";}s:36:\"astra-settings[footer-desktop-items]\";a:4:{s:7:\"default\";a:3:{s:5:\"above\";a:5:{s:7:\"above_1\";a:0:{}s:7:\"above_2\";a:0:{}s:7:\"above_3\";a:0:{}s:7:\"above_4\";a:0:{}s:7:\"above_5\";a:0:{}}s:7:\"primary\";a:5:{s:9:\"primary_1\";a:0:{}s:9:\"primary_2\";a:0:{}s:9:\"primary_3\";a:0:{}s:9:\"primary_4\";a:0:{}s:9:\"primary_5\";a:0:{}}s:5:\"below\";a:5:{s:7:\"below_1\";a:1:{i:0;s:9:\"copyright\";}s:7:\"below_2\";a:0:{}s:7:\"below_3\";a:0:{}s:7:\"below_4\";a:0:{}s:7:\"below_5\";a:0:{}}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[footer-draggable-items]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[footer-builder-pro-items]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[section-footer-builder-layout-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[section-footer-builder-layout-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:52:\"astra-settings[section-footer-builder-layout-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:45:\"section-above-header-builder-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[hba-header-height]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:50;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[hba-header-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:6:{s:16:\"background-color\";s:7:\"#ffffff\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"tablet\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"mobile\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[hba-header-bottom-border-color]\";a:4:{s:7:\"default\";s:7:\"#eaeaea\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:36:\"astra-settings[hba-header-separator]\";a:4:{s:7:\"default\";i:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[section-above-header-builder-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[section-above-header-builder-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:51:\"astra-settings[section-above-header-builder-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:66:\"astra-settings[section-above-header-builder-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:45:\"section-below-header-builder-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[hbb-header-height]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:60;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[hbb-header-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:6:{s:16:\"background-color\";s:7:\"#eeeeee\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"tablet\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"mobile\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[hbb-header-bottom-border-color]\";a:4:{s:7:\"default\";s:7:\"#eaeaea\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:36:\"astra-settings[hbb-header-separator]\";a:4:{s:7:\"default\";i:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[section-below-header-builder-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[section-below-header-builder-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:51:\"astra-settings[section-below-header-builder-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:66:\"astra-settings[section-below-header-builder-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[astra-sidebar-widgets-header-widget-1-margin]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:75:\"astra-settings[astra-sidebar-widgets-header-widget-1-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[astra-sidebar-widgets-header-widget-2-margin]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:75:\"astra-settings[astra-sidebar-widgets-header-widget-2-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:46:\"section-header-mobile-trigger-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[header-trigger-icon]\";a:4:{s:7:\"default\";s:4:\"menu\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[mobile-header-toggle-btn-style]\";a:4:{s:7:\"default\";s:7:\"minimal\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[mobile-header-menu-label]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[mobile-header-toggle-btn-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:46:\"astra-settings[mobile-header-toggle-icon-size]\";a:4:{s:7:\"default\";i:20;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[mobile-header-toggle-btn-bg-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:52:\"astra-settings[mobile-header-toggle-btn-border-size]\";a:4:{s:7:\"default\";a:4:{s:3:\"top\";i:1;s:5:\"right\";i:1;s:6:\"bottom\";i:1;s:4:\"left\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[mobile-header-toggle-border-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:50:\"astra-settings[mobile-header-toggle-border-radius]\";a:4:{s:7:\"default\";i:2;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[section-header-mobile-trigger-margin-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[section-header-mobile-trigger-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:45:\"astra-settings[mobile-header-label-font-size]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"section-popup-header-builder-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[mobile-header-type]\";a:4:{s:7:\"default\";s:8:\"dropdown\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:32:\"astra-settings[off-canvas-slide]\";a:4:{s:7:\"default\";s:5:\"right\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[header-builder-menu-toggle-target]\";a:4:{s:7:\"default\";s:4:\"icon\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[header-offcanvas-content-alignment]\";a:4:{s:7:\"default\";s:10:\"flex-start\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[off-canvas-background]\";a:4:{s:7:\"default\";a:6:{s:16:\"background-color\";s:7:\"#ffffff\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:23:\"sanitize_background_obj\";}}s:38:\"astra-settings[off-canvas-close-color]\";a:4:{s:7:\"default\";s:7:\"#3a3a3a\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:40:\"astra-settings[off-canvas-inner-spacing]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[off-canvas-padding]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"section-primary-header-builder-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:32:\"astra-settings[hb-header-height]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:80;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[hb-header-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:6:{s:16:\"background-color\";s:7:\"#ffffff\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"tablet\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"mobile\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[hb-header-main-sep-color]\";a:4:{s:7:\"default\";s:7:\"#eaeaea\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:34:\"astra-settings[hb-header-main-sep]\";a:4:{s:7:\"default\";i:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[section-primary-header-builder-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[section-primary-header-builder-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:53:\"astra-settings[section-primary-header-builder-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:68:\"astra-settings[section-primary-header-builder-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[logo-title-settings-link]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:30:\"title_tagline-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[title_tagline-margin-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[title_tagline-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:51:\"astra-settings[title_tagline-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:36:\"section-hb-button-1-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[header-button1-text]\";a:4:{s:7:\"default\";s:6:\"Botón\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[header-button1-link-option]\";a:4:{s:7:\"default\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:13:\"sanitize_link\";}}s:47:\"astra-settings[header-button1-text-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[header-button1-background-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-button1-text-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[header-button1-text-h-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-button1-back-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[header-button1-back-h-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:65:\"astra-settings[header-button1-builder-button-border-colors-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[header-button1-border-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[header-button1-border-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[header-button1-border-size]\";a:4:{s:7:\"default\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[header-button1-border-radius]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[header-button1-text-typography]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[header-button1-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:42:\"astra-settings[header-button1-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:40:\"astra-settings[header-button1-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[header-button1-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[section-hb-button-1-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[section-hb-button-1-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[section-hb-button-1-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"12\";s:5:\"right\";s:2:\"20\";s:6:\"bottom\";s:2:\"12\";s:4:\"left\";s:2:\"20\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:42:\"astra-settings[section-hb-button-1-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:55:\"astra-settings[section-hb-html-1-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[font-size-section-hb-html-1]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"section-hb-html-1-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:29:\"astra-settings[header-html-1]\";a:4:{s:7:\"default\";s:31:\"Insertar el código HTML aquí.\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[header-html-1color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-html-1-link-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[header-html-1link-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-html-1link-h-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[section-hb-html-1-margin-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[section-hb-html-1-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:55:\"astra-settings[section-hb-html-2-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[font-size-section-hb-html-2]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"section-hb-html-2-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:29:\"astra-settings[header-html-2]\";a:4:{s:7:\"default\";s:31:\"Insertar el código HTML aquí.\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[header-html-2color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-html-2-link-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[header-html-2link-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-html-2link-h-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[section-hb-html-2-margin-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[section-hb-html-2-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:55:\"astra-settings[section-hb-menu-1-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:34:\"section-hb-menu-1-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[header-menu1-create-menu-link]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[header-menu1-menu-hover-animation]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[header-menu1-submenu-heading]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[header-menu1-submenu-width]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[header-menu1-submenu-container-animation]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[header-menu1-submenu-container-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[header-menu1-submenu-item-b-size]\";a:4:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[header-menu1-submenu-item-b-color]\";a:4:{s:7:\"default\";s:7:\"#eaeaea\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:47:\"astra-settings[header-menu1-submenu-top-offset]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[header-menu1-submenu-border]\";a:4:{s:7:\"default\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[header-menu1-submenu-b-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:50:\"astra-settings[header-menu1-submenu-border-radius]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[header-menu1-submenu-item-border]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[header-menu1-menu-stack-on-mobile]\";a:4:{s:7:\"default\";b:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[section-hb-menu-1-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:40:\"astra-settings[header-menu1-text-colors]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[header-menu1-background-colors]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[header-menu1-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[header-menu1-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"tablet\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"mobile\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[header-menu1-h-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[header-menu1-h-bg-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[header-menu1-a-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[header-menu1-a-bg-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[header-1-font-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[header-menu1-header-menu-typography]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-menu1-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:40:\"astra-settings[header-menu1-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:38:\"astra-settings[header-menu1-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-menu1-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-1-spacing-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-menu1-menu-spacing]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:55:\"astra-settings[section-hb-menu-2-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:34:\"section-hb-menu-2-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[header-menu2-create-menu-link]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[header-menu2-menu-hover-animation]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[header-menu2-submenu-heading]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[header-menu2-submenu-width]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[header-menu2-submenu-container-animation]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[header-menu2-submenu-container-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[header-menu2-submenu-item-b-size]\";a:4:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[header-menu2-submenu-item-b-color]\";a:4:{s:7:\"default\";s:7:\"#eaeaea\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:47:\"astra-settings[header-menu2-submenu-top-offset]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[header-menu2-submenu-border]\";a:4:{s:7:\"default\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[header-menu2-submenu-b-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:50:\"astra-settings[header-menu2-submenu-border-radius]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[header-menu2-submenu-item-border]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[header-menu2-menu-stack-on-mobile]\";a:4:{s:7:\"default\";b:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[section-hb-menu-2-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:40:\"astra-settings[header-menu2-text-colors]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[header-menu2-background-colors]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[header-menu2-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[header-menu2-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"tablet\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"mobile\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[header-menu2-h-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[header-menu2-h-bg-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[header-menu2-a-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[header-menu2-a-bg-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[header-2-font-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[header-menu2-header-menu-typography]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-menu2-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:40:\"astra-settings[header-menu2-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:38:\"astra-settings[header-menu2-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-menu2-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-2-spacing-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-menu2-menu-spacing]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:38:\"section-header-search-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-search-icon-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-search-icon-space]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";i:18;s:6:\"mobile\";i:18;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[section-header-search-margin-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[section-header-search-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:59:\"astra-settings[section-header-search-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[header-account-tabs]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[header-account-login-heading]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[header-account-login-style]\";a:4:{s:7:\"default\";s:4:\"icon\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[header-account-logged-in-text]\";a:4:{s:7:\"default\";s:9:\"Mi cuenta\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-account-login-link]\";a:4:{s:7:\"default\";a:3:{s:3:\"url\";s:0:\"\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:13:\"sanitize_link\";}}s:45:\"astra-settings[header-account-logout-heading]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[header-account-logout-style]\";a:4:{s:7:\"default\";s:4:\"icon\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[header-account-logout-preview]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[header-account-logged-out-text]\";a:4:{s:7:\"default\";s:7:\"Acceder\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[header-account-logout-link]\";a:4:{s:7:\"default\";a:3:{s:3:\"url\";s:41:\"https://procuradorgalicia.es/wp-login.php\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:13:\"sanitize_link\";}}s:42:\"astra-settings[header-account-image-width]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:2:\"40\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-account-icon-size]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";i:18;s:6:\"mobile\";i:18;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-account-icon-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:50:\"astra-settings[header-account-text-design-options]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[header-account-type-text-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:46:\"astra-settings[header-account-spacing-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[header-account-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:48:\"astra-settings[font-size-section-header-account]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[section-header-account-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:63:\"astra-settings[section-hb-social-icons-1-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[font-size-section-hb-social-icons-1]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"section-hb-social-icons-1-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[header-social-1-color-type]\";a:4:{s:7:\"default\";s:6:\"custom\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[header-social-1-icon-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[header-social-1-label-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[header-social-1-background-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[header-social-1-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[header-social-1-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[header-social-1-label-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[header-social-1-label-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-social-1-bg-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[header-social-1-bg-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[header-social-icons-1]\";a:4:{s:7:\"default\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[header-social-1-label-toggle]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[header-social-1-space]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-social-1-bg-space]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[header-social-1-size]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[header-social-1-radius]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[section-hb-social-icons-1-margin-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[section-hb-social-icons-1-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:43:\"section-header-mobile-menu-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[header-mobile-menu-create-menu-link]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[header-mobile-menu-submenu-item-border]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[header-mobile-menu-divider-colors-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[header-mobile-menu-submenu-item-b-size]\";a:4:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:55:\"astra-settings[header-mobile-menu-submenu-item-b-color]\";a:4:{s:7:\"default\";s:7:\"#eaeaea\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:46:\"astra-settings[header-mobile-menu-link-colors]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[header-mobile-menu-background-colors]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[header-mobile-menu-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:25:\"var(--ast-global-color-3)\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[header-mobile-menu-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"tablet\";a:6:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"mobile\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[header-mobile-menu-h-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:25:\"var(--ast-global-color-1)\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[header-mobile-menu-h-bg-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:25:\"var(--ast-global-color-4)\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[header-mobile-menu-a-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:25:\"var(--ast-global-color-1)\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[header-mobile-menu-a-bg-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:25:\"var(--ast-global-color-4)\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[header-mobile-menu-header-typo-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[header-mobile-menu-header-menu-typography]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[header-mobile-menu-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:46:\"astra-settings[header-mobile-menu-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:44:\"astra-settings[header-mobile-menu-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[font-extras-header-mobile-menu]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:55:\"astra-settings[header-mobile-menu-menu-spacing-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[header-mobile-menu-menu-spacing]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:49:\"astra-settings[section-header-mobile-menu-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:64:\"astra-settings[section-header-mobile-menu-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:45:\"section-above-footer-builder-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[hba-footer-column]\";a:4:{s:7:\"default\";s:1:\"2\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[hba-footer-layout]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:7:\"2-equal\";s:6:\"tablet\";s:7:\"2-equal\";s:6:\"mobile\";s:4:\"full\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[hba-footer-layout-width]\";a:4:{s:7:\"default\";s:7:\"content\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[hba-footer-height]\";a:4:{s:7:\"default\";i:60;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[hba-footer-vertical-alignment]\";a:4:{s:7:\"default\";s:10:\"flex-start\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:25:\"astra-settings[hba-stack]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:5:\"stack\";s:6:\"tablet\";s:5:\"stack\";s:6:\"mobile\";s:5:\"stack\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[hba-footer-separator]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[hba-footer-top-border-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:44:\"astra-settings[hba-footer-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:6:{s:16:\"background-color\";s:7:\"#eeeeee\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"tablet\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"mobile\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[hba-inner-spacing]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[section-above-footer-builder-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[section-above-footer-builder-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:51:\"astra-settings[section-above-footer-builder-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:66:\"astra-settings[section-above-footer-builder-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:45:\"section-below-footer-builder-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[hbb-footer-column]\";a:4:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[hbb-footer-layout]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:4:\"full\";s:6:\"tablet\";s:4:\"full\";s:6:\"mobile\";s:4:\"full\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[hbb-footer-layout-width]\";a:4:{s:7:\"default\";s:7:\"content\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[hbb-footer-height]\";a:4:{s:7:\"default\";i:80;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[hbb-footer-vertical-alignment]\";a:4:{s:7:\"default\";s:10:\"flex-start\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:25:\"astra-settings[hbb-stack]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:5:\"stack\";s:6:\"tablet\";s:5:\"stack\";s:6:\"mobile\";s:5:\"stack\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[hbb-footer-separator]\";a:4:{s:7:\"default\";i:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[hbb-footer-top-border-color]\";a:4:{s:7:\"default\";s:25:\"var(--ast-global-color-6)\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:44:\"astra-settings[hbb-footer-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:6:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"tablet\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"mobile\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[hbb-inner-spacing]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[section-below-footer-builder-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[section-below-footer-builder-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:51:\"astra-settings[section-below-footer-builder-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:66:\"astra-settings[section-below-footer-builder-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:41:\"section-footer-copyright-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[footer-copyright-editor]\";a:4:{s:7:\"default\";s:77:\"Copyright [copyright] [current_year] [site_title] | Powered by [theme_author]\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[footer-copyright-alignment]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[footer-copyright-color]\";a:4:{s:7:\"default\";s:25:\"var(--ast-global-color-3)\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:55:\"astra-settings[section-footer-copyright-margin-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[section-footer-copyright-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:50:\"astra-settings[font-size-section-footer-copyright]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:62:\"astra-settings[section-footer-copyright-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:36:\"section-footer-menu-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[footer-create-menu-link]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[footer-menu-layout]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:10:\"horizontal\";s:6:\"tablet\";s:8:\"vertical\";s:6:\"mobile\";s:8:\"vertical\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[footer-menu-alignment]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[footer-menu-link-colors]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[footer-menu-background-colors]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[footer-menu-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[footer-menu-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"tablet\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"mobile\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[footer-menu-h-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[footer-menu-h-bg-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[footer-menu-a-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[footer-menu-a-bg-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[footer-main-menu-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[footer-main-menu-spacing]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:2:\"20\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:2:\"20\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:42:\"astra-settings[section-footer-menu-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:37:\"astra-settings[footer-menu-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[section-footer-menu-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:63:\"astra-settings[section-fb-social-icons-1-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[font-size-section-fb-social-icons-1]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"section-fb-social-icons-1-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[footer-social-1-color-type]\";a:4:{s:7:\"default\";s:6:\"custom\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[footer-social-1-icon-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[footer-social-1-label-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[footer-social-1-background-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[footer-social-1-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[footer-social-1-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[footer-social-1-label-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[footer-social-1-label-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[footer-social-1-bg-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[footer-social-1-bg-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[footer-social-icons-1]\";a:4:{s:7:\"default\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[footer-social-1-label-toggle]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[footer-social-1-space]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[footer-social-1-bg-space]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[footer-social-1-size]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[footer-social-1-radius]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[section-fb-social-icons-1-margin-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[section-fb-social-icons-1-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:41:\"astra-settings[footer-social-1-alignment]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"section-primary-footer-builder-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:32:\"astra-settings[hb-footer-column]\";a:4:{s:7:\"default\";s:1:\"3\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:32:\"astra-settings[hb-footer-layout]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:7:\"3-equal\";s:6:\"tablet\";s:7:\"3-equal\";s:6:\"mobile\";s:4:\"full\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[hb-footer-layout-width]\";a:4:{s:7:\"default\";s:7:\"content\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[hb-footer-vertical-alignment]\";a:4:{s:7:\"default\";s:10:\"flex-start\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:24:\"astra-settings[hb-stack]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:5:\"stack\";s:6:\"tablet\";s:5:\"stack\";s:6:\"mobile\";s:5:\"stack\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[hb-footer-main-sep]\";a:4:{s:7:\"default\";i:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[hb-footer-main-sep-color]\";a:4:{s:7:\"default\";s:7:\"#e6e6e6\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:43:\"astra-settings[hb-footer-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:6:{s:16:\"background-color\";s:7:\"#f9f9f9\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"tablet\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"mobile\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:32:\"astra-settings[hb-inner-spacing]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[section-primary-footer-builder-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[section-primary-footer-builder-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:53:\"astra-settings[section-primary-footer-builder-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:68:\"astra-settings[section-primary-footer-builder-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:55:\"astra-settings[section-fb-html-1-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[font-size-section-fb-html-1]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"section-fb-html-1-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:29:\"astra-settings[footer-html-1]\";a:4:{s:7:\"default\";s:31:\"Insertar el código HTML aquí.\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[footer-html-1color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[footer-html-1-link-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[footer-html-1link-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[footer-html-1link-h-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[section-fb-html-1-margin-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[section-fb-html-1-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:39:\"astra-settings[footer-html-1-alignment]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:55:\"astra-settings[section-fb-html-2-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[font-size-section-fb-html-2]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"section-fb-html-2-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:29:\"astra-settings[footer-html-2]\";a:4:{s:7:\"default\";s:31:\"Insertar el código HTML aquí.\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[footer-html-2color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[footer-html-2-link-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[footer-html-2link-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[footer-html-2link-h-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[section-fb-html-2-margin-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[section-fb-html-2-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:39:\"astra-settings[footer-html-2-alignment]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[astra-sidebar-widgets-footer-widget-1-margin]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:41:\"astra-settings[footer-widget-alignment-1]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:75:\"astra-settings[astra-sidebar-widgets-footer-widget-1-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[astra-sidebar-widgets-footer-widget-2-margin]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:41:\"astra-settings[footer-widget-alignment-2]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:75:\"astra-settings[astra-sidebar-widgets-footer-widget-2-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[astra-sidebar-widgets-footer-widget-3-margin]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:41:\"astra-settings[footer-widget-alignment-3]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:75:\"astra-settings[astra-sidebar-widgets-footer-widget-3-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[astra-sidebar-widgets-footer-widget-4-margin]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:41:\"astra-settings[footer-widget-alignment-4]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:75:\"astra-settings[astra-sidebar-widgets-footer-widget-4-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}}s:8:\"partials\";a:38:{s:37:\"astra-settings[different-retina-logo]\";a:4:{s:8:\"selector\";s:14:\".site-branding\";s:15:\"render_callback\";s:35:\"Astra_Builder_Header::site_identity\";s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:1;}s:38:\"astra-settings[ast-header-retina-logo]\";a:4:{s:8:\"selector\";s:14:\".site-branding\";s:15:\"render_callback\";s:35:\"Astra_Builder_Header::site_identity\";s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:1;}s:37:\"astra-settings[different-mobile-logo]\";a:4:{s:8:\"selector\";s:14:\".site-branding\";s:15:\"render_callback\";s:35:\"Astra_Builder_Header::site_identity\";s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:1;}s:33:\"astra-settings[logo-title-inline]\";a:4:{s:8:\"selector\";s:14:\".site-branding\";s:15:\"render_callback\";s:35:\"Astra_Builder_Header::site_identity\";s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:1;}s:35:\"astra-settings[related-posts-title]\";a:4:{s:8:\"selector\";s:57:\".ast-related-posts-title-section .ast-related-posts-title\";s:15:\"render_callback\";a:2:{i:0;s:26:\"Astra_Related_Posts_Loader\";i:1;s:26:\"render_related_posts_title\";}s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:1;}s:39:\"astra-settings[transparent-header-logo]\";a:4:{s:8:\"selector\";s:64:\".ast-replace-site-logo-transparent .site-branding .site-logo-img\";s:15:\"render_callback\";s:0:\"\";s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:1;}s:35:\"astra-settings[breadcrumb-position]\";a:4:{s:8:\"selector\";s:54:\".ast-breadcrumbs-wrapper .ast-breadcrumbs .trail-items\";s:15:\"render_callback\";s:0:\"\";s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:1;}s:36:\"astra-settings[header-desktop-items]\";a:4:{s:8:\"selector\";s:9:\"#masthead\";s:15:\"render_callback\";a:2:{i:0;O:20:\"Astra_Builder_Header\":0:{}i:1;s:21:\"header_builder_markup\";}s:18:\"containerInclusive\";b:1;s:15:\"fallbackRefresh\";b:1;}s:35:\"astra-settings[header-mobile-items]\";a:4:{s:8:\"selector\";s:9:\"#masthead\";s:15:\"render_callback\";a:2:{i:0;r:6832;i:1;s:21:\"header_builder_markup\";}s:18:\"containerInclusive\";b:1;s:15:\"fallbackRefresh\";b:1;}s:41:\"astra-settings[header-mobile-popup-items]\";a:4:{s:8:\"selector\";s:25:\"#ast-mobile-popup-wrapper\";s:15:\"render_callback\";a:2:{i:0;r:6832;i:1;s:12:\"mobile_popup\";}s:18:\"containerInclusive\";b:1;s:15:\"fallbackRefresh\";b:1;}s:36:\"astra-settings[footer-desktop-items]\";a:4:{s:8:\"selector\";s:12:\".site-footer\";s:15:\"render_callback\";a:2:{i:0;O:20:\"Astra_Builder_Footer\":0:{}i:1;s:13:\"footer_markup\";}s:18:\"containerInclusive\";b:1;s:15:\"fallbackRefresh\";b:1;}s:35:\"astra-settings[header-trigger-icon]\";a:4:{s:8:\"selector\";s:16:\".ast-button-wrap\";s:15:\"render_callback\";a:2:{i:0;s:27:\"Astra_Builder_UI_Controller\";i:1;s:21:\"render_mobile_trigger\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:1;}s:46:\"astra-settings[mobile-header-toggle-btn-style]\";a:4:{s:8:\"selector\";s:16:\".ast-button-wrap\";s:15:\"render_callback\";a:2:{i:0;s:27:\"Astra_Builder_UI_Controller\";i:1;s:21:\"render_mobile_trigger\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:1;}s:40:\"astra-settings[mobile-header-menu-label]\";a:4:{s:8:\"selector\";s:16:\".ast-button-wrap\";s:15:\"render_callback\";a:2:{i:0;s:27:\"Astra_Builder_UI_Controller\";i:1;s:21:\"render_mobile_trigger\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:1;}s:35:\"astra-settings[header-button1-text]\";a:4:{s:8:\"selector\";s:20:\".ast-header-button-1\";s:15:\"render_callback\";a:2:{i:0;r:6832;i:1;s:8:\"button_1\";}s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:0;}s:42:\"astra-settings[header-button1-link-option]\";a:4:{s:8:\"selector\";s:20:\".ast-header-button-1\";s:15:\"render_callback\";a:2:{i:0;r:6832;i:1;s:8:\"button_1\";}s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:1;}s:29:\"astra-settings[header-html-1]\";a:4:{s:8:\"selector\";s:18:\".ast-header-html-1\";s:15:\"render_callback\";a:2:{i:0;r:6832;i:1;s:13:\"header_html_1\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:0;}s:29:\"astra-settings[header-html-2]\";a:4:{s:8:\"selector\";s:18:\".ast-header-html-2\";s:15:\"render_callback\";a:2:{i:0;r:6832;i:1;s:13:\"header_html_2\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:0;}s:42:\"astra-settings[header-account-login-style]\";a:4:{s:8:\"selector\";s:19:\".ast-header-account\";s:15:\"render_callback\";a:2:{i:0;s:27:\"Astra_Builder_UI_Controller\";i:1;s:14:\"render_account\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:1;}s:45:\"astra-settings[header-account-logged-in-text]\";a:4:{s:8:\"selector\";s:19:\".ast-header-account\";s:15:\"render_callback\";a:2:{i:0;s:27:\"Astra_Builder_UI_Controller\";i:1;s:14:\"render_account\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:1;}s:41:\"astra-settings[header-account-login-link]\";a:4:{s:8:\"selector\";s:19:\".ast-header-account\";s:15:\"render_callback\";a:2:{i:0;s:27:\"Astra_Builder_UI_Controller\";i:1;s:14:\"render_account\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:1;}s:43:\"astra-settings[header-account-logout-style]\";a:4:{s:8:\"selector\";s:19:\".ast-header-account\";s:15:\"render_callback\";a:2:{i:0;s:27:\"Astra_Builder_UI_Controller\";i:1;s:14:\"render_account\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:1;}s:45:\"astra-settings[header-account-logout-preview]\";a:4:{s:8:\"selector\";s:19:\".ast-header-account\";s:15:\"render_callback\";a:2:{i:0;s:27:\"Astra_Builder_UI_Controller\";i:1;s:14:\"render_account\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:1;}s:46:\"astra-settings[header-account-logged-out-text]\";a:4:{s:8:\"selector\";s:19:\".ast-header-account\";s:15:\"render_callback\";a:2:{i:0;s:27:\"Astra_Builder_UI_Controller\";i:1;s:14:\"render_account\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:1;}s:37:\"astra-settings[header-social-icons-1]\";a:4:{s:8:\"selector\";s:25:\".ast-header-social-1-wrap\";s:15:\"render_callback\";a:2:{i:0;r:6832;i:1;s:15:\"header_social_1\";}s:18:\"containerInclusive\";b:1;s:15:\"fallbackRefresh\";b:0;}s:44:\"astra-settings[header-social-1-label-toggle]\";a:4:{s:8:\"selector\";s:25:\".ast-header-social-1-wrap\";s:15:\"render_callback\";a:2:{i:0;r:6832;i:1;s:15:\"header_social_1\";}s:18:\"containerInclusive\";b:1;s:15:\"fallbackRefresh\";b:0;}s:33:\"astra-settings[hba-footer-column]\";a:4:{s:8:\"selector\";s:23:\".site-above-footer-wrap\";s:15:\"render_callback\";a:2:{i:0;r:6853;i:1;s:12:\"above_footer\";}s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:1;}s:25:\"astra-settings[hba-stack]\";a:4:{s:8:\"selector\";s:23:\".site-above-footer-wrap\";s:15:\"render_callback\";a:2:{i:0;r:6853;i:1;s:12:\"above_footer\";}s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:1;}s:33:\"astra-settings[hbb-footer-column]\";a:4:{s:8:\"selector\";s:23:\".site-below-footer-wrap\";s:15:\"render_callback\";a:2:{i:0;r:6853;i:1;s:12:\"below_footer\";}s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:1;}s:25:\"astra-settings[hbb-stack]\";a:4:{s:8:\"selector\";s:23:\".site-below-footer-wrap\";s:15:\"render_callback\";a:2:{i:0;r:6853;i:1;s:12:\"below_footer\";}s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:1;}s:39:\"astra-settings[footer-copyright-editor]\";a:4:{s:8:\"selector\";s:21:\".ast-footer-copyright\";s:15:\"render_callback\";a:2:{i:0;r:6853;i:1;s:16:\"footer_copyright\";}s:18:\"containerInclusive\";b:1;s:15:\"fallbackRefresh\";b:1;}s:34:\"astra-settings[footer-menu-layout]\";a:4:{s:8:\"selector\";s:59:\".footer-widget-area[data-section=\"section-footer-menu\"] nav\";s:15:\"render_callback\";a:2:{i:0;r:6853;i:1;s:11:\"footer_menu\";}s:18:\"containerInclusive\";b:1;s:15:\"fallbackRefresh\";b:1;}s:37:\"astra-settings[footer-social-icons-1]\";a:4:{s:8:\"selector\";s:25:\".ast-footer-social-1-wrap\";s:15:\"render_callback\";a:2:{i:0;r:6853;i:1;s:15:\"footer_social_1\";}s:18:\"containerInclusive\";b:1;s:15:\"fallbackRefresh\";b:0;}s:44:\"astra-settings[footer-social-1-label-toggle]\";a:4:{s:8:\"selector\";s:25:\".ast-footer-social-1-wrap\";s:15:\"render_callback\";a:2:{i:0;r:6853;i:1;s:15:\"footer_social_1\";}s:18:\"containerInclusive\";b:1;s:15:\"fallbackRefresh\";b:0;}s:32:\"astra-settings[hb-footer-column]\";a:4:{s:8:\"selector\";s:25:\".site-primary-footer-wrap\";s:15:\"render_callback\";a:2:{i:0;r:6853;i:1;s:14:\"primary_footer\";}s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:1;}s:24:\"astra-settings[hb-stack]\";a:4:{s:8:\"selector\";s:25:\".site-primary-footer-wrap\";s:15:\"render_callback\";a:2:{i:0;r:6853;i:1;s:14:\"primary_footer\";}s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:1;}s:29:\"astra-settings[footer-html-1]\";a:4:{s:8:\"selector\";s:18:\".ast-footer-html-1\";s:15:\"render_callback\";a:2:{i:0;r:6853;i:1;s:13:\"footer_html_1\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:0;}s:29:\"astra-settings[footer-html-2]\";a:4:{s:8:\"selector\";s:18:\".ast-footer-html-2\";s:15:\"render_callback\";a:2:{i:0;r:6853;i:1;s:13:\"footer_html_2\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:0;}}}", "no");
INSERT INTO `wp_options` VALUES("3840", "theme_switched_via_customizer", "1", "yes");
INSERT INTO `wp_options` VALUES("3841", "site_logo", "1434", "yes");
INSERT INTO `wp_options` VALUES("3842", "customize_stashed_theme_mods", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("3863", "penci_import_demo_data", "a:4:{s:5:\"posts\";a:6:{s:10:\"attachment\";a:31:{i:35;s:0:\"\";i:216;s:0:\"\";i:217;s:0:\"\";i:218;s:0:\"\";i:219;s:0:\"\";i:220;s:0:\"\";i:221;s:0:\"\";i:222;s:0:\"\";i:223;s:0:\"\";i:224;s:0:\"\";i:225;s:0:\"\";i:226;s:0:\"\";i:227;s:0:\"\";i:233;s:0:\"\";i:237;s:0:\"\";i:263;s:0:\"\";i:267;s:0:\"\";i:270;s:0:\"\";i:277;s:0:\"\";i:286;s:0:\"\";i:295;s:0:\"\";i:303;s:0:\"\";i:304;s:0:\"\";i:305;s:0:\"\";i:329;s:0:\"\";i:360;s:0:\"\";i:362;s:0:\"\";i:367;s:0:\"\";i:377;s:0:\"\";i:392;s:0:\"\";i:408;s:0:\"\";}s:13:\"nav_menu_item\";a:11:{i:16;s:0:\"\";i:17;s:0:\"\";i:18;s:0:\"\";i:19;s:0:\"\";i:20;s:0:\"\";i:242;s:0:\"\";i:243;s:0:\"\";i:244;s:0:\"\";i:247;s:0:\"\";i:248;s:0:\"\";i:249;s:0:\"\";}s:10:\"mc4wp-form\";a:1:{i:257;s:0:\"\";}s:4:\"page\";a:5:{i:6;s:0:\"\";i:836;s:0:\"\";i:10;s:0:\"\";i:12;s:0:\"\";i:14;s:0:\"\";}s:4:\"post\";a:12:{i:190;s:0:\"\";i:191;s:0:\"\";i:192;s:0:\"\";i:193;s:0:\"\";i:194;s:0:\"\";i:195;s:0:\"\";i:196;s:0:\"\";i:197;s:0:\"\";i:198;s:0:\"\";i:199;s:0:\"\";i:200;s:0:\"\";i:203;s:0:\"\";}s:18:\"wpcf7_contact_form\";a:1:{i:343;s:0:\"\";}}s:5:\"terms\";a:3:{s:8:\"category\";a:4:{i:12;s:0:\"\";i:13;s:0:\"\";i:14;s:0:\"\";i:15;s:0:\"\";}s:8:\"post_tag\";a:2:{i:16;s:0:\"\";i:17;s:0:\"\";}s:8:\"nav_menu\";a:3:{i:18;s:0:\"\";i:19;s:0:\"\";i:20;s:0:\"\";}}s:14:\"installed_demo\";i:185;s:7:\"widgets\";a:5:{s:12:\"main-sidebar\";a:4:{s:4:\"name\";s:12:\"main-sidebar\";s:12:\"message_type\";s:5:\"error\";s:7:\"message\";s:48:\"Sidebar does not exist in theme (using Inactive)\";s:7:\"widgets\";a:4:{s:0:\"\";a:5:{s:4:\"name\";s:19:\"penci_social_widget\";s:5:\"title\";s:14:\"Social Connect\";s:12:\"message_type\";s:5:\"error\";s:7:\"message\";s:28:\"Site does not support widget\";s:7:\"id_base\";s:19:\"penci_social_widget\";}s:8:\"search-2\";a:5:{s:4:\"name\";s:24:\"penci_latest_news_widget\";s:5:\"title\";s:12:\"Recent Posts\";s:12:\"message_type\";s:5:\"error\";s:7:\"message\";s:28:\"Site does not support widget\";s:7:\"id_base\";s:24:\"penci_latest_news_widget\";}s:19:\"mc4wp_form_widget-2\";a:5:{s:4:\"name\";s:39:\"Formulario de suscripción de MailChimp\";s:5:\"title\";s:10:\"Newsletter\";s:12:\"message_type\";s:7:\"warning\";s:7:\"message\";s:20:\"Imported to Inactive\";s:7:\"id_base\";s:17:\"mc4wp_form_widget\";}s:12:\"categories-2\";a:5:{s:4:\"name\";s:11:\"Categorías\";s:5:\"title\";s:8:\"No Title\";s:12:\"message_type\";s:7:\"warning\";s:7:\"message\";s:20:\"Imported to Inactive\";s:7:\"id_base\";s:10:\"categories\";}}}s:8:\"footer-1\";a:4:{s:4:\"name\";s:9:\"1 del pie\";s:12:\"message_type\";s:7:\"success\";s:7:\"message\";s:0:\"\";s:7:\"widgets\";a:1:{s:6:\"text-3\";a:5:{s:4:\"name\";s:5:\"Texto\";s:5:\"title\";s:8:\"No Title\";s:12:\"message_type\";s:7:\"success\";s:7:\"message\";s:8:\"Imported\";s:7:\"id_base\";s:4:\"text\";}}}s:8:\"footer-2\";a:4:{s:4:\"name\";s:9:\"2 del pie\";s:12:\"message_type\";s:7:\"success\";s:7:\"message\";s:0:\"\";s:7:\"widgets\";a:1:{s:10:\"nav_menu-3\";a:5:{s:4:\"name\";s:20:\"Menú de navegación\";s:5:\"title\";s:9:\"Resources\";s:12:\"message_type\";s:7:\"success\";s:7:\"message\";s:8:\"Imported\";s:7:\"id_base\";s:8:\"nav_menu\";}}}s:8:\"footer-3\";a:4:{s:4:\"name\";s:9:\"3 del pie\";s:12:\"message_type\";s:7:\"success\";s:7:\"message\";s:0:\"\";s:7:\"widgets\";a:1:{s:10:\"nav_menu-4\";a:5:{s:4:\"name\";s:20:\"Menú de navegación\";s:5:\"title\";s:12:\"Useful Links\";s:12:\"message_type\";s:7:\"success\";s:7:\"message\";s:8:\"Imported\";s:7:\"id_base\";s:8:\"nav_menu\";}}}s:8:\"footer-4\";a:4:{s:4:\"name\";s:9:\"4 del pie\";s:12:\"message_type\";s:7:\"success\";s:7:\"message\";s:0:\"\";s:7:\"widgets\";a:1:{s:6:\"text-4\";a:5:{s:4:\"name\";s:19:\"penci_social_widget\";s:5:\"title\";s:8:\"No Title\";s:12:\"message_type\";s:5:\"error\";s:7:\"message\";s:28:\"Site does not support widget\";s:7:\"id_base\";s:19:\"penci_social_widget\";}}}}}", "yes");
INSERT INTO `wp_options` VALUES("3890", "seedprod_migration_run_once", "1", "yes");
INSERT INTO `wp_options` VALUES("3891", "seedprod_run_activation", "1", "yes");
INSERT INTO `wp_options` VALUES("3892", "seedprod_settings", "{\"api_key\":\"\",\"enable_coming_soon_mode\":false,\"enable_maintenance_mode\":false,\"enable_login_mode\":false,\"enable_404_mode\":false}", "yes");
INSERT INTO `wp_options` VALUES("3893", "seedprod_over_time", "a:3:{s:17:\"installed_version\";s:6:\"6.15.7\";s:14:\"installed_date\";i:1677097894;s:13:\"installed_pro\";s:4:\"lite\";}", "yes");
INSERT INTO `wp_options` VALUES("3894", "seedprod_token", "bab6d3ab-a8f0-41ea-9bc8-69e7b1eeabb8", "yes");
INSERT INTO `wp_options` VALUES("3898", "seedprod_dismiss_setup_wizard", "1", "yes");
INSERT INTO `wp_options` VALUES("3899", "seedprod_review", "a:2:{s:4:\"time\";i:1677097895;s:9:\"dismissed\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("3900", "seedprod_app_settings", "{  \n   \"facebook_g_app_id\":\"\",\n   \"disable_seedprod_button\":false\n}", "yes");
INSERT INTO `wp_options` VALUES("3901", "seedprod_onetime_flush_rewrite", "1", "yes");
INSERT INTO `wp_options` VALUES("3902", "seedprod_one_click_upgrade", "48c06df64d92aa66828e597d19e81206159905577cbb02336bd664e30eaa87277500633f5a08c6aa47c68fdebbbdbbf7bd81aa9e4b8c87d4c13a8218e7e34f1d", "yes");
INSERT INTO `wp_options` VALUES("3903", "seedprod_notifications", "a:4:{s:6:\"update\";i:1765658128;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("3905", "seedprod_maintenance_mode_page_id", "838", "yes");
INSERT INTO `wp_options` VALUES("3906", "seedprod_stripe_connect_origin", "a7902953-84de-4249-a781-c238b2c102e1", "yes");
INSERT INTO `wp_options` VALUES("3909", "seedprod_coming_soon_page_id", "", "yes");
INSERT INTO `wp_options` VALUES("3910", "seedprod_login_page_id", "", "yes");
INSERT INTO `wp_options` VALUES("3911", "seedprod_404_page_id", "", "yes");
INSERT INTO `wp_options` VALUES("3963", "_transient__demo_contents_file_onepress", "a:2:{s:3:\"xml\";i:845;s:4:\"json\";i:846;}", "yes");
INSERT INTO `wp_options` VALUES("3988", "woocommerce_shop_page_id", "1182", "yes");
INSERT INTO `wp_options` VALUES("3989", "woocommerce_cart_page_id", "1183", "yes");
INSERT INTO `wp_options` VALUES("3990", "woocommerce_checkout_page_id", "1184", "yes");
INSERT INTO `wp_options` VALUES("3991", "woocommerce_myaccount_page_id", "1185", "yes");
INSERT INTO `wp_options` VALUES("3999", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("4000", "elementor_library_category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("4001", "portfolio-category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("4326", "wpforms_notifications", "a:4:{s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}s:6:\"update\";i:1765655048;}", "yes");
INSERT INTO `wp_options` VALUES("5089", "wt_cli_version", "3.3.8", "yes");
INSERT INTO `wp_options` VALUES("5090", "cky_cookie_consent_lite_db_version", "3.3.8", "yes");
INSERT INTO `wp_options` VALUES("5091", "cky_missing_tables", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("5092", "_transient_cky_banners_transient_prefix", "0.18890300 1677532955", "yes");
INSERT INTO `wp_options` VALUES("5093", "cky_banner_template", "a:1:{s:2:\"es\";a:2:{s:4:\"html\";s:10078:\"<div class=\"cky-btn-revisit-wrapper cky-revisit-hide\" data-cky-tag=\"revisit-consent\" data-tooltip=\"Configuración de cookies\" style=\"background-color:#0056A7\"> <button class=\"cky-btn-revisit\" aria-label=\"Configuración de cookies\"> <img src=\"https://procuradorgalicia.es/wp-content/plugins/cookie-law-info/lite/frontend/images/revisit.svg\" alt=\"Revisit consent button\"> </button></div><div class=\"cky-consent-container cky-hide\" tabindex=\"0\"> <div class=\"cky-consent-bar\" data-cky-tag=\"notice\" style=\"background-color:#FFFFFF;border-color:#F4F4F4\">  <div class=\"cky-notice\"> <p class=\"cky-title\" role=\"heading\" aria-level=\"1\" data-cky-tag=\"title\" style=\"color:#212121\">Valoramos tu privacidad</p><div class=\"cky-notice-group\"> <div class=\"cky-notice-des\" data-cky-tag=\"description\" style=\"color:#212121\"> <p>Usamos cookies para mejorar su experiencia de navegación, mostrarle anuncios o contenidos personalizados y analizar nuestro tráfico. Al hacer clic en “Aceptar todo” usted da su consentimiento a nuestro uso de las cookies.</p> </div><div class=\"cky-notice-btn-wrapper\" data-cky-tag=\"notice-buttons\"> <button class=\"cky-btn cky-btn-customize\" aria-label=\"Personalizar\" data-cky-tag=\"settings-button\" style=\"color:#1863DC;background-color:transparent;border-color:#1863DC\">Personalizar</button> <button class=\"cky-btn cky-btn-reject\" aria-label=\"Rechazar todo\" data-cky-tag=\"reject-button\" style=\"color:#1863DC;background-color:transparent;border-color:#1863DC\">Rechazar todo</button> <button class=\"cky-btn cky-btn-accept\" aria-label=\"Aceptar todo\" data-cky-tag=\"accept-button\" style=\"color:#FFFFFF;background-color:#1863DC;border-color:#1863DC\">Aceptar todo</button> </div></div></div></div><div class=\"cky-preference-wrapper\" data-cky-tag=\"detail\" style=\"color:#212121;background-color:#FFFFFF;border-color:#F4F4F4\"> <div class=\"cky-preference-center\"> <div class=\"cky-preference\"> <div class=\"cky-preference-header\"> <span class=\"cky-preference-title\" role=\"heading\" aria-level=\"1\" data-cky-tag=\"detail-title\" style=\"color:#212121\">Personalizar las preferencias de consentimiento</span> <button class=\"cky-btn-close\" aria-label=\"[cky_preference_close_label]\" data-cky-tag=\"detail-close\"> <img src=\"https://procuradorgalicia.es/wp-content/plugins/cookie-law-info/lite/frontend/images/close.svg\" alt=\"Close\"> </button> </div><div class=\"cky-preference-body-wrapper\"> <div class=\"cky-preference-content-wrapper\" data-cky-tag=\"detail-description\" style=\"color:#212121\"> <p>Usamos cookies para ayudarle a navegar de manera eficiente y realizar ciertas funciones. Encontrará información detallada sobre cada una de las cookies bajo cada categoría de consentimiento a continuación.</p><p>Las cookies categorizadas como “Necesarias” se guardan en su navegador, ya que son esenciales para permitir las funcionalidades básicas del sitio web.</p><p>También utilizamos cookies de terceros que nos ayudan a analizar cómo usted utiliza este sitio web, guardar sus preferencias y aportar el contenido y la publicidad que le sean relevantes. Estas cookies solo se guardan en su navegador previo consentimiento por su parte.</p><p>Puede optar por activar o desactivar alguna o todas estas cookies, aunque la desactivación de algunas podría afectar a su experiencia de navegación.</p> </div><div class=\"cky-accordion-wrapper\" data-cky-tag=\"detail-categories\"> <div class=\"cky-accordion\" id=\"ckyDetailCategorynecessary\"> <div class=\"cky-accordion-item\"> <div class=\"cky-accordion-chevron\"><i class=\"cky-chevron-right\"></i></div> <div class=\"cky-accordion-header-wrapper\"> <div class=\"cky-accordion-header\"><button class=\"cky-accordion-btn\" aria-label=\"Necesaria\" data-cky-tag=\"detail-category-title\" style=\"color:#212121\">Necesaria</button><span class=\"cky-always-active\">Siempre activas</span> <div class=\"cky-switch\" data-cky-tag=\"detail-category-toggle\"><input type=\"checkbox\" id=\"ckySwitchnecessary\"></div> </div> <div class=\"cky-accordion-header-des\" data-cky-tag=\"detail-category-description\" style=\"color:#212121\"> <p>Las cookies necesarias son cruciales para las funciones básicas del sitio web y el sitio web no funcionará de la forma prevista sin ellas. Estas cookies no almacenan ningún dato de identificación personal.</p></div> </div> </div> <div class=\"cky-accordion-body\"> <div class=\"cky-audit-table\" data-cky-tag=\"audit-table\" style=\"color:#212121;background-color:#f4f4f4;border-color:#ebebeb\"><ul class=\"cky-cookie-des-table\"><li><div>Cookie</div><div>cookieyes-consent</div></li><li><div>Duración</div><div>7 días</div></li><li><div>Descripción</div><div><p>Cookie para el funcionamiento de la página</p></div></li></ul></div> </div> </div><div class=\"cky-accordion\" id=\"ckyDetailCategoryfunctional\"> <div class=\"cky-accordion-item\"> <div class=\"cky-accordion-chevron\"><i class=\"cky-chevron-right\"></i></div> <div class=\"cky-accordion-header-wrapper\"> <div class=\"cky-accordion-header\"><button class=\"cky-accordion-btn\" aria-label=\"Funcional\" data-cky-tag=\"detail-category-title\" style=\"color:#212121\">Funcional</button><span class=\"cky-always-active\">Siempre activas</span> <div class=\"cky-switch\" data-cky-tag=\"detail-category-toggle\"><input type=\"checkbox\" id=\"ckySwitchfunctional\"></div> </div> <div class=\"cky-accordion-header-des\" data-cky-tag=\"detail-category-description\" style=\"color:#212121\"> <p>Las cookies funcionales ayudan a realizar ciertas funcionalidades, como compartir el contenido del sitio web en plataformas de redes sociales, recopilar comentarios y otras características de terceros.</p></div> </div> </div> <div class=\"cky-accordion-body\"> <div class=\"cky-audit-table\" data-cky-tag=\"audit-table\" style=\"color:#212121;background-color:#f4f4f4;border-color:#ebebeb\"><p class=\"cky-empty-cookies-text\">No hay cookies para mostrar.</p></div> </div> </div><div class=\"cky-accordion\" id=\"ckyDetailCategoryanalytics\"> <div class=\"cky-accordion-item\"> <div class=\"cky-accordion-chevron\"><i class=\"cky-chevron-right\"></i></div> <div class=\"cky-accordion-header-wrapper\"> <div class=\"cky-accordion-header\"><button class=\"cky-accordion-btn\" aria-label=\"Analítica\" data-cky-tag=\"detail-category-title\" style=\"color:#212121\">Analítica</button><span class=\"cky-always-active\">Siempre activas</span> <div class=\"cky-switch\" data-cky-tag=\"detail-category-toggle\"><input type=\"checkbox\" id=\"ckySwitchanalytics\"></div> </div> <div class=\"cky-accordion-header-des\" data-cky-tag=\"detail-category-description\" style=\"color:#212121\"> <p>Las cookies analíticas se utilizan para comprender cómo interactúan los visitantes con el sitio web. Estas cookies ayudan a proporcionar información sobre métricas el número de visitantes, el porcentaje de rebote, la fuente de tráfico, etc.</p></div> </div> </div> <div class=\"cky-accordion-body\"> <div class=\"cky-audit-table\" data-cky-tag=\"audit-table\" style=\"color:#212121;background-color:#f4f4f4;border-color:#ebebeb\"><p class=\"cky-empty-cookies-text\">No hay cookies para mostrar.</p></div> </div> </div><div class=\"cky-accordion\" id=\"ckyDetailCategoryperformance\"> <div class=\"cky-accordion-item\"> <div class=\"cky-accordion-chevron\"><i class=\"cky-chevron-right\"></i></div> <div class=\"cky-accordion-header-wrapper\"> <div class=\"cky-accordion-header\"><button class=\"cky-accordion-btn\" aria-label=\"El rendimiento\" data-cky-tag=\"detail-category-title\" style=\"color:#212121\">El rendimiento</button><span class=\"cky-always-active\">Siempre activas</span> <div class=\"cky-switch\" data-cky-tag=\"detail-category-toggle\"><input type=\"checkbox\" id=\"ckySwitchperformance\"></div> </div> <div class=\"cky-accordion-header-des\" data-cky-tag=\"detail-category-description\" style=\"color:#212121\"> <p>Las cookies de rendimiento se utilizan para comprender y analizar los índices de rendimiento clave del sitio web, lo que ayuda a proporcionar una mejor experiencia de usuario para los visitantes.</p></div> </div> </div> <div class=\"cky-accordion-body\"> <div class=\"cky-audit-table\" data-cky-tag=\"audit-table\" style=\"color:#212121;background-color:#f4f4f4;border-color:#ebebeb\"><p class=\"cky-empty-cookies-text\">No hay cookies para mostrar.</p></div> </div> </div><div class=\"cky-accordion\" id=\"ckyDetailCategoryadvertisement\"> <div class=\"cky-accordion-item\"> <div class=\"cky-accordion-chevron\"><i class=\"cky-chevron-right\"></i></div> <div class=\"cky-accordion-header-wrapper\"> <div class=\"cky-accordion-header\"><button class=\"cky-accordion-btn\" aria-label=\"Anuncio\" data-cky-tag=\"detail-category-title\" style=\"color:#212121\">Anuncio</button><span class=\"cky-always-active\">Siempre activas</span> <div class=\"cky-switch\" data-cky-tag=\"detail-category-toggle\"><input type=\"checkbox\" id=\"ckySwitchadvertisement\"></div> </div> <div class=\"cky-accordion-header-des\" data-cky-tag=\"detail-category-description\" style=\"color:#212121\"> <p>Las cookies publicitarias se utilizan para entregar a los visitantes anuncios personalizados basados ​​en las páginas que visitaron antes y analizar la efectividad de la campaña publicitaria.</p></div> </div> </div> <div class=\"cky-accordion-body\"> <div class=\"cky-audit-table\" data-cky-tag=\"audit-table\" style=\"color:#212121;background-color:#f4f4f4;border-color:#ebebeb\"><p class=\"cky-empty-cookies-text\">No hay cookies para mostrar.</p></div> </div> </div> </div></div></div><div class=\"cky-footer-wrapper\"> <span class=\"cky-footer-shadow\"></span> <div class=\"cky-prefrence-btn-wrapper\" data-cky-tag=\"detail-buttons\"> <button class=\"cky-btn cky-btn-accept\" aria-label=\"Aceptar todo\" data-cky-tag=\"detail-accept-button\" style=\"color:#ffffff;background-color:#1863DC;border-color:#1863DC\"> Aceptar todo </button> <button class=\"cky-btn cky-btn-preferences\" aria-label=\"Guardar mis preferencias\" data-cky-tag=\"detail-save-button\" style=\"color:#1863DC;background-color:transparent;border-color:#1863DC\"> Guardar mis preferencias </button> <button class=\"cky-btn cky-btn-reject\" aria-label=\"Rechazar todo\" data-cky-tag=\"detail-reject-button\" style=\"color:#1863DC;background-color:transparent;border-color:#1863DC\"> Rechazar todo </button> </div></div></div></div></div>\";s:6:\"styles\";s:19403:\".cky-hide{display: none;}.cky-btn-revisit-wrapper{display: flex; align-items: center; justify-content: center; background: #0056a7; width: 45px; height: 45px; border-radius: 50%; position: fixed; z-index: 999999; cursor: pointer;}.cky-revisit-bottom-left{bottom: 15px; left: 15px;}.cky-revisit-bottom-right{bottom: 15px; right: 15px;}.cky-btn-revisit-wrapper .cky-btn-revisit{display: flex; align-items: center; justify-content: center; background: none; border: none; cursor: pointer; position: relative; margin: 0; padding: 0;}.cky-btn-revisit-wrapper .cky-btn-revisit img{max-width: fit-content; margin: 0; height: 30px; width: 30px;}.cky-revisit-bottom-left:hover::before{content: attr(data-tooltip); position: absolute; background: #4E4B66; color: #ffffff; left: calc(100% + 7px); font-size: 12px; line-height: 16px; width: max-content; padding: 4px 8px; border-radius: 4px;}.cky-revisit-bottom-left:hover::after{position: absolute; content: \"\"; border: 5px solid transparent; left: calc(100% + 2px); border-left-width: 0; border-right-color: #4E4B66;}.cky-revisit-bottom-right:hover::before{content: attr(data-tooltip); position: absolute; background: #4E4B66; color: #ffffff; right: calc(100% + 7px); font-size: 12px; line-height: 16px; width: max-content; padding: 4px 8px; border-radius: 4px;}.cky-revisit-bottom-right:hover::after{position: absolute; content: \"\"; border: 5px solid transparent; right: calc(100% + 2px); border-right-width: 0; border-left-color: #4E4B66;}.cky-revisit-hide{display: none;}.cky-consent-container{position: fixed; width: 100%; box-sizing: border-box; z-index: 9999999;}.cky-classic-bottom{bottom: 0; left: 0;}.cky-classic-top{top: 0; left: 0;}.cky-consent-container .cky-consent-bar{background: #ffffff; border: 1px solid; padding: 16.5px 24px; box-shadow: 0 -1px 10px 0 #acabab4d;}.cky-consent-bar .cky-banner-btn-close{position: absolute; right: 9px; top: 5px; background: none; border: none; cursor: pointer; padding: 0; margin: 0; height: auto; width: auto; min-height: 0; line-height: 0; text-shadow: none; box-shadow: none;}.cky-consent-bar .cky-banner-btn-close img{width: 9px; height: 9px; margin: 0;}.cky-custom-brand-logo-wrapper .cky-custom-brand-logo{width: 100px; height: auto; margin: 0 0 10px 0;}.cky-notice .cky-title{color: #212121; font-weight: 700; font-size: 18px; line-height: 24px; margin: 0 0 10px 0;}.cky-notice-group{display: flex; justify-content: space-between; align-items: center;}.cky-notice-des *{font-size: 14px;}.cky-notice-des{color: #212121; font-size: 14px; line-height: 24px; font-weight: 400;}.cky-notice-des img{height: 25px; width: 25px;}.cky-consent-bar .cky-notice-des p{color: inherit; margin-top: 0; overflow-wrap: break-word;}.cky-notice-des p:last-child{margin-bottom: 0;}.cky-notice-des a.cky-policy,.cky-notice-des button.cky-policy{font-size: 14px; color: #1863dc; white-space: nowrap; cursor: pointer; background: transparent; border: 1px solid; text-decoration: underline;}.cky-notice-des button.cky-policy{padding: 0;}.cky-notice-des a.cky-policy:focus-visible,.cky-consent-bar .cky-banner-btn-close:focus-visible,.cky-notice-des button.cky-policy:focus-visible,.cky-category-direct-switch input[type=\"checkbox\"]:focus-visible,.cky-preference-content-wrapper .cky-show-desc-btn:focus-visible,.cky-accordion-header .cky-accordion-btn:focus-visible,.cky-switch input[type=\"checkbox\"]:focus-visible,.cky-footer-wrapper a:focus-visible,.cky-btn:focus-visible{outline: 2px solid #1863dc; outline-offset: 2px;}.cky-btn:focus:not(:focus-visible),.cky-accordion-header .cky-accordion-btn:focus:not(:focus-visible),.cky-preference-content-wrapper .cky-show-desc-btn:focus:not(:focus-visible),.cky-btn-revisit-wrapper .cky-btn-revisit:focus:not(:focus-visible),.cky-preference-header .cky-btn-close:focus:not(:focus-visible),.cky-banner-btn-close:focus:not(:focus-visible){outline: 0;}button.cky-show-desc-btn:not(:hover):not(:active){color: #1863dc; background: transparent;}button.cky-accordion-btn:not(:hover):not(:active),button.cky-banner-btn-close:not(:hover):not(:active),button.cky-btn-close:not(:hover):not(:active),button.cky-btn-revisit:not(:hover):not(:active){background: transparent;}.cky-consent-bar button:hover,.cky-modal.cky-modal-open button:hover,.cky-consent-bar button:focus,.cky-modal.cky-modal-open button:focus{text-decoration: none;}.cky-notice-btn-wrapper{display: flex; justify-content: center; align-items: center; margin-left: 15px;}.cky-notice-btn-wrapper .cky-btn{text-shadow: none; box-shadow: none;}.cky-btn{font-size: 14px; font-family: inherit; line-height: 24px; padding: 8px 27px; font-weight: 500; margin: 0 8px 0 0; border-radius: 2px; white-space: nowrap; cursor: pointer; text-align: center; text-transform: none; min-height: 0;}.cky-btn:hover{opacity: 0.8;}.cky-btn-customize{color: #1863dc; background: transparent; border: 2px solid; border-color: #1863dc; padding: 8px 28px 8px 14px; position: relative;}.cky-btn-reject{color: #1863dc; background: transparent; border: 2px solid #1863dc;}.cky-btn-accept{background: #1863dc; color: #ffffff; border: 2px solid #1863dc;}.cky-consent-bar .cky-btn-customize::after{position: absolute; content: \"\"; display: inline-block; top: 18px; right: 12px; border-left: 5px solid transparent; border-right: 5px solid transparent; border-top: 6px solid; border-top-color: inherit;}.cky-consent-container.cky-consent-bar-expand .cky-btn-customize::after{transform: rotate(-180deg);}.cky-btn:last-child{margin-right: 0;}@media (max-width: 768px){.cky-notice-group{display: block;}.cky-notice-btn-wrapper{margin: 0;}.cky-notice-btn-wrapper{flex-wrap: wrap;}.cky-notice-btn-wrapper .cky-btn{flex: auto; max-width: 100%; margin-top: 10px; white-space: unset;}}@media (max-width: 576px){.cky-btn-accept{order: 1; width: 100%;}.cky-btn-customize{order: 2;}.cky-btn-reject{order: 3; margin-right: 0;}.cky-consent-container.cky-consent-bar-expand .cky-consent-bar{display: none;}.cky-consent-container .cky-consent-bar{padding: 16.5px 0;}.cky-custom-brand-logo-wrapper .cky-custom-brand-logo, .cky-notice .cky-title, .cky-notice-des, .cky-notice-btn-wrapper, .cky-category-direct-preview-wrapper{padding: 0 24px;}.cky-notice-des{max-height: 40vh; overflow-y: scroll;}}@media (max-width: 352px){.cky-notice .cky-title{font-size: 16px;}.cky-notice-des *{font-size: 12px;}.cky-notice-des, .cky-btn, .cky-notice-des a.cky-policy{font-size: 12px;}}.cky-preference-wrapper{display: none;}.cky-consent-container.cky-classic-bottom.cky-consent-bar-expand{animation: cky-classic-expand 1s;}.cky-consent-container.cky-classic-bottom.cky-consent-bar-expand .cky-preference-wrapper{display: block;}@keyframes cky-classic-expand{0%{transform: translateY(50%);}100%{transform: translateY(0%);}}.cky-consent-container.cky-classic-top .cky-preference-wrapper{animation: cky-classic-top-expand 1s;}.cky-consent-container.cky-classic-top.cky-consent-bar-expand .cky-preference-wrapper{display: block;}@keyframes cky-classic-top-expand{0%{opacity: 0; transform: translateY(-50%);}50%{opacity: 0;}100%{opacity: 1; transform: translateY(0%);}}.cky-preference{padding: 0 24px; color: #212121; overflow-y: scroll; max-height: 48vh;}.cky-preference-center,.cky-preference,.cky-preference-header,.cky-footer-wrapper{background-color: inherit;}.cky-preference-center,.cky-preference,.cky-preference-body-wrapper,.cky-accordion-wrapper{color: inherit;}.cky-preference-header .cky-btn-close{cursor: pointer; vertical-align: middle; padding: 0; margin: 0; display: none; background: none; border: none; height: auto; width: auto; min-height: 0; line-height: 0; box-shadow: none; text-shadow: none;}.cky-preference-header .cky-btn-close img{margin: 0; height: 10px; width: 10px;}.cky-preference-header{margin: 16px 0 0 0; display: flex; align-items: center; justify-content: space-between;}.cky-preference-header .cky-preference-title{font-size: 18px; font-weight: 700; line-height: 24px;}.cky-preference-content-wrapper *{font-size: 14px;}.cky-preference-content-wrapper{font-size: 14px; line-height: 24px; font-weight: 400; padding: 12px 0; border-bottom: 1px solid;}.cky-preference-content-wrapper img{height: 25px; width: 25px;}.cky-preference-content-wrapper .cky-show-desc-btn{font-size: 14px; font-family: inherit; color: #1863dc; text-decoration: none; line-height: 24px; padding: 0; margin: 0; white-space: nowrap; cursor: pointer; background: transparent; border-color: transparent; text-transform: none; min-height: 0; text-shadow: none; box-shadow: none;}.cky-preference-body-wrapper .cky-preference-content-wrapper p{color: inherit; margin-top: 0;}.cky-accordion-wrapper{margin-bottom: 10px;}.cky-accordion{border-bottom: 1px solid;}.cky-accordion:last-child{border-bottom: none;}.cky-accordion .cky-accordion-item{display: flex; margin-top: 10px;}.cky-accordion .cky-accordion-body{display: none;}.cky-accordion.cky-accordion-active .cky-accordion-body{display: block; padding: 0 22px; margin-bottom: 16px;}.cky-accordion-header-wrapper{cursor: pointer; width: 100%;}.cky-accordion-item .cky-accordion-header{display: flex; justify-content: space-between; align-items: center;}.cky-accordion-header .cky-accordion-btn{font-size: 16px; font-family: inherit; color: #212121; line-height: 24px; background: none; border: none; font-weight: 700; padding: 0; margin: 0; cursor: pointer; text-transform: none; min-height: 0; text-shadow: none; box-shadow: none;}.cky-accordion-header .cky-always-active{color: #008000; font-weight: 600; line-height: 24px; font-size: 14px;}.cky-accordion-header-des *{font-size: 14px;}.cky-accordion-header-des{color: #212121; font-size: 14px; line-height: 24px; margin: 10px 0 16px 0;}.cky-accordion-header-wrapper .cky-accordion-header-des p{color: inherit; margin-top: 0;}.cky-accordion-chevron{margin-right: 22px; position: relative; cursor: pointer;}.cky-accordion-chevron-hide{display: none;}.cky-accordion .cky-accordion-chevron i::before{content: \"\"; position: absolute; border-right: 1.4px solid; border-bottom: 1.4px solid; border-color: inherit; height: 6px; width: 6px; -webkit-transform: rotate(-45deg); -moz-transform: rotate(-45deg); -ms-transform: rotate(-45deg); -o-transform: rotate(-45deg); transform: rotate(-45deg); transition: all 0.2s ease-in-out; top: 8px;}.cky-accordion.cky-accordion-active .cky-accordion-chevron i::before{-webkit-transform: rotate(45deg); -moz-transform: rotate(45deg); -ms-transform: rotate(45deg); -o-transform: rotate(45deg); transform: rotate(45deg);}.cky-audit-table{background: #f4f4f4; border-radius: 6px;}.cky-audit-table .cky-empty-cookies-text{color: inherit; font-size: 12px; line-height: 24px; margin: 0; padding: 10px;}.cky-audit-table .cky-cookie-des-table{font-size: 12px; line-height: 24px; font-weight: normal; padding: 15px 10px; border-bottom: 1px solid; border-bottom-color: inherit; margin: 0;}.cky-audit-table .cky-cookie-des-table:last-child{border-bottom: none;}.cky-audit-table .cky-cookie-des-table li{list-style-type: none; display: flex; padding: 3px 0;}.cky-audit-table .cky-cookie-des-table li:first-child{padding-top: 0;}.cky-cookie-des-table li div:first-child{width: 100px; font-weight: 600; word-break: break-word; word-wrap: break-word;}.cky-cookie-des-table li div:last-child{flex: 1; word-break: break-word; word-wrap: break-word; margin-left: 8px;}.cky-cookie-des-table li div:last-child p{color: inherit; margin-top: 0;}.cky-cookie-des-table li div:last-child p:last-child{margin-bottom: 0;}.cky-prefrence-btn-wrapper{display: flex; align-items: center; justify-content: flex-end; padding: 18px 24px; border-top: 1px solid;}.cky-prefrence-btn-wrapper .cky-btn{text-shadow: none; box-shadow: none;}.cky-category-direct-preview-btn-wrapper .cky-btn-preferences{text-shadow: none; box-shadow: none;}.cky-prefrence-btn-wrapper .cky-btn-accept,.cky-prefrence-btn-wrapper .cky-btn-reject{display: none;}.cky-btn-preferences{color: #1863dc; background: transparent; border: 2px solid #1863dc;}.cky-footer-wrapper{position: relative;}.cky-footer-shadow{display: block; width: 100%; height: 40px; background: linear-gradient(180deg, rgba(255, 255, 255, 0) 0%, #ffffff 100%); position: absolute; bottom: 100%;}.cky-preference-center,.cky-preference,.cky-preference-body-wrapper,.cky-preference-content-wrapper,.cky-accordion-wrapper,.cky-accordion,.cky-footer-wrapper,.cky-prefrence-btn-wrapper{border-color: inherit;}@media (max-width: 768px){.cky-preference{max-height: 35vh;}}@media (max-width: 576px){.cky-consent-bar-hide{display: none;}.cky-preference{max-height: 100vh; padding: 0;}.cky-preference-body-wrapper{padding: 60px 24px 200px;}.cky-preference-body-wrapper-reject-hide{padding: 60px 24px 165px;}.cky-preference-header{position: fixed; width: 100%; box-sizing: border-box; z-index: 999999999; margin: 0; padding: 16px 24px; border-bottom: 1px solid #f4f4f4;}.cky-preference-header .cky-btn-close{display: block;}.cky-prefrence-btn-wrapper{display: block;}.cky-accordion.cky-accordion-active .cky-accordion-body{padding-right: 0;}.cky-prefrence-btn-wrapper .cky-btn{width: 100%; margin-top: 10px; margin-right: 0;}.cky-prefrence-btn-wrapper .cky-btn:first-child{margin-top: 0;}.cky-accordion:last-child{padding-bottom: 20px;}.cky-prefrence-btn-wrapper .cky-btn-accept, .cky-prefrence-btn-wrapper .cky-btn-reject{display: block;}.cky-footer-wrapper{position: fixed; bottom: 0; width: 100%;}}@media (max-width: 425px){.cky-accordion-chevron{margin-right: 15px;}.cky-accordion.cky-accordion-active .cky-accordion-body{padding: 0 15px;}}@media (max-width: 352px){.cky-preference-header .cky-preference-title{font-size: 16px;}.cky-preference-content-wrapper *, .cky-accordion-header-des *{font-size: 12px;}.cky-accordion-header-des, .cky-preference-content-wrapper, .cky-preference-content-wrapper .cky-show-desc-btn{font-size: 12px;}.cky-accordion-header .cky-accordion-btn{font-size: 14px;}}.cky-category-direct-preview-wrapper{display: flex; flex-wrap: wrap; align-items: center; justify-content: space-between; margin-top: 16px;}.cky-category-direct-preview{display: flex; flex-wrap: wrap; align-items: center; font-size: 14px; font-weight: 600; line-height: 24px; color: #212121;}.cky-category-direct-preview-section{width: 100%; display: flex; justify-content: space-between; flex-wrap: wrap;}.cky-category-direct-item{display: flex; margin: 0 30px 10px 0; cursor: pointer;}.cky-category-direct-item label{font-size: 14px; font-weight: 600; margin-right: 10px; cursor: pointer; word-break: break-word;}.cky-category-direct-switch input[type=\"checkbox\"]{display: inline-block; position: relative; width: 33px; height: 18px; margin: 0; background: #d0d5d2; -webkit-appearance: none; border-radius: 50px; border: none; cursor: pointer; vertical-align: middle; outline: 0; top: 0;}.cky-category-direct-switch input[type=\"checkbox\"]:checked{background: #1863dc;}.cky-category-direct-switch input[type=\"checkbox\"]:before{position: absolute; content: \"\"; height: 15px; width: 15px; left: 2px; bottom: 2px; margin: 0; border-radius: 50%; background-color: white; -webkit-transition: 0.4s; transition: 0.4s;}.cky-category-direct-switch input[type=\"checkbox\"]:checked:before{-webkit-transform: translateX(14px); -ms-transform: translateX(14px); transform: translateX(14px);}.cky-category-direct-switch input[type=\"checkbox\"]:after{display: none;}.cky-category-direct-switch .cky-category-direct-switch-enabled:checked{background: #818181;}@media (max-width: 576px){.cky-category-direct-preview-wrapper{display: block;}.cky-category-direct-item{justify-content: space-between; width: 45%; margin: 0 0 10px 0;}.cky-category-direct-preview-btn-wrapper .cky-btn-preferences{width: 100%;}}@media (max-width: 352px){.cky-category-direct-preview{font-size: 12px;}}.cky-switch{display: flex;}.cky-switch input[type=\"checkbox\"]{position: relative; width: 44px; height: 24px; margin: 0; background: #d0d5d2; -webkit-appearance: none; border-radius: 50px; cursor: pointer; outline: 0; border: none; top: 0;}.cky-switch input[type=\"checkbox\"]:checked{background: #3a76d8;}.cky-switch input[type=\"checkbox\"]:before{position: absolute; content: \"\"; height: 20px; width: 20px; left: 2px; bottom: 2px; border-radius: 50%; background-color: white; -webkit-transition: 0.4s; transition: 0.4s; margin: 0;}.cky-switch input[type=\"checkbox\"]:after{display: none;}.cky-switch input[type=\"checkbox\"]:checked:before{-webkit-transform: translateX(20px); -ms-transform: translateX(20px); transform: translateX(20px);}@media (max-width: 425px){.cky-switch input[type=\"checkbox\"]{width: 38px; height: 21px;}.cky-switch input[type=\"checkbox\"]:before{height: 17px; width: 17px;}.cky-switch input[type=\"checkbox\"]:checked:before{-webkit-transform: translateX(17px); -ms-transform: translateX(17px); transform: translateX(17px);}}.video-placeholder-youtube{background-size: 100% 100%; background-position: center; background-repeat: no-repeat; background-color: #b2b0b059; position: relative; display: flex; align-items: center; justify-content: center; max-width: 100%;}.video-placeholder-text-youtube{text-align: center; align-items: center; padding: 10px 16px; background-color: #000000cc; color: #ffffff; border: 1px solid; border-radius: 2px; cursor: pointer;}.video-placeholder-normal{background-image: url(\"/wp-content/plugins/cookie-law-info/lite/frontend/images/placeholder.svg\"); background-size: 80px; background-position: center; background-repeat: no-repeat; background-color: #b2b0b059; position: relative; display: flex; align-items: flex-end; justify-content: center; max-width: 100%;}.video-placeholder-text-normal{align-items: center; padding: 10px 16px; text-align: center; border: 1px solid; border-radius: 2px; cursor: pointer;}.cky-rtl{direction: rtl; text-align: right;}.cky-rtl .cky-banner-btn-close{left: 9px; right: auto;}.cky-rtl .cky-notice-btn-wrapper .cky-btn:last-child{margin-right: 8px;}.cky-rtl .cky-notice-btn-wrapper{margin-left: 0; margin-right: 15px;}.cky-rtl .cky-prefrence-btn-wrapper .cky-btn{margin-right: 8px;}.cky-rtl .cky-prefrence-btn-wrapper .cky-btn:first-child{margin-right: 0;}.cky-rtl .cky-accordion .cky-accordion-chevron i::before{border: none; border-left: 1.4px solid; border-top: 1.4px solid; left: 12px;}.cky-rtl .cky-accordion.cky-accordion-active .cky-accordion-chevron i::before{-webkit-transform: rotate(-135deg); -moz-transform: rotate(-135deg); -ms-transform: rotate(-135deg); -o-transform: rotate(-135deg); transform: rotate(-135deg);}.cky-rtl .cky-category-direct-preview-btn-wrapper{margin-right: 15px; margin-left: 0;}.cky-rtl .cky-category-direct-item label{margin-right: 0; margin-left: 10px;}.cky-rtl .cky-category-direct-preview-section .cky-category-direct-item:first-child{margin: 0 0 10px 0;}@media (max-width: 992px){.cky-rtl .cky-category-direct-preview-btn-wrapper{margin-right: 0;}}@media (max-width: 768px){.cky-rtl .cky-notice-btn-wrapper{margin-right: 0;}.cky-rtl .cky-notice-btn-wrapper .cky-btn:first-child{margin-right: 0;}}@media (max-width: 576px){.cky-rtl .cky-prefrence-btn-wrapper .cky-btn{margin-right: 0;}.cky-rtl .cky-notice-btn-wrapper .cky-btn{margin-right: 0;}.cky-rtl .cky-notice-btn-wrapper .cky-btn:last-child{margin-right: 0;}.cky-rtl .cky-notice-btn-wrapper .cky-btn-reject{margin-right: 8px;}.cky-rtl .cky-accordion.cky-accordion-active .cky-accordion-body{padding: 0 22px 0 0;}}@media (max-width: 425px){.cky-rtl .cky-accordion.cky-accordion-active .cky-accordion-body{padding: 0 15px 0 0;}}\";}}", "yes");
INSERT INTO `wp_options` VALUES("5095", "_transient_cky_banner_template_transient_prefix", "0.20719000 1677532955", "yes");
INSERT INTO `wp_options` VALUES("5096", "_transient_cky_cookies_transient_prefix", "0.24545300 1677532955", "yes");
INSERT INTO `wp_options` VALUES("5097", "_transient_cky_categories_transient_prefix", "0.24836200 1677532955", "yes");
INSERT INTO `wp_options` VALUES("5100", "cky_settings", "a:6:{s:4:\"site\";a:2:{s:3:\"url\";s:28:\"https://procuradorgalicia.es\";s:9:\"installed\";i:1677532963;}s:3:\"api\";a:1:{s:5:\"token\";s:0:\"\";}s:7:\"account\";a:6:{s:5:\"email\";s:0:\"\";s:6:\"domain\";s:0:\"\";s:9:\"connected\";b:0;s:4:\"plan\";s:4:\"free\";s:10:\"website_id\";s:0:\"\";s:11:\"website_key\";s:0:\"\";}s:12:\"consent_logs\";a:1:{s:6:\"status\";b:1;}s:9:\"languages\";a:2:{s:8:\"selected\";a:2:{i:0;s:2:\"en\";i:1;s:2:\"es\";}s:7:\"default\";s:2:\"es\";}s:10:\"onboarding\";a:1:{s:4:\"step\";i:2;}}", "yes");
INSERT INTO `wp_options` VALUES("5103", "cky_admin_notices", "a:1:{s:14:\"connect_notice\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("5497", "_transient_cky_transient_0.24836200 1677532955_all", "a:5:{i:1;O:8:\"stdClass\":12:{s:11:\"category_id\";i:1;s:4:\"name\";a:2:{s:2:\"en\";s:9:\"Necessary\";s:2:\"es\";s:9:\"Necesaria\";}s:4:\"slug\";s:9:\"necessary\";s:11:\"description\";a:2:{s:2:\"en\";s:212:\"<p>Necessary cookies are required to enable the basic features of this site, such as providing secure log-in or adjusting your consent preferences. These cookies do not store any personally identifiable data.</p>\";s:2:\"es\";s:216:\"<p>Las cookies necesarias son cruciales para las funciones básicas del sitio web y el sitio web no funcionará de la forma prevista sin ellas. Estas cookies no almacenan ningún dato de identificación personal.</p>\";}s:13:\"prior_consent\";i:1;s:8:\"priority\";i:0;s:10:\"visibility\";i:1;s:18:\"sell_personal_data\";i:1;s:4:\"meta\";a:0:{}s:12:\"date_created\";s:19:\"0000-00-00 00:00:00\";s:13:\"date_modified\";s:19:\"0000-00-00 00:00:00\";s:7:\"cookies\";a:1:{i:0;a:12:{s:2:\"id\";i:1;s:4:\"name\";s:17:\"cookieyes-consent\";s:4:\"slug\";s:17:\"cookieyes-consent\";s:11:\"description\";a:2:{s:2:\"en\";s:0:\"\";s:2:\"es\";s:50:\"<p>Cookie para el funcionamiento de la página</p>\";}s:8:\"duration\";a:2:{s:2:\"en\";s:7:\"7 días\";s:2:\"es\";s:7:\"7 días\";}s:4:\"type\";i:0;s:6:\"domain\";s:20:\"procuradorgalicia.es\";s:10:\"discovered\";b:0;s:11:\"url_pattern\";s:0:\"\";s:8:\"category\";i:1;s:12:\"date_created\";s:19:\"2023-02-28 19:56:46\";s:13:\"date_modified\";s:19:\"2023-02-28 19:56:46\";}}}i:2;O:8:\"stdClass\":12:{s:11:\"category_id\";i:2;s:4:\"name\";a:2:{s:2:\"en\";s:10:\"Functional\";s:2:\"es\";s:9:\"Funcional\";}s:4:\"slug\";s:10:\"functional\";s:11:\"description\";a:2:{s:2:\"en\";s:182:\"<p>Functional cookies help perform certain functionalities like sharing the content of the website on social media platforms, collecting feedback, and other third-party features.</p>\";s:2:\"es\";s:209:\"<p>Las cookies funcionales ayudan a realizar ciertas funcionalidades, como compartir el contenido del sitio web en plataformas de redes sociales, recopilar comentarios y otras características de terceros.</p>\";}s:13:\"prior_consent\";i:0;s:8:\"priority\";i:0;s:10:\"visibility\";i:1;s:18:\"sell_personal_data\";i:1;s:4:\"meta\";a:0:{}s:12:\"date_created\";s:19:\"0000-00-00 00:00:00\";s:13:\"date_modified\";s:19:\"0000-00-00 00:00:00\";s:7:\"cookies\";a:0:{}}i:3;O:8:\"stdClass\":12:{s:11:\"category_id\";i:3;s:4:\"name\";a:2:{s:2:\"en\";s:9:\"Analytics\";s:2:\"es\";s:10:\"Analítica\";}s:4:\"slug\";s:9:\"analytics\";s:11:\"description\";a:2:{s:2:\"en\";s:204:\"<p>Analytical cookies are used to understand how visitors interact with the website. These cookies help provide information on metrics such as the number of visitors, bounce rate, traffic source, etc.</p>\";s:2:\"es\";s:254:\"<p>Las cookies analíticas se utilizan para comprender cómo interactúan los visitantes con el sitio web. Estas cookies ayudan a proporcionar información sobre métricas el número de visitantes, el porcentaje de rebote, la fuente de tráfico, etc.</p>\";}s:13:\"prior_consent\";i:0;s:8:\"priority\";i:0;s:10:\"visibility\";i:1;s:18:\"sell_personal_data\";i:1;s:4:\"meta\";a:0:{}s:12:\"date_created\";s:19:\"0000-00-00 00:00:00\";s:13:\"date_modified\";s:19:\"0000-00-00 00:00:00\";s:7:\"cookies\";a:0:{}}i:4;O:8:\"stdClass\":12:{s:11:\"category_id\";i:4;s:4:\"name\";a:2:{s:2:\"en\";s:11:\"Performance\";s:2:\"es\";s:14:\"El rendimiento\";}s:4:\"slug\";s:11:\"performance\";s:11:\"description\";a:2:{s:2:\"en\";s:173:\"<p>Performance cookies are used to understand and analyze the key performance indexes of the website which helps in delivering a better user experience for the visitors.</p>\";s:2:\"es\";s:203:\"<p>Las cookies de rendimiento se utilizan para comprender y analizar los índices de rendimiento clave del sitio web, lo que ayuda a proporcionar una mejor experiencia de usuario para los visitantes.</p>\";}s:13:\"prior_consent\";i:0;s:8:\"priority\";i:0;s:10:\"visibility\";i:1;s:18:\"sell_personal_data\";i:1;s:4:\"meta\";a:0:{}s:12:\"date_created\";s:19:\"0000-00-00 00:00:00\";s:13:\"date_modified\";s:19:\"0000-00-00 00:00:00\";s:7:\"cookies\";a:0:{}}i:5;O:8:\"stdClass\":12:{s:11:\"category_id\";i:5;s:4:\"name\";a:2:{s:2:\"en\";s:13:\"Advertisement\";s:2:\"es\";s:7:\"Anuncio\";}s:4:\"slug\";s:13:\"advertisement\";s:11:\"description\";a:2:{s:2:\"en\";s:184:\"<p>Advertisement cookies are used to provide visitors with customized advertisements based on the pages you visited previously and to analyze the effectiveness of the ad campaigns.</p>\";s:2:\"es\";s:204:\"<p>Las cookies publicitarias se utilizan para entregar a los visitantes anuncios personalizados basados ​​en las páginas que visitaron antes y analizar la efectividad de la campaña publicitaria.</p>\";}s:13:\"prior_consent\";i:0;s:8:\"priority\";i:0;s:10:\"visibility\";i:1;s:18:\"sell_personal_data\";i:1;s:4:\"meta\";a:0:{}s:12:\"date_created\";s:19:\"0000-00-00 00:00:00\";s:13:\"date_modified\";s:19:\"0000-00-00 00:00:00\";s:7:\"cookies\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("7674", "scb_button_z_index", "", "yes");
INSERT INTO `wp_options` VALUES("7697", "action_scheduler_migration_status", "complete", "yes");
INSERT INTO `wp_options` VALUES("7700", "qlwapp", "a:9:{s:3:\"box\";a:0:{}s:6:\"button\";a:18:{s:6:\"layout\";s:6:\"button\";s:3:\"box\";s:2:\"no\";s:7:\"rounded\";s:3:\"yes\";s:8:\"position\";s:12:\"bottom-right\";s:4:\"icon\";s:20:\"qlwapp-whatsapp-icon\";s:4:\"text\";s:25:\"¿Cómo podemos ayudarte?\";s:4:\"type\";s:5:\"phone\";s:5:\"phone\";s:11:\"34698165096\";s:5:\"group\";s:0:\"\";s:7:\"message\";s:33:\"Bienvenido a procuradorgalicia.es\";s:8:\"timefrom\";s:5:\"00:00\";s:6:\"timeto\";s:5:\"00:00\";s:8:\"timezone\";s:5:\"UTC+0\";s:10:\"visibility\";s:8:\"readonly\";s:14:\"animation-name\";s:4:\"none\";s:15:\"animation-delay\";s:0:\"\";s:24:\"qlwapp_button_form_nonce\";s:10:\"e10aa472c3\";s:16:\"_wp_http_referer\";s:38:\"/wp-admin/admin.php?page=qlwapp_button\";}s:4:\"chat\";a:0:{}s:8:\"contacts\";a:0:{}s:7:\"display\";a:0:{}s:6:\"scheme\";a:0:{}s:11:\"woocommerce\";a:0:{}s:7:\"license\";a:0:{}s:8:\"settings\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("15304", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:25:\"agorajuridicasl@gmail.com\";s:7:\"version\";s:5:\"6.7.2\";s:9:\"timestamp\";i:1739322308;}", "off");
INSERT INTO `wp_options` VALUES("31829", "hostinger_plugin_installation_type", "hpanel", "yes");
INSERT INTO `wp_options` VALUES("34086", "astra_partner_url_param", "12425", "no");
INSERT INTO `wp_options` VALUES("53098", "hts_new_installation", "new", "yes");
INSERT INTO `wp_options` VALUES("63072", "external_updates-hostinger-easy-onboarding", "O:8:\"stdClass\":5:{s:9:\"lastCheck\";i:1765660332;s:14:\"checkedVersion\";s:6:\"2.0.98\";s:6:\"update\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"hostinger-easy-onboarding\";s:7:\"version\";s:5:\"2.1.0\";s:12:\"download_url\";s:88:\"https://wp-update.hostinger.io/?action=download&slug=hostinger-easy-onboarding&ver=2.1.0\";s:12:\"translations\";a:0:{}s:2:\"id\";i:0;s:8:\"homepage\";s:21:\"https://hostinger.com\";s:6:\"tested\";s:3:\"6.9\";s:12:\"requires_php\";s:3:\"8.0\";s:14:\"upgrade_notice\";N;s:5:\"icons\";a:0:{}s:8:\"filename\";s:55:\"hostinger-easy-onboarding/hostinger-easy-onboarding.php\";}s:11:\"updateClass\";s:50:\"YahnisElsts\\PluginUpdateChecker\\v5p6\\Plugin\\Update\";s:15:\"updateBaseClass\";s:13:\"Plugin\\Update\";}", "off");
INSERT INTO `wp_options` VALUES("84963", "hostinger_easy_onboarding_steps", "a:1:{s:13:\"website_setup\";a:1:{s:14:\"connect_domain\";b:1;}}", "yes");
INSERT INTO `wp_options` VALUES("84992", "_elementor_settings_update_time", "1738087235", "yes");
INSERT INTO `wp_options` VALUES("84993", "elementor_disable_color_schemes", "", "yes");
INSERT INTO `wp_options` VALUES("84994", "elementor_disable_typography_schemes", "", "yes");
INSERT INTO `wp_options` VALUES("84995", "elementor_google_maps_api_key", "", "yes");
INSERT INTO `wp_options` VALUES("84996", "elementor_css_print_method", "external", "yes");
INSERT INTO `wp_options` VALUES("84997", "elementor_editor_break_lines", "", "yes");
INSERT INTO `wp_options` VALUES("84998", "elementor_unfiltered_files_upload", "", "yes");
INSERT INTO `wp_options` VALUES("84999", "elementor_google_font", "1", "yes");
INSERT INTO `wp_options` VALUES("85000", "elementor_load_fa4_shim", "", "yes");
INSERT INTO `wp_options` VALUES("85001", "elementor_meta_generator_tag", "", "yes");
INSERT INTO `wp_options` VALUES("85002", "elementor_experiment-e_font_icon_svg", "default", "yes");
INSERT INTO `wp_options` VALUES("85003", "elementor_experiment-container", "default", "yes");
INSERT INTO `wp_options` VALUES("85004", "elementor_experiment-e_swiper_latest", "default", "yes");
INSERT INTO `wp_options` VALUES("85005", "elementor_experiment-nested-elements", "default", "yes");
INSERT INTO `wp_options` VALUES("85006", "elementor_experiment-e_lazyload", "default", "yes");
INSERT INTO `wp_options` VALUES("85007", "elementor_experiment-e_dom_optimization", "default", "yes");
INSERT INTO `wp_options` VALUES("85008", "elementor_experiment-e_optimized_assets_loading", "default", "yes");
INSERT INTO `wp_options` VALUES("85009", "elementor_experiment-e_optimized_css_loading", "default", "yes");
INSERT INTO `wp_options` VALUES("85010", "elementor_experiment-a11y_improvements", "default", "yes");
INSERT INTO `wp_options` VALUES("85011", "elementor_experiment-additional_custom_breakpoints", "default", "yes");
INSERT INTO `wp_options` VALUES("85012", "elementor_experiment-landing-pages", "default", "yes");
INSERT INTO `wp_options` VALUES("85013", "elementor_experiment-kit-elements-defaults", "default", "yes");
INSERT INTO `wp_options` VALUES("85029", "_elementor_global_css", "a:6:{s:4:\"time\";i:1738087277;s:5:\"fonts\";a:0:{}s:5:\"icons\";a:0:{}s:20:\"dynamic_elements_ids\";a:0:{}s:6:\"status\";s:4:\"file\";i:0;b:0;}", "yes");
INSERT INTO `wp_options` VALUES("85036", "wp_attachment_pages_enabled", "1", "on");
INSERT INTO `wp_options` VALUES("85037", "db_upgraded", "", "on");
INSERT INTO `wp_options` VALUES("85048", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"e6d0d097fa71e03c12289db6df63064a\";s:6:\"blocks\";a:6:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:18:\"core/term-template\";s:120:\":where(.wp-block-term-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-term-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `wp_options` VALUES("85073", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("85093", "elementor_checklist", "{\"last_opened_timestamp\":null,\"first_closed_checklist_in_editor\":false,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"should_open_in_editor\":false}", "auto");
INSERT INTO `wp_options` VALUES("85101", "_transient_cky_transient_0.18890300 1677532955_all", "a:2:{i:1;O:8:\"stdClass\":7:{s:9:\"banner_id\";i:1;s:4:\"name\";s:4:\"GDPR\";s:4:\"slug\";s:6:\"gdpr-1\";s:8:\"settings\";a:4:{s:8:\"settings\";a:12:{s:2:\"id\";s:8:\"banner-1\";s:4:\"type\";s:7:\"classic\";s:20:\"preferenceCenterType\";s:8:\"pushdown\";s:8:\"position\";s:3:\"top\";s:9:\"versionID\";s:5:\"6.0.0\";s:13:\"applicableLaw\";s:4:\"gdpr\";s:9:\"languages\";a:2:{s:7:\"default\";s:2:\"en\";s:8:\"selected\";a:1:{i:0;s:2:\"en\";}}s:13:\"templateGroup\";s:7:\"default\";s:10:\"customHtml\";a:1:{s:6:\"status\";b:0;}s:5:\"theme\";s:5:\"light\";s:13:\"consentExpiry\";a:2:{s:6:\"status\";b:1;s:5:\"value\";s:3:\"365\";}s:7:\"ruleSet\";a:1:{i:0;a:2:{s:4:\"code\";s:3:\"ALL\";s:7:\"regions\";a:0:{}}}}s:10:\"behaviours\";a:5:{s:20:\"reloadBannerOnAccept\";a:1:{s:6:\"status\";b:0;}s:22:\"loadAnalyticsByDefault\";a:1:{s:6:\"status\";b:0;}s:10:\"animations\";a:2:{s:6:\"onLoad\";s:7:\"animate\";s:6:\"onHide\";s:6:\"sticky\";}s:15:\"legacyFunctions\";a:5:{s:6:\"accept\";a:2:{s:6:\"action\";s:11:\"acceptClose\";s:6:\"newTab\";b:0;}s:6:\"reject\";a:2:{s:6:\"action\";s:11:\"rejectClose\";s:6:\"newTab\";b:0;}s:4:\"idle\";a:2:{s:6:\"action\";s:11:\"acceptClose\";s:5:\"delay\";s:4:\"1000\";}s:10:\"navigation\";a:1:{s:6:\"action\";s:11:\"acceptClose\";}s:10:\"pageScroll\";a:1:{s:6:\"action\";s:11:\"acceptClose\";}}s:10:\"respectGPC\";a:1:{s:6:\"status\";b:0;}}s:6:\"config\";a:7:{s:6:\"notice\";a:5:{s:6:\"status\";b:1;s:3:\"tag\";s:6:\"notice\";s:4:\"type\";s:9:\"container\";s:6:\"styles\";a:2:{s:16:\"background-color\";s:7:\"#FFFFFF\";s:12:\"border-color\";s:7:\"#f4f4f4\";}s:8:\"elements\";a:5:{s:5:\"title\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:5:\"title\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#212121\";}}s:11:\"description\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:11:\"description\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#212121\";}}s:9:\"brandLogo\";a:3:{s:6:\"status\";b:0;s:3:\"tag\";s:10:\"brand-logo\";s:4:\"meta\";a:1:{s:3:\"url\";s:1:\"#\";}}s:7:\"buttons\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:14:\"notice-buttons\";s:4:\"type\";s:9:\"container\";s:8:\"elements\";a:5:{s:6:\"accept\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:13:\"accept-button\";s:4:\"type\";s:6:\"button\";s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#FFFFFF\";s:16:\"background-color\";s:7:\"#1863DC\";s:12:\"border-color\";s:7:\"#1863DC\";}}s:6:\"reject\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:13:\"reject-button\";s:4:\"type\";s:6:\"button\";s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#1863DC\";s:16:\"background-color\";s:11:\"transparent\";s:12:\"border-color\";s:7:\"#1863DC\";}}s:8:\"settings\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:15:\"settings-button\";s:4:\"type\";s:6:\"button\";s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#1863DC\";s:16:\"background-color\";s:11:\"transparent\";s:12:\"border-color\";s:7:\"#1863DC\";}}s:8:\"readMore\";a:5:{s:6:\"status\";b:0;s:3:\"tag\";s:15:\"readmore-button\";s:4:\"type\";s:4:\"link\";s:4:\"meta\";a:2:{s:8:\"noFollow\";b:1;s:6:\"newTab\";b:1;}s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#1863DC\";s:16:\"background-color\";s:11:\"transparent\";s:12:\"border-color\";s:11:\"transparent\";}}s:9:\"donotSell\";a:4:{s:6:\"status\";b:0;s:3:\"tag\";s:16:\"donotsell-button\";s:4:\"type\";s:6:\"button\";s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#1863DC\";s:16:\"background-color\";s:11:\"transparent\";s:12:\"border-color\";s:11:\"transparent\";}}}}s:11:\"closeButton\";a:2:{s:6:\"status\";b:0;s:3:\"tag\";s:12:\"close-button\";}}}s:15:\"categoryPreview\";a:4:{s:6:\"status\";b:0;s:4:\"type\";s:9:\"container\";s:3:\"tag\";s:23:\"detail-category-preview\";s:8:\"elements\";a:3:{s:5:\"title\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:29:\"detail-category-preview-title\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#212121\";}}s:6:\"toggle\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:30:\"detail-category-preview-toggle\";s:4:\"type\";s:6:\"toggle\";s:6:\"states\";a:2:{s:6:\"active\";a:1:{s:6:\"styles\";a:1:{s:16:\"background-color\";s:7:\"#1863DC\";}}s:8:\"inactive\";a:1:{s:6:\"styles\";a:1:{s:16:\"background-color\";s:7:\"#D0D5D2\";}}}}s:7:\"buttons\";a:3:{s:6:\"status\";b:1;s:3:\"tag\";s:31:\"detail-category-preview-buttons\";s:8:\"elements\";a:1:{s:4:\"save\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:35:\"detail-category-preview-save-button\";s:4:\"type\";s:6:\"button\";s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#1863DC\";s:16:\"background-color\";s:11:\"transparent\";s:12:\"border-color\";s:7:\"#1863DC\";}}}}}}s:16:\"preferenceCenter\";a:5:{s:6:\"status\";b:1;s:3:\"tag\";s:6:\"detail\";s:4:\"type\";s:9:\"container\";s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#212121\";s:16:\"background-color\";s:7:\"#FFFFFF\";s:12:\"border-color\";s:7:\"#f4f4f4\";}s:8:\"elements\";a:6:{s:5:\"title\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:12:\"detail-title\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#212121\";}}s:11:\"description\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:18:\"detail-description\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#212121\";}}s:11:\"closeButton\";a:3:{s:6:\"status\";b:1;s:4:\"type\";s:6:\"button\";s:3:\"tag\";s:12:\"detail-close\";}s:10:\"categories\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:17:\"detail-categories\";s:4:\"type\";s:9:\"container\";s:8:\"elements\";a:3:{s:5:\"title\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:21:\"detail-category-title\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#212121\";}}s:11:\"description\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:27:\"detail-category-description\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#212121\";}}s:6:\"toggle\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:22:\"detail-category-toggle\";s:4:\"type\";s:6:\"toggle\";s:6:\"states\";a:2:{s:6:\"active\";a:1:{s:6:\"styles\";a:1:{s:16:\"background-color\";s:7:\"#1863DC\";}}s:8:\"inactive\";a:1:{s:6:\"styles\";a:1:{s:16:\"background-color\";s:7:\"#D0D5D2\";}}}}}}s:7:\"buttons\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:14:\"detail-buttons\";s:4:\"type\";s:9:\"container\";s:8:\"elements\";a:3:{s:6:\"accept\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:20:\"detail-accept-button\";s:4:\"type\";s:6:\"button\";s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#FFFFFF\";s:16:\"background-color\";s:7:\"#1863DC\";s:12:\"border-color\";s:7:\"#1863DC\";}}s:6:\"reject\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:20:\"detail-reject-button\";s:4:\"type\";s:6:\"button\";s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#1863DC\";s:16:\"background-color\";s:11:\"transparent\";s:12:\"border-color\";s:7:\"#1863DC\";}}s:4:\"save\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:18:\"detail-save-button\";s:4:\"type\";s:6:\"button\";s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#1863DC\";s:16:\"background-color\";s:11:\"transparent\";s:12:\"border-color\";s:7:\"#1863DC\";}}}}s:9:\"poweredBy\";a:3:{s:6:\"status\";b:1;s:3:\"tag\";s:17:\"detail-powered-by\";s:6:\"styles\";a:2:{s:16:\"background-color\";s:7:\"#EDEDED\";s:5:\"color\";s:7:\"#293C5B\";}}}}s:11:\"optoutPopup\";a:5:{s:6:\"status\";b:0;s:3:\"tag\";s:12:\"optout-popup\";s:4:\"type\";s:9:\"container\";s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#212121\";s:16:\"background-color\";s:7:\"#FFFFFF\";s:12:\"border-color\";s:7:\"#F4F4F4\";}s:8:\"elements\";a:7:{s:5:\"title\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:12:\"optout-title\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#212121\";}}s:11:\"description\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:18:\"optout-description\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#212121\";}}s:9:\"optOption\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:13:\"optout-option\";s:4:\"type\";s:9:\"container\";s:8:\"elements\";a:2:{s:6:\"toggle\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:20:\"optout-option-toggle\";s:4:\"type\";s:6:\"toggle\";s:6:\"states\";a:2:{s:6:\"active\";a:1:{s:6:\"styles\";a:1:{s:16:\"background-color\";s:7:\"#1863dc\";}}s:8:\"inactive\";a:1:{s:6:\"styles\";a:1:{s:16:\"background-color\";s:7:\"#FFFFFF\";}}}}s:5:\"title\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:19:\"optout-option-title\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#212121\";}}}}s:9:\"gpcOption\";a:4:{s:4:\"type\";s:9:\"container\";s:3:\"tag\";s:17:\"optout-gpc-option\";s:6:\"status\";b:0;s:8:\"elements\";a:1:{s:11:\"description\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:29:\"optout-gpc-option-description\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#212121\";}}}}s:9:\"poweredBy\";a:3:{s:6:\"status\";b:1;s:3:\"tag\";s:17:\"optout-powered-by\";s:6:\"styles\";a:2:{s:16:\"background-color\";s:7:\"#EDEDED\";s:5:\"color\";s:7:\"#293C5B\";}}s:7:\"buttons\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:14:\"optout-buttons\";s:4:\"type\";s:9:\"container\";s:8:\"elements\";a:2:{s:7:\"confirm\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:21:\"optout-confirm-button\";s:4:\"type\";s:6:\"button\";s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#f4f4f4\";s:16:\"background-color\";s:7:\"#1863dc\";s:12:\"border-color\";s:7:\"#1863dc\";}}s:6:\"cancel\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:20:\"optout-cancel-button\";s:4:\"type\";s:6:\"button\";s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#858585\";s:16:\"background-color\";s:7:\"#FFFFFF\";s:12:\"border-color\";s:7:\"#dedfe0\";}}}}s:11:\"closeButton\";a:3:{s:6:\"status\";b:1;s:3:\"tag\";s:12:\"optout-close\";s:4:\"type\";s:6:\"button\";}}}s:10:\"auditTable\";a:5:{s:6:\"status\";b:1;s:3:\"tag\";s:11:\"audit-table\";s:4:\"type\";s:5:\"table\";s:4:\"meta\";a:1:{s:7:\"headers\";a:3:{i:0;s:2:\"id\";i:1;s:8:\"duration\";i:2;s:11:\"description\";}}s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#212121\";s:16:\"background-color\";s:7:\"#f4f4f4\";s:12:\"border-color\";s:7:\"#ebebeb\";}}s:14:\"revisitConsent\";a:6:{s:6:\"status\";b:1;s:3:\"tag\";s:15:\"revisit-consent\";s:8:\"position\";s:11:\"bottom-left\";s:4:\"meta\";a:1:{s:3:\"url\";s:1:\"#\";}s:6:\"styles\";a:1:{s:16:\"background-color\";s:7:\"#0056A7\";}s:8:\"elements\";a:1:{s:5:\"title\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:21:\"revisit-consent-title\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#0056a7\";}}}}s:16:\"videoPlaceholder\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:17:\"video-placeholder\";s:6:\"styles\";a:2:{s:16:\"background-color\";s:7:\"#000000\";s:12:\"border-color\";s:7:\"#000000\";}s:8:\"elements\";a:1:{s:5:\"title\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:17:\"placeholder-title\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#ffffff\";}}}}}s:4:\"meta\";a:2:{s:9:\"customCSS\";s:0:\"\";s:10:\"customHTML\";s:0:\"\";}}s:8:\"contents\";a:2:{s:2:\"en\";a:7:{s:6:\"notice\";a:1:{s:8:\"elements\";a:5:{s:5:\"title\";s:21:\"We value your privacy\";s:11:\"description\";s:179:\"<p>We use cookies to enhance your browsing experience, serve personalized ads or content, and analyze our traffic. By clicking \"Accept All\", you consent to our use of cookies.</p>\";s:11:\"privacyLink\";s:0:\"\";s:7:\"buttons\";a:1:{s:8:\"elements\";a:5:{s:6:\"accept\";s:10:\"Accept All\";s:6:\"reject\";s:10:\"Reject All\";s:8:\"settings\";s:9:\"Customize\";s:8:\"readMore\";s:13:\"Cookie Policy\";s:9:\"donotSell\";s:44:\"Do Not Sell or Share My Personal Information\";}}s:11:\"closeButton\";s:5:\"Close\";}}s:15:\"categoryPreview\";a:1:{s:8:\"elements\";a:1:{s:7:\"buttons\";a:1:{s:8:\"elements\";a:1:{s:4:\"save\";s:19:\"Save My Preferences\";}}}}s:16:\"preferenceCenter\";a:1:{s:8:\"elements\";a:7:{s:5:\"title\";s:29:\"Customize Consent Preferences\";s:11:\"description\";s:717:\"<p>We use cookies to help you navigate efficiently and perform certain functions. You will find detailed information about all cookies under each consent category below.</p><p>The cookies that are categorized as \"Necessary\" are stored on your browser as they are essential for enabling the basic functionalities of the site. </p><p>We also use third-party cookies that help us analyze how you use this website, store your preferences, and provide the content and advertisements that are relevant to you. These cookies will only be stored in your browser with your prior consent.</p><p>You can choose to enable or disable some or all of these cookies but disabling some of them may affect your browsing experience.</p>\";s:8:\"showMore\";s:9:\"Show more\";s:8:\"showLess\";s:9:\"Show less\";s:8:\"category\";a:1:{s:8:\"elements\";a:3:{s:13:\"alwaysEnabled\";s:13:\"Always Active\";s:6:\"enable\";s:6:\"Enable\";s:7:\"disable\";s:7:\"Disable\";}}s:7:\"buttons\";a:1:{s:8:\"elements\";a:3:{s:6:\"accept\";s:10:\"Accept All\";s:4:\"save\";s:19:\"Save My Preferences\";s:6:\"reject\";s:10:\"Reject All\";}}s:11:\"closeButton\";s:5:\"Close\";}}s:11:\"optoutPopup\";a:1:{s:8:\"elements\";a:8:{s:5:\"title\";s:19:\"Opt-out Preferences\";s:11:\"description\";s:480:\"<p>We use third-party cookies that help us analyze how you use this website, store your preferences, and provide the content and advertisements that are relevant to you. However, you can opt out of these cookies by checking \"Do Not Sell or Share My Personal Information\" and clicking the \"Save My Preferences\" button. Once you opt out, you can opt in again at any time by unchecking \"Do Not Sell or Share My Personal Information\" and clicking the \"Save My Preferences\" button.</p>\";s:9:\"optOption\";a:1:{s:8:\"elements\";a:3:{s:5:\"title\";s:44:\"Do Not Sell or Share My Personal Information\";s:6:\"enable\";s:6:\"Enable\";s:7:\"disable\";s:7:\"Disable\";}}s:9:\"gpcOption\";a:1:{s:8:\"elements\";a:1:{s:11:\"description\";s:188:\"<p>Your opt-out settings for this website have been respected since we detected a <b>Global Privacy Control</b> signal from your browser and, therefore, you cannot change this setting.</p>\";}}s:8:\"showLess\";s:9:\"Show less\";s:8:\"showMore\";s:9:\"Show more\";s:7:\"buttons\";a:1:{s:8:\"elements\";a:2:{s:6:\"cancel\";s:6:\"Cancel\";s:7:\"confirm\";s:19:\"Save My Preferences\";}}s:11:\"closeButton\";s:5:\"Close\";}}s:14:\"revisitConsent\";a:1:{s:8:\"elements\";a:1:{s:5:\"title\";s:15:\"Cookie Settings\";}}s:10:\"auditTable\";a:1:{s:8:\"elements\";a:2:{s:7:\"headers\";a:1:{s:8:\"elements\";a:3:{s:2:\"id\";s:6:\"Cookie\";s:8:\"duration\";s:8:\"Duration\";s:11:\"description\";s:11:\"Description\";}}s:7:\"message\";s:22:\"No cookies to display.\";}}s:16:\"videoPlaceholder\";a:1:{s:8:\"elements\";a:1:{s:5:\"title\";s:44:\"Please accept cookies to access this content\";}}}s:2:\"es\";a:7:{s:6:\"notice\";a:1:{s:8:\"elements\";a:5:{s:5:\"title\";s:23:\"Valoramos tu privacidad\";s:11:\"description\";s:234:\"<p>Usamos cookies para mejorar su experiencia de navegación, mostrarle anuncios o contenidos personalizados y analizar nuestro tráfico. Al hacer clic en “Aceptar todo” usted da su consentimiento a nuestro uso de las cookies.</p>\";s:11:\"privacyLink\";s:0:\"\";s:7:\"buttons\";a:1:{s:8:\"elements\";a:5:{s:6:\"accept\";s:12:\"Aceptar todo\";s:6:\"reject\";s:13:\"Rechazar todo\";s:8:\"settings\";s:12:\"Personalizar\";s:8:\"readMore\";s:20:\"Política de cookies\";s:9:\"donotSell\";s:47:\"No vendan ni compartan mi información personal\";}}s:11:\"closeButton\";s:5:\"Cerca\";}}s:15:\"categoryPreview\";a:1:{s:8:\"elements\";a:1:{s:7:\"buttons\";a:1:{s:8:\"elements\";a:1:{s:4:\"save\";s:24:\"Guardar mis preferencias\";}}}}s:16:\"preferenceCenter\";a:1:{s:8:\"elements\";a:7:{s:5:\"title\";s:47:\"Personalizar las preferencias de consentimiento\";s:11:\"description\";s:814:\"<p>Usamos cookies para ayudarle a navegar de manera eficiente y realizar ciertas funciones. Encontrará información detallada sobre cada una de las cookies bajo cada categoría de consentimiento a continuación.</p><p>Las cookies categorizadas como “Necesarias” se guardan en su navegador, ya que son esenciales para permitir las funcionalidades básicas del sitio web.</p><p>También utilizamos cookies de terceros que nos ayudan a analizar cómo usted utiliza este sitio web, guardar sus preferencias y aportar el contenido y la publicidad que le sean relevantes. Estas cookies solo se guardan en su navegador previo consentimiento por su parte.</p><p>Puede optar por activar o desactivar alguna o todas estas cookies, aunque la desactivación de algunas podría afectar a su experiencia de navegación.</p>\";s:8:\"showMore\";s:12:\"Mostrar más\";s:8:\"showLess\";s:13:\"Mostrar menos\";s:8:\"category\";a:1:{s:8:\"elements\";a:3:{s:13:\"alwaysEnabled\";s:15:\"Siempre activas\";s:6:\"enable\";s:8:\"Permitir\";s:7:\"disable\";s:10:\"Desactivar\";}}s:7:\"buttons\";a:1:{s:8:\"elements\";a:3:{s:6:\"accept\";s:12:\"Aceptar todo\";s:4:\"save\";s:24:\"Guardar mis preferencias\";s:6:\"reject\";s:13:\"Rechazar todo\";}}s:11:\"closeButton\";s:5:\"Cerca\";}}s:11:\"optoutPopup\";a:1:{s:8:\"elements\";a:8:{s:5:\"title\";s:37:\"Preferencias de exclusión voluntaria\";s:11:\"description\";s:582:\"<p>Utilizamos cookies de terceros que nos ayudan a analizar el uso que usted hace de este sitio web, a almacenar sus preferencias y a ofrecerle el contenido y la publicidad que le resulten de interés. Sin embargo, usted puede excluirse de estas cookies marcando «No vendan ni compartan mi información personal» y haciendo clic en el botón «Guardar mis preferencias». Una vez que haya optado por la exclusión, podrá cancelarlo en cualquier momento desmarcando «No vendan ni compartan mi información personal» y haciendo clic en el botón «Guardar mis preferencias».</p>\";s:9:\"optOption\";a:1:{s:8:\"elements\";a:3:{s:5:\"title\";s:47:\"No vendan ni compartan mi información personal\";s:6:\"enable\";s:8:\"Permitir\";s:7:\"disable\";s:10:\"Desactivar\";}}s:9:\"gpcOption\";a:1:{s:8:\"elements\";a:1:{s:11:\"description\";s:220:\"<p>Su configuración de exclusión voluntaria para este sitio web se ha respetado desde que detectamos una señal de control de privacidad global de su navegador y, por lo tanto, no puede cambiar esta configuración.</p>\";}}s:8:\"showLess\";s:12:\"Mostrar más\";s:8:\"showMore\";s:13:\"Mostrar menos\";s:7:\"buttons\";a:1:{s:8:\"elements\";a:2:{s:6:\"cancel\";s:8:\"Cancelar\";s:7:\"confirm\";s:24:\"Guardar mis preferencias\";}}s:11:\"closeButton\";s:5:\"Cerca\";}}s:14:\"revisitConsent\";a:1:{s:8:\"elements\";a:1:{s:5:\"title\";s:25:\"Configuración de cookies\";}}s:10:\"auditTable\";a:1:{s:8:\"elements\";a:2:{s:7:\"headers\";a:1:{s:8:\"elements\";a:3:{s:2:\"id\";s:6:\"Cookie\";s:8:\"duration\";s:9:\"Duración\";s:11:\"description\";s:12:\"Descripción\";}}s:7:\"message\";s:28:\"No hay cookies para mostrar.\";}}s:16:\"videoPlaceholder\";a:1:{s:8:\"elements\";a:1:{s:5:\"title\";s:45:\"Por favor acepte el consentimiento de cookies\";}}}}s:14:\"banner_default\";i:1;s:6:\"status\";i:1;}i:2;O:8:\"stdClass\":7:{s:9:\"banner_id\";i:2;s:4:\"name\";s:4:\"CCPA\";s:4:\"slug\";s:6:\"ccpa-2\";s:8:\"settings\";a:4:{s:8:\"settings\";a:12:{s:2:\"id\";s:8:\"banner-1\";s:4:\"type\";s:3:\"box\";s:20:\"preferenceCenterType\";s:5:\"popup\";s:8:\"position\";s:11:\"bottom-left\";s:9:\"versionID\";s:5:\"6.0.0\";s:13:\"applicableLaw\";s:4:\"ccpa\";s:9:\"languages\";a:2:{s:7:\"default\";s:2:\"en\";s:8:\"selected\";a:1:{i:0;s:2:\"en\";}}s:13:\"templateGroup\";s:7:\"default\";s:10:\"customHtml\";a:1:{s:6:\"status\";b:0;}s:5:\"theme\";s:5:\"light\";s:13:\"consentExpiry\";a:2:{s:6:\"status\";b:1;s:5:\"value\";s:3:\"365\";}s:7:\"ruleSet\";a:1:{i:0;a:2:{s:4:\"code\";s:3:\"ALL\";s:7:\"regions\";a:0:{}}}}s:10:\"behaviours\";a:5:{s:20:\"reloadBannerOnAccept\";a:1:{s:6:\"status\";b:0;}s:22:\"loadAnalyticsByDefault\";a:1:{s:6:\"status\";b:0;}s:10:\"animations\";a:2:{s:6:\"onLoad\";s:7:\"animate\";s:6:\"onHide\";s:6:\"sticky\";}s:15:\"legacyFunctions\";a:5:{s:6:\"accept\";a:2:{s:6:\"action\";s:11:\"acceptClose\";s:6:\"newTab\";b:0;}s:6:\"reject\";a:2:{s:6:\"action\";s:11:\"rejectClose\";s:6:\"newTab\";b:0;}s:4:\"idle\";a:2:{s:6:\"action\";s:11:\"acceptClose\";s:5:\"delay\";s:4:\"1000\";}s:10:\"navigation\";a:1:{s:6:\"action\";s:11:\"acceptClose\";}s:10:\"pageScroll\";a:1:{s:6:\"action\";s:11:\"acceptClose\";}}s:10:\"respectGPC\";a:1:{s:6:\"status\";b:0;}}s:6:\"config\";a:7:{s:6:\"notice\";a:5:{s:6:\"status\";b:1;s:3:\"tag\";s:6:\"notice\";s:4:\"type\";s:9:\"container\";s:6:\"styles\";a:2:{s:16:\"background-color\";s:7:\"#FFFFFF\";s:12:\"border-color\";s:7:\"#f4f4f4\";}s:8:\"elements\";a:5:{s:5:\"title\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:5:\"title\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#212121\";}}s:11:\"description\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:11:\"description\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#212121\";}}s:9:\"brandLogo\";a:3:{s:6:\"status\";b:0;s:3:\"tag\";s:10:\"brand-logo\";s:4:\"meta\";a:1:{s:3:\"url\";s:1:\"#\";}}s:7:\"buttons\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:14:\"notice-buttons\";s:4:\"type\";s:9:\"container\";s:8:\"elements\";a:5:{s:6:\"accept\";a:4:{s:6:\"status\";b:0;s:3:\"tag\";s:13:\"accept-button\";s:4:\"type\";s:6:\"button\";s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#FFFFFF\";s:16:\"background-color\";s:7:\"#1863DC\";s:12:\"border-color\";s:7:\"#1863DC\";}}s:6:\"reject\";a:4:{s:6:\"status\";b:0;s:3:\"tag\";s:13:\"reject-button\";s:4:\"type\";s:6:\"button\";s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#1863DC\";s:16:\"background-color\";s:11:\"transparent\";s:12:\"border-color\";s:7:\"#1863DC\";}}s:8:\"settings\";a:4:{s:6:\"status\";b:0;s:3:\"tag\";s:15:\"settings-button\";s:4:\"type\";s:6:\"button\";s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#1863DC\";s:16:\"background-color\";s:11:\"transparent\";s:12:\"border-color\";s:7:\"#1863DC\";}}s:8:\"readMore\";a:5:{s:6:\"status\";b:0;s:3:\"tag\";s:15:\"readmore-button\";s:4:\"type\";s:4:\"link\";s:4:\"meta\";a:2:{s:8:\"noFollow\";b:1;s:6:\"newTab\";b:1;}s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#1863DC\";s:16:\"background-color\";s:11:\"transparent\";s:12:\"border-color\";s:11:\"transparent\";}}s:9:\"donotSell\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:16:\"donotsell-button\";s:4:\"type\";s:6:\"button\";s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#1863DC\";s:16:\"background-color\";s:11:\"transparent\";s:12:\"border-color\";s:11:\"transparent\";}}}}s:11:\"closeButton\";a:2:{s:6:\"status\";b:1;s:3:\"tag\";s:12:\"close-button\";}}}s:15:\"categoryPreview\";a:4:{s:6:\"status\";b:0;s:4:\"type\";s:9:\"container\";s:3:\"tag\";s:23:\"detail-category-preview\";s:8:\"elements\";a:3:{s:5:\"title\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:29:\"detail-category-preview-title\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#212121\";}}s:6:\"toggle\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:30:\"detail-category-preview-toggle\";s:4:\"type\";s:6:\"toggle\";s:6:\"states\";a:2:{s:6:\"active\";a:1:{s:6:\"styles\";a:1:{s:16:\"background-color\";s:7:\"#1863DC\";}}s:8:\"inactive\";a:1:{s:6:\"styles\";a:1:{s:16:\"background-color\";s:7:\"#D0D5D2\";}}}}s:7:\"buttons\";a:3:{s:6:\"status\";b:1;s:3:\"tag\";s:31:\"detail-category-preview-buttons\";s:8:\"elements\";a:1:{s:4:\"save\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:35:\"detail-category-preview-save-button\";s:4:\"type\";s:6:\"button\";s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#1863DC\";s:16:\"background-color\";s:11:\"transparent\";s:12:\"border-color\";s:7:\"#1863DC\";}}}}}}s:16:\"preferenceCenter\";a:5:{s:6:\"status\";b:0;s:3:\"tag\";s:6:\"detail\";s:4:\"type\";s:9:\"container\";s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#212121\";s:16:\"background-color\";s:7:\"#FFFFFF\";s:12:\"border-color\";s:7:\"#f4f4f4\";}s:8:\"elements\";a:6:{s:5:\"title\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:12:\"detail-title\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#212121\";}}s:11:\"description\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:18:\"detail-description\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#212121\";}}s:11:\"closeButton\";a:3:{s:6:\"status\";b:1;s:4:\"type\";s:6:\"button\";s:3:\"tag\";s:12:\"detail-close\";}s:10:\"categories\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:17:\"detail-categories\";s:4:\"type\";s:9:\"container\";s:8:\"elements\";a:3:{s:5:\"title\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:21:\"detail-category-title\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#212121\";}}s:11:\"description\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:27:\"detail-category-description\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#212121\";}}s:6:\"toggle\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:22:\"detail-category-toggle\";s:4:\"type\";s:6:\"toggle\";s:6:\"states\";a:2:{s:6:\"active\";a:1:{s:6:\"styles\";a:1:{s:16:\"background-color\";s:7:\"#1863DC\";}}s:8:\"inactive\";a:1:{s:6:\"styles\";a:1:{s:16:\"background-color\";s:7:\"#D0D5D2\";}}}}}}s:7:\"buttons\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:14:\"detail-buttons\";s:4:\"type\";s:9:\"container\";s:8:\"elements\";a:3:{s:6:\"accept\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:20:\"detail-accept-button\";s:4:\"type\";s:6:\"button\";s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#FFFFFF\";s:16:\"background-color\";s:7:\"#1863DC\";s:12:\"border-color\";s:7:\"#1863DC\";}}s:6:\"reject\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:20:\"detail-reject-button\";s:4:\"type\";s:6:\"button\";s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#1863DC\";s:16:\"background-color\";s:11:\"transparent\";s:12:\"border-color\";s:7:\"#1863DC\";}}s:4:\"save\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:18:\"detail-save-button\";s:4:\"type\";s:6:\"button\";s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#1863DC\";s:16:\"background-color\";s:11:\"transparent\";s:12:\"border-color\";s:7:\"#1863DC\";}}}}s:9:\"poweredBy\";a:3:{s:6:\"status\";b:1;s:3:\"tag\";s:17:\"detail-powered-by\";s:6:\"styles\";a:2:{s:16:\"background-color\";s:7:\"#EDEDED\";s:5:\"color\";s:7:\"#293C5B\";}}}}s:11:\"optoutPopup\";a:5:{s:6:\"status\";b:1;s:3:\"tag\";s:12:\"optout-popup\";s:4:\"type\";s:9:\"container\";s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#212121\";s:16:\"background-color\";s:7:\"#FFFFFF\";s:12:\"border-color\";s:7:\"#F4F4F4\";}s:8:\"elements\";a:7:{s:5:\"title\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:12:\"optout-title\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#212121\";}}s:11:\"description\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:18:\"optout-description\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#212121\";}}s:9:\"optOption\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:13:\"optout-option\";s:4:\"type\";s:9:\"container\";s:8:\"elements\";a:2:{s:6:\"toggle\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:20:\"optout-option-toggle\";s:4:\"type\";s:6:\"toggle\";s:6:\"states\";a:2:{s:6:\"active\";a:1:{s:6:\"styles\";a:1:{s:16:\"background-color\";s:7:\"#1863dc\";}}s:8:\"inactive\";a:1:{s:6:\"styles\";a:1:{s:16:\"background-color\";s:7:\"#FFFFFF\";}}}}s:5:\"title\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:19:\"optout-option-title\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#212121\";}}}}s:9:\"gpcOption\";a:4:{s:4:\"type\";s:9:\"container\";s:3:\"tag\";s:17:\"optout-gpc-option\";s:6:\"status\";b:0;s:8:\"elements\";a:1:{s:11:\"description\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:29:\"optout-gpc-option-description\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#212121\";}}}}s:9:\"poweredBy\";a:3:{s:6:\"status\";b:1;s:3:\"tag\";s:17:\"optout-powered-by\";s:6:\"styles\";a:2:{s:16:\"background-color\";s:7:\"#EDEDED\";s:5:\"color\";s:7:\"#293C5B\";}}s:7:\"buttons\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:14:\"optout-buttons\";s:4:\"type\";s:9:\"container\";s:8:\"elements\";a:2:{s:7:\"confirm\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:21:\"optout-confirm-button\";s:4:\"type\";s:6:\"button\";s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#f4f4f4\";s:16:\"background-color\";s:7:\"#1863dc\";s:12:\"border-color\";s:7:\"#1863dc\";}}s:6:\"cancel\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:20:\"optout-cancel-button\";s:4:\"type\";s:6:\"button\";s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#858585\";s:16:\"background-color\";s:7:\"#FFFFFF\";s:12:\"border-color\";s:7:\"#dedfe0\";}}}}s:11:\"closeButton\";a:3:{s:6:\"status\";b:1;s:3:\"tag\";s:12:\"optout-close\";s:4:\"type\";s:6:\"button\";}}}s:10:\"auditTable\";a:5:{s:6:\"status\";b:0;s:3:\"tag\";s:11:\"audit-table\";s:4:\"type\";s:5:\"table\";s:4:\"meta\";a:1:{s:7:\"headers\";a:3:{i:0;s:2:\"id\";i:1;s:8:\"duration\";i:2;s:11:\"description\";}}s:6:\"styles\";a:3:{s:5:\"color\";s:7:\"#212121\";s:16:\"background-color\";s:7:\"#f4f4f4\";s:12:\"border-color\";s:7:\"#ebebeb\";}}s:14:\"revisitConsent\";a:6:{s:6:\"status\";b:1;s:3:\"tag\";s:15:\"revisit-consent\";s:8:\"position\";s:11:\"bottom-left\";s:4:\"meta\";a:1:{s:3:\"url\";s:1:\"#\";}s:6:\"styles\";a:1:{s:16:\"background-color\";s:7:\"#0056A7\";}s:8:\"elements\";a:1:{s:5:\"title\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:21:\"revisit-consent-title\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#0056a7\";}}}}s:16:\"videoPlaceholder\";a:4:{s:6:\"status\";b:1;s:3:\"tag\";s:17:\"video-placeholder\";s:6:\"styles\";a:2:{s:16:\"background-color\";s:7:\"#000000\";s:12:\"border-color\";s:7:\"#000000\";}s:8:\"elements\";a:1:{s:5:\"title\";a:4:{s:4:\"type\";s:4:\"text\";s:3:\"tag\";s:17:\"placeholder-title\";s:6:\"status\";b:1;s:6:\"styles\";a:1:{s:5:\"color\";s:7:\"#ffffff\";}}}}}s:4:\"meta\";a:2:{s:9:\"customCSS\";s:0:\"\";s:10:\"customHTML\";s:0:\"\";}}s:8:\"contents\";a:2:{s:2:\"en\";a:7:{s:6:\"notice\";a:1:{s:8:\"elements\";a:5:{s:5:\"title\";s:21:\"We value your privacy\";s:11:\"description\";s:189:\"This website or its third-party tools process personal data. You can opt out of the sale of your personal information by clicking on the \"Do Not Sell or Share My Personal Information\" link.\";s:11:\"privacyLink\";s:0:\"\";s:7:\"buttons\";a:1:{s:8:\"elements\";a:5:{s:6:\"accept\";s:10:\"Accept All\";s:6:\"reject\";s:10:\"Reject All\";s:8:\"settings\";s:9:\"Customize\";s:8:\"readMore\";s:13:\"Cookie Policy\";s:9:\"donotSell\";s:44:\"Do Not Sell or Share My Personal Information\";}}s:11:\"closeButton\";s:5:\"Close\";}}s:15:\"categoryPreview\";a:1:{s:8:\"elements\";a:1:{s:7:\"buttons\";a:1:{s:8:\"elements\";a:1:{s:4:\"save\";s:19:\"Save My Preferences\";}}}}s:16:\"preferenceCenter\";a:1:{s:8:\"elements\";a:7:{s:5:\"title\";s:29:\"Customize Consent Preferences\";s:11:\"description\";s:717:\"<p>We use cookies to help you navigate efficiently and perform certain functions. You will find detailed information about all cookies under each consent category below.</p><p>The cookies that are categorized as \"Necessary\" are stored on your browser as they are essential for enabling the basic functionalities of the site. </p><p>We also use third-party cookies that help us analyze how you use this website, store your preferences, and provide the content and advertisements that are relevant to you. These cookies will only be stored in your browser with your prior consent.</p><p>You can choose to enable or disable some or all of these cookies but disabling some of them may affect your browsing experience.</p>\";s:8:\"showMore\";s:9:\"Show more\";s:8:\"showLess\";s:9:\"Show less\";s:8:\"category\";a:1:{s:8:\"elements\";a:3:{s:13:\"alwaysEnabled\";s:13:\"Always Active\";s:6:\"enable\";s:6:\"Enable\";s:7:\"disable\";s:7:\"Disable\";}}s:7:\"buttons\";a:1:{s:8:\"elements\";a:3:{s:6:\"accept\";s:10:\"Accept All\";s:4:\"save\";s:19:\"Save My Preferences\";s:6:\"reject\";s:10:\"Reject All\";}}s:11:\"closeButton\";s:5:\"Close\";}}s:11:\"optoutPopup\";a:1:{s:8:\"elements\";a:8:{s:5:\"title\";s:19:\"Opt-out Preferences\";s:11:\"description\";s:480:\"<p>We use third-party cookies that help us analyze how you use this website, store your preferences, and provide the content and advertisements that are relevant to you. However, you can opt out of these cookies by checking \"Do Not Sell or Share My Personal Information\" and clicking the \"Save My Preferences\" button. Once you opt out, you can opt in again at any time by unchecking \"Do Not Sell or Share My Personal Information\" and clicking the \"Save My Preferences\" button.</p>\";s:9:\"optOption\";a:1:{s:8:\"elements\";a:3:{s:5:\"title\";s:44:\"Do Not Sell or Share My Personal Information\";s:6:\"enable\";s:6:\"Enable\";s:7:\"disable\";s:7:\"Disable\";}}s:9:\"gpcOption\";a:1:{s:8:\"elements\";a:1:{s:11:\"description\";s:188:\"<p>Your opt-out settings for this website have been respected since we detected a <b>Global Privacy Control</b> signal from your browser and, therefore, you cannot change this setting.</p>\";}}s:8:\"showLess\";s:9:\"Show less\";s:8:\"showMore\";s:9:\"Show more\";s:7:\"buttons\";a:1:{s:8:\"elements\";a:2:{s:6:\"cancel\";s:6:\"Cancel\";s:7:\"confirm\";s:19:\"Save My Preferences\";}}s:11:\"closeButton\";s:5:\"Close\";}}s:14:\"revisitConsent\";a:1:{s:8:\"elements\";a:1:{s:5:\"title\";s:15:\"Cookie Settings\";}}s:10:\"auditTable\";a:1:{s:8:\"elements\";a:2:{s:7:\"headers\";a:1:{s:8:\"elements\";a:3:{s:2:\"id\";s:6:\"Cookie\";s:8:\"duration\";s:8:\"Duration\";s:11:\"description\";s:11:\"Description\";}}s:7:\"message\";s:22:\"No cookies to display.\";}}s:16:\"videoPlaceholder\";a:1:{s:8:\"elements\";a:1:{s:5:\"title\";s:44:\"Please accept cookies to access this content\";}}}s:2:\"es\";a:7:{s:6:\"notice\";a:1:{s:8:\"elements\";a:5:{s:5:\"title\";s:23:\"Valoramos tu privacidad\";s:11:\"description\";s:220:\"Este sitio web o sus herramientas de terceros procesan datos personales. Puede optar por no participar en la venta de su información personal haciendo clic en el enlace \"No vendan ni compartan mi información personal\".\";s:11:\"privacyLink\";s:0:\"\";s:7:\"buttons\";a:1:{s:8:\"elements\";a:5:{s:6:\"accept\";s:12:\"Aceptar todo\";s:6:\"reject\";s:13:\"Rechazar todo\";s:8:\"settings\";s:12:\"Personalizar\";s:8:\"readMore\";s:20:\"Política de cookies\";s:9:\"donotSell\";s:47:\"No vendan ni compartan mi información personal\";}}s:11:\"closeButton\";s:5:\"Cerca\";}}s:15:\"categoryPreview\";a:1:{s:8:\"elements\";a:1:{s:7:\"buttons\";a:1:{s:8:\"elements\";a:1:{s:4:\"save\";s:24:\"Guardar mis preferencias\";}}}}s:16:\"preferenceCenter\";a:1:{s:8:\"elements\";a:7:{s:5:\"title\";s:47:\"Personalizar las preferencias de consentimiento\";s:11:\"description\";s:814:\"<p>Usamos cookies para ayudarle a navegar de manera eficiente y realizar ciertas funciones. Encontrará información detallada sobre cada una de las cookies bajo cada categoría de consentimiento a continuación.</p><p>Las cookies categorizadas como “Necesarias” se guardan en su navegador, ya que son esenciales para permitir las funcionalidades básicas del sitio web.</p><p>También utilizamos cookies de terceros que nos ayudan a analizar cómo usted utiliza este sitio web, guardar sus preferencias y aportar el contenido y la publicidad que le sean relevantes. Estas cookies solo se guardan en su navegador previo consentimiento por su parte.</p><p>Puede optar por activar o desactivar alguna o todas estas cookies, aunque la desactivación de algunas podría afectar a su experiencia de navegación.</p>\";s:8:\"showMore\";s:12:\"Mostrar más\";s:8:\"showLess\";s:13:\"Mostrar menos\";s:8:\"category\";a:1:{s:8:\"elements\";a:3:{s:13:\"alwaysEnabled\";s:15:\"Siempre activas\";s:6:\"enable\";s:8:\"Permitir\";s:7:\"disable\";s:10:\"Desactivar\";}}s:7:\"buttons\";a:1:{s:8:\"elements\";a:3:{s:6:\"accept\";s:12:\"Aceptar todo\";s:4:\"save\";s:24:\"Guardar mis preferencias\";s:6:\"reject\";s:13:\"Rechazar todo\";}}s:11:\"closeButton\";s:5:\"Cerca\";}}s:11:\"optoutPopup\";a:1:{s:8:\"elements\";a:8:{s:5:\"title\";s:37:\"Preferencias de exclusión voluntaria\";s:11:\"description\";s:582:\"<p>Utilizamos cookies de terceros que nos ayudan a analizar el uso que usted hace de este sitio web, a almacenar sus preferencias y a ofrecerle el contenido y la publicidad que le resulten de interés. Sin embargo, usted puede excluirse de estas cookies marcando «No vendan ni compartan mi información personal» y haciendo clic en el botón «Guardar mis preferencias». Una vez que haya optado por la exclusión, podrá cancelarlo en cualquier momento desmarcando «No vendan ni compartan mi información personal» y haciendo clic en el botón «Guardar mis preferencias».</p>\";s:9:\"optOption\";a:1:{s:8:\"elements\";a:3:{s:5:\"title\";s:47:\"No vendan ni compartan mi información personal\";s:6:\"enable\";s:8:\"Permitir\";s:7:\"disable\";s:10:\"Desactivar\";}}s:9:\"gpcOption\";a:1:{s:8:\"elements\";a:1:{s:11:\"description\";s:220:\"<p>Su configuración de exclusión voluntaria para este sitio web se ha respetado desde que detectamos una señal de control de privacidad global de su navegador y, por lo tanto, no puede cambiar esta configuración.</p>\";}}s:8:\"showLess\";s:12:\"Mostrar más\";s:8:\"showMore\";s:13:\"Mostrar menos\";s:7:\"buttons\";a:1:{s:8:\"elements\";a:2:{s:6:\"cancel\";s:8:\"Cancelar\";s:7:\"confirm\";s:24:\"Guardar mis preferencias\";}}s:11:\"closeButton\";s:5:\"Cerca\";}}s:14:\"revisitConsent\";a:1:{s:8:\"elements\";a:1:{s:5:\"title\";s:25:\"Configuración de cookies\";}}s:10:\"auditTable\";a:1:{s:8:\"elements\";a:2:{s:7:\"headers\";a:1:{s:8:\"elements\";a:3:{s:2:\"id\";s:6:\"Cookie\";s:8:\"duration\";s:9:\"Duración\";s:11:\"description\";s:12:\"Descripción\";}}s:7:\"message\";s:28:\"No hay cookies para mostrar.\";}}s:16:\"videoPlaceholder\";a:1:{s:8:\"elements\";a:1:{s:5:\"title\";s:45:\"Por favor acepte el consentimiento de cookies\";}}}}s:14:\"banner_default\";i:0;s:6:\"status\";i:0;}}", "on");
INSERT INTO `wp_options` VALUES("85102", "e_editor_counter", "12", "auto");
INSERT INTO `wp_options` VALUES("85103", "_elementor_free_to_pro_upsell", "a:2:{s:7:\"timeout\";i:1755716918;s:5:\"value\";s:593:\"[{\"id\":\"animated_headline\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/animated_headline.jpg\"},{\"id\":\"video_playlist\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/video_playlist.jpg\"},{\"id\":\"cta\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/cta.jpg\"},{\"id\":\"testimonial_widget\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/testimonial_widget.jpg\"},{\"id\":\"image_carousel\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/image_carousel.jpg\"}]\";}", "off");
INSERT INTO `wp_options` VALUES("85104", "_elementor_notifications_data", "a:2:{s:7:\"timeout\";i:1755716918;s:5:\"value\";s:15897:\"[{\"id\":\"host-special-offer\",\"title\":\"Host with Elementor, Get Unified Support for Building & Hosting\",\"description\":\"Advance to Elementor\'s Cloud Hosting powered by Google Cloud and Cloudflare. Use the coupon CLOUDPLUSSPECIAL2025 to get Host Cloud Plus at the price of Host Cloud.\",\"topic\":\"Special offer: Elementor Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/host_coupon.png\",\"chipTags\":[\"Cloud Hosting\"],\"cta\":\"Get it Now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/host-whats-new-host-discount\\/\"},{\"id\":\"ally-assistant\",\"title\":\"New! Fix accessibility issues with Ally Assistant\",\"description\":\"Scan any page for accessibility issues and fix them in one click. From color contrast to missing alt text, Ally Assistant provides guided steps or AI-powered fixes to make your site more inclusive.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-assistant.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Scan for free\",\"ctaLink\":\"http:\\/\\/go.elementor.com\\/acc-assistant-launch-whats-new\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"send-notification-august\",\"title\":\"All Your Assets, One Library\",\"description\":\"Save time and skip the re-uploads - now you can pull images straight from your WordPress Media Library into Send. Faster, simpler, and built for WordPress.\",\"topic\":\"Send: Email & SMS built for WooCommerce\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aug_send.png\",\"chipTags\":[\"Cart abandonment\"],\"cta\":\"Upload Your Assets\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/ML_WN\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"send-app\\/send-app.php\"}]]},{\"id\":\"classes-3.30\",\"title\":\"Better class control\",\"description\":\"Get popovers with your class name, breakpoint, state and possible conflicts. Plus, the exact class names you define are now reflected in the code, making debugging and working with external tools easier!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/classes-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.30-cloud-websites\\/\"},{\"id\":\"tools-3.30\",\"title\":\"Essential Editor tools\",\"description\":\"V4 now includes a long list of essential V3 capabilities, re-engineered to fit the new framework - IDs, custom unit, anchor offset, display none, object fit, clear icons and more!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/tools-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"youtube-3.30\",\"title\":\"YouTube Element\",\"description\":\"The new YouTube Element is purpose-built to support V4 capabilities with faster rendering, better performance, and familiar controls like autoplay, loop, mute, and aspect ratio.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/youtube-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"host-google-cloud\",\"title\":\"Deliver fast, secure websites at scale - free migration included!\",\"description\":\"Host your site on Elementor\\u2019s infrastructure - built for speed, security, and scale. Powered by Google Cloud, with free migration and 24\\/7 expert support.\",\"topic\":\"Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/host-google-cloud.png\",\"chipTags\":[\"Cloud Hosting\"],\"link\":\"https:\\/\\/go.elementor.com\\/elementor-host-google-cloud\",\"readMoreText\":\"Read More\"},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates\\/\"},{\"id\":\"classes-3.29\",\"title\":\"Classes: Style Once, Apply Everywhere\",\"description\":\"Create Classes to define styling patterns once and apply them across your entire site with a single click. Add States for stunning hover and focus effects\\u2014no coding needed!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-classes.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"style-tab-3.29\",\"title\":\"Consistent Styling Everywhere\",\"description\":\"Every V4 element shares the same styling capabilities in the same logical order and location. Plus, we\'ve streamlined from 3 tabs to just 2\\u2014content in one, styling in the other!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-style-tab.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"responsive-3.29\",\"title\":\"Fully Responsive Design\",\"description\":\"With Editor V4, every single style property can be customized per device. Complete creative control for desktop, tablet, and mobile!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-responsive.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"performance-3.29\",\"title\":\"Blazing fast performance\",\"description\":\"In Editor V4, each element uses one clean div instead of multiple nested divs like in the current version\\u2014your sites will load lightning-fast with cleaner code!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-performance.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"migration-host\",\"title\":\"Move to Better Cloud Hosting, Painlessly\",\"description\":\"Migrate your Elementor website for free to a home that\\u2019s perfect for it, in minutes, with a combination of\\u2028advanced automation and free expert support\",\"topic\":\"Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/migration-host.png\",\"chipTags\":[\"Cloud Hosting\"],\"link\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\",\"readMoreText\":\"Learn More\",\"cta\":\"Migrate for free\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"introduction_meta\",\"meta\":\"ai_get_started\"}]],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Start Free Trial\",\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"hello-biz-contact\",\"title\":\"New Contact Widget, Visual Layout Presets & more\",\"description\":\"Hello Biz just got an update! Explore the new Contact Widget, Visual Layout Presets, Form Submissions integration, and fresh new kits.\",\"topic\":\"Hello Biz\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/hello-biz-contact.png\",\"chipTags\":[\"New Features\"],\"link\":\"https:\\/\\/go.elementor.com\\/hello-biz-updates\",\"readMoreText\":\"Learn More\"},{\"id\":\"ai-site-planner-colors\",\"title\":\"Style Your Wireframe, Speed Up Your Store Build\",\"description\":\"Site Planner now lets you style your wireframe with fonts and colors - instantly visualizing your site\\u2019s look and feel. Plus, it predesigns pages for WooCommerce like Cart and Checkout, so you can dive straight into customizations\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/site-planner-colors.png\",\"chipTags\":[\"New Feature\"],\"link\":\"http:\\/\\/www.elementor.com\\/ai-site-planner\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-notification\",\"title\":\"Just released! Ally - a new plugin for web accessibility & usability\",\"description\":\"Ally simplifies the complexities of making your website more accessible. With new regulations here and coming, making your website more usable and inclusive is no longer just an option, but a must.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-notification.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get it free\",\"ctaLink\":\"https:\\/\\/wordpress.org\\/plugins\\/pojo-accessibility\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"ai-site-planner\",\"title\":\"Instant Sitemaps & Wireframes\",\"description\":\"Get your website plan in minutes with AI Site Planner. Describe your desired site and AI will generate a sitemap, brief and wireframe populated with initial content, ready for you to customize.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aI-site-planner.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/ai-notification-site-planner\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"grid-span-3.27\",\"title\":\"Design Grid layouts that fit your exact vision\",\"description\":\"Advanced column and row span controls give you the power to design Grid Container layouts that fit your exact vision.\",\"topic\":\"Elementor 3.27\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/grid-span-3.27.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.27-grid-span-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"local-fonts-3.27\",\"title\":\"Load Google Fonts safer and faster\",\"description\":\"Once enabled, Google Fonts are served directly from your server, streamlining the loading process and enhancing security.\",\"topic\":\"Elementor 3.27\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/local-google-fonts-3.27.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.27-local-fonts-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"video-shorts-3.27\",\"title\":\"Showcase short-form, vertical videos\",\"description\":\"The Video widget now supports YouTube Shorts in a vertical 9:16 ratio, the go-to format for engaging audiences.\",\"topic\":\"Elementor 3.27\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/video-shorts-3.27.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.27-video-shorts-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"dynamic-off-canvas-3.26\",\"title\":\"Dynamic Off-Canvas for Loop Grids\",\"description\":\"Create richer, more interactive designs by linking Dynamic Content to the Off Canvas widget, delivering seamless user experiences.\",\"topic\":\"Elementor Pro 3.26\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/off-canvas-loop-grids.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.26-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"dynamic-off-canvas-3.26\",\"title\":\"Dynamic Off-Canvas for Loop Grids\",\"description\":\"Create richer, more interactive designs by linking Dynamic Content to the Off Canvas widget, delivering seamless user experiences.\",\"topic\":\"Elementor Pro 3.26\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/off-canvas-loop-grids.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.26-loop-off-canvas\\/\"},{\"id\":\"image-optimizer-3.19\",\"title\":\"Effortlessly optimize images for a stunning, high-speed website with the Image Optimizer plugin.\",\"description\":\"Image Optimizer perfectly balances between image quality and performance to boost your website.  Resize, compress, and convert images to WebP, for faster loading times and and better user experience.\",\"topic\":\"Image Optimizer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/image-optimizer-3.19.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get the Image Optimizer\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/io-notification-wp-dash-learn-more\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"image-optimization\\/image-optimization.php\"}]]},{\"id\":\"5-star-rating-prompt\",\"title\":\"Love the New Features? Let Us Know with 5 Stars!\",\"description\":\"Help spread the word by telling the world what you love about Elementor.\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/5-star-rating-prompt.png\",\"cta\":\"Leave a Review\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/wp-dash-notification-five-stars\\/\"},{\"id\":\"site-mailer-introducing\",\"title\":\"Introducing Site Mailer\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"topic\":\"Site Mailer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/Site-mailer.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/sm-wp-dash-whatsnew\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"site-mailer\\/site-mailer.php\"}]]}]\";}", "off");
INSERT INTO `wp_options` VALUES("85107", "elementor_connect_site_key", "e0537fb62280984b3a4a5e83f5eb25c6", "auto");
INSERT INTO `wp_options` VALUES("85117", "recovery_mode_email_last_sent", "1750089267", "auto");
INSERT INTO `wp_options` VALUES("85129", "elementor_clear_cache", "", "auto");
INSERT INTO `wp_options` VALUES("85130", "elementor_reset_api_data", "", "auto");
INSERT INTO `wp_options` VALUES("85131", "elementor_enable_inspector", "", "auto");
INSERT INTO `wp_options` VALUES("85132", "elementor_replace_url", "", "auto");
INSERT INTO `wp_options` VALUES("85133", "elementor_rollback", "", "auto");
INSERT INTO `wp_options` VALUES("85134", "elementor_beta", "no", "auto");
INSERT INTO `wp_options` VALUES("85135", "elementor_maintenance_mode_mode", "", "auto");
INSERT INTO `wp_options` VALUES("85136", "elementor_maintenance_mode_exclude_mode", "logged_in", "auto");
INSERT INTO `wp_options` VALUES("85137", "elementor_maintenance_mode_exclude_roles", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("85138", "elementor_maintenance_mode_template_id", "", "auto");
INSERT INTO `wp_options` VALUES("85202", "_wpforms_transient_timeout_docs.json", "1766026611", "off");
INSERT INTO `wp_options` VALUES("85203", "_wpforms_transient_docs.json", "1765421811", "off");
INSERT INTO `wp_options` VALUES("85207", "_wpforms_transient_timeout_templates.json", "1766026611", "off");
INSERT INTO `wp_options` VALUES("85208", "_wpforms_transient_templates.json", "1765421811", "off");
INSERT INTO `wp_options` VALUES("85212", "wpforms_constant_contact_version", "3", "auto");
INSERT INTO `wp_options` VALUES("85216", "wpforms_splash_version", "1.9.7", "auto");
INSERT INTO `wp_options` VALUES("85224", "_wpforms_transient_timeout_addons.json", "1766026611", "off");
INSERT INTO `wp_options` VALUES("85225", "_wpforms_transient_addons.json", "1765421811", "off");
INSERT INTO `wp_options` VALUES("85226", "wpforms_pointers", "a:2:{s:10:\"engagement\";a:0:{}s:7:\"dismiss\";a:1:{i:0;s:19:\"admin_menu_payments\";}}", "auto");
INSERT INTO `wp_options` VALUES("85227", "_wpforms_transient_wpforms_htaccess_file", "a:3:{s:4:\"size\";i:767;s:5:\"mtime\";i:1742357708;s:5:\"ctime\";i:1742357708;}", "on");
INSERT INTO `wp_options` VALUES("85228", "_wpforms_transient_wpforms_/home/u176508502/domains/procuradorgalicia.es/public_html/wp-content/uploads/wpforms/cache/.htaccess_file", "a:3:{s:4:\"size\";i:476;s:5:\"mtime\";i:1765660333;s:5:\"ctime\";i:1765660333;}", "on");
INSERT INTO `wp_options` VALUES("85233", "wpforms_version_previous", "1.9.8.2", "auto");
INSERT INTO `wp_options` VALUES("85236", "wpforms_splash_data_version", "1.9.6", "auto");
INSERT INTO `wp_options` VALUES("85251", "wpforms_templates_hash", "92bcd91d08ba63c72764829015bebfd2", "auto");
INSERT INTO `wp_options` VALUES("99794", "elementor_landing_pages_activation", "0", "auto");
INSERT INTO `wp_options` VALUES("99817", "_wpforms_transient_upload_htaccess_file", "a:3:{s:4:\"size\";i:767;s:5:\"mtime\";i:1750089379;s:5:\"ctime\";i:1750089379;}", "on");
INSERT INTO `wp_options` VALUES("99852", "_transient_jetpack_autoloader_plugin_paths", "a:2:{i:0;s:27:\"{{WP_PLUGIN_DIR}}/hostinger\";i:1;s:43:\"{{WP_PLUGIN_DIR}}/hostinger-easy-onboarding\";}", "on");
INSERT INTO `wp_options` VALUES("100612", "wpforms_email_summaries_shown_notifications", "a:1:{i:0;i:442;}", "off");
INSERT INTO `wp_options` VALUES("100803", "hostinger_tools", "a:7:{s:16:\"maintenance_mode\";b:0;s:11:\"bypass_code\";s:0:\"\";s:15:\"disable_xml_rpc\";b:0;s:11:\"force_https\";b:0;s:9:\"force_www\";b:0;s:31:\"disable_authentication_password\";b:1;s:15:\"enable_llms_txt\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("101560", "cky_promo_notices", "a:1:{s:13:\"notice_banner\";a:4:{s:11:\"dismissible\";b:1;s:4:\"type\";s:5:\"promo\";s:10:\"expiration\";i:0;s:7:\"message\";s:0:\"\";}}", "auto");
INSERT INTO `wp_options` VALUES("107866", "_elementor_element_cache_unique_id", "fc9124a459c03743018c1a208e76b2c4", "auto");
INSERT INTO `wp_options` VALUES("108173", "_transient_timeout_hostinger_hide_addons_banner", "1786869768", "off");
INSERT INTO `wp_options` VALUES("108174", "_transient_hostinger_hide_addons_banner", "1", "off");
INSERT INTO `wp_options` VALUES("108690", "_elementor_local_google_fonts", "a:1:{s:6:\"roboto\";a:2:{s:3:\"url\";s:85:\"https://procuradorgalicia.es/wp-content/uploads/elementor/google-fonts/css/roboto.css\";s:7:\"version\";i:1755713332;}}", "auto");
INSERT INTO `wp_options` VALUES("108700", "wp_mail_smtp_initial_version", "4.5.0", "off");
INSERT INTO `wp_options` VALUES("108701", "wp_mail_smtp_version", "4.5.0", "off");
INSERT INTO `wp_options` VALUES("108702", "wp_mail_smtp", "a:15:{s:4:\"mail\";a:6:{s:10:\"from_email\";s:27:\"correo@procuradorgalicia.es\";s:9:\"from_name\";s:0:\"\";s:6:\"mailer\";s:4:\"smtp\";s:11:\"return_path\";b:0;s:16:\"from_email_force\";b:0;s:15:\"from_name_force\";b:0;}s:4:\"smtp\";a:7:{s:7:\"autotls\";b:1;s:4:\"auth\";b:1;s:4:\"host\";s:0:\"\";s:10:\"encryption\";s:4:\"none\";s:4:\"port\";i:0;s:4:\"user\";s:0:\"\";s:4:\"pass\";s:56:\"uh3O3mb2rUqJdPEmnaRiT3xWcXXqpnFtIjZl3d8WZaePWaUOSnu0aw==\";}s:7:\"general\";a:1:{s:29:\"summary_report_email_disabled\";b:0;}s:9:\"sendlayer\";a:1:{s:7:\"api_key\";s:0:\"\";}s:7:\"smtpcom\";a:2:{s:7:\"api_key\";s:0:\"\";s:7:\"channel\";s:0:\"\";}s:10:\"sendinblue\";a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"domain\";s:0:\"\";}s:12:\"elasticemail\";a:1:{s:7:\"api_key\";s:0:\"\";}s:5:\"gmail\";a:2:{s:9:\"client_id\";s:0:\"\";s:13:\"client_secret\";s:0:\"\";}s:7:\"mailgun\";a:3:{s:7:\"api_key\";s:0:\"\";s:6:\"domain\";s:0:\"\";s:6:\"region\";s:2:\"US\";}s:7:\"mailjet\";a:2:{s:7:\"api_key\";s:0:\"\";s:10:\"secret_key\";s:0:\"\";}s:10:\"mailersend\";a:2:{s:7:\"api_key\";s:0:\"\";s:12:\"has_pro_plan\";b:0;}s:8:\"postmark\";a:2:{s:16:\"server_api_token\";s:0:\"\";s:14:\"message_stream\";s:0:\"\";}s:8:\"sendgrid\";a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"domain\";s:0:\"\";}s:7:\"smtp2go\";a:1:{s:7:\"api_key\";s:0:\"\";}s:9:\"sparkpost\";a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"region\";s:2:\"US\";}}", "off");
INSERT INTO `wp_options` VALUES("108703", "wp_mail_smtp_activated_time", "1755713502", "off");
INSERT INTO `wp_options` VALUES("108704", "wp_mail_smtp_activated", "a:1:{s:4:\"lite\";i:1755713502;}", "auto");
INSERT INTO `wp_options` VALUES("108709", "wp_mail_smtp_source", "wpforms", "auto");
INSERT INTO `wp_options` VALUES("108711", "wp_mail_smtp_migration_version", "5", "on");
INSERT INTO `wp_options` VALUES("108712", "wp_mail_smtp_debug_events_db_version", "1", "on");
INSERT INTO `wp_options` VALUES("108713", "wp_mail_smtp_setup_wizard_stats", "a:3:{s:13:\"launched_time\";i:1755713509;s:14:\"completed_time\";i:0;s:14:\"was_successful\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("108717", "wp_mail_smtp_notifications", "a:4:{s:6:\"update\";i:1765660353;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("108720", "wp_mail_smtp_review_notice", "a:2:{s:4:\"time\";i:1755713731;s:9:\"dismissed\";b:0;}", "auto");
INSERT INTO `wp_options` VALUES("108731", "wp_mail_smtp_debug", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("108732", "wp_mail_smtp_lite_sent_email_counter", "58", "on");
INSERT INTO `wp_options` VALUES("108733", "wp_mail_smtp_lite_weekly_sent_email_counter", "a:12:{i:39;i:2;i:40;i:3;i:41;i:2;i:42;i:2;i:43;i:3;i:44;i:2;i:45;i:3;i:46;i:3;i:47;i:5;i:48;i:2;i:49;i:2;i:50;i:3;}", "on");
INSERT INTO `wp_options` VALUES("108736", "wp_mail_smtp_mail_key", "kOfUK5Swk/eIOBcMjHGxL87gi+l0DI+POoDitNzCfRA=", "auto");
INSERT INTO `wp_options` VALUES("109352", "wp_mail_smtp_summary_report_email_last_sent_week", "50", "auto");
INSERT INTO `wp_options` VALUES("109628", "hostinger_onboarding_steps_was_completed", "0", "auto");
INSERT INTO `wp_options` VALUES("111025", "updraftplus_version", "1.25.9", "on");
INSERT INTO `wp_options` VALUES("111026", "updraft_updraftvault", "a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-4a8b637efa7bb2f5086c825486a21a33\";a:3:{s:5:\"token\";s:0:\"\";s:5:\"email\";s:0:\"\";s:5:\"quota\";i:-1;}}}", "on");
INSERT INTO `wp_options` VALUES("111027", "updraft_dropbox", "a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-318eccdd6feba75cda2ba19b453adda7\";a:4:{s:6:\"appkey\";s:0:\"\";s:6:\"secret\";s:0:\"\";s:6:\"folder\";s:0:\"\";s:15:\"tk_access_token\";s:0:\"\";}}}", "on");
INSERT INTO `wp_options` VALUES("111028", "updraft_s3", "a:2:{s:7:\"version\";s:1:\"1\";s:8:\"settings\";a:1:{s:34:\"s-ac5281f9d1138dfb569ac469bfd96030\";a:3:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:50:\"https://oponte-coolify.sfo3.digitaloceanspaces.com\";}}}", "on");
INSERT INTO `wp_options` VALUES("111029", "updraft_cloudfiles", "a:2:{s:7:\"version\";s:1:\"1\";s:8:\"settings\";a:1:{s:34:\"s-7d5ec05c00b5b2df8d157e3370992473\";a:5:{s:7:\"authurl\";s:35:\"https://auth.api.rackspacecloud.com\";s:6:\"region\";s:3:\"DFW\";s:4:\"user\";s:0:\"\";s:6:\"apikey\";s:0:\"\";s:4:\"path\";s:0:\"\";}}}", "on");
INSERT INTO `wp_options` VALUES("111030", "updraft_googledrive", "a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-ae1dc8a5f1ce91f22de693b28edd0af6\";a:4:{s:8:\"clientid\";s:0:\"\";s:6:\"secret\";s:0:\"\";s:5:\"token\";s:0:\"\";s:6:\"folder\";s:11:\"UpdraftPlus\";}}}", "on");
INSERT INTO `wp_options` VALUES("111031", "updraft_onedrive", "a:1:{s:7:\"version\";s:1:\"1\";}", "on");
INSERT INTO `wp_options` VALUES("111032", "updraft_ftp", "a:2:{s:7:\"version\";s:1:\"1\";s:8:\"settings\";a:1:{s:34:\"s-be27df64f9052994ae30925d851fb224\";a:5:{s:4:\"host\";s:0:\"\";s:4:\"user\";s:0:\"\";s:4:\"pass\";s:0:\"\";s:4:\"path\";s:0:\"\";s:7:\"passive\";s:1:\"1\";}}}", "on");
INSERT INTO `wp_options` VALUES("111033", "updraft_azure", "a:1:{s:7:\"version\";s:1:\"1\";}", "on");
INSERT INTO `wp_options` VALUES("111034", "updraft_sftp", "a:1:{s:7:\"version\";s:1:\"1\";}", "on");
INSERT INTO `wp_options` VALUES("111035", "updraft_googlecloud", "a:1:{s:7:\"version\";s:1:\"1\";}", "on");
INSERT INTO `wp_options` VALUES("111036", "updraft_backblaze", "a:1:{s:7:\"version\";s:1:\"1\";}", "on");
INSERT INTO `wp_options` VALUES("111037", "updraft_webdav", "a:1:{s:7:\"version\";s:1:\"1\";}", "on");
INSERT INTO `wp_options` VALUES("111038", "updraft_s3generic", "a:2:{s:7:\"version\";s:1:\"1\";s:8:\"settings\";a:1:{s:34:\"s-4779288bfe1a724150c5c3e59142294b\";a:7:{s:9:\"accesskey\";s:20:\"DO8014WMKUXWA4HVHPRB\";s:9:\"secretkey\";s:43:\"uVa2GREacrs0skvFyDstxnVEtaaHXn2jbYKkQLVINpo\";s:4:\"path\";s:9:\"wordpress\";s:8:\"endpoint\";s:42:\"oponte-coolify.sfo3.digitaloceanspaces.com\";s:19:\"bucket_access_style\";s:10:\"path_style\";s:17:\"signature_version\";s:2:\"v4\";s:16:\"instance_enabled\";i:1;}}}", "on");
INSERT INTO `wp_options` VALUES("111039", "updraft_pcloud", "a:1:{s:7:\"version\";s:1:\"1\";}", "on");
INSERT INTO `wp_options` VALUES("111040", "updraft_openstack", "a:2:{s:7:\"version\";s:1:\"1\";s:8:\"settings\";a:1:{s:34:\"s-9c6b78913eaafd4a7d77e44142ea90a6\";a:6:{s:7:\"authurl\";s:0:\"\";s:6:\"tenant\";s:0:\"\";s:6:\"region\";s:0:\"\";s:4:\"user\";s:0:\"\";s:8:\"password\";s:0:\"\";s:4:\"path\";s:0:\"\";}}}", "on");
INSERT INTO `wp_options` VALUES("111041", "updraft_dreamobjects", "a:2:{s:7:\"version\";s:1:\"1\";s:8:\"settings\";a:1:{s:34:\"s-0999d018ac273e826b70f3155310dee3\";a:4:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";s:8:\"endpoint\";s:23:\"s3.us-east-005.dream.io\";}}}", "on");
INSERT INTO `wp_options` VALUES("111042", "updraftplus-addons_siteid", "3609ddaeced68939732cf2ae9e11e78e", "off");
INSERT INTO `wp_options` VALUES("111043", "updraftplus_tour_cancelled_on", "settings_timing", "on");
INSERT INTO `wp_options` VALUES("111048", "updraft_retain_extrarules", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("111049", "updraft_email", "", "on");
INSERT INTO `wp_options` VALUES("111050", "updraft_report_warningsonly", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("111051", "updraft_report_wholebackup", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("111052", "updraft_extradbs", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("111053", "updraft_include_more_path", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("111054", "auto_update_plugins", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("111055", "updraft_interval", "manual", "on");
INSERT INTO `wp_options` VALUES("111056", "updraft_retain", "2", "on");
INSERT INTO `wp_options` VALUES("111057", "updraft_interval_database", "manual", "on");
INSERT INTO `wp_options` VALUES("111058", "updraft_retain_db", "2", "on");
INSERT INTO `wp_options` VALUES("111059", "updraft_service", "s3generic", "on");
INSERT INTO `wp_options` VALUES("111060", "updraft_include_plugins", "1", "on");
INSERT INTO `wp_options` VALUES("111061", "updraft_include_themes", "1", "on");
INSERT INTO `wp_options` VALUES("111062", "updraft_include_uploads", "1", "on");
INSERT INTO `wp_options` VALUES("111063", "updraft_include_uploads_exclude", "backup*,*backups,backwpup*,wp-clone,snapshots,wp-staging", "on");
INSERT INTO `wp_options` VALUES("111064", "updraft_include_mu-plugins", "1", "on");
INSERT INTO `wp_options` VALUES("111065", "updraft_include_others", "1", "on");
INSERT INTO `wp_options` VALUES("111066", "updraft_include_others_exclude", "upgrade,cache,updraft,backup*,*backups,mysql.sql,debug.log", "on");
INSERT INTO `wp_options` VALUES("111067", "updraft_split_every", "400", "on");
INSERT INTO `wp_options` VALUES("111068", "updraft_delete_local", "1", "on");
INSERT INTO `wp_options` VALUES("111069", "updraft_dir", "updraft", "on");
INSERT INTO `wp_options` VALUES("111070", "updraft_debug_mode", "0", "on");
INSERT INTO `wp_options` VALUES("111071", "updraft_ssl_useservercerts", "0", "on");
INSERT INTO `wp_options` VALUES("111072", "updraft_ssl_disableverify", "0", "on");
INSERT INTO `wp_options` VALUES("111073", "updraft_ssl_nossl", "0", "on");
INSERT INTO `wp_options` VALUES("111075", "updraft_lastmessage", "Deleting old log file: log.39c2793ae145.txt (Oct 17 22:29:51)", "on");
INSERT INTO `wp_options` VALUES("111076", "updraftplus_unlocked_fd", "1", "no");
INSERT INTO `wp_options` VALUES("111077", "updraftplus_last_lock_time_fd", "2025-09-07 10:33:41", "no");
INSERT INTO `wp_options` VALUES("111078", "updraftplus_semaphore_fd", "0", "no");
INSERT INTO `wp_options` VALUES("111079", "updraft_last_scheduled_fd", "1757241221", "auto");
INSERT INTO `wp_options` VALUES("111082", "updraft_backup_history", "a:1:{i:1757241221;a:21:{s:7:\"plugins\";a:1:{i:0;s:67:\"backup_2025-09-07-1033_procuradorgaliciaes_39c2793ae145-plugins.zip\";}s:12:\"plugins-size\";i:63499224;s:6:\"themes\";a:1:{i:0;s:66:\"backup_2025-09-07-1033_procuradorgaliciaes_39c2793ae145-themes.zip\";}s:11:\"themes-size\";i:18739490;s:7:\"uploads\";a:1:{i:0;s:67:\"backup_2025-09-07-1033_procuradorgaliciaes_39c2793ae145-uploads.zip\";}s:12:\"uploads-size\";i:49421319;s:10:\"mu-plugins\";a:1:{i:0;s:70:\"backup_2025-09-07-1033_procuradorgaliciaes_39c2793ae145-mu-plugins.zip\";}s:15:\"mu-plugins-size\";i:1479;s:6:\"others\";a:1:{i:0;s:66:\"backup_2025-09-07-1033_procuradorgaliciaes_39c2793ae145-others.zip\";}s:11:\"others-size\";i:3171808;s:2:\"db\";s:61:\"backup_2025-09-07-1033_procuradorgaliciaes_39c2793ae145-db.gz\";s:7:\"db-size\";i:422069;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:6:{s:8:\"plugins0\";s:40:\"f2db9f6f5700f27f5037090ab0f54fe18f47ba25\";s:7:\"themes0\";s:40:\"445e75f488f1442338429fd329dd0b6d354a9628\";s:8:\"uploads0\";s:40:\"af2703bbc6f1cdbaa1699f9af1f940b1e6f970c2\";s:11:\"mu-plugins0\";s:40:\"fd68e2df0bae66c733eacc06639368065548b549\";s:7:\"others0\";s:40:\"6e066e76d275522b052a47328ff6e9a92e4739e2\";s:3:\"db0\";s:40:\"0b220968727c4f3d0ca3a878b77732221683f210\";}s:6:\"sha256\";a:6:{s:8:\"plugins0\";s:64:\"f6719d135bb790167573a50d905193a2b8d7625c0f63dca7fb33d4d385d5c486\";s:7:\"themes0\";s:64:\"31bcc5ad6fc7b00d810e5ed46138291c0ea27794e04ab669a106b52ca113f2c1\";s:8:\"uploads0\";s:64:\"801edc134b90b0b609623641d952577a0008709530b5cfe79dc6eeccb65e4f5a\";s:11:\"mu-plugins0\";s:64:\"a76babfc63cd43eda508a56d5a704db1155a9ac41536733b98c45d6cba34f75d\";s:7:\"others0\";s:64:\"89a2821ed2930d22a57701ac4f153903d7c6a27665ccdc2e2cdda062ccc3a60a\";s:3:\"db0\";s:64:\"1424d46686a3b696581f9e30582df63bd831d24faaf5f92e28f31258efd11f5b\";}}s:5:\"nonce\";s:12:\"39c2793ae145\";s:7:\"service\";a:1:{i:0;s:9:\"s3generic\";}s:20:\"service_instance_ids\";a:1:{s:9:\"s3generic\";a:1:{i:0;s:34:\"s-4779288bfe1a724150c5c3e59142294b\";}}s:11:\"always_keep\";b:0;s:19:\"files_enumerated_at\";a:5:{s:7:\"plugins\";i:1757241221;s:6:\"themes\";i:1757241272;s:7:\"uploads\";i:1757241285;s:10:\"mu-plugins\";i:1757241309;s:6:\"others\";i:1757241310;}s:18:\"created_by_version\";s:6:\"1.25.7\";s:21:\"last_saved_by_version\";s:6:\"1.25.7\";s:12:\"is_multisite\";b:0;}}", "off");
INSERT INTO `wp_options` VALUES("111083", "updraft_last_backup", "a:6:{s:26:\"nonincremental_backup_time\";i:1757241221;s:11:\"backup_time\";i:1757241221;s:12:\"backup_array\";a:13:{s:7:\"plugins\";a:1:{i:0;s:67:\"backup_2025-09-07-1033_procuradorgaliciaes_39c2793ae145-plugins.zip\";}s:12:\"plugins-size\";i:63499224;s:6:\"themes\";a:1:{i:0;s:66:\"backup_2025-09-07-1033_procuradorgaliciaes_39c2793ae145-themes.zip\";}s:11:\"themes-size\";i:18739490;s:7:\"uploads\";a:1:{i:0;s:67:\"backup_2025-09-07-1033_procuradorgaliciaes_39c2793ae145-uploads.zip\";}s:12:\"uploads-size\";i:49421319;s:10:\"mu-plugins\";a:1:{i:0;s:70:\"backup_2025-09-07-1033_procuradorgaliciaes_39c2793ae145-mu-plugins.zip\";}s:15:\"mu-plugins-size\";i:1479;s:6:\"others\";a:1:{i:0;s:66:\"backup_2025-09-07-1033_procuradorgaliciaes_39c2793ae145-others.zip\";}s:11:\"others-size\";i:3171808;s:2:\"db\";s:61:\"backup_2025-09-07-1033_procuradorgaliciaes_39c2793ae145-db.gz\";s:7:\"db-size\";i:422069;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:6:{s:8:\"plugins0\";s:40:\"f2db9f6f5700f27f5037090ab0f54fe18f47ba25\";s:7:\"themes0\";s:40:\"445e75f488f1442338429fd329dd0b6d354a9628\";s:8:\"uploads0\";s:40:\"af2703bbc6f1cdbaa1699f9af1f940b1e6f970c2\";s:11:\"mu-plugins0\";s:40:\"fd68e2df0bae66c733eacc06639368065548b549\";s:7:\"others0\";s:40:\"6e066e76d275522b052a47328ff6e9a92e4739e2\";s:3:\"db0\";s:40:\"0b220968727c4f3d0ca3a878b77732221683f210\";}s:6:\"sha256\";a:6:{s:8:\"plugins0\";s:64:\"f6719d135bb790167573a50d905193a2b8d7625c0f63dca7fb33d4d385d5c486\";s:7:\"themes0\";s:64:\"31bcc5ad6fc7b00d810e5ed46138291c0ea27794e04ab669a106b52ca113f2c1\";s:8:\"uploads0\";s:64:\"801edc134b90b0b609623641d952577a0008709530b5cfe79dc6eeccb65e4f5a\";s:11:\"mu-plugins0\";s:64:\"a76babfc63cd43eda508a56d5a704db1155a9ac41536733b98c45d6cba34f75d\";s:7:\"others0\";s:64:\"89a2821ed2930d22a57701ac4f153903d7c6a27665ccdc2e2cdda062ccc3a60a\";s:3:\"db0\";s:64:\"1424d46686a3b696581f9e30582df63bd831d24faaf5f92e28f31258efd11f5b\";}}}s:7:\"success\";i:1;s:6:\"errors\";a:0:{}s:12:\"backup_nonce\";s:12:\"39c2793ae145\";}", "on");
INSERT INTO `wp_options` VALUES("112103", "_transient_onepress_categories", "2", "on");
INSERT INTO `wp_options` VALUES("123242", "cky_banners_table_version", "3.3.8", "auto");
INSERT INTO `wp_options` VALUES("123243", "cky_cookie_table_version", "3.3.8", "auto");
INSERT INTO `wp_options` VALUES("123244", "cky_cookie_category_table_version", "3.3.8", "auto");
INSERT INTO `wp_options` VALUES("124283", "wp_notes_notify", "1", "on");
INSERT INTO `wp_options` VALUES("124288", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:3:\"6.9\";s:5:\"files\";a:584:{i:0;s:31:\"accordion-heading/style-rtl.css\";i:1;s:35:\"accordion-heading/style-rtl.min.css\";i:2;s:27:\"accordion-heading/style.css\";i:3;s:31:\"accordion-heading/style.min.css\";i:4;s:28:\"accordion-item/style-rtl.css\";i:5;s:32:\"accordion-item/style-rtl.min.css\";i:6;s:24:\"accordion-item/style.css\";i:7;s:28:\"accordion-item/style.min.css\";i:8;s:29:\"accordion-panel/style-rtl.css\";i:9;s:33:\"accordion-panel/style-rtl.min.css\";i:10;s:25:\"accordion-panel/style.css\";i:11;s:29:\"accordion-panel/style.min.css\";i:12;s:23:\"accordion/style-rtl.css\";i:13;s:27:\"accordion/style-rtl.min.css\";i:14;s:19:\"accordion/style.css\";i:15;s:23:\"accordion/style.min.css\";i:16;s:23:\"archives/editor-rtl.css\";i:17;s:27:\"archives/editor-rtl.min.css\";i:18;s:19:\"archives/editor.css\";i:19;s:23:\"archives/editor.min.css\";i:20;s:22:\"archives/style-rtl.css\";i:21;s:26:\"archives/style-rtl.min.css\";i:22;s:18:\"archives/style.css\";i:23;s:22:\"archives/style.min.css\";i:24;s:20:\"audio/editor-rtl.css\";i:25;s:24:\"audio/editor-rtl.min.css\";i:26;s:16:\"audio/editor.css\";i:27;s:20:\"audio/editor.min.css\";i:28;s:19:\"audio/style-rtl.css\";i:29;s:23:\"audio/style-rtl.min.css\";i:30;s:15:\"audio/style.css\";i:31;s:19:\"audio/style.min.css\";i:32;s:19:\"audio/theme-rtl.css\";i:33;s:23:\"audio/theme-rtl.min.css\";i:34;s:15:\"audio/theme.css\";i:35;s:19:\"audio/theme.min.css\";i:36;s:21:\"avatar/editor-rtl.css\";i:37;s:25:\"avatar/editor-rtl.min.css\";i:38;s:17:\"avatar/editor.css\";i:39;s:21:\"avatar/editor.min.css\";i:40;s:20:\"avatar/style-rtl.css\";i:41;s:24:\"avatar/style-rtl.min.css\";i:42;s:16:\"avatar/style.css\";i:43;s:20:\"avatar/style.min.css\";i:44;s:21:\"button/editor-rtl.css\";i:45;s:25:\"button/editor-rtl.min.css\";i:46;s:17:\"button/editor.css\";i:47;s:21:\"button/editor.min.css\";i:48;s:20:\"button/style-rtl.css\";i:49;s:24:\"button/style-rtl.min.css\";i:50;s:16:\"button/style.css\";i:51;s:20:\"button/style.min.css\";i:52;s:22:\"buttons/editor-rtl.css\";i:53;s:26:\"buttons/editor-rtl.min.css\";i:54;s:18:\"buttons/editor.css\";i:55;s:22:\"buttons/editor.min.css\";i:56;s:21:\"buttons/style-rtl.css\";i:57;s:25:\"buttons/style-rtl.min.css\";i:58;s:17:\"buttons/style.css\";i:59;s:21:\"buttons/style.min.css\";i:60;s:22:\"calendar/style-rtl.css\";i:61;s:26:\"calendar/style-rtl.min.css\";i:62;s:18:\"calendar/style.css\";i:63;s:22:\"calendar/style.min.css\";i:64;s:25:\"categories/editor-rtl.css\";i:65;s:29:\"categories/editor-rtl.min.css\";i:66;s:21:\"categories/editor.css\";i:67;s:25:\"categories/editor.min.css\";i:68;s:24:\"categories/style-rtl.css\";i:69;s:28:\"categories/style-rtl.min.css\";i:70;s:20:\"categories/style.css\";i:71;s:24:\"categories/style.min.css\";i:72;s:19:\"code/editor-rtl.css\";i:73;s:23:\"code/editor-rtl.min.css\";i:74;s:15:\"code/editor.css\";i:75;s:19:\"code/editor.min.css\";i:76;s:18:\"code/style-rtl.css\";i:77;s:22:\"code/style-rtl.min.css\";i:78;s:14:\"code/style.css\";i:79;s:18:\"code/style.min.css\";i:80;s:18:\"code/theme-rtl.css\";i:81;s:22:\"code/theme-rtl.min.css\";i:82;s:14:\"code/theme.css\";i:83;s:18:\"code/theme.min.css\";i:84;s:22:\"columns/editor-rtl.css\";i:85;s:26:\"columns/editor-rtl.min.css\";i:86;s:18:\"columns/editor.css\";i:87;s:22:\"columns/editor.min.css\";i:88;s:21:\"columns/style-rtl.css\";i:89;s:25:\"columns/style-rtl.min.css\";i:90;s:17:\"columns/style.css\";i:91;s:21:\"columns/style.min.css\";i:92;s:33:\"comment-author-name/style-rtl.css\";i:93;s:37:\"comment-author-name/style-rtl.min.css\";i:94;s:29:\"comment-author-name/style.css\";i:95;s:33:\"comment-author-name/style.min.css\";i:96;s:29:\"comment-content/style-rtl.css\";i:97;s:33:\"comment-content/style-rtl.min.css\";i:98;s:25:\"comment-content/style.css\";i:99;s:29:\"comment-content/style.min.css\";i:100;s:26:\"comment-date/style-rtl.css\";i:101;s:30:\"comment-date/style-rtl.min.css\";i:102;s:22:\"comment-date/style.css\";i:103;s:26:\"comment-date/style.min.css\";i:104;s:31:\"comment-edit-link/style-rtl.css\";i:105;s:35:\"comment-edit-link/style-rtl.min.css\";i:106;s:27:\"comment-edit-link/style.css\";i:107;s:31:\"comment-edit-link/style.min.css\";i:108;s:32:\"comment-reply-link/style-rtl.css\";i:109;s:36:\"comment-reply-link/style-rtl.min.css\";i:110;s:28:\"comment-reply-link/style.css\";i:111;s:32:\"comment-reply-link/style.min.css\";i:112;s:30:\"comment-template/style-rtl.css\";i:113;s:34:\"comment-template/style-rtl.min.css\";i:114;s:26:\"comment-template/style.css\";i:115;s:30:\"comment-template/style.min.css\";i:116;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:117;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:118;s:38:\"comments-pagination-numbers/editor.css\";i:119;s:42:\"comments-pagination-numbers/editor.min.css\";i:120;s:34:\"comments-pagination/editor-rtl.css\";i:121;s:38:\"comments-pagination/editor-rtl.min.css\";i:122;s:30:\"comments-pagination/editor.css\";i:123;s:34:\"comments-pagination/editor.min.css\";i:124;s:33:\"comments-pagination/style-rtl.css\";i:125;s:37:\"comments-pagination/style-rtl.min.css\";i:126;s:29:\"comments-pagination/style.css\";i:127;s:33:\"comments-pagination/style.min.css\";i:128;s:29:\"comments-title/editor-rtl.css\";i:129;s:33:\"comments-title/editor-rtl.min.css\";i:130;s:25:\"comments-title/editor.css\";i:131;s:29:\"comments-title/editor.min.css\";i:132;s:23:\"comments/editor-rtl.css\";i:133;s:27:\"comments/editor-rtl.min.css\";i:134;s:19:\"comments/editor.css\";i:135;s:23:\"comments/editor.min.css\";i:136;s:22:\"comments/style-rtl.css\";i:137;s:26:\"comments/style-rtl.min.css\";i:138;s:18:\"comments/style.css\";i:139;s:22:\"comments/style.min.css\";i:140;s:20:\"cover/editor-rtl.css\";i:141;s:24:\"cover/editor-rtl.min.css\";i:142;s:16:\"cover/editor.css\";i:143;s:20:\"cover/editor.min.css\";i:144;s:19:\"cover/style-rtl.css\";i:145;s:23:\"cover/style-rtl.min.css\";i:146;s:15:\"cover/style.css\";i:147;s:19:\"cover/style.min.css\";i:148;s:22:\"details/editor-rtl.css\";i:149;s:26:\"details/editor-rtl.min.css\";i:150;s:18:\"details/editor.css\";i:151;s:22:\"details/editor.min.css\";i:152;s:21:\"details/style-rtl.css\";i:153;s:25:\"details/style-rtl.min.css\";i:154;s:17:\"details/style.css\";i:155;s:21:\"details/style.min.css\";i:156;s:20:\"embed/editor-rtl.css\";i:157;s:24:\"embed/editor-rtl.min.css\";i:158;s:16:\"embed/editor.css\";i:159;s:20:\"embed/editor.min.css\";i:160;s:19:\"embed/style-rtl.css\";i:161;s:23:\"embed/style-rtl.min.css\";i:162;s:15:\"embed/style.css\";i:163;s:19:\"embed/style.min.css\";i:164;s:19:\"embed/theme-rtl.css\";i:165;s:23:\"embed/theme-rtl.min.css\";i:166;s:15:\"embed/theme.css\";i:167;s:19:\"embed/theme.min.css\";i:168;s:19:\"file/editor-rtl.css\";i:169;s:23:\"file/editor-rtl.min.css\";i:170;s:15:\"file/editor.css\";i:171;s:19:\"file/editor.min.css\";i:172;s:18:\"file/style-rtl.css\";i:173;s:22:\"file/style-rtl.min.css\";i:174;s:14:\"file/style.css\";i:175;s:18:\"file/style.min.css\";i:176;s:23:\"footnotes/style-rtl.css\";i:177;s:27:\"footnotes/style-rtl.min.css\";i:178;s:19:\"footnotes/style.css\";i:179;s:23:\"footnotes/style.min.css\";i:180;s:23:\"freeform/editor-rtl.css\";i:181;s:27:\"freeform/editor-rtl.min.css\";i:182;s:19:\"freeform/editor.css\";i:183;s:23:\"freeform/editor.min.css\";i:184;s:22:\"gallery/editor-rtl.css\";i:185;s:26:\"gallery/editor-rtl.min.css\";i:186;s:18:\"gallery/editor.css\";i:187;s:22:\"gallery/editor.min.css\";i:188;s:21:\"gallery/style-rtl.css\";i:189;s:25:\"gallery/style-rtl.min.css\";i:190;s:17:\"gallery/style.css\";i:191;s:21:\"gallery/style.min.css\";i:192;s:21:\"gallery/theme-rtl.css\";i:193;s:25:\"gallery/theme-rtl.min.css\";i:194;s:17:\"gallery/theme.css\";i:195;s:21:\"gallery/theme.min.css\";i:196;s:20:\"group/editor-rtl.css\";i:197;s:24:\"group/editor-rtl.min.css\";i:198;s:16:\"group/editor.css\";i:199;s:20:\"group/editor.min.css\";i:200;s:19:\"group/style-rtl.css\";i:201;s:23:\"group/style-rtl.min.css\";i:202;s:15:\"group/style.css\";i:203;s:19:\"group/style.min.css\";i:204;s:19:\"group/theme-rtl.css\";i:205;s:23:\"group/theme-rtl.min.css\";i:206;s:15:\"group/theme.css\";i:207;s:19:\"group/theme.min.css\";i:208;s:21:\"heading/style-rtl.css\";i:209;s:25:\"heading/style-rtl.min.css\";i:210;s:17:\"heading/style.css\";i:211;s:21:\"heading/style.min.css\";i:212;s:19:\"html/editor-rtl.css\";i:213;s:23:\"html/editor-rtl.min.css\";i:214;s:15:\"html/editor.css\";i:215;s:19:\"html/editor.min.css\";i:216;s:20:\"image/editor-rtl.css\";i:217;s:24:\"image/editor-rtl.min.css\";i:218;s:16:\"image/editor.css\";i:219;s:20:\"image/editor.min.css\";i:220;s:19:\"image/style-rtl.css\";i:221;s:23:\"image/style-rtl.min.css\";i:222;s:15:\"image/style.css\";i:223;s:19:\"image/style.min.css\";i:224;s:19:\"image/theme-rtl.css\";i:225;s:23:\"image/theme-rtl.min.css\";i:226;s:15:\"image/theme.css\";i:227;s:19:\"image/theme.min.css\";i:228;s:29:\"latest-comments/style-rtl.css\";i:229;s:33:\"latest-comments/style-rtl.min.css\";i:230;s:25:\"latest-comments/style.css\";i:231;s:29:\"latest-comments/style.min.css\";i:232;s:27:\"latest-posts/editor-rtl.css\";i:233;s:31:\"latest-posts/editor-rtl.min.css\";i:234;s:23:\"latest-posts/editor.css\";i:235;s:27:\"latest-posts/editor.min.css\";i:236;s:26:\"latest-posts/style-rtl.css\";i:237;s:30:\"latest-posts/style-rtl.min.css\";i:238;s:22:\"latest-posts/style.css\";i:239;s:26:\"latest-posts/style.min.css\";i:240;s:18:\"list/style-rtl.css\";i:241;s:22:\"list/style-rtl.min.css\";i:242;s:14:\"list/style.css\";i:243;s:18:\"list/style.min.css\";i:244;s:22:\"loginout/style-rtl.css\";i:245;s:26:\"loginout/style-rtl.min.css\";i:246;s:18:\"loginout/style.css\";i:247;s:22:\"loginout/style.min.css\";i:248;s:19:\"math/editor-rtl.css\";i:249;s:23:\"math/editor-rtl.min.css\";i:250;s:15:\"math/editor.css\";i:251;s:19:\"math/editor.min.css\";i:252;s:18:\"math/style-rtl.css\";i:253;s:22:\"math/style-rtl.min.css\";i:254;s:14:\"math/style.css\";i:255;s:18:\"math/style.min.css\";i:256;s:25:\"media-text/editor-rtl.css\";i:257;s:29:\"media-text/editor-rtl.min.css\";i:258;s:21:\"media-text/editor.css\";i:259;s:25:\"media-text/editor.min.css\";i:260;s:24:\"media-text/style-rtl.css\";i:261;s:28:\"media-text/style-rtl.min.css\";i:262;s:20:\"media-text/style.css\";i:263;s:24:\"media-text/style.min.css\";i:264;s:19:\"more/editor-rtl.css\";i:265;s:23:\"more/editor-rtl.min.css\";i:266;s:15:\"more/editor.css\";i:267;s:19:\"more/editor.min.css\";i:268;s:30:\"navigation-link/editor-rtl.css\";i:269;s:34:\"navigation-link/editor-rtl.min.css\";i:270;s:26:\"navigation-link/editor.css\";i:271;s:30:\"navigation-link/editor.min.css\";i:272;s:29:\"navigation-link/style-rtl.css\";i:273;s:33:\"navigation-link/style-rtl.min.css\";i:274;s:25:\"navigation-link/style.css\";i:275;s:29:\"navigation-link/style.min.css\";i:276;s:33:\"navigation-submenu/editor-rtl.css\";i:277;s:37:\"navigation-submenu/editor-rtl.min.css\";i:278;s:29:\"navigation-submenu/editor.css\";i:279;s:33:\"navigation-submenu/editor.min.css\";i:280;s:25:\"navigation/editor-rtl.css\";i:281;s:29:\"navigation/editor-rtl.min.css\";i:282;s:21:\"navigation/editor.css\";i:283;s:25:\"navigation/editor.min.css\";i:284;s:24:\"navigation/style-rtl.css\";i:285;s:28:\"navigation/style-rtl.min.css\";i:286;s:20:\"navigation/style.css\";i:287;s:24:\"navigation/style.min.css\";i:288;s:23:\"nextpage/editor-rtl.css\";i:289;s:27:\"nextpage/editor-rtl.min.css\";i:290;s:19:\"nextpage/editor.css\";i:291;s:23:\"nextpage/editor.min.css\";i:292;s:24:\"page-list/editor-rtl.css\";i:293;s:28:\"page-list/editor-rtl.min.css\";i:294;s:20:\"page-list/editor.css\";i:295;s:24:\"page-list/editor.min.css\";i:296;s:23:\"page-list/style-rtl.css\";i:297;s:27:\"page-list/style-rtl.min.css\";i:298;s:19:\"page-list/style.css\";i:299;s:23:\"page-list/style.min.css\";i:300;s:24:\"paragraph/editor-rtl.css\";i:301;s:28:\"paragraph/editor-rtl.min.css\";i:302;s:20:\"paragraph/editor.css\";i:303;s:24:\"paragraph/editor.min.css\";i:304;s:23:\"paragraph/style-rtl.css\";i:305;s:27:\"paragraph/style-rtl.min.css\";i:306;s:19:\"paragraph/style.css\";i:307;s:23:\"paragraph/style.min.css\";i:308;s:35:\"post-author-biography/style-rtl.css\";i:309;s:39:\"post-author-biography/style-rtl.min.css\";i:310;s:31:\"post-author-biography/style.css\";i:311;s:35:\"post-author-biography/style.min.css\";i:312;s:30:\"post-author-name/style-rtl.css\";i:313;s:34:\"post-author-name/style-rtl.min.css\";i:314;s:26:\"post-author-name/style.css\";i:315;s:30:\"post-author-name/style.min.css\";i:316;s:25:\"post-author/style-rtl.css\";i:317;s:29:\"post-author/style-rtl.min.css\";i:318;s:21:\"post-author/style.css\";i:319;s:25:\"post-author/style.min.css\";i:320;s:33:\"post-comments-count/style-rtl.css\";i:321;s:37:\"post-comments-count/style-rtl.min.css\";i:322;s:29:\"post-comments-count/style.css\";i:323;s:33:\"post-comments-count/style.min.css\";i:324;s:33:\"post-comments-form/editor-rtl.css\";i:325;s:37:\"post-comments-form/editor-rtl.min.css\";i:326;s:29:\"post-comments-form/editor.css\";i:327;s:33:\"post-comments-form/editor.min.css\";i:328;s:32:\"post-comments-form/style-rtl.css\";i:329;s:36:\"post-comments-form/style-rtl.min.css\";i:330;s:28:\"post-comments-form/style.css\";i:331;s:32:\"post-comments-form/style.min.css\";i:332;s:32:\"post-comments-link/style-rtl.css\";i:333;s:36:\"post-comments-link/style-rtl.min.css\";i:334;s:28:\"post-comments-link/style.css\";i:335;s:32:\"post-comments-link/style.min.css\";i:336;s:26:\"post-content/style-rtl.css\";i:337;s:30:\"post-content/style-rtl.min.css\";i:338;s:22:\"post-content/style.css\";i:339;s:26:\"post-content/style.min.css\";i:340;s:23:\"post-date/style-rtl.css\";i:341;s:27:\"post-date/style-rtl.min.css\";i:342;s:19:\"post-date/style.css\";i:343;s:23:\"post-date/style.min.css\";i:344;s:27:\"post-excerpt/editor-rtl.css\";i:345;s:31:\"post-excerpt/editor-rtl.min.css\";i:346;s:23:\"post-excerpt/editor.css\";i:347;s:27:\"post-excerpt/editor.min.css\";i:348;s:26:\"post-excerpt/style-rtl.css\";i:349;s:30:\"post-excerpt/style-rtl.min.css\";i:350;s:22:\"post-excerpt/style.css\";i:351;s:26:\"post-excerpt/style.min.css\";i:352;s:34:\"post-featured-image/editor-rtl.css\";i:353;s:38:\"post-featured-image/editor-rtl.min.css\";i:354;s:30:\"post-featured-image/editor.css\";i:355;s:34:\"post-featured-image/editor.min.css\";i:356;s:33:\"post-featured-image/style-rtl.css\";i:357;s:37:\"post-featured-image/style-rtl.min.css\";i:358;s:29:\"post-featured-image/style.css\";i:359;s:33:\"post-featured-image/style.min.css\";i:360;s:34:\"post-navigation-link/style-rtl.css\";i:361;s:38:\"post-navigation-link/style-rtl.min.css\";i:362;s:30:\"post-navigation-link/style.css\";i:363;s:34:\"post-navigation-link/style.min.css\";i:364;s:27:\"post-template/style-rtl.css\";i:365;s:31:\"post-template/style-rtl.min.css\";i:366;s:23:\"post-template/style.css\";i:367;s:27:\"post-template/style.min.css\";i:368;s:24:\"post-terms/style-rtl.css\";i:369;s:28:\"post-terms/style-rtl.min.css\";i:370;s:20:\"post-terms/style.css\";i:371;s:24:\"post-terms/style.min.css\";i:372;s:31:\"post-time-to-read/style-rtl.css\";i:373;s:35:\"post-time-to-read/style-rtl.min.css\";i:374;s:27:\"post-time-to-read/style.css\";i:375;s:31:\"post-time-to-read/style.min.css\";i:376;s:24:\"post-title/style-rtl.css\";i:377;s:28:\"post-title/style-rtl.min.css\";i:378;s:20:\"post-title/style.css\";i:379;s:24:\"post-title/style.min.css\";i:380;s:26:\"preformatted/style-rtl.css\";i:381;s:30:\"preformatted/style-rtl.min.css\";i:382;s:22:\"preformatted/style.css\";i:383;s:26:\"preformatted/style.min.css\";i:384;s:24:\"pullquote/editor-rtl.css\";i:385;s:28:\"pullquote/editor-rtl.min.css\";i:386;s:20:\"pullquote/editor.css\";i:387;s:24:\"pullquote/editor.min.css\";i:388;s:23:\"pullquote/style-rtl.css\";i:389;s:27:\"pullquote/style-rtl.min.css\";i:390;s:19:\"pullquote/style.css\";i:391;s:23:\"pullquote/style.min.css\";i:392;s:23:\"pullquote/theme-rtl.css\";i:393;s:27:\"pullquote/theme-rtl.min.css\";i:394;s:19:\"pullquote/theme.css\";i:395;s:23:\"pullquote/theme.min.css\";i:396;s:39:\"query-pagination-numbers/editor-rtl.css\";i:397;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:398;s:35:\"query-pagination-numbers/editor.css\";i:399;s:39:\"query-pagination-numbers/editor.min.css\";i:400;s:31:\"query-pagination/editor-rtl.css\";i:401;s:35:\"query-pagination/editor-rtl.min.css\";i:402;s:27:\"query-pagination/editor.css\";i:403;s:31:\"query-pagination/editor.min.css\";i:404;s:30:\"query-pagination/style-rtl.css\";i:405;s:34:\"query-pagination/style-rtl.min.css\";i:406;s:26:\"query-pagination/style.css\";i:407;s:30:\"query-pagination/style.min.css\";i:408;s:25:\"query-title/style-rtl.css\";i:409;s:29:\"query-title/style-rtl.min.css\";i:410;s:21:\"query-title/style.css\";i:411;s:25:\"query-title/style.min.css\";i:412;s:25:\"query-total/style-rtl.css\";i:413;s:29:\"query-total/style-rtl.min.css\";i:414;s:21:\"query-total/style.css\";i:415;s:25:\"query-total/style.min.css\";i:416;s:20:\"query/editor-rtl.css\";i:417;s:24:\"query/editor-rtl.min.css\";i:418;s:16:\"query/editor.css\";i:419;s:20:\"query/editor.min.css\";i:420;s:19:\"quote/style-rtl.css\";i:421;s:23:\"quote/style-rtl.min.css\";i:422;s:15:\"quote/style.css\";i:423;s:19:\"quote/style.min.css\";i:424;s:19:\"quote/theme-rtl.css\";i:425;s:23:\"quote/theme-rtl.min.css\";i:426;s:15:\"quote/theme.css\";i:427;s:19:\"quote/theme.min.css\";i:428;s:23:\"read-more/style-rtl.css\";i:429;s:27:\"read-more/style-rtl.min.css\";i:430;s:19:\"read-more/style.css\";i:431;s:23:\"read-more/style.min.css\";i:432;s:18:\"rss/editor-rtl.css\";i:433;s:22:\"rss/editor-rtl.min.css\";i:434;s:14:\"rss/editor.css\";i:435;s:18:\"rss/editor.min.css\";i:436;s:17:\"rss/style-rtl.css\";i:437;s:21:\"rss/style-rtl.min.css\";i:438;s:13:\"rss/style.css\";i:439;s:17:\"rss/style.min.css\";i:440;s:21:\"search/editor-rtl.css\";i:441;s:25:\"search/editor-rtl.min.css\";i:442;s:17:\"search/editor.css\";i:443;s:21:\"search/editor.min.css\";i:444;s:20:\"search/style-rtl.css\";i:445;s:24:\"search/style-rtl.min.css\";i:446;s:16:\"search/style.css\";i:447;s:20:\"search/style.min.css\";i:448;s:20:\"search/theme-rtl.css\";i:449;s:24:\"search/theme-rtl.min.css\";i:450;s:16:\"search/theme.css\";i:451;s:20:\"search/theme.min.css\";i:452;s:24:\"separator/editor-rtl.css\";i:453;s:28:\"separator/editor-rtl.min.css\";i:454;s:20:\"separator/editor.css\";i:455;s:24:\"separator/editor.min.css\";i:456;s:23:\"separator/style-rtl.css\";i:457;s:27:\"separator/style-rtl.min.css\";i:458;s:19:\"separator/style.css\";i:459;s:23:\"separator/style.min.css\";i:460;s:23:\"separator/theme-rtl.css\";i:461;s:27:\"separator/theme-rtl.min.css\";i:462;s:19:\"separator/theme.css\";i:463;s:23:\"separator/theme.min.css\";i:464;s:24:\"shortcode/editor-rtl.css\";i:465;s:28:\"shortcode/editor-rtl.min.css\";i:466;s:20:\"shortcode/editor.css\";i:467;s:24:\"shortcode/editor.min.css\";i:468;s:24:\"site-logo/editor-rtl.css\";i:469;s:28:\"site-logo/editor-rtl.min.css\";i:470;s:20:\"site-logo/editor.css\";i:471;s:24:\"site-logo/editor.min.css\";i:472;s:23:\"site-logo/style-rtl.css\";i:473;s:27:\"site-logo/style-rtl.min.css\";i:474;s:19:\"site-logo/style.css\";i:475;s:23:\"site-logo/style.min.css\";i:476;s:27:\"site-tagline/editor-rtl.css\";i:477;s:31:\"site-tagline/editor-rtl.min.css\";i:478;s:23:\"site-tagline/editor.css\";i:479;s:27:\"site-tagline/editor.min.css\";i:480;s:26:\"site-tagline/style-rtl.css\";i:481;s:30:\"site-tagline/style-rtl.min.css\";i:482;s:22:\"site-tagline/style.css\";i:483;s:26:\"site-tagline/style.min.css\";i:484;s:25:\"site-title/editor-rtl.css\";i:485;s:29:\"site-title/editor-rtl.min.css\";i:486;s:21:\"site-title/editor.css\";i:487;s:25:\"site-title/editor.min.css\";i:488;s:24:\"site-title/style-rtl.css\";i:489;s:28:\"site-title/style-rtl.min.css\";i:490;s:20:\"site-title/style.css\";i:491;s:24:\"site-title/style.min.css\";i:492;s:26:\"social-link/editor-rtl.css\";i:493;s:30:\"social-link/editor-rtl.min.css\";i:494;s:22:\"social-link/editor.css\";i:495;s:26:\"social-link/editor.min.css\";i:496;s:27:\"social-links/editor-rtl.css\";i:497;s:31:\"social-links/editor-rtl.min.css\";i:498;s:23:\"social-links/editor.css\";i:499;s:27:\"social-links/editor.min.css\";i:500;s:26:\"social-links/style-rtl.css\";i:501;s:30:\"social-links/style-rtl.min.css\";i:502;s:22:\"social-links/style.css\";i:503;s:26:\"social-links/style.min.css\";i:504;s:21:\"spacer/editor-rtl.css\";i:505;s:25:\"spacer/editor-rtl.min.css\";i:506;s:17:\"spacer/editor.css\";i:507;s:21:\"spacer/editor.min.css\";i:508;s:20:\"spacer/style-rtl.css\";i:509;s:24:\"spacer/style-rtl.min.css\";i:510;s:16:\"spacer/style.css\";i:511;s:20:\"spacer/style.min.css\";i:512;s:20:\"table/editor-rtl.css\";i:513;s:24:\"table/editor-rtl.min.css\";i:514;s:16:\"table/editor.css\";i:515;s:20:\"table/editor.min.css\";i:516;s:19:\"table/style-rtl.css\";i:517;s:23:\"table/style-rtl.min.css\";i:518;s:15:\"table/style.css\";i:519;s:19:\"table/style.min.css\";i:520;s:19:\"table/theme-rtl.css\";i:521;s:23:\"table/theme-rtl.min.css\";i:522;s:15:\"table/theme.css\";i:523;s:19:\"table/theme.min.css\";i:524;s:24:\"tag-cloud/editor-rtl.css\";i:525;s:28:\"tag-cloud/editor-rtl.min.css\";i:526;s:20:\"tag-cloud/editor.css\";i:527;s:24:\"tag-cloud/editor.min.css\";i:528;s:23:\"tag-cloud/style-rtl.css\";i:529;s:27:\"tag-cloud/style-rtl.min.css\";i:530;s:19:\"tag-cloud/style.css\";i:531;s:23:\"tag-cloud/style.min.css\";i:532;s:28:\"template-part/editor-rtl.css\";i:533;s:32:\"template-part/editor-rtl.min.css\";i:534;s:24:\"template-part/editor.css\";i:535;s:28:\"template-part/editor.min.css\";i:536;s:27:\"template-part/theme-rtl.css\";i:537;s:31:\"template-part/theme-rtl.min.css\";i:538;s:23:\"template-part/theme.css\";i:539;s:27:\"template-part/theme.min.css\";i:540;s:24:\"term-count/style-rtl.css\";i:541;s:28:\"term-count/style-rtl.min.css\";i:542;s:20:\"term-count/style.css\";i:543;s:24:\"term-count/style.min.css\";i:544;s:30:\"term-description/style-rtl.css\";i:545;s:34:\"term-description/style-rtl.min.css\";i:546;s:26:\"term-description/style.css\";i:547;s:30:\"term-description/style.min.css\";i:548;s:23:\"term-name/style-rtl.css\";i:549;s:27:\"term-name/style-rtl.min.css\";i:550;s:19:\"term-name/style.css\";i:551;s:23:\"term-name/style.min.css\";i:552;s:28:\"term-template/editor-rtl.css\";i:553;s:32:\"term-template/editor-rtl.min.css\";i:554;s:24:\"term-template/editor.css\";i:555;s:28:\"term-template/editor.min.css\";i:556;s:27:\"term-template/style-rtl.css\";i:557;s:31:\"term-template/style-rtl.min.css\";i:558;s:23:\"term-template/style.css\";i:559;s:27:\"term-template/style.min.css\";i:560;s:27:\"text-columns/editor-rtl.css\";i:561;s:31:\"text-columns/editor-rtl.min.css\";i:562;s:23:\"text-columns/editor.css\";i:563;s:27:\"text-columns/editor.min.css\";i:564;s:26:\"text-columns/style-rtl.css\";i:565;s:30:\"text-columns/style-rtl.min.css\";i:566;s:22:\"text-columns/style.css\";i:567;s:26:\"text-columns/style.min.css\";i:568;s:19:\"verse/style-rtl.css\";i:569;s:23:\"verse/style-rtl.min.css\";i:570;s:15:\"verse/style.css\";i:571;s:19:\"verse/style.min.css\";i:572;s:20:\"video/editor-rtl.css\";i:573;s:24:\"video/editor-rtl.min.css\";i:574;s:16:\"video/editor.css\";i:575;s:20:\"video/editor.min.css\";i:576;s:19:\"video/style-rtl.css\";i:577;s:23:\"video/style-rtl.min.css\";i:578;s:15:\"video/style.css\";i:579;s:19:\"video/style.min.css\";i:580;s:19:\"video/theme-rtl.css\";i:581;s:23:\"video/theme-rtl.min.css\";i:582;s:15:\"video/theme.css\";i:583;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `wp_options` VALUES("124557", "_transient_timeout_mc4wp_mailchimp_lists", "1765690835", "off");
INSERT INTO `wp_options` VALUES("124558", "_transient_mc4wp_mailchimp_lists", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("124797", "_transient_timeout_elementor_remote_info_api_data_3.33.4", "1765672404", "off");
INSERT INTO `wp_options` VALUES("124798", "_transient_elementor_remote_info_api_data_3.33.4", "a:4:{s:9:\"timestamp\";s:10:\"1765625775\";s:14:\"upgrade_notice\";a:3:{s:7:\"version\";s:5:\"2.0.0\";s:7:\"message\";s:0:\"\";s:11:\"update_link\";s:0:\"\";}s:11:\"pro_widgets\";a:82:{i:0;a:4:{s:4:\"name\";s:6:\"search\";s:5:\"title\";s:6:\"Search\";s:4:\"icon\";s:17:\"eicon-site-search\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:1;a:4:{s:4:\"name\";s:5:\"posts\";s:5:\"title\";s:5:\"Posts\";s:4:\"icon\";s:15:\"eicon-post-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:2;a:4:{s:4:\"name\";s:9:\"portfolio\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:18:\"eicon-gallery-grid\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:3;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-2\";s:5:\"title\";s:7:\"Classic\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:4;a:4:{s:4:\"name\";s:9:\"mega-menu\";s:5:\"title\";s:4:\"Menu\";s:4:\"icon\";s:15:\"eicon-mega-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:5;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-3\";s:5:\"title\";s:8:\"Showcase\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:6;a:4:{s:4:\"name\";s:4:\"form\";s:5:\"title\";s:4:\"Form\";s:4:\"icon\";s:21:\"eicon-form-horizontal\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:7;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-4\";s:5:\"title\";s:5:\"Links\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:8;a:4:{s:4:\"name\";s:9:\"loop-grid\";s:5:\"title\";s:9:\"Loop Grid\";s:4:\"icon\";s:18:\"eicon-loop-builder\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:9;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-5\";s:5:\"title\";s:8:\"Services\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:10;a:4:{s:4:\"name\";s:13:\"loop-carousel\";s:5:\"title\";s:13:\"Loop Carousel\";s:4:\"icon\";s:19:\"eicon-carousel-loop\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:11;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-6\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:12;a:4:{s:4:\"name\";s:7:\"gallery\";s:5:\"title\";s:7:\"Gallery\";s:4:\"icon\";s:23:\"eicon-gallery-justified\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:13;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-7\";s:5:\"title\";s:13:\"Business Card\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:14;a:4:{s:4:\"name\";s:17:\"animated-headline\";s:5:\"title\";s:17:\"Animated Headline\";s:4:\"icon\";s:23:\"eicon-animated-headline\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:15;a:4:{s:4:\"name\";s:10:\"price-list\";s:5:\"title\";s:10:\"Price List\";s:4:\"icon\";s:16:\"eicon-price-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:16;a:4:{s:4:\"name\";s:11:\"price-table\";s:5:\"title\";s:11:\"Price Table\";s:4:\"icon\";s:17:\"eicon-price-table\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:17;a:4:{s:4:\"name\";s:8:\"flip-box\";s:5:\"title\";s:8:\"Flip Box\";s:4:\"icon\";s:14:\"eicon-flip-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:18;a:4:{s:4:\"name\";s:14:\"call-to-action\";s:5:\"title\";s:14:\"Call to Action\";s:4:\"icon\";s:20:\"eicon-image-rollover\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:19;a:4:{s:4:\"name\";s:14:\"media-carousel\";s:5:\"title\";s:14:\"Media Carousel\";s:4:\"icon\";s:20:\"eicon-media-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:20;a:4:{s:4:\"name\";s:15:\"nested-carousel\";s:5:\"title\";s:8:\"Carousel\";s:4:\"icon\";s:21:\"eicon-nested-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:21;a:4:{s:4:\"name\";s:10:\"off-canvas\";s:5:\"title\";s:10:\"Off-Canvas\";s:4:\"icon\";s:16:\"eicon-off-canvas\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:22;a:4:{s:4:\"name\";s:9:\"countdown\";s:5:\"title\";s:9:\"Countdown\";s:4:\"icon\";s:15:\"eicon-countdown\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:23;a:4:{s:4:\"name\";s:13:\"share-buttons\";s:5:\"title\";s:13:\"Share Buttons\";s:4:\"icon\";s:11:\"eicon-share\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:24;a:4:{s:4:\"name\";s:10:\"blockquote\";s:5:\"title\";s:10:\"Blockquote\";s:4:\"icon\";s:16:\"eicon-blockquote\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:25;a:4:{s:4:\"name\";s:6:\"lottie\";s:5:\"title\";s:6:\"Lottie\";s:4:\"icon\";s:12:\"eicon-lottie\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:26;a:4:{s:4:\"name\";s:7:\"hotspot\";s:5:\"title\";s:7:\"Hotspot\";s:4:\"icon\";s:19:\"eicon-image-hotspot\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:27;a:4:{s:4:\"name\";s:13:\"paypal-button\";s:5:\"title\";s:13:\"PayPal Button\";s:4:\"icon\";s:19:\"eicon-paypal-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:28;a:4:{s:4:\"name\";s:14:\"code-highlight\";s:5:\"title\";s:14:\"Code Highlight\";s:4:\"icon\";s:20:\"eicon-code-highlight\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:29;a:4:{s:4:\"name\";s:14:\"video-playlist\";s:5:\"title\";s:14:\"Video Playlist\";s:4:\"icon\";s:20:\"eicon-video-playlist\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:30;a:4:{s:4:\"name\";s:8:\"template\";s:5:\"title\";s:8:\"Template\";s:4:\"icon\";s:19:\"eicon-document-file\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:31;a:4:{s:4:\"name\";s:13:\"stripe-button\";s:5:\"title\";s:13:\"Stripe Button\";s:4:\"icon\";s:19:\"eicon-stripe-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:32;a:4:{s:4:\"name\";s:16:\"progress-tracker\";s:5:\"title\";s:16:\"Progress Tracker\";s:4:\"icon\";s:22:\"eicon-progress-tracker\";s:10:\"categories\";s:40:\"[\"pro-elements\",\"theme-elements-single\"]\";}i:33;a:4:{s:4:\"name\";s:8:\"nav-menu\";s:5:\"title\";s:8:\"Nav Menu\";s:4:\"icon\";s:14:\"eicon-nav-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:34;a:4:{s:4:\"name\";s:17:\"table-of-contents\";s:5:\"title\";s:17:\"Table of Contents\";s:4:\"icon\";s:23:\"eicon-table-of-contents\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:35;a:4:{s:4:\"name\";s:5:\"login\";s:5:\"title\";s:5:\"Login\";s:4:\"icon\";s:15:\"eicon-lock-user\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:36;a:4:{s:4:\"name\";s:6:\"slides\";s:5:\"title\";s:6:\"Slides\";s:4:\"icon\";s:12:\"eicon-slides\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:37;a:4:{s:4:\"name\";s:20:\"testimonial-carousel\";s:5:\"title\";s:20:\"Testimonial Carousel\";s:4:\"icon\";s:26:\"eicon-testimonial-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:38;a:4:{s:4:\"name\";s:7:\"reviews\";s:5:\"title\";s:7:\"Reviews\";s:4:\"icon\";s:12:\"eicon-review\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:39;a:4:{s:4:\"name\";s:15:\"facebook-button\";s:5:\"title\";s:15:\"Facebook Button\";s:4:\"icon\";s:23:\"eicon-facebook-like-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:40;a:4:{s:4:\"name\";s:17:\"facebook-comments\";s:5:\"title\";s:17:\"Facebook Comments\";s:4:\"icon\";s:23:\"eicon-facebook-comments\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:41;a:4:{s:4:\"name\";s:14:\"facebook-embed\";s:5:\"title\";s:14:\"Facebook Embed\";s:4:\"icon\";s:14:\"eicon-fb-embed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:42;a:4:{s:4:\"name\";s:13:\"facebook-page\";s:5:\"title\";s:13:\"Facebook Page\";s:4:\"icon\";s:13:\"eicon-fb-feed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:43;a:4:{s:4:\"name\";s:15:\"theme-site-logo\";s:5:\"title\";s:9:\"Site Logo\";s:4:\"icon\";s:15:\"eicon-site-logo\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:44;a:4:{s:4:\"name\";s:16:\"theme-site-title\";s:5:\"title\";s:10:\"Site Title\";s:4:\"icon\";s:16:\"eicon-site-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:45;a:4:{s:4:\"name\";s:16:\"theme-page-title\";s:5:\"title\";s:10:\"Page Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:46;a:4:{s:4:\"name\";s:16:\"theme-post-title\";s:5:\"title\";s:10:\"Post Title\";s:4:\"icon\";s:16:\"eicon-post-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:47;a:4:{s:4:\"name\";s:18:\"theme-post-excerpt\";s:5:\"title\";s:12:\"Post Excerpt\";s:4:\"icon\";s:18:\"eicon-post-excerpt\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:48;a:4:{s:4:\"name\";s:25:\"theme-post-featured-image\";s:5:\"title\";s:14:\"Featured Image\";s:4:\"icon\";s:20:\"eicon-featured-image\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:49;a:4:{s:4:\"name\";s:19:\"theme-archive-title\";s:5:\"title\";s:13:\"Archive Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:50;a:4:{s:4:\"name\";s:13:\"archive-posts\";s:5:\"title\";s:13:\"Archive Posts\";s:4:\"icon\";s:19:\"eicon-archive-posts\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:51;a:4:{s:4:\"name\";s:10:\"author-box\";s:5:\"title\";s:10:\"Author Box\";s:4:\"icon\";s:12:\"eicon-person\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:52;a:4:{s:4:\"name\";s:13:\"post-comments\";s:5:\"title\";s:13:\"Post Comments\";s:4:\"icon\";s:14:\"eicon-comments\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:53;a:4:{s:4:\"name\";s:15:\"post-navigation\";s:5:\"title\";s:15:\"Post Navigation\";s:4:\"icon\";s:21:\"eicon-post-navigation\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:54;a:4:{s:4:\"name\";s:9:\"post-info\";s:5:\"title\";s:9:\"Post Info\";s:4:\"icon\";s:15:\"eicon-post-info\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:55;a:4:{s:4:\"name\";s:7:\"sitemap\";s:5:\"title\";s:7:\"Sitemap\";s:4:\"icon\";s:13:\"eicon-sitemap\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:56;a:4:{s:4:\"name\";s:11:\"breadcrumbs\";s:5:\"title\";s:11:\"Breadcrumbs\";s:4:\"icon\";s:11:\"eicon-yoast\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:57;a:4:{s:4:\"name\";s:21:\"woocommerce-menu-cart\";s:5:\"title\";s:9:\"Menu Cart\";s:4:\"icon\";s:10:\"eicon-cart\";s:10:\"categories\";s:41:\"[\"theme-elements\",\"woocommerce-elements\"]\";}i:58;a:4:{s:4:\"name\";s:19:\"wc-archive-products\";s:5:\"title\";s:16:\"Archive Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:59;a:4:{s:4:\"name\";s:31:\"woocommerce-archive-description\";s:5:\"title\";s:19:\"Archive Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:60;a:4:{s:4:\"name\";s:20:\"woocommerce-products\";s:5:\"title\";s:8:\"Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:61;a:4:{s:4:\"name\";s:22:\"woocommerce-breadcrumb\";s:5:\"title\";s:23:\"WooCommerce Breadcrumbs\";s:4:\"icon\";s:25:\"eicon-product-breadcrumbs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:62;a:4:{s:4:\"name\";s:14:\"wc-add-to-cart\";s:5:\"title\";s:18:\"Custom Add To Cart\";s:4:\"icon\";s:17:\"eicon-woocommerce\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:63;a:4:{s:4:\"name\";s:11:\"wc-elements\";s:5:\"title\";s:17:\"WooCommerce Pages\";s:4:\"icon\";s:19:\"eicon-product-pages\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:64;a:4:{s:4:\"name\";s:13:\"wc-categories\";s:5:\"title\";s:18:\"Product Categories\";s:4:\"icon\";s:24:\"eicon-product-categories\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:65;a:4:{s:4:\"name\";s:25:\"woocommerce-product-title\";s:5:\"title\";s:13:\"Product Title\";s:4:\"icon\";s:19:\"eicon-product-title\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:66;a:4:{s:4:\"name\";s:26:\"woocommerce-product-images\";s:5:\"title\";s:14:\"Product Images\";s:4:\"icon\";s:20:\"eicon-product-images\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:67;a:4:{s:4:\"name\";s:25:\"woocommerce-product-price\";s:5:\"title\";s:13:\"Product Price\";s:4:\"icon\";s:19:\"eicon-product-price\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:68;a:4:{s:4:\"name\";s:31:\"woocommerce-product-add-to-cart\";s:5:\"title\";s:11:\"Add To Cart\";s:4:\"icon\";s:25:\"eicon-product-add-to-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:69;a:4:{s:4:\"name\";s:26:\"woocommerce-product-rating\";s:5:\"title\";s:14:\"Product Rating\";s:4:\"icon\";s:20:\"eicon-product-rating\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:70;a:4:{s:4:\"name\";s:25:\"woocommerce-product-stock\";s:5:\"title\";s:13:\"Product Stock\";s:4:\"icon\";s:19:\"eicon-product-stock\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:71;a:4:{s:4:\"name\";s:24:\"woocommerce-product-meta\";s:5:\"title\";s:12:\"Product Meta\";s:4:\"icon\";s:18:\"eicon-product-meta\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:72;a:4:{s:4:\"name\";s:37:\"woocommerce-product-short-description\";s:5:\"title\";s:17:\"Short Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:73;a:4:{s:4:\"name\";s:29:\"woocommerce-product-data-tabs\";s:5:\"title\";s:17:\"Product Data Tabs\";s:4:\"icon\";s:18:\"eicon-product-tabs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:74;a:4:{s:4:\"name\";s:42:\"woocommerce-product-additional-information\";s:5:\"title\";s:22:\"Additional Information\";s:4:\"icon\";s:19:\" eicon-product-info\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:75;a:4:{s:4:\"name\";s:27:\"woocommerce-product-related\";s:5:\"title\";s:15:\"Product Related\";s:4:\"icon\";s:21:\"eicon-product-related\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:76;a:4:{s:4:\"name\";s:26:\"woocommerce-product-upsell\";s:5:\"title\";s:7:\"Upsells\";s:4:\"icon\";s:20:\"eicon-product-upsell\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:77;a:4:{s:4:\"name\";s:25:\"woocommerce-checkout-page\";s:5:\"title\";s:8:\"Checkout\";s:4:\"icon\";s:14:\"eicon-checkout\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:78;a:4:{s:4:\"name\";s:16:\"woocommerce-cart\";s:5:\"title\";s:4:\"Cart\";s:4:\"icon\";s:14:\"eicon-woo-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:79;a:4:{s:4:\"name\";s:22:\"woocommerce-my-account\";s:5:\"title\";s:10:\"My Account\";s:4:\"icon\";s:16:\"eicon-my-account\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:80;a:4:{s:4:\"name\";s:28:\"woocommerce-purchase-summary\";s:5:\"title\";s:16:\"Purchase Summary\";s:4:\"icon\";s:22:\"eicon-purchase-summary\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:81;a:4:{s:4:\"name\";s:19:\"woocommerce-notices\";s:5:\"title\";s:19:\"WooCommerce Notices\";s:4:\"icon\";s:25:\"eicon-woocommerce-notices\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}}s:17:\"canary_deployment\";a:2:{s:11:\"plugin_info\";a:11:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:5:\"3.6.0\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.0.zip\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:5:\"icons\";a:3:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.png?rev=1427768\";s:2:\"1x\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";s:3:\"svg\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:3:\"6.9\";s:12:\"requires_php\";s:3:\"5.6\";}s:10:\"conditions\";a:0:{}}}", "off");
INSERT INTO `wp_options` VALUES("124826", "_transient_timeout_hostinger_login_data", "1765669694", "off");
INSERT INTO `wp_options` VALUES("124827", "_transient_hostinger_login_data", "a:11:{s:5:\"email\";s:25:\"agorajuridicasl@gmail.com\";s:17:\"redirect_location\";s:6:\"hpanel\";s:9:\"client_id\";s:8:\"36818666\";s:16:\"acting_client_id\";s:0:\"\";s:8:\"username\";s:10:\"u176508502\";s:6:\"domain\";s:20:\"procuradorgalicia.es\";s:9:\"directory\";s:0:\"\";s:6:\"source\";s:12:\"website_list\";s:12:\"callback_url\";s:114:\"https://hpanel.hostinger.com/api/rest-hosting/v3/wordpress/login/callback/9b7ca5e97d51035989713c336aedb194bd794ce0\";s:14:\"autologin_file\";s:94:\"/home/u176508502/domains/procuradorgalicia.es/public_html/create_autologin_hew4vhvn2lbopth.php\";s:13:\"redirect_page\";s:73:\"https://procuradorgalicia.es/wp-admin/?platform=hpanel&client_id=36818666\";}", "off");
INSERT INTO `wp_options` VALUES("124828", "_transient_timeout_check_transients", "1765670032", "off");
INSERT INTO `wp_options` VALUES("124829", "_transient_check_transients", "1", "off");
INSERT INTO `wp_options` VALUES("124833", "_transient_timeout_action_scheduler_last_pastdue_actions_check", "1765676580", "off");
INSERT INTO `wp_options` VALUES("124834", "_transient_action_scheduler_last_pastdue_actions_check", "1765654980", "off");
INSERT INTO `wp_options` VALUES("124835", "_transient_timeout_survey_questions_transient_request", "1765665780", "off");
INSERT INTO `wp_options` VALUES("124836", "_transient_survey_questions_transient_request", "1", "off");
INSERT INTO `wp_options` VALUES("124839", "_transient_timeout_client_eligibility_transient_response", "1765665780", "off");
INSERT INTO `wp_options` VALUES("124840", "_transient_client_eligibility_transient_response", "eligible", "off");
INSERT INTO `wp_options` VALUES("124841", "_transient_timeout_amplitude_event_wordpress.reach_banner.shown", "1765741381", "off");
INSERT INTO `wp_options` VALUES("124842", "_transient_amplitude_event_wordpress.reach_banner.shown", "1765654981", "off");
INSERT INTO `wp_options` VALUES("124843", "can_compress_scripts", "1", "on");
INSERT INTO `wp_options` VALUES("124844", "_transient_timeout_amplitude_event_wordpress.easy_onboarding.enter", "1765741383", "off");
INSERT INTO `wp_options` VALUES("124845", "_transient_amplitude_event_wordpress.easy_onboarding.enter", "1765654983", "off");
INSERT INTO `wp_options` VALUES("124846", "_transient_timeout_hostinger_newest_wordpress_version", "1765741387", "off");
INSERT INTO `wp_options` VALUES("124847", "_transient_hostinger_newest_wordpress_version", "6.9", "off");
INSERT INTO `wp_options` VALUES("124848", "_transient_timeout_hostinger_is_eligible_www_redirect", "1765655107", "off");
INSERT INTO `wp_options` VALUES("124849", "_transient_hostinger_is_eligible_www_redirect", "", "off");
INSERT INTO `wp_options` VALUES("124855", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1765665888", "off");
INSERT INTO `wp_options` VALUES("124856", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "O:8:\"stdClass\":100:{s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:7814;}s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4947;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2802;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2781;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:2154;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:2152;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:2141;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1975;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:1711;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1665;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1627;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1562;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1519;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1516;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1509;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:1396;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1374;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1318;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:1285;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1184;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1161;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:1087;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:1086;}s:5:\"block\";a:3:{s:4:\"name\";s:5:\"block\";s:4:\"slug\";s:5:\"block\";s:5:\"count\";i:1084;}s:9:\"gutenberg\";a:3:{s:4:\"name\";s:9:\"gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:5:\"count\";i:1075;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:1068;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:1051;}s:9:\"elementor\";a:3:{s:4:\"name\";s:9:\"elementor\";s:4:\"slug\";s:9:\"elementor\";s:5:\"count\";i:1045;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:1013;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:990;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:957;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:953;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:940;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:937;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:914;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:904;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:868;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:824;}s:2:\"ai\";a:3:{s:4:\"name\";s:2:\"AI\";s:4:\"slug\";s:2:\"ai\";s:5:\"count\";i:813;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:791;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:786;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:776;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:773;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:767;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:757;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:730;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:725;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:710;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:707;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:702;}s:8:\"shipping\";a:3:{s:4:\"name\";s:8:\"shipping\";s:4:\"slug\";s:8:\"shipping\";s:5:\"count\";i:698;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:696;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:678;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:665;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:665;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:654;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:653;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:653;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:653;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:640;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:626;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:625;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:620;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:616;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:615;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:612;}s:6:\"blocks\";a:3:{s:4:\"name\";s:6:\"blocks\";s:4:\"slug\";s:6:\"blocks\";s:5:\"count\";i:609;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:599;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:589;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:587;}s:8:\"payments\";a:3:{s:4:\"name\";s:8:\"payments\";s:4:\"slug\";s:8:\"payments\";s:5:\"count\";i:586;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:583;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:580;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:578;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:571;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:562;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:539;}s:8:\"checkout\";a:3:{s:4:\"name\";s:8:\"checkout\";s:4:\"slug\";s:8:\"checkout\";s:5:\"count\";i:537;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:533;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:531;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:530;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:529;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:525;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:512;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:510;}s:7:\"gateway\";a:3:{s:4:\"name\";s:7:\"gateway\";s:4:\"slug\";s:7:\"gateway\";s:5:\"count\";i:490;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:485;}s:6:\"import\";a:3:{s:4:\"name\";s:6:\"import\";s:4:\"slug\";s:6:\"import\";s:5:\"count\";i:483;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:479;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:472;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:470;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:461;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:458;}s:5:\"cache\";a:3:{s:4:\"name\";s:5:\"cache\";s:4:\"slug\";s:5:\"cache\";s:5:\"count\";i:455;}s:7:\"chatbot\";a:3:{s:4:\"name\";s:7:\"chatbot\";s:4:\"slug\";s:7:\"chatbot\";s:5:\"count\";i:449;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:444;}s:8:\"products\";a:3:{s:4:\"name\";s:8:\"products\";s:4:\"slug\";s:8:\"products\";s:5:\"count\";i:433;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:432;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:428;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:426;}}", "off");
INSERT INTO `wp_options` VALUES("124857", "ai1wm_status", "a:2:{s:4:\"type\";s:8:\"download\";s:7:\"message\";s:378:\"<a href=\"https://procuradorgalicia.es/wp-content/ai1wm-backups/procuradorgalicia-es-20251213-194552-8reinne7vdxg.wpress\" class=\"ai1wm-button-green ai1wm-emphasize ai1wm-button-download\" title=\"procuradorgalicia.es\" download=\"procuradorgalicia-es-20251213-194552-8reinne7vdxg.wpress\">\n							<span>Descargar procuradorgalicia.es</span>\n							<em>Tamaño: 345 MB</em>\n							</a>\";}", "auto");
INSERT INTO `wp_options` VALUES("124859", "_transient_timeout_amplitude_event_wordpress.preview_site", "1765741768", "off");
INSERT INTO `wp_options` VALUES("124860", "_transient_amplitude_event_wordpress.preview_site", "1765655368", "off");
INSERT INTO `wp_options` VALUES("124865", "_site_transient_timeout_available_translations", "1765666716", "off");
INSERT INTO `wp_options` VALUES("124866", "_site_transient_available_translations", "a:131:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:6:\"6.0.11\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.0.11/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2024-02-13 12:49:38\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.7/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-07-10 08:09:09\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2024-01-19 08:58:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.7/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2024-12-26 00:37:42\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.28/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-01 10:38:20\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-07 14:52:58\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-05 09:40:40\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-11 21:36:34\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-26 15:18:01\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-18 15:47:02\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-10-23 12:01:47\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-11 23:07:58\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-11 23:06:57\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.9/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-28 08:11:27\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-28 08:08:17\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.9/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-03 20:02:46\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-05-22 11:56:25\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-25 13:30:15\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-13 00:57:20\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-13 06:27:29\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-25 15:42:18\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-08-19 08:40:47\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-28 13:13:48\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-03 11:10:15\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-10 15:28:40\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-12 22:21:48\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-13 04:21:30\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2024-10-16 21:04:12\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.9-RC/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2025-10-01 22:54:47\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.9-RC/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2023-10-16 16:00:04\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:6:\"5.8.12\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.8.12/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.18/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.23\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.23/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-06 09:50:37\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2025-11-05 21:53:17\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9-RC/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-06 02:07:08\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2025-02-14 17:29:08\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.9-RC/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-29 11:04:04\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-10-03 04:54:28\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-10 11:15:06\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"6.5.7\";s:7:\"updated\";s:19:\"2024-02-01 23:56:53\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.7/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2023-04-30 13:56:46\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2025-10-21 16:35:04\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.8/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-18 15:51:09\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-09 11:14:55\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.34\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.34/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2024-05-04 18:39:24\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2025-02-06 05:17:11\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-03 02:14:36\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-03 02:11:55\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-10-23 03:46:40\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.28/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-01 17:48:46\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-28 11:59:02\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.28/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-25 08:25:07\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-07-05 11:40:39\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2024-07-18 02:49:24\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9-RC/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.23\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.23/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-13 14:52:59\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-03 12:23:06\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-08 08:55:07\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/translation/core/6.9/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:3:\"kir\";a:8:{s:8:\"language\";s:3:\"kir\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-23 15:08:15\";s:12:\"english_name\";s:6:\"Kyrgyz\";s:11:\"native_name\";s:16:\"Кыргызча\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/translation/core/6.9/kir.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ky\";i:2;s:3:\"kir\";i:3;s:3:\"kir\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Улантуу\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2025-09-27 20:51:17\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.9-RC/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-07-15 19:11:43\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:6:\"6.0.11\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.0.11/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-13 18:17:49\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.5.7\";s:7:\"updated\";s:19:\"2024-06-20 17:22:06\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.7/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-05 11:38:40\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.17\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.17/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.39\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.39/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-02 19:55:58\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2025-11-07 08:26:32\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.9-RC/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-28 09:40:20\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-11 13:52:50\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-18 15:26:13\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.9/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-01 09:45:52\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.35\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.35/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-02 18:21:27\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2023-08-21 12:15:00\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-02 10:17:43\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-02 00:03:57\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/6.9/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-09 09:48:35\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-08 13:01:10\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.18/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-01 04:57:17\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2025-04-24 16:58:02\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/6.9-RC/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-10-29 11:19:02\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-21 22:07:32\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-03 15:37:44\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-27 15:18:03\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-16 17:19:56\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.39\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.39/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:6:\"5.8.12\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.8.12/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-13 08:39:22\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-26 15:28:41\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-11 16:02:15\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"6.8\";s:7:\"updated\";s:19:\"2025-04-18 21:10:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.8/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.18/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-09-01 09:12:13\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-02 00:32:44\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-03 08:19:35\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}}", "off");
INSERT INTO `wp_options` VALUES("124880", "_site_transient_timeout_theme_roots", "1765660695", "off");
INSERT INTO `wp_options` VALUES("124881", "_site_transient_theme_roots", "a:3:{s:5:\"astra\";s:7:\"/themes\";s:8:\"onepress\";s:7:\"/themes\";s:16:\"twentytwentyfive\";s:7:\"/themes\";}", "off");
INSERT INTO `wp_options` VALUES("124888", "_site_transient_timeout_wp_remote_block_patterns_a24702d1c5a3db976db49141dea44a66", "1765662785", "off");
INSERT INTO `wp_options` VALUES("124889", "_site_transient_wp_remote_block_patterns_a24702d1c5a3db976db49141dea44a66", "a:94:{i:0;O:8:\"stdClass\":7:{s:2:\"id\";i:515135;s:5:\"title\";O:8:\"stdClass\":1:{s:8:\"rendered\";s:50:\"Área de introducción con encabezamiento e imagen\";}s:7:\"content\";O:8:\"stdClass\":2:{s:8:\"rendered\";s:1712:\"\n<div class=\"wp-block-group alignfull is-content-justification-center is-layout-constrained wp-block-group-is-layout-constrained\" style=\"margin-top:0;margin-bottom:0\">\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-group alignwide is-layout-flow wp-block-group-is-layout-flow\">\n<div class=\"wp-block-columns alignwide are-vertically-aligned-top is-layout-flex wp-container-core-columns-is-layout-5c8fb865 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-vertically-aligned-top is-content-justification-left is-layout-constrained wp-container-core-column-is-layout-95996b15 wp-block-column-is-layout-constrained\">\n<h2 class=\"wp-block-heading\">Descubre un reino de oportunidades.</h2>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-top is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:40%\">\n<p>Explorando el complejo tapiz de la vida, las opciones revelan rutas hacia lo excepcional, requiriendo innovación, curiosidad y valentía para un viaje profundamente satisfactorio.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">EMPEZAR</a></div>\n</div>\n</div>\n</div>\n\n\n\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://pd.w.org/2023/07/44364b18862589f06.53436652.jpg\" alt=\"\" style=\"aspect-ratio:16/9;object-fit:cover\" /></figure>\n</div>\n\n\n\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n</div>\n\";s:9:\"protected\";b:0;}s:4:\"meta\";O:8:\"stdClass\":9:{s:31:\"jetpack_post_was_ever_published\";b:0;s:13:\"wpop_keywords\";s:28:\"Sección a pantalla completa\";s:16:\"wpop_description\";s:112:\"Dos columnas de texto, la izquierda con un encabezado y la derecha con un párrafo, con una imagen amplia abajo.\";s:19:\"wpop_viewport_width\";i:1200;s:16:\"wpop_block_types\";a:1:{i:0;s:0:\"\";}s:11:\"wpop_locale\";s:5:\"es_ES\";s:15:\"wpop_wp_version\";s:3:\"6.5\";s:25:\"wpop_contains_block_types\";s:111:\"core/button,core/buttons,core/column,core/columns,core/group,core/heading,core/image,core/paragraph,core/spacer\";s:9:\"footnotes\";s:0:\"\";}s:14:\"category_slugs\";a:1:{i:0;s:5:\"about\";}s:13:\"keyword_slugs\";a:1:{i:0;s:4:\"core\";}s:15:\"pattern_content\";s:2441:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0\"><!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"metadata\":{\"name\":\"Contents\"},\"align\":\"wide\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:columns {\"verticalAlignment\":\"top\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-top\"><!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\",\"contentSize\":\"450px\"}} -->\n<div class=\"wp-block-column is-vertically-aligned-top\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Descubre un reino de oportunidades.</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"40%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:40%\"><!-- wp:paragraph -->\n<p>Explorando el complejo tapiz de la vida, las opciones revelan rutas hacia lo excepcional, requiriendo innovación, curiosidad y valentía para un viaje profundamente satisfactorio.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">EMPEZAR</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"aspectRatio\":\"16/9\",\"scale\":\"cover\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://pd.w.org/2023/07/44364b18862589f06.53436652.jpg\" alt=\"\" style=\"aspect-ratio:16/9;object-fit:cover\" /></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";}i:1;O:8:\"stdClass\":7:{s:2:\"id\";i:310653;s:5:\"title\";O:8:\"stdClass\":1:{s:8:\"rendered\";s:40:\"Cover Poster on Left, Paragraph on Right\";}s:7:\"content\";O:8:\"stdClass\":2:{s:8:\"rendered\";s:3826:\"\n<div class=\"wp-block-cover alignfull has-custom-content-position is-position-top-center\" style=\"margin-top:0;padding-top:5vw;padding-right:5vw;padding-bottom:5vw;padding-left:5vw\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-100 has-background-dim\" style=\"background-color:#36220c\"></span><div class=\"wp-block-cover__inner-container is-layout-flow wp-block-cover-is-layout-flow\">\n<div class=\"wp-block-group is-content-justification-space-between is-layout-flex wp-container-core-group-is-layout-495512eb wp-block-group-is-layout-flex\">\n<div class=\"wp-block-cover is-light has-custom-content-position is-position-top-right wp-container-content-ceb7f5b3 wp-duotone-rgb137750-rgb210210210-1\" style=\"padding-top:4vw;padding-right:4vw;padding-bottom:4vw;padding-left:4vw;min-height:75vh;aspect-ratio:unset;\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim\"></span><img decoding=\"async\" class=\"wp-block-cover__image-background wp-image-334\" alt=\"\" src=\"https://pd.w.org/2023/04/654642d52f20d6367.57324872.jpg\" data-object-fit=\"cover\" /><div class=\"wp-block-cover__inner-container is-layout-flow wp-block-cover-is-layout-flow\">\n<div class=\"wp-block-group is-vertical is-content-justification-right is-nowrap is-layout-flex wp-container-core-group-is-layout-67854338 wp-block-group-is-layout-flex\">\n<p class=\"has-text-color\" style=\"color:#e5683a;font-size:140px;font-style:normal;font-weight:800;letter-spacing:-6px;line-height:0.8;text-transform:uppercase\">Wardell</p>\n\n\n\n<p class=\"has-text-color\" style=\"color:#e5683a;font-size:130px;font-style:normal;font-weight:800;letter-spacing:-6px;line-height:0.8;text-transform:uppercase\">gris</p>\n\n\n\n<p class=\"has-text-align-center has-text-color\" style=\"color:#d09c9c;font-size:90px;font-style:normal;font-weight:800;letter-spacing:0px;line-height:1;text-transform:uppercase\">Plays</p>\n\n\n\n<p class=\"has-text-align-center has-text-color\" style=\"color:#e59937;font-size:90px;font-style:normal;font-weight:800;letter-spacing:0px;line-height:0.8;text-transform:uppercase\">Bebop &amp;</p>\n\n\n\n<p class=\"has-text-align-center has-text-color\" style=\"color:#e59937;font-size:90px;font-style:normal;font-weight:800;letter-spacing:0px;line-height:1;text-transform:uppercase\">SWING</p>\n</div>\n</div></div>\n\n\n\n<div class=\"wp-block-group wp-container-content-d387280b is-vertical is-nowrap is-layout-flex wp-container-core-group-is-layout-3cf04848 wp-block-group-is-layout-flex\">\n<p class=\"has-text-color\" style=\"color:#e59937;font-size:18px;font-style:normal;font-weight:400;letter-spacing:0px;line-height:1.7\">Wardell Gray nació en Oklahoma City, el menor de cuatro hermanos. Pasó los primeros años de su infancia en Oklahoma, antes de trasladarse con su familia a Detroit en 1929. </p>\n\n\n\n<p class=\"has-text-color\" style=\"color:#e59937;font-size:18px;font-style:normal;font-weight:400;letter-spacing:0px;line-height:1.7\">A principios de 1935, Gray empezó a asistir al instituto Northeastern High School, y luego se trasladó al instituto Cass Technical High School, que destaca por tener como antiguos alumnos a Donald Byrd, Lucky Thompson y Al McKibbon. </p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-left is-nowrap is-layout-flex wp-container-core-buttons-is-layout-fc9f69e7 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button has-custom-font-size is-style-outline is-style-outline--2\" style=\"font-size:16px;font-style:normal;font-weight:700;letter-spacing:0px;text-transform:uppercase\"><a class=\"wp-block-button__link has-text-color wp-element-button\" style=\"border-radius:0px;color:#e59937;padding-top:16px;padding-right:32px;padding-bottom:16px;padding-left:32px\">Escuchar ahora</a></div>\n</div>\n\n\n\n<div style=\"height:7.5vw\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n</div>\n</div>\n</div></div>\n\";s:9:\"protected\";b:0;}s:4:\"meta\";O:8:\"stdClass\":9:{s:31:\"jetpack_post_was_ever_published\";b:0;s:13:\"wpop_keywords\";s:0:\"\";s:16:\"wpop_description\";s:0:\"\";s:19:\"wpop_viewport_width\";i:800;s:16:\"wpop_block_types\";a:1:{i:0;s:0:\"\";}s:11:\"wpop_locale\";s:5:\"es_ES\";s:15:\"wpop_wp_version\";s:3:\"6.2\";s:25:\"wpop_contains_block_types\";s:73:\"core/button,core/buttons,core/cover,core/group,core/paragraph,core/spacer\";s:9:\"footnotes\";s:0:\"\";}s:14:\"category_slugs\";a:1:{i:0;s:6:\"banner\";}s:13:\"keyword_slugs\";a:1:{i:0;s:4:\"core\";}s:15:\"pattern_content\";s:6412:\"<!-- wp:cover {\"customOverlayColor\":\"#36220c\",\"contentPosition\":\"top center\",\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"5vw\",\"right\":\"5vw\",\"bottom\":\"5vw\",\"left\":\"5vw\"},\"margin\":{\"top\":\"0\"}}}} -->\n<div class=\"wp-block-cover alignfull has-custom-content-position is-position-top-center\" style=\"margin-top:0;padding-top:5vw;padding-right:5vw;padding-bottom:5vw;padding-left:5vw\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-100 has-background-dim\" style=\"background-color:#36220c\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"3vw\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"verticalAlignment\":\"stretch\",\"justifyContent\":\"space-between\"}} -->\n<div class=\"wp-block-group\"><!-- wp:cover {\"url\":\"https://pd.w.org/2023/04/654642d52f20d6367.57324872.jpg\",\"id\":334,\"dimRatio\":50,\"minHeight\":75,\"minHeightUnit\":\"vh\",\"contentPosition\":\"top right\",\"isDark\":false,\"style\":{\"layout\":{\"selfStretch\":\"fill\"},\"spacing\":{\"padding\":{\"top\":\"4vw\",\"right\":\"4vw\",\"bottom\":\"4vw\",\"left\":\"4vw\"}},\"color\":{\"duotone\":[\"rgb(137, 75, 0)\",\"rgb(210, 210, 210)\"]}}} -->\n<div class=\"wp-block-cover is-light has-custom-content-position is-position-top-right\" style=\"padding-top:4vw;padding-right:4vw;padding-bottom:4vw;padding-left:4vw;min-height:75vh\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-334\" alt=\"\" src=\"https://pd.w.org/2023/04/654642d52f20d6367.57324872.jpg\" data-object-fit=\"cover\" /><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"140px\",\"textTransform\":\"uppercase\",\"fontStyle\":\"normal\",\"fontWeight\":\"800\",\"lineHeight\":\"0.8\",\"letterSpacing\":\"-6px\"},\"color\":{\"text\":\"#e5683a\"}}} -->\n<p class=\"has-text-color\" style=\"color:#e5683a;font-size:140px;font-style:normal;font-weight:800;letter-spacing:-6px;line-height:0.8;text-transform:uppercase\">Wardell</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"130px\",\"textTransform\":\"uppercase\",\"fontStyle\":\"normal\",\"fontWeight\":\"800\",\"lineHeight\":\"0.8\",\"letterSpacing\":\"-6px\"},\"color\":{\"text\":\"#e5683a\"}}} -->\n<p class=\"has-text-color\" style=\"color:#e5683a;font-size:130px;font-style:normal;font-weight:800;letter-spacing:-6px;line-height:0.8;text-transform:uppercase\">gris</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"placeholder\":\"Escribe el título…\",\"style\":{\"typography\":{\"fontSize\":\"90px\",\"textTransform\":\"uppercase\",\"fontStyle\":\"normal\",\"fontWeight\":\"800\",\"letterSpacing\":\"0px\",\"lineHeight\":\"1\"},\"color\":{\"text\":\"#d09c9c\"}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#d09c9c;font-size:90px;font-style:normal;font-weight:800;letter-spacing:0px;line-height:1;text-transform:uppercase\">Plays</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"placeholder\":\"Escribe el título…\",\"style\":{\"typography\":{\"fontSize\":\"90px\",\"textTransform\":\"uppercase\",\"fontStyle\":\"normal\",\"fontWeight\":\"800\",\"letterSpacing\":\"0px\",\"lineHeight\":\"0.8\"},\"color\":{\"text\":\"#e59937\"}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#e59937;font-size:90px;font-style:normal;font-weight:800;letter-spacing:0px;line-height:0.8;text-transform:uppercase\">Bebop &amp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"placeholder\":\"Escribe el título…\",\"style\":{\"typography\":{\"fontSize\":\"90px\",\"textTransform\":\"uppercase\",\"fontStyle\":\"normal\",\"fontWeight\":\"800\",\"letterSpacing\":\"0px\",\"lineHeight\":\"1\"},\"color\":{\"text\":\"#e59937\"}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#e59937;font-size:90px;font-style:normal;font-weight:800;letter-spacing:0px;line-height:1;text-transform:uppercase\">SWING</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:group {\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"420px\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"flexWrap\":\"nowrap\",\"verticalAlignment\":\"bottom\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"18px\",\"letterSpacing\":\"0px\",\"lineHeight\":\"1.7\",\"fontStyle\":\"normal\",\"fontWeight\":\"400\"},\"color\":{\"text\":\"#e59937\"}}} -->\n<p class=\"has-text-color\" style=\"color:#e59937;font-size:18px;font-style:normal;font-weight:400;letter-spacing:0px;line-height:1.7\">Wardell Gray nació en Oklahoma City, el menor de cuatro hermanos. Pasó los primeros años de su infancia en Oklahoma, antes de trasladarse con su familia a Detroit en 1929. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"18px\",\"letterSpacing\":\"0px\",\"lineHeight\":\"1.7\",\"fontStyle\":\"normal\",\"fontWeight\":\"400\"},\"color\":{\"text\":\"#e59937\"}}} -->\n<p class=\"has-text-color\" style=\"color:#e59937;font-size:18px;font-style:normal;font-weight:400;letter-spacing:0px;line-height:1.7\">A principios de 1935, Gray empezó a asistir al instituto Northeastern High School, y luego se trasladó al instituto Cass Technical High School, que destaca por tener como antiguos alumnos a Donald Byrd, Lucky Thompson y Al McKibbon. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"color\":{\"text\":\"#e59937\"},\"border\":{\"radius\":\"0px\"},\"spacing\":{\"padding\":{\"top\":\"16px\",\"right\":\"32px\",\"bottom\":\"16px\",\"left\":\"32px\"}},\"typography\":{\"fontSize\":\"16px\",\"textTransform\":\"uppercase\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\",\"letterSpacing\":\"0px\"}},\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button has-custom-font-size is-style-outline\" style=\"font-size:16px;font-style:normal;font-weight:700;letter-spacing:0px;text-transform:uppercase\"><a class=\"wp-block-button__link has-text-color wp-element-button\" style=\"border-radius:0px;color:#e59937;padding-top:16px;padding-right:32px;padding-bottom:16px;padding-left:32px\">Escuchar ahora</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:spacer {\"height\":\"7.5vw\"} -->\n<div style=\"height:7.5vw\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:cover -->\";}i:2;O:8:\"stdClass\":7:{s:2:\"id\";i:309977;s:5:\"title\";O:8:\"stdClass\":1:{s:8:\"rendered\";s:33:\"Imagen centrada con fondo bicolor\";}s:7:\"content\";O:8:\"stdClass\":2:{s:8:\"rendered\";s:1331:\"\n<div class=\"wp-block-cover alignfull is-light\" style=\"margin-top:0;padding-top:5vw;padding-right:5vw;padding-bottom:5vw;padding-left:5vw;min-height:66vh;aspect-ratio:unset;\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-100 has-background-dim has-background-gradient\" style=\"background:linear-gradient(90deg,rgb(35,74,20) 50%,rgb(225,137,116) 50%)\"></span><div class=\"wp-block-cover__inner-container is-layout-flow wp-block-cover-is-layout-flow\">\n<div class=\"wp-block-group wp-container-content-9cfa9a5a is-layout-constrained wp-container-core-group-is-layout-a1274fd4 wp-block-group-is-layout-constrained\">\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-large is-style-default wp-duotone-000000-ffffff-3\"><img decoding=\"async\" src=\"https://pd.w.org/2022/03/3866241b433db4ee2.96648572.jpeg\" alt=\"\" /></figure>\n\n\n\n<div style=\"height:48px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading alignwide has-text-align-center has-white-color has-text-color\" style=\"padding-left:32px;font-size:50px;font-style:normal;font-weight:400;letter-spacing:32px;line-height:1;text-transform:uppercase\">Etcétera</h2>\n\n\n\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n</div>\n</div></div>\n\";s:9:\"protected\";b:0;}s:4:\"meta\";O:8:\"stdClass\":9:{s:31:\"jetpack_post_was_ever_published\";b:0;s:13:\"wpop_keywords\";s:18:\"Gradiente, Bicolor\";s:16:\"wpop_description\";s:0:\"\";s:19:\"wpop_viewport_width\";i:800;s:16:\"wpop_block_types\";a:1:{i:0;s:0:\"\";}s:11:\"wpop_locale\";s:5:\"es_ES\";s:15:\"wpop_wp_version\";s:3:\"6.2\";s:25:\"wpop_contains_block_types\";s:57:\"core/cover,core/group,core/heading,core/image,core/spacer\";s:9:\"footnotes\";s:0:\"\";}s:14:\"category_slugs\";a:3:{i:0;s:6:\"banner\";i:1;s:6:\"images\";i:2;s:4:\"text\";}s:13:\"keyword_slugs\";a:1:{i:0;s:4:\"core\";}s:15:\"pattern_content\";s:2135:\"<!-- wp:cover {\"minHeight\":66,\"minHeightUnit\":\"vh\",\"customGradient\":\"linear-gradient(90deg,rgb(35,74,20) 50%,rgb(225,137,116) 50%)\",\"isDark\":false,\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"5vw\",\"right\":\"5vw\",\"bottom\":\"5vw\",\"left\":\"5vw\"},\"margin\":{\"top\":\"0\"}}}} -->\n<div class=\"wp-block-cover alignfull is-light\" style=\"margin-top:0;padding-top:5vw;padding-right:5vw;padding-bottom:5vw;padding-left:5vw;min-height:66vh\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-100 has-background-dim has-background-gradient\" style=\"background:linear-gradient(90deg,rgb(35,74,20) 50%,rgb(225,137,116) 50%)\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0px\"},\"layout\":{\"selfStretch\":\"fill\",\"flexSize\":null}},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"600px\",\"wideSize\":\"1200px\"}} -->\n<div class=\"wp-block-group\"><!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"sizeSlug\":\"large\",\"style\":{\"color\":{\"duotone\":[\"#000000\",\"#ffffff\"]}},\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-large is-style-default\"><img src=\"https://pd.w.org/2022/03/3866241b433db4ee2.96648572.jpeg\" alt=\"\" /></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"48px\"} -->\n<div style=\"height:48px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"align\":\"wide\",\"style\":{\"typography\":{\"fontSize\":\"50px\",\"fontStyle\":\"normal\",\"fontWeight\":\"400\",\"textTransform\":\"uppercase\",\"letterSpacing\":\"32px\",\"lineHeight\":\"1\"},\"spacing\":{\"padding\":{\"left\":\"32px\"}}},\"textColor\":\"white\"} -->\n<h2 class=\"wp-block-heading alignwide has-text-align-center has-white-color has-text-color\" style=\"padding-left:32px;font-size:50px;font-style:normal;font-weight:400;letter-spacing:32px;line-height:1;text-transform:uppercase\">Etcétera</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:cover -->\";}i:3;O:8:\"stdClass\":7:{s:2:\"id\";i:416395;s:5:\"title\";O:8:\"stdClass\":1:{s:8:\"rendered\";s:68:\"Banner oscuro de ancho completo con encabezado arriba a la izquierda\";}s:7:\"content\";O:8:\"stdClass\":2:{s:8:\"rendered\";s:1089:\"\n<div class=\"wp-block-cover alignfull has-custom-content-position is-position-top-left\" style=\"margin-top:0;padding-top:5vw;padding-right:5vw;padding-bottom:5vw;padding-left:5vw;min-height:50vh;aspect-ratio:unset;\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-90 has-background-dim\" style=\"background-color:#141414\"></span><img decoding=\"async\" class=\"wp-block-cover__image-background wp-image-333\" alt=\"\" src=\"https://pd.w.org/2022/07/87262c92d42acd1c3.73206444.jpg\" style=\"object-position:50% 0%\" data-object-fit=\"cover\" data-object-position=\"50% 0%\" /><div class=\"wp-block-cover__inner-container is-layout-flow wp-block-cover-is-layout-flow\">\n<div class=\"wp-block-group wp-container-content-9cfa9a5a is-vertical is-nowrap is-layout-flex wp-container-core-group-is-layout-2890af74 wp-block-group-is-layout-flex\">\n<p class=\"has-text-align-left has-text-color has-source-serif-pro-font-family\" style=\"color:#d8a557;font-size:160px;font-style:italic;font-weight:900;letter-spacing:-4px;line-height:0.8;text-transform:none\">¡colega!</p>\n</div>\n</div></div>\n\";s:9:\"protected\";b:0;}s:4:\"meta\";O:8:\"stdClass\":9:{s:31:\"jetpack_post_was_ever_published\";b:0;s:13:\"wpop_keywords\";s:20:\"Jazz, Ancho completo\";s:16:\"wpop_description\";s:0:\"\";s:19:\"wpop_viewport_width\";i:800;s:16:\"wpop_block_types\";a:1:{i:0;s:0:\"\";}s:11:\"wpop_locale\";s:5:\"es_ES\";s:15:\"wpop_wp_version\";s:3:\"6.2\";s:25:\"wpop_contains_block_types\";s:36:\"core/cover,core/group,core/paragraph\";s:9:\"footnotes\";s:0:\"\";}s:14:\"category_slugs\";a:1:{i:0;s:6:\"banner\";}s:13:\"keyword_slugs\";a:1:{i:0;s:4:\"core\";}s:15:\"pattern_content\";s:1702:\"<!-- wp:cover {\"url\":\"https://pd.w.org/2022/07/87262c92d42acd1c3.73206444.jpg\",\"id\":333,\"dimRatio\":90,\"customOverlayColor\":\"#141414\",\"focalPoint\":{\"x\":0.5,\"y\":0},\"minHeight\":50,\"minHeightUnit\":\"vh\",\"contentPosition\":\"top left\",\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"5vw\",\"right\":\"5vw\",\"bottom\":\"5vw\",\"left\":\"5vw\"},\"margin\":{\"top\":\"0\"}}}} -->\n<div class=\"wp-block-cover alignfull has-custom-content-position is-position-top-left\" style=\"margin-top:0;padding-top:5vw;padding-right:5vw;padding-bottom:5vw;padding-left:5vw;min-height:50vh\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-90 has-background-dim\" style=\"background-color:#141414\"></span><img class=\"wp-block-cover__image-background wp-image-333\" alt=\"\" src=\"https://pd.w.org/2022/07/87262c92d42acd1c3.73206444.jpg\" style=\"object-position:50% 0%\" data-object-fit=\"cover\" data-object-position=\"50% 0%\" /><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0px\"},\"layout\":{\"selfStretch\":\"fill\",\"flexSize\":null}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"typography\":{\"fontSize\":\"160px\",\"fontStyle\":\"italic\",\"fontWeight\":\"900\",\"lineHeight\":\"0.8\",\"letterSpacing\":\"-4px\",\"textTransform\":\"none\"},\"color\":{\"text\":\"#d8a557\"}},\"fontFamily\":\"source-serif-pro\"} -->\n<p class=\"has-text-align-left has-text-color has-source-serif-pro-font-family\" style=\"color:#d8a557;font-size:160px;font-style:italic;font-weight:900;letter-spacing:-4px;line-height:0.8;text-transform:none\">¡colega!</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:cover -->\";}i:4;O:8:\"stdClass\":7:{s:2:\"id\";i:310043;s:5:\"title\";O:8:\"stdClass\":1:{s:8:\"rendered\";s:58:\"Bold Heading on Left, Paragraph and Button on bottom right\";}s:7:\"content\";O:8:\"stdClass\":2:{s:8:\"rendered\";s:2225:\"\n<div class=\"wp-block-cover alignfull\" style=\"margin-top:0;padding-top:5vw;padding-right:5vw;padding-bottom:5vw;padding-left:5vw\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-100 has-background-dim\" style=\"background-color:#d1362a\"></span><div class=\"wp-block-cover__inner-container is-layout-flow wp-block-cover-is-layout-flow\">\n<div class=\"wp-block-group is-layout-flex wp-container-core-group-is-layout-e4aad5c3 wp-block-group-is-layout-flex\">\n<div class=\"wp-block-group wp-container-content-9cfa9a5a is-layout-flow wp-container-core-group-is-layout-d6743c7d wp-block-group-is-layout-flow\">\n<p class=\"has-text-align-left has-black-color has-text-color\" style=\"font-size:148px;font-style:normal;font-weight:700;letter-spacing:-4px;line-height:0.9;text-transform:none\">Comin&#8217;<br>Home<br>Baby</p>\n\n\n\n<p class=\"has-text-align-left has-white-color has-text-color\" style=\"font-size:148px;font-style:normal;font-weight:700;letter-spacing:-4px;line-height:0.9;text-transform:none\">— Mel<br>Torme</p>\n</div>\n\n\n\n<div class=\"wp-block-group wp-container-content-5b91cf2b is-vertical is-nowrap is-layout-flex wp-container-core-group-is-layout-82cc2081 wp-block-group-is-layout-flex\">\n<p style=\"font-size:17px;font-style:normal;font-weight:500;letter-spacing:0px;line-height:1.4;text-decoration:none;text-transform:none\">Featuring Tormé&#8217;s smooth vocal style backed by a small jazz ensemble that includes saxophonist Al Cohn, guitarist Joe Puma, and pianist Hank Jones.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button has-custom-font-size\" style=\"font-size:20px;font-style:normal;font-weight:700;letter-spacing:0px;text-decoration:none;text-transform:none\"><a class=\"wp-block-button__link has-white-color has-black-background-color has-text-color has-background wp-element-button\" style=\"border-radius:0px;border-top-style:none;border-top-width:0px;border-right-style:none;border-right-width:0px;border-bottom-style:none;border-bottom-width:0px;border-left-style:none;border-left-width:0px;padding-top:24px;padding-right:36px;padding-bottom:24px;padding-left:36px\">Escuchar ahora</a></div>\n</div>\n</div>\n</div>\n</div></div>\n\";s:9:\"protected\";b:0;}s:4:\"meta\";O:8:\"stdClass\":9:{s:31:\"jetpack_post_was_ever_published\";b:0;s:13:\"wpop_keywords\";s:21:\"Jazz, negrita, grande\";s:16:\"wpop_description\";s:0:\"\";s:19:\"wpop_viewport_width\";i:800;s:16:\"wpop_block_types\";a:1:{i:0;s:0:\"\";}s:11:\"wpop_locale\";s:5:\"es_ES\";s:15:\"wpop_wp_version\";s:3:\"6.2\";s:25:\"wpop_contains_block_types\";s:61:\"core/button,core/buttons,core/cover,core/group,core/paragraph\";s:9:\"footnotes\";s:0:\"\";}s:14:\"category_slugs\";a:3:{i:0;s:6:\"banner\";i:1;s:14:\"call-to-action\";i:2;s:4:\"text\";}s:13:\"keyword_slugs\";a:1:{i:0;s:4:\"core\";}s:15:\"pattern_content\";s:3735:\"<!-- wp:cover {\"customOverlayColor\":\"#d1362a\",\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"5vw\",\"right\":\"5vw\",\"bottom\":\"5vw\",\"left\":\"5vw\"},\"margin\":{\"top\":\"0\"}}}} -->\n<div class=\"wp-block-cover alignfull\" style=\"margin-top:0;padding-top:5vw;padding-right:5vw;padding-bottom:5vw;padding-left:5vw\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-100 has-background-dim\" style=\"background-color:#d1362a\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"48px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"verticalAlignment\":\"bottom\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0px\"},\"layout\":{\"selfStretch\":\"fill\",\"flexSize\":null}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"typography\":{\"fontSize\":\"148px\",\"textTransform\":\"none\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\",\"lineHeight\":\"0.9\",\"letterSpacing\":\"-4px\"}},\"textColor\":\"black\"} -->\n<p class=\"has-text-align-left has-black-color has-text-color\" style=\"font-size:148px;font-style:normal;font-weight:700;letter-spacing:-4px;line-height:0.9;text-transform:none\">Comin\'<br>Home<br>Baby</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"typography\":{\"fontSize\":\"148px\",\"textTransform\":\"none\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\",\"lineHeight\":\"0.9\",\"letterSpacing\":\"-4px\"}},\"textColor\":\"white\"} -->\n<p class=\"has-text-align-left has-white-color has-text-color\" style=\"font-size:148px;font-style:normal;font-weight:700;letter-spacing:-4px;line-height:0.9;text-transform:none\">— Mel<br>Torme</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"340px\"},\"spacing\":{\"blockGap\":\"24px\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"verticalAlignment\":\"top\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"style\":{\"layout\":{\"flexSize\":\"330px\"},\"typography\":{\"fontSize\":\"17px\",\"fontStyle\":\"normal\",\"fontWeight\":\"500\",\"lineHeight\":\"1.4\",\"textTransform\":\"none\",\"textDecoration\":\"none\",\"letterSpacing\":\"0px\"}}} -->\n<p style=\"font-size:17px;font-style:normal;font-weight:500;letter-spacing:0px;line-height:1.4;text-decoration:none;text-transform:none\">Featuring Tormé\'s smooth vocal style backed by a small jazz ensemble that includes saxophonist Al Cohn, guitarist Joe Puma, and pianist Hank Jones.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"black\",\"textColor\":\"white\",\"style\":{\"typography\":{\"fontSize\":\"20px\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\",\"textDecoration\":\"none\",\"textTransform\":\"none\",\"letterSpacing\":\"0px\"},\"spacing\":{\"padding\":{\"top\":\"24px\",\"bottom\":\"24px\",\"left\":\"36px\",\"right\":\"36px\"}},\"border\":{\"radius\":\"0px\",\"top\":{\"width\":\"0px\",\"style\":\"none\"},\"right\":{\"width\":\"0px\",\"style\":\"none\"},\"bottom\":{\"width\":\"0px\",\"style\":\"none\"},\"left\":{\"width\":\"0px\",\"style\":\"none\"}}}} -->\n<div class=\"wp-block-button has-custom-font-size\" style=\"font-size:20px;font-style:normal;font-weight:700;letter-spacing:0px;text-decoration:none;text-transform:none\"><a class=\"wp-block-button__link has-white-color has-black-background-color has-text-color has-background wp-element-button\" style=\"border-radius:0px;border-top-style:none;border-top-width:0px;border-right-style:none;border-right-width:0px;border-bottom-style:none;border-bottom-width:0px;border-left-style:none;border-left-width:0px;padding-top:24px;padding-right:36px;padding-bottom:24px;padding-left:36px\">Escuchar ahora</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:cover -->\";}i:5;O:8:\"stdClass\":7:{s:2:\"id\";i:309310;s:5:\"title\";O:8:\"stdClass\":1:{s:8:\"rendered\";s:54:\"Portada de ancho completo con texto degradado repetido\";}s:7:\"content\";O:8:\"stdClass\":2:{s:8:\"rendered\";s:1750:\"\n<div class=\"wp-block-cover alignfull is-light wp-duotone-36345d-abaaaa-4\" style=\"margin-top:0;padding-top:5vw;padding-right:5vw;padding-bottom:5vw;padding-left:5vw\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-60 has-background-dim\" style=\"background-color:#c2b7a4\"></span><img decoding=\"async\" class=\"wp-block-cover__image-background wp-image-334\" alt=\"\" src=\"https://pd.w.org/2022/01/95161f850d22f0c06.37817431.jpg\" style=\"object-position:50% 5%\" data-object-fit=\"cover\" data-object-position=\"50% 5%\" /><div class=\"wp-block-cover__inner-container is-layout-flow wp-block-cover-is-layout-flow\">\n<div style=\"height:48px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-group is-vertical is-content-justification-center is-nowrap is-layout-flex wp-container-core-group-is-layout-b77dfac5 wp-block-group-is-layout-flex\">\n<p class=\"has-text-align-right has-text-color\" style=\"color:#c8c4d3;font-size:148px;font-style:normal;font-weight:300;letter-spacing:-4px;line-height:0.8;text-transform:uppercase\">DJANGO</p>\n\n\n\n<p class=\"has-text-align-right has-text-color\" style=\"color:#ac94b2;font-size:148px;font-style:normal;font-weight:300;letter-spacing:-4px;line-height:0.8;text-transform:uppercase\">DJANGO</p>\n\n\n\n<p class=\"has-text-align-right has-text-color\" style=\"color:#71689c;font-size:148px;font-style:normal;font-weight:300;letter-spacing:-4px;line-height:0.8;text-transform:uppercase\">DJANGO</p>\n\n\n\n<p class=\"has-text-align-right has-text-color\" style=\"color:#444178;font-size:148px;font-style:normal;font-weight:300;letter-spacing:-4px;line-height:0.8;text-transform:uppercase\">DJANGO</p>\n</div>\n\n\n\n<div style=\"height:48px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n</div></div>\n\";s:9:\"protected\";b:0;}s:4:\"meta\";O:8:\"stdClass\":9:{s:31:\"jetpack_post_was_ever_published\";b:0;s:13:\"wpop_keywords\";s:54:\"Ancho completo, Imagen de fondo, Gradiente, Mayúscula\";s:16:\"wpop_description\";s:0:\"\";s:19:\"wpop_viewport_width\";i:800;s:16:\"wpop_block_types\";a:1:{i:0;s:0:\"\";}s:11:\"wpop_locale\";s:5:\"es_ES\";s:15:\"wpop_wp_version\";s:3:\"6.2\";s:25:\"wpop_contains_block_types\";s:48:\"core/cover,core/group,core/paragraph,core/spacer\";s:9:\"footnotes\";s:0:\"\";}s:14:\"category_slugs\";a:2:{i:0;s:6:\"banner\";i:1;s:4:\"text\";}s:13:\"keyword_slugs\";a:1:{i:0;s:4:\"core\";}s:15:\"pattern_content\";s:3135:\"<!-- wp:cover {\"url\":\"https://pd.w.org/2022/01/95161f850d22f0c06.37817431.jpg\",\"id\":334,\"dimRatio\":60,\"customOverlayColor\":\"#c2b7a4\",\"focalPoint\":{\"x\":0.5,\"y\":0.05},\"isDark\":false,\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"5vw\",\"right\":\"5vw\",\"bottom\":\"5vw\",\"left\":\"5vw\"},\"margin\":{\"top\":\"0\"}},\"color\":{\"duotone\":[\"#36345d\",\"#abaaaa\"]}}} -->\n<div class=\"wp-block-cover alignfull is-light\" style=\"margin-top:0;padding-top:5vw;padding-right:5vw;padding-bottom:5vw;padding-left:5vw\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-60 has-background-dim\" style=\"background-color:#c2b7a4\"></span><img class=\"wp-block-cover__image-background wp-image-334\" alt=\"\" src=\"https://pd.w.org/2022/01/95161f850d22f0c06.37817431.jpg\" style=\"object-position:50% 5%\" data-object-fit=\"cover\" data-object-position=\"50% 5%\" /><div class=\"wp-block-cover__inner-container\"><!-- wp:spacer {\"height\":\"48px\"} -->\n<div style=\"height:48px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"right\",\"style\":{\"typography\":{\"fontSize\":\"148px\",\"textTransform\":\"uppercase\",\"fontStyle\":\"normal\",\"fontWeight\":\"300\",\"lineHeight\":\"0.8\",\"letterSpacing\":\"-4px\"},\"color\":{\"text\":\"#c8c4d3\"}}} -->\n<p class=\"has-text-align-right has-text-color\" style=\"color:#c8c4d3;font-size:148px;font-style:normal;font-weight:300;letter-spacing:-4px;line-height:0.8;text-transform:uppercase\">DJANGO</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"right\",\"style\":{\"typography\":{\"fontSize\":\"148px\",\"textTransform\":\"uppercase\",\"fontStyle\":\"normal\",\"fontWeight\":\"300\",\"lineHeight\":\"0.8\",\"letterSpacing\":\"-4px\"},\"color\":{\"text\":\"#ac94b2\"}}} -->\n<p class=\"has-text-align-right has-text-color\" style=\"color:#ac94b2;font-size:148px;font-style:normal;font-weight:300;letter-spacing:-4px;line-height:0.8;text-transform:uppercase\">DJANGO</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"right\",\"style\":{\"typography\":{\"fontSize\":\"148px\",\"textTransform\":\"uppercase\",\"fontStyle\":\"normal\",\"fontWeight\":\"300\",\"lineHeight\":\"0.8\",\"letterSpacing\":\"-4px\"},\"color\":{\"text\":\"#71689c\"}}} -->\n<p class=\"has-text-align-right has-text-color\" style=\"color:#71689c;font-size:148px;font-style:normal;font-weight:300;letter-spacing:-4px;line-height:0.8;text-transform:uppercase\">DJANGO</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"right\",\"style\":{\"typography\":{\"fontSize\":\"148px\",\"textTransform\":\"uppercase\",\"fontStyle\":\"normal\",\"fontWeight\":\"300\",\"lineHeight\":\"0.8\",\"letterSpacing\":\"-4px\"},\"color\":{\"text\":\"#444178\"}}} -->\n<p class=\"has-text-align-right has-text-color\" style=\"color:#444178;font-size:148px;font-style:normal;font-weight:300;letter-spacing:-4px;line-height:0.8;text-transform:uppercase\">DJANGO</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"48px\"} -->\n<div style=\"height:48px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div></div>\n<!-- /wp:cover -->\";}i:6;O:8:\"stdClass\":7:{s:2:\"id\";i:309415;s:5:\"title\";O:8:\"stdClass\":1:{s:8:\"rendered\";s:93:\"Título de ancho completo alineado verticalmente a la derecha con descripción a la izquierda\";}s:7:\"content\";O:8:\"stdClass\":2:{s:8:\"rendered\";s:2238:\"\n<div class=\"wp-block-cover alignfull is-light\" style=\"margin-top:0;padding-top:5vw;padding-right:5vw;padding-bottom:5vw;padding-left:5vw\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-100 has-background-dim\" style=\"background-color:#e68b14\"></span><div class=\"wp-block-cover__inner-container is-layout-flow wp-block-cover-is-layout-flow\">\n<div class=\"wp-block-group is-layout-flex wp-container-core-group-is-layout-d0921e6e wp-block-group-is-layout-flex\">\n<div class=\"wp-block-group wp-container-content-8eb0bdf3 is-layout-flow wp-container-core-group-is-layout-634f0b9d wp-block-group-is-layout-flow\">\n<p class=\"wp-container-content-aeb25491\" style=\"font-size:17px;font-style:normal;font-weight:300;letter-spacing:0px;line-height:1.4;text-decoration:none;text-transform:none\">Let &#8216;em Roll es un álbum del organista estadounidense Big John Patton grabado en 1965 y lanzado con el sello Blue Note.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button has-custom-font-size\" style=\"font-size:17px;font-style:normal;font-weight:700;letter-spacing:0px;text-decoration:none;text-transform:uppercase\"><a class=\"wp-block-button__link has-white-color has-black-background-color has-text-color has-background wp-element-button\" style=\"border-radius:0px;border-top-style:none;border-top-width:0px;border-right-style:none;border-right-width:0px;border-bottom-style:none;border-bottom-width:0px;border-left-style:none;border-left-width:0px;padding-top:14px;padding-right:36px;padding-bottom:14px;padding-left:36px\">Compra ahora</a></div>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-group wp-container-content-9cfa9a5a is-layout-flow wp-container-core-group-is-layout-d6743c7d wp-block-group-is-layout-flow\">\n<p class=\"has-text-align-right has-black-color has-text-color\" style=\"font-size:148px;font-style:normal;font-weight:700;letter-spacing:-4px;line-height:0.8;text-transform:uppercase\">Let<br>&#8216;EM<br>Roll</p>\n\n\n\n<p class=\"has-text-align-right has-white-color has-text-color\" style=\"font-size:148px;font-style:normal;font-weight:700;letter-spacing:-4px;line-height:0.8;text-transform:uppercase\">Big<br>John<br>Patton</p>\n</div>\n</div>\n</div></div>\n\";s:9:\"protected\";b:0;}s:4:\"meta\";O:8:\"stdClass\":9:{s:31:\"jetpack_post_was_ever_published\";b:0;s:13:\"wpop_keywords\";s:93:\"verticalmente, negrita, Jazz, tienda, tienda, titular, Sección a pantalla completa, Producto\";s:16:\"wpop_description\";s:0:\"\";s:19:\"wpop_viewport_width\";i:800;s:16:\"wpop_block_types\";a:1:{i:0;s:0:\"\";}s:11:\"wpop_locale\";s:5:\"es_ES\";s:15:\"wpop_wp_version\";s:3:\"6.2\";s:25:\"wpop_contains_block_types\";s:61:\"core/button,core/buttons,core/cover,core/group,core/paragraph\";s:9:\"footnotes\";s:0:\"\";}s:14:\"category_slugs\";a:2:{i:0;s:6:\"banner\";i:1;s:14:\"call-to-action\";}s:13:\"keyword_slugs\";a:1:{i:0;s:4:\"core\";}s:15:\"pattern_content\";s:3735:\"<!-- wp:cover {\"customOverlayColor\":\"#e68b14\",\"isDark\":false,\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"5vw\",\"right\":\"5vw\",\"bottom\":\"5vw\",\"left\":\"5vw\"},\"margin\":{\"top\":\"0\"}}}} -->\n<div class=\"wp-block-cover alignfull is-light\" style=\"margin-top:0;padding-top:5vw;padding-right:5vw;padding-bottom:5vw;padding-left:5vw\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-100 has-background-dim\" style=\"background-color:#e68b14\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"verticalAlignment\":\"top\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"320px\"},\"spacing\":{\"blockGap\":\"24px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"330px\"},\"typography\":{\"fontSize\":\"17px\",\"fontStyle\":\"normal\",\"fontWeight\":\"300\",\"lineHeight\":\"1.4\",\"textTransform\":\"none\",\"textDecoration\":\"none\",\"letterSpacing\":\"0px\"}}} -->\n<p style=\"font-size:17px;font-style:normal;font-weight:300;letter-spacing:0px;line-height:1.4;text-decoration:none;text-transform:none\">Let \'em Roll es un álbum del organista estadounidense Big John Patton grabado en 1965 y lanzado con el sello Blue Note.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"black\",\"textColor\":\"white\",\"style\":{\"typography\":{\"fontSize\":\"17px\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\",\"textDecoration\":\"none\",\"textTransform\":\"uppercase\",\"letterSpacing\":\"0px\"},\"spacing\":{\"padding\":{\"top\":\"14px\",\"bottom\":\"14px\",\"left\":\"36px\",\"right\":\"36px\"}},\"border\":{\"radius\":\"0px\",\"top\":{\"radius\":\"0px\",\"width\":\"0px\",\"style\":\"none\"},\"right\":{\"radius\":\"0px\",\"width\":\"0px\",\"style\":\"none\"},\"bottom\":{\"radius\":\"0px\",\"width\":\"0px\",\"style\":\"none\"},\"left\":{\"radius\":\"0px\",\"width\":\"0px\",\"style\":\"none\"}}}} -->\n<div class=\"wp-block-button has-custom-font-size\" style=\"font-size:17px;font-style:normal;font-weight:700;letter-spacing:0px;text-decoration:none;text-transform:uppercase\"><a class=\"wp-block-button__link has-white-color has-black-background-color has-text-color has-background wp-element-button\" style=\"border-radius:0px;border-top-style:none;border-top-width:0px;border-right-style:none;border-right-width:0px;border-bottom-style:none;border-bottom-width:0px;border-left-style:none;border-left-width:0px;padding-top:14px;padding-right:36px;padding-bottom:14px;padding-left:36px\">Compra ahora</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0px\"},\"layout\":{\"selfStretch\":\"fill\",\"flexSize\":null}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"right\",\"style\":{\"typography\":{\"fontSize\":\"148px\",\"textTransform\":\"uppercase\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\",\"lineHeight\":\"0.8\",\"letterSpacing\":\"-4px\"}},\"textColor\":\"black\"} -->\n<p class=\"has-text-align-right has-black-color has-text-color\" style=\"font-size:148px;font-style:normal;font-weight:700;letter-spacing:-4px;line-height:0.8;text-transform:uppercase\">Let<br>\'EM<br>Roll</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"right\",\"style\":{\"typography\":{\"fontSize\":\"148px\",\"textTransform\":\"uppercase\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\",\"lineHeight\":\"0.8\",\"letterSpacing\":\"-4px\"}},\"textColor\":\"white\"} -->\n<p class=\"has-text-align-right has-white-color has-text-color\" style=\"font-size:148px;font-style:normal;font-weight:700;letter-spacing:-4px;line-height:0.8;text-transform:uppercase\">Big<br>John<br>Patton</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:cover -->\";}i:7;O:8:\"stdClass\":7:{s:2:\"id\";i:309475;s:5:\"title\";O:8:\"stdClass\":1:{s:8:\"rendered\";s:69:\"Titular de ancho completo con enlaces y fondo desplazado en degradado\";}s:7:\"content\";O:8:\"stdClass\":2:{s:8:\"rendered\";s:2077:\"\n<div class=\"wp-block-cover alignfull is-light\" style=\"margin-top:0;padding-top:48px;padding-right:5vw;padding-bottom:48px;padding-left:5vw\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-100 has-background-dim has-background-gradient\" style=\"background:linear-gradient(180deg,rgb(0,0,0) 39%,rgb(83,80,123) 39%)\"></span><div class=\"wp-block-cover__inner-container is-layout-flow wp-block-cover-is-layout-flow\">\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-group is-content-justification-space-between is-layout-flex wp-container-core-group-is-layout-b04426d0 wp-block-group-is-layout-flex\">\n<div class=\"wp-block-group wp-container-content-9cfa9a5a is-layout-flow wp-container-core-group-is-layout-d6743c7d wp-block-group-is-layout-flow\">\n<p class=\"has-text-align-left has-white-color has-text-color has-link-color wp-elements-813e1e29